/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class WindowsFileParser
extends FTPFileParser {
    private static String cvsId = "@(#)$Id: WindowsFileParser.java,v 1.3 2004/05/05 20:27:55 bruceb Exp $";
    private static final SimpleDateFormat formatter = new SimpleDateFormat("MM-dd-yy hh:mma", Locale.US);
    private static final String DIR = "<DIR>";
    private static final int MIN_EXPECTED_FIELD_COUNT = 4;

    public FTPFile parse(String raw) throws ParseException {
        String[] fields = this.split(raw);
        if (fields.length < 4) {
            throw new ParseException("Unexpected number of fields: " + fields.length, 0);
        }
        Date lastModified = formatter.parse(fields[0] + " " + fields[1]);
        boolean isDir = false;
        long size = 0L;
        if (fields[2].equalsIgnoreCase(DIR)) {
            isDir = true;
        } else {
            try {
                size = Long.parseLong(fields[2]);
            }
            catch (NumberFormatException ex) {
                throw new ParseException("Failed to parse size: " + fields[2], 0);
            }
        }
        int pos = raw.indexOf(fields[3]);
        if (pos > 0) {
            String name = raw.substring(pos);
            return new FTPFile(0, raw, name.toString(), size, isDir, lastModified);
        }
        throw new ParseException("Failed to retrieve name: " + raw, 0);
    }
}

