/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.test.FTPTestCase;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestFileOperations
extends FTPTestCase {
    private static String cvsId = "@(#)$Id: TestFileOperations.java,v 1.4 2004/04/17 18:38:38 bruceb Exp $";
    private SimpleDateFormat modFormatter = new SimpleDateFormat("yyyy/MM/dd @ HH:mm:ss");
    static /* synthetic */ Class class$com$enterprisedt$net$ftp$test$TestFileOperations;

    protected String getLogName() {
        return "TestFileOperations.log";
    }

    public void testDelete() throws Exception {
        this.connect();
        this.login();
        this.ftp.chdir(this.testdir);
        try {
            String file = this.generateRandomFilename();
            this.log.println("Deleting a non-existent file");
            this.ftp.delete(file);
        }
        catch (FTPException ex) {
            this.log.println("Expected exception: " + ex.getMessage());
        }
        this.ftp.quit();
    }

    public void testRename() throws Exception {
        this.connect();
        this.login();
        this.ftp.chdir(this.testdir);
        String rename = this.remoteTextFile + ".renamed";
        this.ftp.rename(this.remoteTextFile, rename);
        Date modTime = this.ftp.modtime(rename);
        String mod = this.modFormatter.format(modTime);
        this.log.println(rename + ": " + mod);
        try {
            this.ftp.modtime(this.remoteTextFile);
        }
        catch (FTPException ex) {
            this.log.println("Expected exception: " + ex.getMessage());
        }
        this.ftp.rename(rename, this.remoteTextFile);
        modTime = this.ftp.modtime(this.remoteTextFile);
        mod = this.modFormatter.format(modTime);
        this.log.println(this.remoteTextFile + ": " + mod);
        try {
            this.ftp.modtime(rename);
        }
        catch (FTPException ex) {
            this.log.println("Expected exception: " + ex.getMessage());
        }
        this.ftp.quit();
    }

    public void testModtime() throws Exception {
        this.connect();
        this.login();
        this.ftp.chdir(this.testdir);
        this.log.println("Modtime on existing file: " + this.remoteTextFile);
        Date modTime = this.ftp.modtime(this.remoteTextFile);
        String mod = this.modFormatter.format(modTime);
        this.log.println(this.remoteTextFile + ": " + mod);
        try {
            String file = this.generateRandomFilename();
            this.log.println("Modtime on non-existent file");
            modTime = this.ftp.modtime(file);
            mod = this.modFormatter.format(modTime);
            this.log.println(this.remoteTextFile + ": " + mod);
        }
        catch (FTPException ex) {
            this.log.println("Expected exception: " + ex.getMessage());
        }
        this.ftp.quit();
    }

    public void testSize() throws Exception {
        this.connect();
        this.login();
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.BINARY);
        String filename = this.generateRandomFilename();
        this.ftp.put(this.localTextFile, filename);
        File local = new File(this.localTextFile);
        long sizeLocal = local.length();
        long sizeRemote = this.ftp.size(filename);
        this.ftp.delete(filename);
        if (sizeLocal != sizeRemote) {
            String msg = "Local size(" + sizeLocal + ") != remote size(" + sizeRemote + ")";
            this.log.println(msg);
            throw new Exception(msg);
        }
        this.ftp.quit();
    }

    public static Test suite() {
        return new TestSuite(class$com$enterprisedt$net$ftp$test$TestFileOperations == null ? (class$com$enterprisedt$net$ftp$test$TestFileOperations = TestFileOperations.class$("com.enterprisedt.net.ftp.test.TestFileOperations")) : class$com$enterprisedt$net$ftp$test$TestFileOperations);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestFileOperations.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

