/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.xhtml;

import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.command.ViewHTML;
import com.xmlmind.xmledit.doc.Attribute;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Path;
import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.edit.DocumentUtil;
import com.xmlmind.xmledit.edit.Formatter;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.ShowStatus;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmleditapp.xhtml.Msg;
import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;

public class Preview
extends RecordableCommand {
    private static final Name CONTENT_ATTRIBUTE = Name.get((String)"content");

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        DocumentView documentView = (DocumentView)gadget;
        Document document = documentView.getDocument();
        if (document == null || !"html".equals(document.getRootElement().getLocalName())) {
            return false;
        }
        URL uRL = document.getLocation();
        return uRL != null && uRL.getProtocol().equals("file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        Document document = documentView.getDocument();
        File file = FileUtil.urlToFile((URL)document.getLocation());
        String string2 = this.getBaseName(file);
        File file2 = new File(file.getParent(), "__PREVIEW__" + string2 + ".html");
        ShowStatus.showStatus((String)Msg.msg("savingPreviewFile", file2));
        DocumentUtil.commitChanges((Document)document);
        try {
            String string3 = this.findCharsetName(document);
            if (string3 == null) {
                string3 = FileUtil.defaultEncoding();
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), string3));
            DocumentType documentType = (DocumentType)document.getProperty((Object)"DOCUMENT_TYPE");
            Formatter formatter = new Formatter(documentType);
            formatter.setEncoding(string3);
            formatter.setPreserveInclusions(0);
            formatter.setSaveCharsAsEntityRefs(false);
            formatter.setFavorInteroperability(true);
            try {
                formatter.writeDocumentElement(document, (Writer)bufferedWriter);
                Object var14_14 = null;
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                ((Writer)bufferedWriter).close();
                throw throwable;
            }
            ((Writer)bufferedWriter).close();
            file2.deleteOnExit();
        }
        catch (IOException iOException) {
            Alert.showError((Component)documentView.getPanel(), (String)Msg.msg("cannotSavePreviewFile", file, MiscUtil.reason((Throwable)iOException)));
            return Command.EXECUTION_FAILED;
        }
        if (!ViewHTML.viewHTML((URL)FileUtil.fileToURL((File)file2), (String)string, (Component)documentView.getPanel())) {
            return Command.EXECUTION_FAILED;
        }
        return null;
    }

    private String getBaseName(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    private String findCharsetName(Document document) {
        Path path = Path.fromString((String)"/html/head/meta/@http-equiv", (PrefixToNamespace)document);
        XNode[] xNodeArray = path.select(document);
        String string = null;
        int n = 0;
        while (n < xNodeArray.length) {
            Attribute attribute = (Attribute)xNodeArray[n];
            if (attribute.value.trim().toLowerCase().equals("content-type")) {
                String string2 = attribute.element.getAttribute(CONTENT_ATTRIBUTE);
                if (string2 == null) break;
                string = FileUtil.contentTypeToCharsetName((String)string2);
                break;
            }
            ++n;
        }
        return string;
    }
}

