/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.xhtml.form;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentEvent;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.TextEvent;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.edit.TextOffset;
import com.xmlmind.xmledit.gadget.ComponentWrapper;
import com.xmlmind.xmledit.gadget.WrappedComponent;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledview.ComponentFactory;
import com.xmlmind.xmledit.styledview.CustomViewManager;
import com.xmlmind.xmledit.styledview.StyledViewFactory;
import com.xmlmind.xmledit.stylesheet.StyleValue;
import com.xmlmind.xmledit.view.ViewFactory;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmleditapp.xmlapputil.ComponentUtil;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class TextArea
implements ComponentFactory {
    private static final Name ROWS = Name.get((Namespace)Namespace.NONE, (String)"rows");
    private static final Name COLS = Name.get((Namespace)Namespace.NONE, (String)"cols");
    private static final Name READONLY = Name.get((Namespace)Namespace.NONE, (String)"readonly");
    private static final Name DISABLED = Name.get((Namespace)Namespace.NONE, (String)"disabled");

    public Component createComponent(Element element, Style style, StyleValue[] styleValueArray, StyledViewFactory styledViewFactory, boolean[] blArray) {
        XHTMLTextArea xHTMLTextArea = new XHTMLTextArea(element);
        styledViewFactory.getCustomViewManager().add((CustomViewManager.SimpleElementEditor)xHTMLTextArea, element);
        ComponentUtil.addFocusGainedListener((Component)xHTMLTextArea, (Element)element, (ViewFactory)styledViewFactory);
        return xHTMLTextArea;
    }

    private static class XHTMLTextArea
    extends JScrollPane
    implements WrappedComponent,
    CustomViewManager.SimpleElementEditor {
        private Element element;
        private JTextArea textArea;
        private ComponentWrapper componentWrapper;
        private boolean typing = false;
        private boolean refreshing = false;

        public XHTMLTextArea(Element element) {
            this.element = element;
            this.textArea = new JTextArea(5, 40);
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(true);
            this.textArea.getDocument().addDocumentListener(new DocumentListener(this){
                private final /* synthetic */ XHTMLTextArea this$0;
                {
                    this.this$0 = xHTMLTextArea;
                }

                public void insertUpdate(javax.swing.event.DocumentEvent documentEvent) {
                    String string;
                    if (XHTMLTextArea.access$000(this.this$0)) {
                        return;
                    }
                    XHTMLTextArea.access$102(this.this$0, true);
                    int n = documentEvent.getOffset();
                    try {
                        string = documentEvent.getDocument().getText(n, documentEvent.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                        string = null;
                    }
                    if (string != null) {
                        XHTMLTextArea.access$300(XHTMLTextArea.access$200(this.this$0), n, string);
                    }
                    XHTMLTextArea.access$102(this.this$0, false);
                }

                public void removeUpdate(javax.swing.event.DocumentEvent documentEvent) {
                    if (XHTMLTextArea.access$000(this.this$0)) {
                        return;
                    }
                    XHTMLTextArea.access$102(this.this$0, true);
                    XHTMLTextArea.access$400(XHTMLTextArea.access$200(this.this$0), documentEvent.getOffset(), documentEvent.getLength());
                    XHTMLTextArea.access$102(this.this$0, false);
                }

                public void changedUpdate(javax.swing.event.DocumentEvent documentEvent) {
                }
            });
            this.getViewport().setView(this.textArea);
        }

        private static final TextOffset findText(Element element, int n) {
            Text text = null;
            int n2 = -1;
            int n3 = 0;
            Text text2 = null;
            Node node = element.getFirstChild();
            while (node != null) {
                if (node instanceof Text) {
                    text2 = (Text)node;
                    int n4 = text2.getTextLength();
                    if (n >= n3 && n < n3 + n4) {
                        text = text2;
                        n2 = n - n3;
                        break;
                    }
                    n3 += n4;
                }
                node = node.getNextSibling();
            }
            if (text == null && text2 != null && n == n3) {
                text = text2;
                n2 = text2.getTextLength();
            }
            return text == null ? null : new TextOffset((TextNode)text, n2);
        }

        private static final void insertText(Element element, int n, String string) {
            if (!element.isEditable()) {
                return;
            }
            TextOffset textOffset = XHTMLTextArea.findText(element, n);
            if (textOffset == null) {
                return;
            }
            textOffset.text.insertText(textOffset.offset, string);
        }

        private static final void removeText(Element element, int n, int n2) {
            if (!element.isEditable()) {
                return;
            }
            TextOffset textOffset = XHTMLTextArea.findText(element, n);
            if (textOffset == null) {
                return;
            }
            Document document = element.getDocument();
            if (document != null) {
                document.beginBatchEditing();
            }
            Text text = (Text)textOffset.text;
            int n3 = textOffset.offset;
            while (n2 > 0) {
                int n4 = Math.min(n2, text.getTextLength() - n3);
                text.deleteText(n3, n4);
                n2 -= n4;
                Node node = text.getNextSibling();
                while (node != null) {
                    if (node instanceof Text) {
                        text = (Text)node;
                        n3 = 0;
                        break;
                    }
                    node = node.getNextSibling();
                }
                if (text == null) break;
            }
            if (document != null) {
                document.endBatchEditing();
            }
        }

        public void setComponentWrapper(ComponentWrapper componentWrapper) {
            this.componentWrapper = componentWrapper;
        }

        public ComponentWrapper getComponentWrapper() {
            return this.componentWrapper;
        }

        public void customViewAdded() {
            this.elementChanged(new DocumentEvent[0]);
        }

        public void customViewRemoved() {
        }

        public void commitChanges() {
        }

        public void elementChanged(DocumentEvent[] documentEventArray) {
            if (this.typing) {
                return;
            }
            this.refreshing = true;
            if (documentEventArray.length == 1 && documentEventArray[0] instanceof TextEvent) {
                this.refreshText();
            } else {
                this.refresh();
            }
            this.refreshing = false;
        }

        private void refreshText() {
            String string = this.element.getText();
            this.textArea.setText(string == null ? "" : string);
        }

        private void refresh() {
            int n;
            this.refreshText();
            boolean bl = false;
            int n2 = this.element.getIntAttribute(ROWS, -1);
            if (n2 <= 0) {
                n2 = 5;
            }
            if (this.textArea.getRows() != n2) {
                this.textArea.setRows(n2);
                bl = true;
            }
            if ((n = this.element.getIntAttribute(COLS, -1)) <= 0) {
                n = 40;
            }
            if (this.textArea.getColumns() != n) {
                this.textArea.setColumns(n);
                bl = true;
            }
            if (bl && this.componentWrapper != null) {
                this.componentWrapper.refresh();
            }
            this.textArea.setEditable(!this.element.hasAttribute(READONLY));
            this.textArea.setEnabled(!this.element.hasAttribute(DISABLED));
        }

        static /* synthetic */ boolean access$000(XHTMLTextArea xHTMLTextArea) {
            return xHTMLTextArea.refreshing;
        }

        static /* synthetic */ boolean access$102(XHTMLTextArea xHTMLTextArea, boolean bl) {
            xHTMLTextArea.typing = bl;
            return xHTMLTextArea.typing;
        }

        static /* synthetic */ Element access$200(XHTMLTextArea xHTMLTextArea) {
            return xHTMLTextArea.element;
        }

        static /* synthetic */ void access$300(Element element, int n, String string) {
            XHTMLTextArea.insertText(element, n, string);
        }

        static /* synthetic */ void access$400(Element element, int n, int n2) {
            XHTMLTextArea.removeText(element, n, n2);
        }
    }
}

