/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.xhtml.table;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.styledview.StyledViewFactory;
import com.xmlmind.xmledit.stylesheet.StyleSpec;
import com.xmlmind.xmledit.stylesheet.StyleSpecsBase;
import com.xmlmind.xmledit.stylesheet.StyleValue;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmleditapp.xmlapputil.SpanHelper;
import java.awt.Color;

public class StyleSpecsImpl
extends StyleSpecsBase {
    private static final Name ALIGN = Name.get((Namespace)Namespace.NONE, (String)"align");
    private static final Name VALIGN = Name.get((Namespace)Namespace.NONE, (String)"valign");
    private static final Name ROWSPAN = Name.get((Namespace)Namespace.NONE, (String)"rowspan");
    private static final Name COLSPAN = Name.get((Namespace)Namespace.NONE, (String)"colspan");
    private static final Name SPAN = Name.get((Namespace)Namespace.NONE, (String)"span");
    private static final Name WIDTH = Name.get((Namespace)Namespace.NONE, (String)"width");
    private static final Name BORDER = Name.get((Namespace)Namespace.NONE, (String)"border");
    private static final Name FRAME = Name.get((Namespace)Namespace.NONE, (String)"frame");
    private static final Name RULES = Name.get((Namespace)Namespace.NONE, (String)"rules");
    private static final int FRAME_VOID = 0;
    private static final int FRAME_ABOVE = 1;
    private static final int FRAME_BELOW = 2;
    private static final int FRAME_HSIDES = 3;
    private static final int FRAME_VSIDES = 4;
    private static final int FRAME_LHS = 5;
    private static final int FRAME_RHS = 6;
    private static final int FRAME_BOX = 7;
    private static final int FRAME_BORDER = 8;
    private static final int RULES_NONE = 0;
    private static final int RULES_GROUPS = 1;
    private static final int RULES_ROWS = 2;
    private static final int RULES_COLS = 3;
    private static final int RULES_ALL = 4;
    protected static final String[] DEPENDENCIES = new String[]{"table", "border", "table", "frame", "table", "rules", "thead", "align", "thead", "valign", "tfoot", "align", "tfoot", "valign", "tbody", "align", "tbody", "valign", "tr", "align", "tr", "valign", "td", "align", "td", "valign", "td", "colspan", "td", "rowspan", "th", "align", "th", "valign", "th", "colspan", "th", "rowspan"};
    private Color borderColor;
    private Color noBorderColor;
    private int rowGroupSpan;
    private int cellRowWithinGroup;
    private Element rowContainer;
    private ColGroup[] colGroups = new ColGroup[0];
    private int colGroupCount;
    private ColSubgroup[] colSubgroups = new ColSubgroup[0];
    private int colSubgroupCount;
    private SpanHelper spanHelper = new SpanHelper();
    private int cellColumn;
    private ColSubgroup cellColSubgroup;
    private StyleValue borderTopColorValue = new StyleValue(27);
    private StyleValue borderBottomColorValue = new StyleValue(27);
    private StyleValue borderLeftColorValue = new StyleValue(27);
    private StyleValue borderRightColorValue = new StyleValue(27);
    private StyleValue textAlignValue = new StyleValue();
    private StyleValue verticalAlignValue = new StyleValue();
    private StyleValue rowSpanValue = new StyleValue(0);
    private StyleValue columnSpanValue = new StyleValue(0);
    private StyleValue widthValue = new StyleValue();

    public StyleSpecsImpl(StyledViewFactory styledViewFactory, Color color, Color color2) {
        this.borderColor = color;
        this.noBorderColor = color2;
        if (styledViewFactory != null) {
            int n = 0;
            while (n < DEPENDENCIES.length) {
                styledViewFactory.addDependency(null, DEPENDENCIES[n], Namespace.NONE, DEPENDENCIES[n + 1]);
                n += 2;
            }
        }
    }

    protected StyleSpecsImpl(Color color, Color color2) {
        this(null, color, color2);
    }

    protected boolean isTableName(String string) {
        return "table".equals(string);
    }

    public int findStyleSpec(Element element, StyleSpec[] styleSpecArray) {
        String string = element.getLocalName();
        if (string.equals("td") || string.equals("th") ? this.addCellStyle(element, styleSpecArray[0]) : this.isTableName(string) && this.addTableStyle(element, styleSpecArray[0])) {
            return 1;
        }
        return 0;
    }

    private boolean addTableStyle(Element element, StyleSpec styleSpec) {
        String string;
        if (this.borderColor == null) {
            return false;
        }
        int n = 0;
        int n2 = StyleSpecsImpl.getBorderAttribute(element);
        if (n2 > 0) {
            n = 8;
        }
        if ((string = element.getAttribute(FRAME)) != null) {
            if (string.equals("hsides")) {
                n = 3;
            } else if (string.equals("vsides")) {
                n = 4;
            } else if (string.equals("above")) {
                n = 1;
            } else if (string.equals("below")) {
                n = 2;
            } else if (string.equals("lhs")) {
                n = 5;
            } else if (string.equals("rhs")) {
                n = 6;
            } else if (string.equals("box")) {
                n = 7;
            } else if (string.equals("border")) {
                n = 8;
            } else if (string.equals("void")) {
                n = 0;
            }
        }
        switch (n) {
            case 3: {
                this.setBorderTopColor(styleSpec, this.borderColor);
                this.setBorderRightColor(styleSpec, this.noBorderColor);
                this.setBorderBottomColor(styleSpec, this.borderColor);
                this.setBorderLeftColor(styleSpec, this.noBorderColor);
                break;
            }
            case 4: {
                this.setBorderTopColor(styleSpec, this.noBorderColor);
                this.setBorderRightColor(styleSpec, this.borderColor);
                this.setBorderBottomColor(styleSpec, this.noBorderColor);
                this.setBorderLeftColor(styleSpec, this.borderColor);
                break;
            }
            case 1: {
                this.setBorderTopColor(styleSpec, this.borderColor);
                this.setBorderRightColor(styleSpec, this.noBorderColor);
                this.setBorderBottomColor(styleSpec, this.noBorderColor);
                this.setBorderLeftColor(styleSpec, this.noBorderColor);
                break;
            }
            case 2: {
                this.setBorderTopColor(styleSpec, this.noBorderColor);
                this.setBorderRightColor(styleSpec, this.noBorderColor);
                this.setBorderBottomColor(styleSpec, this.borderColor);
                this.setBorderLeftColor(styleSpec, this.noBorderColor);
                break;
            }
            case 5: {
                this.setBorderTopColor(styleSpec, this.noBorderColor);
                this.setBorderRightColor(styleSpec, this.noBorderColor);
                this.setBorderBottomColor(styleSpec, this.noBorderColor);
                this.setBorderLeftColor(styleSpec, this.borderColor);
                break;
            }
            case 6: {
                this.setBorderTopColor(styleSpec, this.noBorderColor);
                this.setBorderRightColor(styleSpec, this.borderColor);
                this.setBorderBottomColor(styleSpec, this.noBorderColor);
                this.setBorderLeftColor(styleSpec, this.noBorderColor);
                break;
            }
            case 7: 
            case 8: {
                this.setBorderTopColor(styleSpec, this.borderColor);
                this.setBorderRightColor(styleSpec, this.borderColor);
                this.setBorderBottomColor(styleSpec, this.borderColor);
                this.setBorderLeftColor(styleSpec, this.borderColor);
                break;
            }
            default: {
                this.setBorderTopColor(styleSpec, this.noBorderColor);
                this.setBorderRightColor(styleSpec, this.noBorderColor);
                this.setBorderBottomColor(styleSpec, this.noBorderColor);
                this.setBorderLeftColor(styleSpec, this.noBorderColor);
            }
        }
        return true;
    }

    private void setBorderTopColor(StyleSpec styleSpec, Color color) {
        this.borderTopColorValue.color = color;
        styleSpec.borderTopColor = this.borderTopColorValue;
    }

    private void setBorderBottomColor(StyleSpec styleSpec, Color color) {
        this.borderBottomColorValue.color = color;
        styleSpec.borderBottomColor = this.borderBottomColorValue;
    }

    private void setBorderLeftColor(StyleSpec styleSpec, Color color) {
        this.borderLeftColorValue.color = color;
        styleSpec.borderLeftColor = this.borderLeftColorValue;
    }

    private void setBorderRightColor(StyleSpec styleSpec, Color color) {
        this.borderRightColorValue.color = color;
        styleSpec.borderRightColor = this.borderRightColorValue;
    }

    private boolean addCellStyle(Element element, StyleSpec styleSpec) {
        String string;
        Element element2;
        this.initRowContainer(element);
        this.initColSubgroups(element);
        String string2 = element.getAttribute(ALIGN);
        if (string2 == null) {
            if (this.cellColSubgroup != null) {
                string2 = this.cellColSubgroup.align;
            }
            if (string2 == null) {
                element2 = element.getParentElement();
                while (element2 != null) {
                    string = element2.getLocalName();
                    if (!string.equals("tr") && !string.equals("tbody") && !string.equals("thead") && !string.equals("tfoot") || (string2 = element2.getAttribute(ALIGN)) != null) break;
                    element2 = element2.getParentElement();
                }
            }
        }
        if (string2 != null) {
            if ("left".equals(string2 = string2.trim()) || "justify".equals(string2) || "char".equals(string2)) {
                this.setTextAlign(styleSpec, 62);
            } else if ("center".equals(string2)) {
                this.setTextAlign(styleSpec, 64);
            } else if ("right".equals(string2)) {
                this.setTextAlign(styleSpec, 63);
            }
        }
        if (string2 == null && "th".equals(element.getLocalName())) {
            this.setTextAlign(styleSpec, 64);
        }
        if ((string2 = element.getAttribute(VALIGN)) == null) {
            element2 = element.getParentElement();
            while (element2 != null) {
                string = element2.getLocalName();
                if (!string.equals("tr") && !string.equals("tbody") && !string.equals("thead") && !string.equals("tfoot") || (string2 = element2.getAttribute(VALIGN)) != null) break;
                element2 = element2.getParentElement();
            }
            if (string2 == null && this.cellColSubgroup != null) {
                string2 = this.cellColSubgroup.valign;
            }
        }
        if (string2 != null) {
            if ("middle".equals(string2 = string2.trim())) {
                this.setVerticalAlign(styleSpec, 67);
            } else if ("top".equals(string2)) {
                this.setVerticalAlign(styleSpec, 66);
            } else if ("bottom".equals(string2)) {
                this.setVerticalAlign(styleSpec, 68);
            } else if ("baseline".equals(string2)) {
                this.setVerticalAlign(styleSpec, 65);
            }
        }
        if (string2 == null && "th".equals(element.getLocalName())) {
            this.setVerticalAlign(styleSpec, 67);
        }
        this.setRowSpan(styleSpec, this.getRowSpan(element));
        int n = this.getColSpan(element);
        this.setColumnSpan(styleSpec, n);
        if (this.cellColSubgroup != null && this.cellColSubgroup.width != null && n == 1 && StyleSpecsImpl.parseColWidth(this.cellColSubgroup.width, this.widthValue)) {
            styleSpec.width = this.widthValue;
        }
        if (this.borderColor != null) {
            switch (this.getRules(element)) {
                case 1: {
                    if (this.cellColSubgroup == null) {
                        this.setBorderLeftColor(styleSpec, this.noBorderColor);
                        this.setBorderRightColor(styleSpec, this.noBorderColor);
                    } else {
                        this.setBorderLeftColor(styleSpec, this.cellColumn == this.cellColSubgroup.first ? this.borderColor : this.noBorderColor);
                        this.setBorderRightColor(styleSpec, this.cellColumn == this.cellColSubgroup.first + this.cellColSubgroup.span - 1 ? this.borderColor : this.noBorderColor);
                    }
                    if (this.rowContainer == null || this.isTableName(this.rowContainer.getLocalName())) {
                        this.setBorderTopColor(styleSpec, this.noBorderColor);
                        this.setBorderBottomColor(styleSpec, this.noBorderColor);
                        break;
                    }
                    this.setBorderTopColor(styleSpec, this.cellRowWithinGroup == 0 ? this.borderColor : this.noBorderColor);
                    this.setBorderBottomColor(styleSpec, this.cellRowWithinGroup == this.rowGroupSpan - 1 ? this.borderColor : this.noBorderColor);
                    break;
                }
                case 2: {
                    this.setBorderTopColor(styleSpec, this.borderColor);
                    this.setBorderRightColor(styleSpec, this.noBorderColor);
                    this.setBorderBottomColor(styleSpec, this.borderColor);
                    this.setBorderLeftColor(styleSpec, this.noBorderColor);
                    break;
                }
                case 3: {
                    this.setBorderTopColor(styleSpec, this.noBorderColor);
                    this.setBorderRightColor(styleSpec, this.borderColor);
                    this.setBorderBottomColor(styleSpec, this.noBorderColor);
                    this.setBorderLeftColor(styleSpec, this.borderColor);
                    break;
                }
                case 4: {
                    this.setBorderTopColor(styleSpec, this.borderColor);
                    this.setBorderRightColor(styleSpec, this.borderColor);
                    this.setBorderBottomColor(styleSpec, this.borderColor);
                    this.setBorderLeftColor(styleSpec, this.borderColor);
                    break;
                }
                default: {
                    this.setBorderTopColor(styleSpec, this.noBorderColor);
                    this.setBorderRightColor(styleSpec, this.noBorderColor);
                    this.setBorderBottomColor(styleSpec, this.noBorderColor);
                    this.setBorderLeftColor(styleSpec, this.noBorderColor);
                }
            }
        }
        return true;
    }

    private void setTextAlign(StyleSpec styleSpec, int n) {
        this.textAlignValue.type = n;
        styleSpec.textAlign = this.textAlignValue;
    }

    private void setVerticalAlign(StyleSpec styleSpec, int n) {
        this.verticalAlignValue.type = n;
        styleSpec.verticalAlign = this.verticalAlignValue;
    }

    private void setRowSpan(StyleSpec styleSpec, int n) {
        this.rowSpanValue.number = n;
        styleSpec.rowSpan = this.rowSpanValue;
    }

    private void setColumnSpan(StyleSpec styleSpec, int n) {
        this.columnSpanValue.number = n;
        styleSpec.columnSpan = this.columnSpanValue;
    }

    private void initRowContainer(Element element) {
        this.rowContainer = null;
        this.rowGroupSpan = 0;
        this.cellRowWithinGroup = 0;
        Element element2 = element.getParentElement();
        while (element2 != null) {
            String string = element2.getLocalName();
            if (string.equals("tbody") || string.equals("thead") || string.equals("tfoot") || this.isTableName(string)) {
                this.rowContainer = element2;
                break;
            }
            element2 = element2.getParentElement();
        }
        if (this.rowContainer == null) {
            return;
        }
        int n = 0;
        Node node = this.rowContainer.getFirstChild();
        while (node != null) {
            Element element3;
            if (node instanceof Element && (element3 = (Element)node).getLocalName().equals("tr")) {
                Node node2 = element3.getFirstChild();
                while (node2 != null) {
                    Element element4;
                    String string;
                    if (node2 instanceof Element && ((string = (element4 = (Element)node2).getLocalName()).equals("td") || string.equals("th"))) {
                        int n2;
                        if (element4 == element) {
                            this.cellRowWithinGroup = n;
                        }
                        if (n + (n2 = StyleSpecsImpl.getIntAttribute(element4, ROWSPAN, 1, 1)) > this.rowGroupSpan) {
                            this.rowGroupSpan = n + n2;
                        }
                    }
                    node2 = node2.getNextSibling();
                }
                ++n;
            }
            node = node.getNextSibling();
        }
    }

    private void initColSubgroups(Element element) {
        ColSubgroup colSubgroup;
        this.compileColSubgroups(element);
        this.cellColumn = 0;
        this.cellColSubgroup = null;
        this.spanHelper.reset();
        if (this.rowContainer == null) {
            return;
        }
        Node node = this.rowContainer.getFirstChild();
        block0: while (node != null) {
            Element element2;
            if (node instanceof Element && (element2 = (Element)node).getLocalName().equals("tr")) {
                this.spanHelper.addRow();
                colSubgroup = element2.getFirstChild();
                while (colSubgroup != null) {
                    if (colSubgroup instanceof Element) {
                        Element element3 = (Element)colSubgroup;
                        if (element3 == element) {
                            this.cellColumn = this.spanHelper.getNextColumn();
                            break block0;
                        }
                        String string = element3.getLocalName();
                        if (string.equals("td") || string.equals("th")) {
                            this.addCell(this.spanHelper, element3);
                        }
                    }
                    colSubgroup = colSubgroup.getNextSibling();
                }
            }
            node = node.getNextSibling();
        }
        int n = 0;
        while (n < this.colSubgroupCount) {
            colSubgroup = this.colSubgroups[n];
            if (this.cellColumn >= colSubgroup.first && this.cellColumn < colSubgroup.first + colSubgroup.span) {
                this.cellColSubgroup = colSubgroup;
                break;
            }
            ++n;
        }
    }

    private void addCell(SpanHelper spanHelper, Element element) {
        int n;
        int n2 = StyleSpecsImpl.getIntAttribute(element, ROWSPAN, 0, 1);
        if (n2 == 0 && (n2 = this.rowGroupSpan - (spanHelper.getNextRow() - 1)) <= 0) {
            n2 = 1;
        }
        if ((n = StyleSpecsImpl.getIntAttribute(element, COLSPAN, 0, 1)) == 0) {
            int n3 = spanHelper.getNextColumn();
            int n4 = 0;
            while (n4 < this.colSubgroupCount) {
                ColSubgroup colSubgroup = this.colSubgroups[n4];
                if (n3 >= colSubgroup.first && n3 < colSubgroup.first + colSubgroup.span) {
                    n = colSubgroup.group.span - (n3 - colSubgroup.group.first);
                    break;
                }
                ++n4;
            }
            if (n <= 0) {
                n = 1;
            }
        }
        spanHelper.addCell(n2, n);
    }

    private void compileColSubgroups(Element element) {
        this.colGroupCount = 0;
        this.colSubgroupCount = 0;
        Element element2 = null;
        Element element3 = null;
        Element element4 = element.getParentElement();
        while (element4 != null) {
            if (this.isTableName(element4.getLocalName())) {
                element2 = element4;
                break;
            }
            element3 = element4;
            element4 = element4.getParentElement();
        }
        if (element2 == null) {
            return;
        }
        int n = 0;
        Node node = element2.getFirstChild();
        while (node != null) {
            if (node == element3) break;
            if (node instanceof Element) {
                ColGroup colGroup;
                Element element5 = (Element)node;
                String string = element5.getLocalName();
                if (string.equals("colgroup")) {
                    colGroup = this.addColGroup(n, element5);
                    n = colGroup.first + colGroup.span;
                } else if (string.equals("col")) {
                    colGroup = this.addColSubgroup(n, null, element5);
                    n = ((ColSubgroup)colGroup).first + ((ColSubgroup)colGroup).span;
                }
            }
            node = node.getNextSibling();
        }
    }

    private ColGroup addColGroup(int n, Element element) {
        ColSubgroup colSubgroup;
        ColGroup colGroup = this.addColGroup();
        colGroup.first = n;
        colGroup.span = StyleSpecsImpl.getIntAttribute(element, SPAN, 1, 1);
        colGroup.width = element.getAttribute(WIDTH);
        colGroup.align = element.getAttribute(ALIGN);
        colGroup.valign = element.getAttribute(VALIGN);
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element && (colSubgroup = (Element)node).getLocalName().equals("col")) {
                ColSubgroup colSubgroup2 = this.addColSubgroup(n, colGroup, (Element)colSubgroup);
                n += colSubgroup2.span;
            }
            node = node.getNextSibling();
        }
        if (n > colGroup.first) {
            colGroup.span = n - colGroup.first;
        } else {
            colSubgroup = this.addColSubgroup();
            colSubgroup.group = colGroup;
            colSubgroup.first = colGroup.first;
            colSubgroup.span = colGroup.span;
            colSubgroup.width = colGroup.width;
            colSubgroup.align = colGroup.align;
            colSubgroup.valign = colGroup.valign;
        }
        return colGroup;
    }

    private ColGroup addColGroup() {
        if (this.colGroupCount == this.colGroups.length) {
            int n = Math.max(10, 2 * this.colGroupCount);
            ColGroup[] colGroupArray = new ColGroup[n];
            System.arraycopy(this.colGroups, 0, colGroupArray, 0, this.colGroupCount);
            int n2 = this.colGroupCount;
            while (n2 < n) {
                colGroupArray[n2] = new ColGroup();
                ++n2;
            }
            this.colGroups = colGroupArray;
        }
        return this.colGroups[this.colGroupCount++];
    }

    private ColSubgroup addColSubgroup(int n, ColGroup colGroup, Element element) {
        ColSubgroup colSubgroup = this.addColSubgroup();
        if (colGroup == null) {
            colGroup = colSubgroup;
        }
        colSubgroup.group = colGroup;
        colSubgroup.first = n;
        colSubgroup.span = StyleSpecsImpl.getIntAttribute(element, SPAN, 1, 1);
        colSubgroup.width = element.getAttribute(WIDTH);
        if (colSubgroup.width == null) {
            colSubgroup.width = colGroup.width;
        }
        colSubgroup.align = element.getAttribute(ALIGN);
        if (colSubgroup.align == null) {
            colSubgroup.align = colGroup.align;
        }
        colSubgroup.valign = element.getAttribute(VALIGN);
        if (colSubgroup.valign == null) {
            colSubgroup.valign = colGroup.valign;
        }
        return colSubgroup;
    }

    private ColSubgroup addColSubgroup() {
        if (this.colSubgroupCount == this.colSubgroups.length) {
            int n = Math.max(10, 2 * this.colSubgroupCount);
            ColSubgroup[] colSubgroupArray = new ColSubgroup[n];
            System.arraycopy(this.colSubgroups, 0, colSubgroupArray, 0, this.colSubgroupCount);
            int n2 = this.colSubgroupCount;
            while (n2 < n) {
                colSubgroupArray[n2] = new ColSubgroup();
                ++n2;
            }
            this.colSubgroups = colSubgroupArray;
        }
        return this.colSubgroups[this.colSubgroupCount++];
    }

    private int getRowSpan(Element element) {
        int n = StyleSpecsImpl.getIntAttribute(element, ROWSPAN, 0, 1);
        if (n == 0 && (n = this.rowGroupSpan - this.cellRowWithinGroup) <= 0) {
            n = 1;
        }
        return n;
    }

    private int getColSpan(Element element) {
        int n = StyleSpecsImpl.getIntAttribute(element, COLSPAN, 0, 1);
        if (n == 0) {
            if (this.cellColSubgroup == null) {
                n = 1;
            } else {
                n = this.cellColSubgroup.group.span - (this.cellColumn - this.cellColSubgroup.group.first);
                if (n <= 0) {
                    n = 1;
                }
            }
        }
        return n;
    }

    private int getRules(Element element) {
        String string;
        int n = 0;
        Element element2 = element.getParentElement();
        while (element2 != null) {
            if (this.isTableName(element2.getLocalName())) break;
            element2 = element2.getParentElement();
        }
        if (element2 == null) {
            return n;
        }
        int n2 = StyleSpecsImpl.getBorderAttribute(element2);
        if (n2 > 0) {
            n = 4;
        }
        if ((string = element2.getAttribute(RULES)) != null) {
            if (string.equals("groups")) {
                n = 1;
            } else if (string.equals("rows")) {
                n = 2;
            } else if (string.equals("cols")) {
                n = 3;
            } else if (string.equals("all")) {
                n = 4;
            } else if (string.equals("none")) {
                n = 0;
            }
        }
        return n;
    }

    private static final int getBorderAttribute(Element element) {
        String string = element.getAttribute(BORDER);
        if (string == null) {
            return 0;
        }
        return StyleSpecsImpl.parseInt(string, 0, 1);
    }

    private static final int getIntAttribute(Element element, Name name, int n, int n2) {
        int n3 = element.getIntAttribute(name, n2);
        return n3 < n ? n2 : n3;
    }

    private static final int parseInt(String string, int n, int n2) {
        int n3;
        try {
            n3 = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
        return n3 < n ? n2 : n3;
    }

    private static final boolean parseColWidth(String string, StyleValue styleValue) {
        double d;
        int n;
        string = string.trim();
        String string2 = null;
        if (string.endsWith("%")) {
            n = 20;
            string = string.substring(0, string.length() - 1);
        } else if (string.endsWith("*")) {
            n = 21;
            string2 = "*";
            string = string.substring(0, string.length() - 1);
        } else {
            n = 5;
        }
        if (n == 21 && string.length() == 0) {
            d = 1.0;
        } else {
            try {
                d = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                d = -1.0;
            }
            if (d < 0.0) {
                return false;
            }
        }
        if (n != 21 && d == 0.0) {
            return false;
        }
        styleValue.type = n;
        styleValue.number = d;
        styleValue.string = string2;
        return true;
    }

    private static final class ColSubgroup
    extends ColGroup {
        public ColGroup group;

        private ColSubgroup() {
        }
    }

    private static class ColGroup {
        public int first;
        public int span;
        public String width = null;
        public String align = null;
        public String valign = null;

        private ColGroup() {
        }
    }
}

