/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.xhtml.table;

import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmleditapp.xmlapputil.SpanHelper;
import java.util.ArrayList;

public abstract class TableCommand
extends RecordableCommand {
    protected static final Name ROWSPAN = Name.get((String)"rowspan");
    protected static final Name COLSPAN = Name.get((String)"colspan");
    protected static final Name SPAN = Name.get((String)"span");
    protected static final int CELL_TYPE_AUTO = 0;
    protected static final int CELL_TYPE_TH = 1;
    protected static final int CELL_TYPE_TD = 2;
    private boolean isRowCommand;
    protected Element selectedCell;
    protected boolean delete;
    protected boolean before;
    protected int cellType;

    protected TableCommand(boolean bl) {
        this.isRowCommand = bl;
    }

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        DocumentView documentView = (DocumentView)gadget;
        this.selectedCell = documentView.getSelectedElement(true);
        if (this.selectedCell == null) {
            return false;
        }
        this.selectedCell = TableCommand.findSelectedCell(this.selectedCell, this.isRowCommand);
        if (this.selectedCell == null) {
            return false;
        }
        if (string == null) {
            return false;
        }
        if ((string = string.trim()).startsWith("insertBefore")) {
            this.delete = false;
            this.before = true;
            this.cellType = TableCommand.parseCellType(string);
        } else if (string.startsWith("insertAfter")) {
            this.delete = false;
            this.before = false;
            this.cellType = TableCommand.parseCellType(string);
        } else if (string.startsWith("delete")) {
            this.delete = true;
        } else {
            return false;
        }
        Element element = this.findTable();
        if (element == null) {
            return false;
        }
        return element.isEditable() && element.findReadOnlyDescendant() == null;
    }

    /*
     * Unable to fully structure code
     */
    public static final Element findSelectedCell(Element var0, boolean var1_1) {
        block3: {
            var2_2 = var0.getLocalName();
            if (!var1_1 || !var2_2.equals("tr")) ** GOTO lbl14
            var3_3 = var0.getFirstChild();
            var0 = null;
            while (var3_3 != null) {
                if (var3_3 instanceof Element && ((var2_2 = (var4_4 = (Element)var3_3).getLocalName()).equals("td") || var2_2.equals("th"))) {
                    var0 = var4_4;
                    break block3;
                }
                var3_3 = var3_3.getNextSibling();
            }
            break block3;
            while (!(var2_2 = var0.getLocalName()).equals("td") && !var2_2.equals("th")) {
                var0 = var0.getParentElement();
lbl14:
                // 2 sources

                if (var0 != null) continue;
            }
        }
        return var0;
    }

    private static final int parseCellType(String string) {
        if (string.endsWith("th")) {
            return 1;
        }
        if (string.endsWith("td")) {
            return 2;
        }
        return 0;
    }

    protected Element findTable() {
        Element element = this.selectedCell.getParentElement();
        while (element != null) {
            if (this.isTableName(element.getLocalName())) {
                return element;
            }
            element = element.getParentElement();
        }
        return null;
    }

    protected boolean isTableName(String string) {
        return "table".equals(string);
    }

    protected Element newCell(Element element) {
        Name name;
        switch (this.cellType) {
            case 1: {
                name = Name.get((Namespace)element.getNamespace(), (String)"th");
                break;
            }
            case 2: {
                name = Name.get((Namespace)element.getNamespace(), (String)"td");
                break;
            }
            default: {
                name = element.getName();
            }
        }
        Element element2 = new Element(name);
        element2.appendChild((Node)new Text());
        return element2;
    }

    protected static final Group findGroup(ArrayList arrayList, int n) {
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < n2) {
            Group group = (Group)arrayList.get(n3);
            if (n >= group.first && n < group.first + group.span) {
                return group;
            }
            ++n3;
        }
        return null;
    }

    protected static final Cell findCell(ArrayList arrayList, Element element) {
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            Cell cell = (Cell)arrayList.get(n2);
            if (cell.cell == element) {
                return cell;
            }
            ++n2;
        }
        return null;
    }

    protected static final void compileTable(Element element, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        TableCommand.compileRowGroups(element, arrayList);
        TableCommand.compileColGroups(element, arrayList2);
        TableCommand.addCells(element, arrayList, arrayList2, new SpanHelper(), arrayList3);
    }

    private static final void compileRowGroups(Element element, ArrayList arrayList) {
        int n = 0;
        Node node = element.getFirstChild();
        while (node != null) {
            Element element2;
            String string;
            if (node instanceof Element && ((string = (element2 = (Element)node).getLocalName()).equals("thead") || string.equals("tfoot") || string.equals("tbody"))) {
                Group group = TableCommand.addRowGroup(n, element2, arrayList);
                n = group.first + group.span;
            }
            node = node.getNextSibling();
        }
        if (arrayList.size() == 0) {
            TableCommand.addRowGroup(0, element, arrayList);
        }
    }

    private static final Group addRowGroup(int n, Element element, ArrayList arrayList) {
        Group group = new Group();
        group.group = element;
        group.first = n;
        group.span = 1;
        int n2 = 0;
        Node node = element.getFirstChild();
        while (node != null) {
            Element element2;
            if (node instanceof Element && (element2 = (Element)node).getLocalName().equals("tr")) {
                Node node2 = element2.getFirstChild();
                while (node2 != null) {
                    int n3;
                    Element element3;
                    String string;
                    if (node2 instanceof Element && ((string = (element3 = (Element)node2).getLocalName()).equals("td") || string.equals("th")) && n2 + (n3 = element3.getIntAttribute(ROWSPAN, 1, Integer.MAX_VALUE, 1)) > group.span) {
                        group.span = n2 + n3;
                    }
                    node2 = node2.getNextSibling();
                }
                ++n2;
            }
            node = node.getNextSibling();
        }
        arrayList.add(group);
        return group;
    }

    private static final void compileColGroups(Element element, ArrayList arrayList) {
        int n = 0;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Group group;
                Element element2 = (Element)node;
                String string = element2.getLocalName();
                if (string.equals("colgroup")) {
                    group = TableCommand.addColGroup(n, element2, arrayList);
                    n = group.first + group.span;
                } else if (string.equals("col")) {
                    group = TableCommand.addCol(n, element2, arrayList);
                    n = group.first + group.span;
                }
            }
            node = node.getNextSibling();
        }
    }

    private static final Group addColGroup(int n, Element element, ArrayList arrayList) {
        Group group = new Group();
        group.group = element;
        group.first = n;
        group.span = element.getIntAttribute(SPAN, 1, Integer.MAX_VALUE, 1);
        Node node = element.getFirstChild();
        while (node != null) {
            Element element2;
            if (node instanceof Element && (element2 = (Element)node).getLocalName().equals("col")) {
                Group group2 = TableCommand.addCol(n, element2, arrayList);
                n += group2.span;
            }
            node = node.getNextSibling();
        }
        if (n > group.first) {
            group.span = n - group.first;
        } else {
            arrayList.add(group);
        }
        return group;
    }

    private static final Group addCol(int n, Element element, ArrayList arrayList) {
        Group group = new Group();
        group.group = element;
        group.first = n;
        group.span = element.getIntAttribute(SPAN, 1, Integer.MAX_VALUE, 1);
        arrayList.add(group);
        return group;
    }

    private static final void addCells(Element element, ArrayList arrayList, ArrayList arrayList2, SpanHelper spanHelper, ArrayList arrayList3) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Element element2 = (Element)node;
                if (element2.getLocalName().equals("tr")) {
                    TableCommand.addRow(element2, arrayList, arrayList2, spanHelper, arrayList3);
                } else {
                    TableCommand.addCells(element2, arrayList, arrayList2, spanHelper, arrayList3);
                }
            }
            node = node.getNextSibling();
        }
    }

    private static final void addRow(Element element, ArrayList arrayList, ArrayList arrayList2, SpanHelper spanHelper, ArrayList arrayList3) {
        spanHelper.addRow();
        Node node = element.getFirstChild();
        while (node != null) {
            Element element2;
            String string;
            if (node instanceof Element && ((string = (element2 = (Element)node).getLocalName()).equals("td") || string.equals("th"))) {
                TableCommand.addCell(element2, arrayList, arrayList2, spanHelper, arrayList3);
            }
            node = node.getNextSibling();
        }
    }

    private static final void addCell(Element element, ArrayList arrayList, ArrayList arrayList2, SpanHelper spanHelper, ArrayList arrayList3) {
        Group group;
        Cell cell = new Cell();
        cell.cell = element;
        cell.row = spanHelper.getNextRow() - 1;
        cell.col = spanHelper.getNextColumn();
        cell.specRowSpan = element.getIntAttribute(ROWSPAN, 0, Integer.MAX_VALUE, 1);
        if (cell.specRowSpan == 0) {
            group = TableCommand.findGroup(arrayList, cell.row);
            if (group == null) {
                cell.rowSpan = 1;
            } else {
                cell.rowSpan = group.first + group.span - cell.row;
                if (cell.rowSpan <= 0) {
                    cell.rowSpan = 1;
                }
            }
        } else {
            cell.rowSpan = cell.specRowSpan;
        }
        cell.specColSpan = element.getIntAttribute(COLSPAN, 0, Integer.MAX_VALUE, 1);
        if (cell.specColSpan == 0) {
            group = TableCommand.findGroup(arrayList2, cell.col);
            if (group == null) {
                cell.colSpan = 1;
            } else {
                cell.colSpan = group.first + group.span - cell.col;
                if (cell.colSpan <= 0) {
                    cell.colSpan = 1;
                }
            }
        } else {
            cell.colSpan = cell.specColSpan;
        }
        spanHelper.addCell(cell.rowSpan, cell.colSpan);
        arrayList3.add(cell);
    }

    protected static final class Cell {
        public Element cell;
        public int row;
        public int col;
        public int rowSpan;
        public int colSpan;
        public int specRowSpan;
        public int specColSpan;

        protected Cell() {
        }
    }

    protected static final class Group {
        public Element group;
        public int first;
        public int span;

        protected Group() {
        }
    }
}

