/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.xhtml.table;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.guiutil.ShowStatus;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmleditapp.xhtml.table.Msg;
import com.xmlmind.xmleditapp.xhtml.table.TableCommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class TableRow
extends TableCommand {
    private static final Name ALIGN = Name.get((String)"align");
    private static final Name CHAR = Name.get((String)"char");
    private static final Name CHAROFF = Name.get((String)"charoff");
    private static final Name VALIGN = Name.get((String)"valign");
    private static CellCompare cellCompare = new CellCompare();

    public TableRow() {
        super(true);
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        String string2;
        Document document = documentView.getDocument();
        Element element = this.findTable();
        if (element == null) {
            ShowStatus.showStatus((String)Msg.msg("invalidTable"));
            return null;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        TableCommand.compileTable(element, arrayList, arrayList2, arrayList3);
        TableCommand.Cell cell = TableCommand.findCell(arrayList3, this.selectedCell);
        if (cell == null) {
            ShowStatus.showStatus((String)Msg.msg("invalidTable"));
            return null;
        }
        int n3 = cell.row;
        Element element2 = this.selectedCell.getParentElement();
        Element element3 = element2.getParentElement();
        Element element4 = null;
        if (this.delete) {
            if (TableRow.getRowCount(element3) <= 1) {
                ShowStatus.showStatus((String)Msg.msg("cannotDeleteLastRow"));
                return null;
            }
            document.beginBatchEditing();
            string2 = Msg.msg("deleteRow");
            int n4 = arrayList3.size();
            int n5 = 0;
            while (n5 < n4) {
                cell = (TableCommand.Cell)arrayList3.get(n5);
                if (n3 >= cell.row && n3 < cell.row + cell.rowSpan && cell.rowSpan > 1) {
                    if (n3 == cell.row) {
                        TableRow.insertShorterClone(cell, element2, arrayList3);
                    } else if (cell.specRowSpan != 0) {
                        cell.cell.putAttribute(TableCommand.ROWSPAN, Integer.toString(cell.rowSpan - 1));
                    }
                }
                ++n5;
            }
            element3.removeChild((Node)element2);
            element4 = element3;
        } else {
            document.beginBatchEditing();
            Element element5 = this.newRow(element2);
            ArrayList<TableCommand.Cell> arrayList4 = new ArrayList<TableCommand.Cell>();
            if (this.before) {
                string2 = Msg.msg("insertRowBefore");
                int n6 = arrayList3.size();
                int n7 = 0;
                while (n7 < n6) {
                    cell = (TableCommand.Cell)arrayList3.get(n7);
                    if (n3 >= cell.row && n3 < cell.row + cell.rowSpan) {
                        if (n3 == cell.row) {
                            TableCommand.Cell cell2 = new TableCommand.Cell();
                            cell2.cell = this.newCell(cell.cell);
                            cell2.col = cell.col;
                            arrayList4.add(cell2);
                        } else if (cell.specRowSpan != 0) {
                            cell.cell.putAttribute(TableCommand.ROWSPAN, Integer.toString(cell.rowSpan + 1));
                        }
                    }
                    ++n7;
                }
                TableRow.addCellsSortedByCol(arrayList4, element5);
                element3.insertChild((Node)element2, (Node)element5);
            } else {
                string2 = Msg.msg("insertRowAfter");
                int n8 = arrayList3.size();
                int n9 = 0;
                while (n9 < n8) {
                    cell = (TableCommand.Cell)arrayList3.get(n9);
                    if (n3 >= cell.row && n3 < cell.row + cell.rowSpan) {
                        if (n3 == cell.row + cell.rowSpan - 1 && cell.specRowSpan != 0) {
                            TableCommand.Cell cell3 = new TableCommand.Cell();
                            cell3.cell = this.newCell(cell.cell);
                            cell3.col = cell.col;
                            arrayList4.add(cell3);
                        } else if (cell.specRowSpan != 0) {
                            cell.cell.putAttribute(TableCommand.ROWSPAN, Integer.toString(cell.rowSpan + 1));
                        }
                    }
                    ++n9;
                }
                TableRow.addCellsSortedByCol(arrayList4, element5);
                element3.insertChild(element2.getNextSibling(), (Node)element5);
            }
            element4 = element5;
        }
        document.endBatchEditing();
        documentView.describeUndo(string2);
        if (element4 != null) {
            documentView.selectNode((Node)element4);
            documentView.moveDotInto((Node)element4);
        }
        return null;
    }

    private Element newRow(Element element) {
        Element element2 = new Element(Name.get((Namespace)element.getNamespace(), (String)"tr"));
        if (this.cellType == 0) {
            String string = element.getAttribute(ALIGN);
            if (string != null) {
                element2.putAttribute(ALIGN, string);
            }
            if ((string = element.getAttribute(CHAR)) != null) {
                element2.putAttribute(CHAR, string);
            }
            if ((string = element.getAttribute(CHAROFF)) != null) {
                element2.putAttribute(CHAROFF, string);
            }
            if ((string = element.getAttribute(VALIGN)) != null) {
                element2.putAttribute(VALIGN, string);
            }
        }
        return element2;
    }

    protected Element newCell(Element element) {
        Element element2 = super.newCell(element);
        String string = element.getAttribute(TableCommand.COLSPAN);
        if (string != null) {
            element2.putAttribute(TableCommand.COLSPAN, string);
        }
        if (this.cellType == 0) {
            string = element.getAttribute(ALIGN);
            if (string != null) {
                element2.putAttribute(ALIGN, string);
            }
            if ((string = element.getAttribute(CHAR)) != null) {
                element2.putAttribute(CHAR, string);
            }
            if ((string = element.getAttribute(CHAROFF)) != null) {
                element2.putAttribute(CHAROFF, string);
            }
            if ((string = element.getAttribute(VALIGN)) != null) {
                element2.putAttribute(VALIGN, string);
            }
        }
        return element2;
    }

    private static final int getRowCount(Element element) {
        int n = 0;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element && ((Element)node).getLocalName().equals("tr")) {
                ++n;
            }
            node = node.getNextSibling();
        }
        return n;
    }

    private static final void insertShorterClone(TableCommand.Cell cell, Element element, ArrayList arrayList) {
        Element element2 = null;
        Node node = element.getNextSibling();
        while (node != null) {
            if (node instanceof Element && ((Element)node).getLocalName().equals("tr")) {
                element2 = (Element)node;
                break;
            }
            node = node.getNextSibling();
        }
        if (element2 == null) {
            return;
        }
        Element element3 = (Element)cell.cell.copy();
        if (cell.specRowSpan != 0) {
            element3.putAttribute(TableCommand.ROWSPAN, Integer.toString(cell.rowSpan - 1));
        }
        TableCommand.Cell cell2 = new TableCommand.Cell();
        cell2.cell = element3;
        cell2.row = cell.row + 1;
        cell2.col = cell.col;
        cell2.rowSpan = cell.rowSpan - 1;
        cell2.colSpan = cell.colSpan;
        cell2.specRowSpan = cell.specRowSpan;
        cell2.specColSpan = cell.specColSpan;
        TableCommand.Cell cell3 = null;
        node = element2.getFirstChild();
        while (node != null) {
            TableCommand.Cell cell4;
            Element element4;
            String string;
            if (node instanceof Element && ((string = (element4 = (Element)node).getLocalName()).equals("td") || string.equals("th")) && (cell4 = TableCommand.findCell(arrayList, element4)) != null && cell4.col > cell.col) {
                cell3 = cell4;
                break;
            }
            node = node.getNextSibling();
        }
        if (cell3 == null) {
            element2.appendChild((Node)element3);
            arrayList.add(cell2);
        } else {
            element2.insertChild((Node)cell3.cell, (Node)element3);
            arrayList.add(arrayList.indexOf(cell3), cell2);
        }
    }

    private static final void addCellsSortedByCol(ArrayList arrayList, Element element) {
        Collections.sort(arrayList, cellCompare);
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            TableCommand.Cell cell = (TableCommand.Cell)arrayList.get(n2);
            element.appendChild((Node)cell.cell);
            ++n2;
        }
    }

    private static final class CellCompare
    implements Comparator {
        private CellCompare() {
        }

        public int compare(Object object, Object object2) {
            return ((TableCommand.Cell)object).col - ((TableCommand.Cell)object2).col;
        }
    }
}

