/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.FilenameMangler;
import HTTPClient.HttpHeaderElement;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Util;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.BitSet;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class Codecs {
    private static BitSet BoundChar;
    private static BitSet EBCDICUnsafeChar;
    private static byte[] Base64EncMap;
    private static byte[] Base64DecMap;
    private static char[] UUEncMap;
    private static byte[] UUDecMap;
    private static final String ContDisp = "\r\nContent-Disposition: form-data; name=\"";
    private static final String FileName = "\"; filename=\"";
    private static final String ContType = "\r\nContent-Type: ";
    private static final String Boundary = "\r\n----------ieoau._._+2_8_GoodLuck8.3-dskdfJwSJKl234324jfLdsjfdAuaoei-----";
    private static NVPair[] dummy;

    private Codecs() {
    }

    public static final String base64Encode(String str) {
        if (str == null) {
            return null;
        }
        try {
            return new String(Codecs.base64Encode(str.getBytes("8859_1")), "8859_1");
        }
        catch (UnsupportedEncodingException uee) {
            throw new Error(uee.toString());
        }
    }

    public static final byte[] base64Encode(byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] dest = new byte[(data.length + 2) / 3 * 4];
        int sidx = 0;
        int didx = 0;
        while (sidx < data.length - 2) {
            dest[didx++] = Base64EncMap[data[sidx] >>> 2 & 0x3F];
            dest[didx++] = Base64EncMap[data[sidx + 1] >>> 4 & 0xF | data[sidx] << 4 & 0x3F];
            dest[didx++] = Base64EncMap[data[sidx + 2] >>> 6 & 3 | data[sidx + 1] << 2 & 0x3F];
            dest[didx++] = Base64EncMap[data[sidx + 2] & 0x3F];
            sidx += 3;
        }
        if (sidx < data.length) {
            dest[didx++] = Base64EncMap[data[sidx] >>> 2 & 0x3F];
            if (sidx < data.length - 1) {
                dest[didx++] = Base64EncMap[data[sidx + 1] >>> 4 & 0xF | data[sidx] << 4 & 0x3F];
                dest[didx++] = Base64EncMap[data[sidx + 1] << 2 & 0x3F];
            } else {
                dest[didx++] = Base64EncMap[data[sidx] << 4 & 0x3F];
            }
        }
        while (didx < dest.length) {
            dest[didx] = 61;
            ++didx;
        }
        return dest;
    }

    public static final String base64Decode(String str) {
        if (str == null) {
            return null;
        }
        try {
            return new String(Codecs.base64Decode(str.getBytes("8859_1")), "8859_1");
        }
        catch (UnsupportedEncodingException uee) {
            throw new Error(uee.toString());
        }
    }

    public static final byte[] base64Decode(byte[] data) {
        if (data == null) {
            return null;
        }
        int tail = data.length;
        while (data[tail - 1] == 61) {
            --tail;
        }
        byte[] dest = new byte[tail - data.length / 4];
        int idx = 0;
        while (idx < data.length) {
            data[idx] = Base64DecMap[data[idx]];
            ++idx;
        }
        int sidx = 0;
        int didx = 0;
        while (didx < dest.length - 2) {
            dest[didx] = (byte)(data[sidx] << 2 & 0xFF | data[sidx + 1] >>> 4 & 3);
            dest[didx + 1] = (byte)(data[sidx + 1] << 4 & 0xFF | data[sidx + 2] >>> 2 & 0xF);
            dest[didx + 2] = (byte)(data[sidx + 2] << 6 & 0xFF | data[sidx + 3] & 0x3F);
            sidx += 4;
            didx += 3;
        }
        if (didx < dest.length) {
            dest[didx] = (byte)(data[sidx] << 2 & 0xFF | data[sidx + 1] >>> 4 & 3);
        }
        if (++didx < dest.length) {
            dest[didx] = (byte)(data[sidx + 1] << 4 & 0xFF | data[sidx + 2] >>> 2 & 0xF);
        }
        return dest;
    }

    public static final char[] uuencode(byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length == 0) {
            return new char[0];
        }
        int line_len = 45;
        char[] nl = System.getProperty("line.separator", "\n").toCharArray();
        char[] dest = new char[(data.length + 2) / 3 * 4 + (data.length + line_len - 1) / line_len * (nl.length + 1)];
        int sidx = 0;
        int didx = 0;
        while (sidx + line_len < data.length) {
            dest[didx++] = UUEncMap[line_len];
            int end = sidx + line_len;
            while (sidx < end) {
                dest[didx++] = UUEncMap[data[sidx] >>> 2 & 0x3F];
                dest[didx++] = UUEncMap[data[sidx + 1] >>> 4 & 0xF | data[sidx] << 4 & 0x3F];
                dest[didx++] = UUEncMap[data[sidx + 2] >>> 6 & 3 | data[sidx + 1] << 2 & 0x3F];
                dest[didx++] = UUEncMap[data[sidx + 2] & 0x3F];
                sidx += 3;
            }
            int idx = 0;
            while (idx < nl.length) {
                dest[didx++] = nl[idx];
                ++idx;
            }
        }
        dest[didx++] = UUEncMap[data.length - sidx];
        while (sidx + 2 < data.length) {
            dest[didx++] = UUEncMap[data[sidx] >>> 2 & 0x3F];
            dest[didx++] = UUEncMap[data[sidx + 1] >>> 4 & 0xF | data[sidx] << 4 & 0x3F];
            dest[didx++] = UUEncMap[data[sidx + 2] >>> 6 & 3 | data[sidx + 1] << 2 & 0x3F];
            dest[didx++] = UUEncMap[data[sidx + 2] & 0x3F];
            sidx += 3;
        }
        if (sidx < data.length - 1) {
            dest[didx++] = UUEncMap[data[sidx] >>> 2 & 0x3F];
            dest[didx++] = UUEncMap[data[sidx + 1] >>> 4 & 0xF | data[sidx] << 4 & 0x3F];
            dest[didx++] = UUEncMap[data[sidx + 1] << 2 & 0x3F];
            dest[didx++] = UUEncMap[0];
        } else if (sidx < data.length) {
            dest[didx++] = UUEncMap[data[sidx] >>> 2 & 0x3F];
            dest[didx++] = UUEncMap[data[sidx] << 4 & 0x3F];
            dest[didx++] = UUEncMap[0];
            dest[didx++] = UUEncMap[0];
        }
        int idx = 0;
        while (idx < nl.length) {
            dest[didx++] = nl[idx];
            ++idx;
        }
        if (didx != dest.length) {
            throw new Error("Calculated " + dest.length + " chars but wrote " + didx + " chars!");
        }
        return dest;
    }

    private static final byte[] uudecode(BufferedReader rdr) throws ParseException, IOException {
        String line;
        while ((line = rdr.readLine()) != null && !line.startsWith("begin ")) {
        }
        if (line == null) {
            throw new ParseException("'begin' line not found");
        }
        StringTokenizer tok = new StringTokenizer(line);
        tok.nextToken();
        try {
            int file_mode = Integer.parseInt(tok.nextToken(), 8);
        }
        catch (Exception e) {
            throw new ParseException("Invalid mode on line: " + line);
        }
        try {
            String file_name = tok.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new ParseException("No file name found on line: " + line);
        }
        byte[] body = new byte[1000];
        int off = 0;
        while ((line = rdr.readLine()) != null && !line.equals("end")) {
            byte[] tmp = Codecs.uudecode(line.toCharArray());
            if (off + tmp.length > body.length) {
                body = Util.resizeArray(body, off + 1000);
            }
            System.arraycopy(tmp, 0, body, off, tmp.length);
            off += tmp.length;
        }
        if (line == null) {
            throw new ParseException("'end' line not found");
        }
        return Util.resizeArray(body, off);
    }

    public static final byte[] uudecode(char[] data) {
        if (data == null) {
            return null;
        }
        byte[] dest = new byte[data.length / 4 * 3];
        int sidx = 0;
        int didx = 0;
        while (sidx < data.length) {
            byte B;
            byte A;
            byte len = UUDecMap[data[sidx++]];
            int end = didx + len;
            while (didx < end - 2) {
                A = UUDecMap[data[sidx]];
                B = UUDecMap[data[sidx + 1]];
                byte C = UUDecMap[data[sidx + 2]];
                byte D = UUDecMap[data[sidx + 3]];
                dest[didx++] = (byte)(A << 2 & 0xFF | B >>> 4 & 3);
                dest[didx++] = (byte)(B << 4 & 0xFF | C >>> 2 & 0xF);
                dest[didx++] = (byte)(C << 6 & 0xFF | D & 0x3F);
                sidx += 4;
            }
            if (didx < end) {
                A = UUDecMap[data[sidx]];
                B = UUDecMap[data[sidx + 1]];
                dest[didx++] = (byte)(A << 2 & 0xFF | B >>> 4 & 3);
            }
            if (didx < end) {
                byte B2 = UUDecMap[data[sidx + 1]];
                byte C = UUDecMap[data[sidx + 2]];
                dest[didx++] = (byte)(B2 << 4 & 0xFF | C >>> 2 & 0xF);
            }
            while (sidx < data.length && data[sidx] != '\n' && data[sidx] != '\r') {
                ++sidx;
            }
            while (sidx < data.length && (data[sidx] == '\n' || data[sidx] == '\r')) {
                ++sidx;
            }
        }
        return Util.resizeArray(dest, didx);
    }

    public static final String quotedPrintableEncode(String str) {
        if (str == null) {
            return null;
        }
        char[] map = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] nl = System.getProperty("line.separator", "\n").toCharArray();
        char[] res = new char[(int)((double)str.length() * 1.5)];
        char[] src = str.toCharArray();
        int cnt = 0;
        int didx = 1;
        boolean last = false;
        int slen = str.length();
        int sidx = 0;
        while (sidx < slen) {
            char ch = src[sidx];
            if (ch == nl[0] && Codecs.match(src, sidx, nl)) {
                if (res[didx - 1] == ' ') {
                    res[didx - 1] = 61;
                    res[didx++] = 50;
                    res[didx++] = 48;
                } else if (res[didx - 1] == '\t') {
                    res[didx - 1] = 61;
                    res[didx++] = 48;
                    res[didx++] = 57;
                }
                res[didx++] = 13;
                res[didx++] = 10;
                sidx += nl.length - 1;
                cnt = didx;
            } else if (ch > '~' || ch < ' ' && ch != '\t' || ch == '=' || EBCDICUnsafeChar.get(ch)) {
                res[didx++] = 61;
                res[didx++] = map[(ch & 0xF0) >>> 4];
                res[didx++] = map[ch & 0xF];
            } else {
                res[didx++] = ch;
            }
            if (didx > cnt + 70) {
                res[didx++] = 61;
                res[didx++] = 13;
                res[didx++] = 10;
                cnt = didx;
            }
            if (didx > res.length - 5) {
                res = Util.resizeArray(res, res.length + 500);
            }
            ++sidx;
        }
        return String.valueOf(res, 1, didx - 1);
    }

    private static final boolean match(char[] str, int start, char[] arr) {
        if (str.length < start + arr.length) {
            return false;
        }
        int idx = 1;
        while (idx < arr.length) {
            if (str[start + idx] != arr[idx]) {
                return false;
            }
            ++idx;
        }
        return true;
    }

    public static final String quotedPrintableDecode(String str) throws ParseException {
        if (str == null) {
            return null;
        }
        char[] res = new char[(int)((double)str.length() * 1.1)];
        char[] src = str.toCharArray();
        char[] nl = System.getProperty("line.separator", "\n").toCharArray();
        int last = 0;
        int didx = 0;
        int slen = str.length();
        int sidx = 0;
        while (sidx < slen) {
            char ch;
            if ((ch = src[sidx++]) == '=') {
                if (sidx >= slen - 1) {
                    throw new ParseException("Premature end of input detected");
                }
                if (src[sidx] == '\n' || src[sidx] == '\r') {
                    if (src[++sidx - 1] == '\r' && src[sidx] == '\n') {
                        ++sidx;
                    }
                } else {
                    int lo;
                    int hi = Character.digit(src[sidx], 16);
                    if ((hi | (lo = Character.digit(src[sidx + 1], 16))) < 0) {
                        throw new ParseException(new String(src, sidx - 1, 3) + " is an invalid code");
                    }
                    char repl = (char)(hi << 4 | lo);
                    sidx += 2;
                    res[didx++] = repl;
                }
                last = didx;
            } else if (ch == '\n' || ch == '\r') {
                if (ch == '\r' && sidx < slen && src[sidx] == '\n') {
                    ++sidx;
                }
                int idx = 0;
                while (idx < nl.length) {
                    res[last++] = nl[idx];
                    ++idx;
                }
                didx = last;
            } else {
                res[didx++] = ch;
                if (ch != ' ' && ch != '\t') {
                    last = didx;
                }
            }
            if (didx <= res.length - nl.length - 2) continue;
            res = Util.resizeArray(res, res.length + 500);
        }
        return new String(res, 0, didx);
    }

    public static final String URLEncode(String str) {
        if (str == null) {
            return null;
        }
        return URLEncoder.encode(str);
    }

    public static final String URLDecode(String str) throws ParseException {
        if (str == null) {
            return null;
        }
        char[] res = new char[str.length()];
        int didx = 0;
        int sidx = 0;
        while (sidx < str.length()) {
            char ch = str.charAt(sidx);
            if (ch == '+') {
                res[didx++] = 32;
            } else if (ch == '%') {
                try {
                    res[didx++] = (char)Integer.parseInt(str.substring(sidx + 1, sidx + 3), 16);
                    sidx += 2;
                }
                catch (NumberFormatException e) {
                    throw new ParseException(str.substring(sidx, sidx + 3) + " is an invalid code");
                }
            } else {
                res[didx++] = ch;
            }
            ++sidx;
        }
        return String.valueOf(res, 0, didx);
    }

    public static final NVPair[] mpFormDataDecode(byte[] data, String cont_type, String dir) throws IOException, ParseException {
        return Codecs.mpFormDataDecode(data, cont_type, dir, null);
    }

    public static final NVPair[] mpFormDataDecode(byte[] data, String cont_type, String dir, FilenameMangler mangler) throws IOException, ParseException {
        String bndstr = Util.getParameter("boundary", cont_type);
        if (bndstr == null) {
            throw new ParseException("'boundary' parameter not found in Content-type: " + cont_type);
        }
        byte[] srtbndry = ("--" + bndstr + "\r\n").getBytes("8859_1");
        byte[] boundary = ("\r\n--" + bndstr + "\r\n").getBytes("8859_1");
        byte[] endbndry = ("\r\n--" + bndstr + "--").getBytes("8859_1");
        int[] bs = Util.compile_search(srtbndry);
        int[] bc = Util.compile_search(boundary);
        int[] be = Util.compile_search(endbndry);
        int start = Util.findStr(srtbndry, bs, data, 0, data.length);
        if (start == -1) {
            throw new ParseException("Starting boundary not found: " + new String(srtbndry, "8859_1"));
        }
        start += srtbndry.length;
        NVPair[] res = new NVPair[10];
        boolean done = false;
        int idx = 0;
        while (!done) {
            String value;
            int next;
            int end = Util.findStr(boundary, bc, data, start, data.length);
            if (end == -1) {
                end = Util.findStr(endbndry, be, data, start, data.length);
                if (end == -1) {
                    throw new ParseException("Ending boundary not found: " + new String(endbndry, "8859_1"));
                }
                done = true;
            }
            String name = null;
            String filename = null;
            String cont_disp = null;
            while ((next = Codecs.findEOL(data, start) + 2) - 2 > start) {
                byte ch;
                String hdr = new String(data, start, next - 2 - start, "8859_1");
                start = next;
                while (next < data.length - 1 && ((ch = data[next]) == 32 || ch == 9)) {
                    next = Codecs.findEOL(data, start) + 2;
                    hdr = hdr + new String(data, start, next - 2 - start, "8859_1");
                    start = next;
                }
                if (!hdr.regionMatches(true, 0, "Content-Disposition", 0, 19)) continue;
                Vector pcd = Util.parseHeader(hdr.substring(hdr.indexOf(58) + 1));
                HttpHeaderElement elem = Util.getElement(pcd, "form-data");
                if (elem == null) {
                    throw new ParseException("Expected 'Content-Disposition: form-data' in line: " + hdr);
                }
                NVPair[] params = elem.getParams();
                filename = null;
                name = null;
                int pidx = 0;
                while (pidx < params.length) {
                    if (params[pidx].getName().equalsIgnoreCase("name")) {
                        name = params[pidx].getValue();
                    }
                    if (params[pidx].getName().equalsIgnoreCase("filename")) {
                        filename = params[pidx].getValue();
                    }
                    ++pidx;
                }
                if (name == null) {
                    throw new ParseException("'name' parameter not found in header: " + hdr);
                }
                cont_disp = hdr;
            }
            if ((start += 2) > end) {
                throw new ParseException("End of header not found at offset " + end);
            }
            if (cont_disp == null) {
                throw new ParseException("Missing 'Content-Disposition' header at offset " + start);
            }
            if (filename != null) {
                if (mangler != null) {
                    filename = mangler.mangleFilename(filename, name);
                }
                if (filename != null && filename.length() > 0) {
                    File file = new File(dir, filename);
                    FileOutputStream out = new FileOutputStream(file);
                    out.write(data, start, end - start);
                    out.close();
                }
                value = filename;
            } else {
                value = new String(data, start, end - start, "8859_1");
            }
            if (idx >= res.length) {
                res = Util.resizeArray(res, idx + 10);
            }
            res[idx] = new NVPair(name, value);
            start = end + boundary.length;
            ++idx;
        }
        return Util.resizeArray(res, idx);
    }

    private static final int findEOL(byte[] arr, int off) {
        while (off < arr.length - 1 && (arr[off++] != 13 || arr[off] != 10)) {
        }
        return off - 1;
    }

    public static final byte[] mpFormDataEncode(NVPair[] opts, NVPair[] files, NVPair[] ct_hdr) throws IOException {
        return Codecs.mpFormDataEncode(opts, files, ct_hdr, null);
    }

    /*
     * Unable to fully structure code
     */
    public static final byte[] mpFormDataEncode(NVPair[] opts, NVPair[] files, NVPair[] ct_hdr, FilenameMangler mangler) throws IOException {
        boundary = "\r\n----------ieoau._._+2_8_GoodLuck8.3-dskdfJwSJKl234324jfLdsjfdAuaoei-----".getBytes("8859_1");
        cont_disp = "\r\nContent-Disposition: form-data; name=\"".getBytes("8859_1");
        cont_type = "\r\nContent-Type: ".getBytes("8859_1");
        filename = "\"; filename=\"".getBytes("8859_1");
        len = 0;
        hdr_len = boundary.length + cont_disp.length + 1 + 2 + 2;
        if (opts == null) {
            opts = Codecs.dummy;
        }
        if (files == null) {
            files = Codecs.dummy;
        }
        idx = 0;
        while (idx < opts.length) {
            if (opts[idx] != null) {
                len += hdr_len + opts[idx].getName().length() + opts[idx].getValue().length();
            }
            ++idx;
        }
        idx = 0;
        while (idx < files.length) {
            if (files[idx] != null) {
                file = new File(files[idx].getValue());
                fname = file.getName();
                if (mangler != null) {
                    fname = mangler.mangleFilename(fname, files[idx].getName());
                }
                if (fname != null) {
                    len += hdr_len + files[idx].getName().length() + filename.length;
                    len = (int)((long)len + ((long)fname.length() + file.length()));
                    ct = CT.getContentType(file.getName());
                    if (ct != null) {
                        len += cont_type.length + ct.length();
                    }
                }
            }
            ++idx;
        }
        if (len == 0) {
            ct_hdr[0] = new NVPair("Content-Type", "application/octet-stream");
            return new byte[0];
        }
        len -= 2;
        res = new byte[len += boundary.length + 2 + 2];
        pos = 0;
        new_c = 0x30303030;
        block2: while (new_c != 0x7A7A7A7A) {
            pos = 0;
            while (!Codecs.BoundChar.get(new_c & 255)) {
                ++new_c;
            }
            while (!Codecs.BoundChar.get(new_c >> 8 & 255)) {
                new_c += 256;
            }
            while (!Codecs.BoundChar.get(new_c >> 16 & 255)) {
                new_c += 65536;
            }
            while (!Codecs.BoundChar.get(new_c >> 24 & 255)) {
                new_c += 0x1000000;
            }
            boundary[40] = (byte)(new_c & 255);
            boundary[42] = (byte)(new_c >> 8 & 255);
            boundary[44] = (byte)(new_c >> 16 & 255);
            boundary[46] = (byte)(new_c >> 24 & 255);
            off = 2;
            bnd_cmp = Util.compile_search(boundary);
            idx = 0;
            while (idx < opts.length) {
                block27: {
                    if (opts[idx] == null) break block27;
                    System.arraycopy(boundary, off, res, pos, boundary.length - off);
                    off = 0;
                    start = pos += boundary.length - off;
                    System.arraycopy(cont_disp, 0, res, pos, cont_disp.length);
                    nlen = opts[idx].getName().length();
                    System.arraycopy(opts[idx].getName().getBytes("8859_1"), 0, res, pos += cont_disp.length, nlen);
                    pos += nlen;
                    res[pos++] = 34;
                    res[pos++] = 13;
                    res[pos++] = 10;
                    res[pos++] = 13;
                    res[pos++] = 10;
                    vlen = opts[idx].getValue().length();
                    System.arraycopy(opts[idx].getValue().getBytes("8859_1"), 0, res, pos, vlen);
                    if ((pos += vlen) - start >= boundary.length && Util.findStr(boundary, bnd_cmp, res, start, pos) != -1) ** GOTO lbl121
                }
                ++idx;
            }
            idx = 0;
            while (idx < files.length) {
                block29: {
                    block28: {
                        if (files[idx] == null) break block28;
                        file = new File(files[idx].getValue());
                        fname = file.getName();
                        if (mangler != null) {
                            fname = mangler.mangleFilename(fname, files[idx].getName());
                        }
                        if (fname == null) break block28;
                        System.arraycopy(boundary, off, res, pos, boundary.length - off);
                        off = 0;
                        start = pos += boundary.length - off;
                        System.arraycopy(cont_disp, 0, res, pos, cont_disp.length);
                        nlen = files[idx].getName().length();
                        System.arraycopy(files[idx].getName().getBytes("8859_1"), 0, res, pos += cont_disp.length, nlen);
                        System.arraycopy(filename, 0, res, pos += nlen, filename.length);
                        nlen = fname.length();
                        System.arraycopy(fname.getBytes("8859_1"), 0, res, pos += filename.length, nlen);
                        pos += nlen;
                        res[pos++] = 34;
                        ct = CT.getContentType(file.getName());
                        if (ct != null) {
                            System.arraycopy(cont_type, 0, res, pos, cont_type.length);
                            System.arraycopy(ct.getBytes("8859_1"), 0, res, pos += cont_type.length, ct.length());
                            pos += ct.length();
                        }
                        res[pos++] = 13;
                        res[pos++] = 10;
                        res[pos++] = 13;
                        res[pos++] = 10;
                        nlen = (int)file.length();
                        fin = new FileInputStream(file);
                        while (nlen > 0) {
                            got = fin.read(res, pos, nlen);
                            nlen -= got;
                            pos += got;
                        }
                        fin.close();
                        if (pos - start >= boundary.length && Util.findStr(boundary, bnd_cmp, res, start, pos) != -1) break block29;
                    }
                    ++idx;
                    continue;
                }
                ++new_c;
                continue block2;
            }
            break block2;
        }
        System.arraycopy(boundary, 0, res, pos, boundary.length);
        pos += boundary.length;
        res[pos++] = 45;
        res[pos++] = 45;
        res[pos++] = 13;
        res[pos++] = 10;
        if (pos != len) {
            throw new Error("Calculated " + len + " bytes but wrote " + pos + " bytes!");
        }
        ct_hdr[0] = new NVPair("Content-Type", "multipart/form-data; boundary=" + new String(boundary, 4, boundary.length - 4, "8859_1"));
        return res;
    }

    public static final String nv2query(NVPair[] pairs) {
        if (pairs == null) {
            return null;
        }
        StringBuffer qbuf = new StringBuffer();
        int idx = 0;
        while (idx < pairs.length) {
            if (pairs[idx] != null) {
                qbuf.append(Codecs.URLEncode(pairs[idx].getName()) + "=" + Codecs.URLEncode(pairs[idx].getValue()) + "&");
            }
            ++idx;
        }
        if (qbuf.length() > 0) {
            qbuf.setLength(qbuf.length() - 1);
        }
        return qbuf.toString();
    }

    public static final NVPair[] query2nv(String query) throws ParseException {
        if (query == null) {
            return null;
        }
        int idx = -1;
        int cnt = 1;
        while ((idx = query.indexOf(38, idx + 1)) != -1) {
            ++cnt;
        }
        NVPair[] pairs = new NVPair[cnt];
        idx = 0;
        cnt = 0;
        while (cnt < pairs.length) {
            int eq = query.indexOf(61, idx);
            int end = query.indexOf(38, idx);
            if (end == -1) {
                end = query.length();
            }
            if (eq == -1 || eq >= end) {
                throw new ParseException("'=' missing in " + query.substring(idx, end));
            }
            pairs[cnt] = new NVPair(Codecs.URLDecode(query.substring(idx, eq)), Codecs.URLDecode(query.substring(eq + 1, end)));
            idx = end + 1;
            ++cnt;
        }
        return pairs;
    }

    public static final byte[] chunkedEncode(byte[] data, NVPair[] ftrs, boolean last) {
        return Codecs.chunkedEncode(data, 0, data == null ? 0 : data.length, ftrs, last);
    }

    public static final byte[] chunkedEncode(byte[] data, int off, int len, NVPair[] ftrs, boolean last) {
        if (data == null) {
            data = new byte[]{};
            len = 0;
        }
        if (last && ftrs == null) {
            ftrs = new NVPair[]{};
        }
        String hex_len = Integer.toString(len, 16);
        int res_len = 0;
        if (len > 0) {
            res_len += hex_len.length() + 2 + len + 2;
        }
        if (last) {
            res_len += 3;
            int idx = 0;
            while (idx < ftrs.length) {
                res_len += ftrs[idx].getName().length() + 2 + ftrs[idx].getValue().length() + 2;
                ++idx;
            }
            res_len += 2;
        }
        byte[] res = new byte[res_len];
        int r_off = 0;
        if (len > 0) {
            int hlen = hex_len.length();
            try {
                System.arraycopy(hex_len.getBytes("8859_1"), 0, res, r_off, hlen);
            }
            catch (UnsupportedEncodingException uee) {
                throw new Error(uee.toString());
            }
            r_off += hlen;
            res[r_off++] = 13;
            res[r_off++] = 10;
            System.arraycopy(data, off, res, r_off, len);
            r_off += len;
            res[r_off++] = 13;
            res[r_off++] = 10;
        }
        if (last) {
            res[r_off++] = 48;
            res[r_off++] = 13;
            res[r_off++] = 10;
            int idx = 0;
            while (idx < ftrs.length) {
                int nlen = ftrs[idx].getName().length();
                try {
                    System.arraycopy(ftrs[idx].getName().getBytes("8859_1"), 0, res, r_off, nlen);
                }
                catch (UnsupportedEncodingException uee) {
                    throw new Error(uee.toString());
                }
                r_off += nlen;
                res[r_off++] = 58;
                res[r_off++] = 32;
                int vlen = ftrs[idx].getValue().length();
                try {
                    System.arraycopy(ftrs[idx].getValue().getBytes("8859_1"), 0, res, r_off, vlen);
                }
                catch (UnsupportedEncodingException uee) {
                    throw new Error(uee.toString());
                }
                r_off += vlen;
                res[r_off++] = 13;
                res[r_off++] = 10;
                ++idx;
            }
            res[r_off++] = 13;
            res[r_off++] = 10;
        }
        if (r_off != res.length) {
            throw new Error("Calculated " + res.length + " bytes but wrote " + r_off + " bytes!");
        }
        return res;
    }

    /*
     * WARNING - void declaration
     */
    public static final Object chunkedDecode(InputStream input) throws ParseException, IOException {
        String line;
        long clen = Codecs.getChunkLength(input);
        if (clen > Integer.MAX_VALUE) {
            throw new ParseException("Can't deal with chunk lengths greater Integer.MAX_VALUE: " + clen + " > " + Integer.MAX_VALUE);
        }
        if (clen > 0L) {
            byte[] res = new byte[(int)clen];
            int off = 0;
            int len = 0;
            while (len != -1 && off < res.length) {
                len = input.read(res, off, res.length - off);
                off += len;
            }
            if (len == -1) {
                throw new ParseException("Premature EOF while reading chunk;Expected: " + res.length + " Bytes, " + "Received: " + (off + 1) + " Bytes");
            }
            input.read();
            input.read();
            return res;
        }
        NVPair[] res = new NVPair[]{};
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, "8859_1"));
        while ((line = reader.readLine()) != null && line.length() > 0) {
            void len;
            int colon = len.indexOf(58);
            if (colon == -1) {
                throw new ParseException("Error in Footer format: no ':' found in '" + (String)len + "'");
            }
            res = Util.resizeArray(res, res.length + 1);
            res[res.length - 1] = new NVPair(len.substring(0, colon).trim(), len.substring(colon + 1).trim());
        }
        return res;
    }

    static final long getChunkLength(InputStream input) throws ParseException, IOException {
        int ch;
        byte[] hex_len = new byte[16];
        int off = 0;
        while ((ch = input.read()) > 0 && (ch == 32 || ch == 9)) {
        }
        if (ch < 0) {
            throw new EOFException("Premature EOF while reading chunk length");
        }
        hex_len[off++] = (byte)ch;
        while ((ch = input.read()) > 0 && ch != 13 && ch != 10 && ch != 32 && ch != 9 && ch != 59 && off < hex_len.length) {
            hex_len[off++] = (byte)ch;
        }
        while ((ch == 32 || ch == 9) && (ch = input.read()) > 0) {
        }
        if (ch == 59) {
            while ((ch = input.read()) > 0 && ch != 13 && ch != 10) {
            }
        }
        if (ch < 0) {
            throw new EOFException("Premature EOF while reading chunk length");
        }
        if (ch != 10 && (ch != 13 || input.read() != 10)) {
            throw new ParseException("Didn't find valid chunk length: " + new String(hex_len, 0, off, "8859_1"));
        }
        try {
            return Long.parseLong(new String(hex_len, 0, off, "8859_1").trim(), 16);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Didn't find valid chunk length: " + new String(hex_len, 0, off, "8859_1"));
        }
    }

    static {
        ContDisp = ContDisp;
        FileName = FileName;
        ContType = ContType;
        Boundary = Boundary;
        BoundChar = new BitSet(256);
        int ch = 48;
        while (ch <= 57) {
            BoundChar.set(ch);
            ++ch;
        }
        int ch2 = 65;
        while (ch2 <= 90) {
            BoundChar.set(ch2);
            ++ch2;
        }
        int ch3 = 97;
        while (ch3 <= 122) {
            BoundChar.set(ch3);
            ++ch3;
        }
        BoundChar.set(43);
        BoundChar.set(95);
        BoundChar.set(45);
        BoundChar.set(46);
        EBCDICUnsafeChar = new BitSet(256);
        EBCDICUnsafeChar.set(33);
        EBCDICUnsafeChar.set(34);
        EBCDICUnsafeChar.set(35);
        EBCDICUnsafeChar.set(36);
        EBCDICUnsafeChar.set(64);
        EBCDICUnsafeChar.set(91);
        EBCDICUnsafeChar.set(92);
        EBCDICUnsafeChar.set(93);
        EBCDICUnsafeChar.set(94);
        EBCDICUnsafeChar.set(96);
        EBCDICUnsafeChar.set(123);
        EBCDICUnsafeChar.set(124);
        EBCDICUnsafeChar.set(125);
        EBCDICUnsafeChar.set(126);
        byte[] map = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        Base64EncMap = map;
        Base64DecMap = new byte[128];
        int idx = 0;
        while (idx < Base64EncMap.length) {
            Codecs.Base64DecMap[Codecs.Base64EncMap[idx]] = (byte)idx;
            ++idx;
        }
        UUEncMap = new char[64];
        int idx2 = 0;
        while (idx2 < UUEncMap.length) {
            Codecs.UUEncMap[idx2] = (char)(idx2 + 32);
            ++idx2;
        }
        UUDecMap = new byte[128];
        int idx3 = 0;
        while (idx3 < UUEncMap.length) {
            Codecs.UUDecMap[Codecs.UUEncMap[idx3]] = (byte)idx3;
            ++idx3;
        }
        dummy = new NVPair[0];
    }

    private static class CT
    extends URLConnection {
        protected static final String getContentType(String fname) {
            return URLConnection.guessContentTypeFromName(fname);
        }

        private CT() {
            super(null);
        }

        public void connect() {
        }
    }
}

