/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Codecs;
import HTTPClient.Log;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HttpOutputStream
extends OutputStream {
    private static final NVPair[] empty = new NVPair[0];
    private int length;
    private int rcvd = 0;
    private Request req = null;
    private Response resp = null;
    private OutputStream os = null;
    private ByteArrayOutputStream bos = null;
    private NVPair[] trailers = empty;
    private int con_to = 0;
    private boolean ignore = false;

    public HttpOutputStream() {
        this.length = -1;
    }

    public HttpOutputStream(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length must be greater equal 0");
        }
        this.length = length;
    }

    void goAhead(Request req, OutputStream os, int con_to) {
        this.req = req;
        this.os = os;
        this.con_to = con_to;
        if (os == null) {
            this.bos = new ByteArrayOutputStream();
        }
        Log.write(1, "OutS:  Stream ready for writing");
        if (this.bos != null) {
            Log.write(1, "OutS:  Buffering all data before sending request");
        }
    }

    void ignoreData(Request req) {
        this.req = req;
        this.ignore = true;
    }

    synchronized Response getResponse() {
        while (this.resp == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.resp;
    }

    public int getLength() {
        return this.length;
    }

    public NVPair[] getTrailers() {
        return this.trailers;
    }

    public void setTrailers(NVPair[] trailers) {
        this.trailers = trailers != null ? trailers : empty;
    }

    public void reset() {
        this.rcvd = 0;
        this.req = null;
        this.resp = null;
        this.os = null;
        this.bos = null;
        this.con_to = 0;
        this.ignore = false;
    }

    public void write(int b) throws IOException, IllegalAccessError {
        byte[] tmp = new byte[]{(byte)b};
        this.write(tmp, 0, 1);
    }

    public synchronized void write(byte[] buf, int off, int len) throws IOException, IllegalAccessError {
        if (this.req == null) {
            throw new IllegalAccessError("Stream not associated with a request");
        }
        if (this.ignore) {
            return;
        }
        if (this.length != -1 && this.rcvd + len > this.length) {
            IOException ioe = new IOException("Tried to write too many bytes (" + (this.rcvd + len) + " > " + this.length + ")");
            this.req.getConnection().closeDemux(ioe, false);
            this.req.getConnection().outputFinished();
            throw ioe;
        }
        try {
            if (this.bos != null) {
                this.bos.write(buf, off, len);
            } else if (this.length != -1) {
                this.os.write(buf, off, len);
            } else {
                this.os.write(Codecs.chunkedEncode(buf, off, len, null, false));
            }
        }
        catch (IOException ioe) {
            this.req.getConnection().closeDemux(ioe, true);
            this.req.getConnection().outputFinished();
            throw ioe;
        }
        this.rcvd += len;
    }

    public synchronized void close() throws IOException, IllegalAccessError {
        if (this.req == null) {
            throw new IllegalAccessError("Stream not associated with a request");
        }
        if (this.ignore) {
            return;
        }
        if (this.bos != null) {
            this.req.setData(this.bos.toByteArray());
            this.req.setStream(null);
            if (this.trailers.length > 0) {
                NVPair[] hdrs = this.req.getHeaders();
                int len = hdrs.length;
                int idx = 0;
                while (idx < len) {
                    if (hdrs[idx].getName().equalsIgnoreCase("Trailer")) {
                        System.arraycopy(hdrs, idx + 1, hdrs, idx, len - idx - 1);
                        --len;
                    }
                    ++idx;
                }
                hdrs = Util.resizeArray(hdrs, len + this.trailers.length);
                System.arraycopy(this.trailers, 0, hdrs, len, this.trailers.length);
                this.req.setHeaders(hdrs);
            }
            Log.write(1, "OutS:  Sending request");
            try {
                this.resp = this.req.getConnection().sendRequest(this.req, this.con_to);
            }
            catch (ModuleException me) {
                throw new IOException(me.toString());
            }
            this.notify();
        } else {
            if (this.rcvd < this.length) {
                IOException ioe = new IOException("Premature close: only " + this.rcvd + " bytes written instead of the " + "expected " + this.length);
                this.req.getConnection().closeDemux(ioe, false);
                this.req.getConnection().outputFinished();
                throw ioe;
            }
            try {
                try {
                    if (this.length == -1) {
                        if (Log.isEnabled(1) && this.trailers.length > 0) {
                            Log.write(1, "OutS:  Sending trailers:");
                            int idx = 0;
                            while (idx < this.trailers.length) {
                                Log.write(1, "       " + this.trailers[idx].getName() + ": " + this.trailers[idx].getValue());
                                ++idx;
                            }
                        }
                        this.os.write(Codecs.chunkedEncode(null, 0, 0, this.trailers, true));
                    }
                    this.os.flush();
                    Log.write(1, "OutS:  All data sent");
                }
                catch (IOException ioe) {
                    this.req.getConnection().closeDemux(ioe, true);
                    throw ioe;
                }
                Object var5_8 = null;
                this.req.getConnection().outputFinished();
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                this.req.getConnection().outputFinished();
                throw throwable;
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "[length=" + this.length + "]";
    }
}

