/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPConnection;
import HTTPClient.HttpOutputStream;
import HTTPClient.Log;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.URI;
import HTTPClient.Util;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Hashtable;

class RedirectionModule
implements HTTPClientModule {
    private static Hashtable perm_redir_cntxt_list = new Hashtable();
    private static Hashtable deferred_redir_list = new Hashtable();
    private int level = 0;
    private URI lastURI = null;
    private boolean new_con;
    private Request saved_req = null;

    RedirectionModule() {
    }

    public int requestHandler(Request req, Response[] resp) {
        URI cur_loc;
        HTTPConnection con = req.getConnection();
        HttpOutputStream out = req.getStream();
        if (out != null && deferred_redir_list.get(out) != null) {
            this.copyFrom((RedirectionModule)deferred_redir_list.remove(out));
            req.copyFrom(this.saved_req);
            if (this.new_con) {
                return 5;
            }
            return 1;
        }
        try {
            cur_loc = new URI(new URI(con.getProtocol(), con.getHost(), con.getPort(), null), req.getRequestURI());
        }
        catch (ParseException pe) {
            throw new Error("HTTPClient Internal Error: unexpected exception '" + pe + "'");
        }
        Hashtable perm_redir_list = Util.getList(perm_redir_cntxt_list, req.getConnection().getContext());
        URI new_loc = (URI)perm_redir_list.get(cur_loc);
        if (new_loc != null) {
            String nres = new_loc.getPathAndQuery();
            req.setRequestURI(nres);
            try {
                this.lastURI = new URI(new_loc, nres);
            }
            catch (ParseException pe) {
                // empty catch block
            }
            Log.write(32, "RdirM: matched request in permanent redirection list - redoing request to " + this.lastURI.toExternalForm());
            if (!con.isCompatibleWith(new_loc)) {
                try {
                    con = new HTTPConnection(new_loc);
                }
                catch (Exception e) {
                    throw new Error("HTTPClient Internal Error: unexpected exception '" + e + "'");
                }
                con.setSSLSocketFactory(req.getConnection().getSSLSocketFactory());
                con.setContext(req.getConnection().getContext());
                req.setConnection(con);
                return 5;
            }
            return 1;
        }
        return 0;
    }

    public void responsePhase1Handler(Response resp, RoRequest req) throws IOException {
        int sts = resp.getStatusCode();
        if ((sts < 301 || sts > 307 || sts == 304) && this.lastURI != null) {
            resp.setEffectiveURI(this.lastURI);
        }
    }

    public int responsePhase2Handler(Response resp, Request req) throws IOException {
        int sts = resp.getStatusCode();
        switch (sts) {
            case 302: {
                if (req.getMethod().equals("POST") || req.getMethod().equals("PUT")) {
                    Log.write(32, "RdirM: Received status: " + sts + " " + resp.getReasonLine() + " - treating as 303");
                    sts = 303;
                }
            }
            case 301: 
            case 303: 
            case 307: {
                Log.write(32, "RdirM: Handling status: " + sts + " " + resp.getReasonLine());
                if (!req.getMethod().equals("GET") && !req.getMethod().equals("HEAD") && sts != 303) {
                    Log.write(32, "RdirM: not redirected because method is neither HEAD nor GET");
                    if (sts == 301 && resp.getHeader("Location") != null) {
                        RedirectionModule.update_perm_redir_list(req, this.resLocHdr(resp.getHeader("Location"), req));
                    }
                    resp.setEffectiveURI(this.lastURI);
                    return 10;
                }
            }
            case 305: 
            case 306: {
                String nres;
                HTTPConnection mvd;
                if (sts == 305 || sts == 306) {
                    Log.write(32, "RdirM: Handling status: " + sts + " " + resp.getReasonLine());
                }
                if (sts == 305 && req.getConnection().getProxyHost() != null) {
                    Log.write(32, "RdirM: 305 ignored because a proxy is already in use");
                    resp.setEffectiveURI(this.lastURI);
                    return 10;
                }
                if (this.level >= 15 || resp.getHeader("Location") == null) {
                    if (this.level >= 15) {
                        Log.write(32, "RdirM: not redirected because of too many levels of redirection");
                    } else {
                        Log.write(32, "RdirM: not redirected because no Location header was present");
                    }
                    resp.setEffectiveURI(this.lastURI);
                    return 10;
                }
                ++this.level;
                URI loc = this.resLocHdr(resp.getHeader("Location"), req);
                this.new_con = false;
                if (sts == 305) {
                    mvd = new HTTPConnection(req.getConnection().getProtocol(), req.getConnection().getHost(), req.getConnection().getPort());
                    mvd.setCurrentProxy(loc.getHost(), loc.getPort());
                    mvd.setSSLSocketFactory(req.getConnection().getSSLSocketFactory());
                    mvd.setContext(req.getConnection().getContext());
                    this.new_con = true;
                    nres = req.getRequestURI();
                    req.setMethod("GET");
                    req.setData(null);
                    req.setStream(null);
                } else {
                    if (sts == 306) {
                        return 10;
                    }
                    if (req.getConnection().isCompatibleWith(loc)) {
                        mvd = req.getConnection();
                        nres = loc.getPathAndQuery();
                    } else {
                        try {
                            mvd = new HTTPConnection(loc);
                            nres = loc.getPathAndQuery();
                        }
                        catch (Exception e) {
                            if (req.getConnection().getProxyHost() == null || !loc.getScheme().equalsIgnoreCase("ftp")) {
                                return 10;
                            }
                            mvd = new HTTPConnection("http", req.getConnection().getProxyHost(), req.getConnection().getProxyPort());
                            mvd.setCurrentProxy(null, 0);
                            nres = loc.toExternalForm();
                        }
                        mvd.setSSLSocketFactory(req.getConnection().getSSLSocketFactory());
                        mvd.setContext(req.getConnection().getContext());
                        this.new_con = true;
                    }
                    if (sts == 303) {
                        if (!req.getMethod().equals("HEAD")) {
                            req.setMethod("GET");
                        }
                        req.setData(null);
                        req.setStream(null);
                    } else {
                        if (req.getStream() != null) {
                            if (!HTTPConnection.deferStreamed) {
                                Log.write(32, "RdirM: status " + sts + " not handled - request " + "has an output stream");
                                return 10;
                            }
                            this.saved_req = (Request)req.clone();
                            deferred_redir_list.put(req.getStream(), this);
                            req.getStream().reset();
                            resp.setRetryRequest(true);
                        }
                        if (sts == 301) {
                            try {
                                RedirectionModule.update_perm_redir_list(req, new URI(loc, nres));
                            }
                            catch (ParseException pe) {
                                throw new Error("HTTPClient Internal Error: unexpected exception '" + pe + "'");
                            }
                        }
                    }
                    NVPair[] hdrs = req.getHeaders();
                    int idx = 0;
                    while (idx < hdrs.length) {
                        if (hdrs[idx].getName().equalsIgnoreCase("Referer")) {
                            HTTPConnection con = req.getConnection();
                            hdrs[idx] = new NVPair("Referer", con + req.getRequestURI());
                            break;
                        }
                        ++idx;
                    }
                }
                req.setConnection(mvd);
                req.setRequestURI(nres);
                try {
                    resp.getInputStream().close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (sts != 305 && sts != 306) {
                    try {
                        this.lastURI = new URI(loc, nres);
                    }
                    catch (ParseException pe) {
                        // empty catch block
                    }
                    Log.write(32, "RdirM: request redirected to " + this.lastURI.toExternalForm() + " using method " + req.getMethod());
                } else {
                    Log.write(32, "RdirM: resending request using proxy " + mvd.getProxyHost() + ":" + mvd.getProxyPort());
                }
                if (req.getStream() != null) {
                    return 10;
                }
                if (this.new_con) {
                    return 15;
                }
                return 13;
            }
        }
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) {
    }

    public void trailerHandler(Response resp, RoRequest req) {
    }

    private static void update_perm_redir_list(RoRequest req, URI new_loc) {
        HTTPConnection con = req.getConnection();
        URI cur_loc = null;
        try {
            cur_loc = new URI(new URI(con.getProtocol(), con.getHost(), con.getPort(), null), req.getRequestURI());
        }
        catch (ParseException pe) {
            // empty catch block
        }
        if (!cur_loc.equals(new_loc)) {
            Hashtable perm_redir_list = Util.getList(perm_redir_cntxt_list, con.getContext());
            perm_redir_list.put(cur_loc, new_loc);
        }
    }

    private URI resLocHdr(String loc, RoRequest req) throws ProtocolException {
        try {
            URI base = new URI(req.getConnection().getProtocol(), req.getConnection().getHost(), req.getConnection().getPort(), null);
            base = new URI(base, req.getRequestURI());
            URI res = new URI(base, loc);
            if (res.getHost() == null) {
                throw new ProtocolException("Malformed URL in Location header: `" + loc + "' - missing host field");
            }
            return res;
        }
        catch (ParseException pe) {
            throw new ProtocolException("Malformed URL in Location header: `" + loc + "' - exception was: " + pe.getMessage());
        }
    }

    private void copyFrom(RedirectionModule other) {
        this.level = other.level;
        this.lastURI = other.lastURI;
        this.saved_req = other.saved_req;
    }
}

