/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.StreamDemultiplexor;

class SocketTimeout
extends Thread {
    private boolean alive = true;
    TimeoutEntry[] time_list;
    int current;

    SocketTimeout(int secs) {
        super("SocketTimeout");
        try {
            this.setDaemon(true);
        }
        catch (SecurityException se) {
            // empty catch block
        }
        this.setPriority(10);
        this.time_list = new TimeoutEntry[secs];
        int idx = 0;
        while (idx < secs) {
            this.time_list[idx] = new TimeoutEntry(null);
            this.time_list[idx].next = this.time_list[idx].prev = this.time_list[idx];
            ++idx;
        }
        this.current = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeoutEntry setTimeout(StreamDemultiplexor demux) {
        TimeoutEntry entry = new TimeoutEntry(demux);
        TimeoutEntry[] timeoutEntryArray = this.time_list;
        synchronized (timeoutEntryArray) {
            entry.next = this.time_list[this.current];
            entry.prev = this.time_list[this.current].prev;
            entry.prev.next = entry;
            entry.next.prev = entry;
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        TimeoutEntry marked = null;
        while (this.alive) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            TimeoutEntry[] timeoutEntryArray = this.time_list;
            synchronized (timeoutEntryArray) {
                TimeoutEntry entry = this.time_list[this.current].next;
                while (entry != this.time_list[this.current]) {
                    entry.restart = false;
                    entry = entry.next;
                }
                ++this.current;
                if (this.current >= this.time_list.length) {
                    this.current = 0;
                }
                TimeoutEntry entry2 = this.time_list[this.current].next;
                while (entry2 != this.time_list[this.current]) {
                    if (entry2.alive && !entry2.hyber) {
                        TimeoutEntry prev = entry2.prev;
                        entry2.kill();
                        entry2.next = marked;
                        marked = entry2;
                        entry2 = prev;
                    }
                    entry2 = entry2.next;
                }
            }
            while (marked != null) {
                marked.demux.markForClose(null);
                marked = marked.next;
            }
        }
    }

    public void kill() {
        this.alive = false;
    }

    class TimeoutEntry {
        boolean restart = false;
        boolean hyber = false;
        boolean alive = true;
        StreamDemultiplexor demux;
        TimeoutEntry next = null;
        TimeoutEntry prev = null;

        TimeoutEntry(StreamDemultiplexor demux) {
            this.demux = demux;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reset() {
            this.hyber = false;
            if (this.restart) {
                return;
            }
            this.restart = true;
            TimeoutEntry[] timeoutEntryArray = SocketTimeout.this.time_list;
            synchronized (timeoutEntryArray) {
                if (!this.alive) {
                    return;
                }
                this.next.prev = this.prev;
                this.prev.next = this.next;
                this.next = SocketTimeout.this.time_list[SocketTimeout.this.current];
                this.prev = SocketTimeout.this.time_list[SocketTimeout.this.current].prev;
                this.prev.next = this;
                this.next.prev = this;
            }
        }

        void hyber() {
            if (this.alive) {
                this.hyber = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void kill() {
            this.alive = false;
            this.restart = false;
            this.hyber = false;
            TimeoutEntry[] timeoutEntryArray = SocketTimeout.this.time_list;
            synchronized (timeoutEntryArray) {
                if (this.prev == null) {
                    return;
                }
                this.next.prev = this.prev;
                this.prev.next = this.next;
                this.prev = null;
            }
        }
    }
}

