/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.DefaultAuthHandler;
import HTTPClient.GlobalConstants;
import HTTPClient.HashVerifier;
import HTTPClient.HttpHeaderElement;
import HTTPClient.Log;
import HTTPClient.MD5;
import HTTPClient.ParseException;
import HTTPClient.RoResponse;
import HTTPClient.Util;
import java.io.IOException;
import java.util.Vector;

class VerifyRspAuth
implements HashVerifier,
GlobalConstants {
    private String uri;
    private String HA1;
    private String alg;
    private String nonce;
    private String cnonce;
    private String nc;
    private String hdr;
    private RoResponse resp;

    public VerifyRspAuth(String uri, String HA1, String alg, String nonce, String cnonce, String nc, String hdr, RoResponse resp) {
        this.uri = uri;
        this.HA1 = HA1;
        this.alg = alg;
        this.nonce = nonce;
        this.cnonce = cnonce;
        this.nc = nc;
        this.hdr = hdr;
        this.resp = resp;
    }

    public void verifyHash(byte[] hash, long len) throws IOException {
        String qop;
        Vector pai;
        String auth_info = this.resp.getHeader(this.hdr);
        if (auth_info == null) {
            auth_info = this.resp.getTrailer(this.hdr);
        }
        if (auth_info == null) {
            return;
        }
        try {
            pai = Util.parseHeader(auth_info);
        }
        catch (ParseException pe) {
            throw new IOException(pe.toString());
        }
        HttpHeaderElement elem = Util.getElement(pai, "qop");
        if (elem == null || (qop = elem.getValue()) == null || !qop.equalsIgnoreCase("auth") && !qop.equalsIgnoreCase("auth-int")) {
            return;
        }
        elem = Util.getElement(pai, "rspauth");
        if (elem == null || elem.getValue() == null) {
            return;
        }
        byte[] digest = DefaultAuthHandler.unHex(elem.getValue());
        elem = Util.getElement(pai, "cnonce");
        if (elem != null && elem.getValue() != null && !elem.getValue().equals(this.cnonce)) {
            throw new IOException("Digest auth scheme: received wrong client-nonce '" + elem.getValue() + "' - expected '" + this.cnonce + "'");
        }
        elem = Util.getElement(pai, "nc");
        if (elem != null && elem.getValue() != null && !elem.getValue().equals(this.nc)) {
            throw new IOException("Digest auth scheme: received wrong nonce-count '" + elem.getValue() + "' - expected '" + this.nc + "'");
        }
        String A1 = this.alg != null && this.alg.equalsIgnoreCase("MD5-sess") ? MD5.hexDigest(this.HA1 + ":" + this.nonce + ":" + this.cnonce) : this.HA1;
        String A2 = ":" + this.uri;
        if (qop.equalsIgnoreCase("auth-int")) {
            A2 = A2 + ":" + MD5.toHex(hash);
        }
        A2 = MD5.hexDigest(A2);
        hash = MD5.digest(A1 + ":" + this.nonce + ":" + this.nc + ":" + this.cnonce + ":" + qop + ":" + A2);
        int idx = 0;
        while (idx < hash.length) {
            if (hash[idx] != digest[idx]) {
                throw new IOException("MD5-Digest mismatch: expected " + DefaultAuthHandler.hex(digest) + " but calculated " + DefaultAuthHandler.hex(hash));
            }
            ++idx;
        }
        Log.write(8, "Auth:  rspauth from " + this.hdr + " successfully verified");
    }
}

