/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.Alphabet;
import com.thaiopensource.relaxng.impl.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternFunction;
import com.thaiopensource.relaxng.impl.PatternVisitor;
import com.thaiopensource.relaxng.impl.RestrictionViolationException;
import com.thaiopensource.relaxng.impl.SchemaPatternBuilder;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ListPattern
extends Pattern {
    private final Pattern p;
    private final Locator locator;

    ListPattern(Pattern pattern, Locator locator) {
        super(false, 3, Pattern.combineHashCode(37, pattern.hashCode()));
        this.p = pattern;
        this.locator = locator;
    }

    Pattern expand(SchemaPatternBuilder schemaPatternBuilder) {
        Pattern pattern = this.p.expand(schemaPatternBuilder);
        if (pattern != this.p) {
            return schemaPatternBuilder.makeList(pattern, this.locator);
        }
        return this;
    }

    void checkRecursion(int n) throws SAXException {
        this.p.checkRecursion(n);
    }

    boolean samePattern(Pattern pattern) {
        return pattern instanceof ListPattern && this.p == ((ListPattern)pattern).p;
    }

    public void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitList(this.p);
    }

    Object apply(PatternFunction patternFunction) {
        return patternFunction.caseList(this);
    }

    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        switch (n) {
            case 7: {
                throw new RestrictionViolationException("data_except_contains_list");
            }
            case 0: {
                throw new RestrictionViolationException("start_contains_list");
            }
            case 6: {
                throw new RestrictionViolationException("list_contains_list");
            }
        }
        try {
            this.p.checkRestrictions(6, duplicateAttributeDetector, null);
        }
        catch (RestrictionViolationException restrictionViolationException) {
            restrictionViolationException.maybeSetLocator(this.locator);
            throw restrictionViolationException;
        }
    }

    public Pattern getOperand() {
        return this.p;
    }
}

