/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.util;

import com.thaiopensource.relaxng.impl.CompactSchemaReader;
import com.thaiopensource.relaxng.impl.RngProperty;
import com.thaiopensource.relaxng.impl.SAXSchemaReader;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.Flag;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.xml.sax.XMLReaderCreator;
import java.io.IOException;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaFactory {
    private PropertyMapBuilder properties = new PropertyMapBuilder();
    private boolean compactSyntax = false;

    public Schema createSchema(InputSource inputSource) throws IOException, SAXException, IncorrectSchemaException {
        SchemaReader schemaReader = this.compactSyntax ? CompactSchemaReader.getInstance() : SAXSchemaReader.getInstance();
        return schemaReader.createSchema(inputSource, this.properties.toPropertyMap());
    }

    public void setXMLReaderCreator(XMLReaderCreator xMLReaderCreator) {
        this.properties.put(ValidateProperty.XML_READER_CREATOR, xMLReaderCreator);
    }

    public XMLReaderCreator getXMLReaderCreator() {
        return (XMLReaderCreator)this.properties.get(ValidateProperty.XML_READER_CREATOR);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.properties.put(ValidateProperty.ERROR_HANDLER, errorHandler);
    }

    public ErrorHandler getErrorHandler() {
        return (ErrorHandler)this.properties.get(ValidateProperty.ERROR_HANDLER);
    }

    public void setDatatypeLibraryFactory(DatatypeLibraryFactory datatypeLibraryFactory) {
        this.properties.put(RngProperty.DATATYPE_LIBRARY_FACTORY, datatypeLibraryFactory);
    }

    public DatatypeLibraryFactory getDatatypeLibraryFactory() {
        return (DatatypeLibraryFactory)this.properties.get(RngProperty.DATATYPE_LIBRARY_FACTORY);
    }

    public void setCheckIdIdref(boolean bl) {
        this.properties.put(RngProperty.CHECK_ID_IDREF, bl ? Flag.PRESENT : null);
    }

    public boolean getCheckIdIdref() {
        return this.properties.contains(RngProperty.CHECK_ID_IDREF);
    }

    public void setCompactSyntax(boolean bl) {
        this.compactSyntax = bl;
    }

    public boolean getCompactSyntax() {
        return this.compactSyntax;
    }

    public void setFeasible(boolean bl) {
        this.properties.put(RngProperty.FEASIBLE, bl ? Flag.PRESENT : null);
    }

    public boolean getFeasible() {
        return this.properties.contains(RngProperty.FEASIBLE);
    }
}

