/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.batik;

import com.xmlmind.xmledit.doc.Attribute;
import com.xmlmind.xmledit.doc.Comment;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.DocumentTypeUtil;
import com.xmlmind.xmledit.doctype.UnconstrainedDocumentType;
import com.xmlmind.xmledit.imagetoolkit.ImageConverter;
import com.xmlmind.xmledit.imagetoolkit.ImageRenderer;
import com.xmlmind.xmledit.imagetoolkit.ImageRendererAdapter;
import com.xmlmind.xmledit.imagetoolkit.ImageToolkitUtil;
import com.xmlmind.xmledit.imagetoolkit.VectorImage;
import com.xmlmind.xmledit.imagetoolkit.VectorImageToolkit;
import com.xmlmind.xmledit.stylesheet.StyleValue;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.URLPathUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import java.awt.Color;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.gvt.CanvasGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.transcoder.ErrorHandler;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.XMLAbstractTranscoder;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.image.TIFFTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class BatikImageToolkit
implements VectorImageToolkit,
ErrorHandler {
    private Console console = null;

    public BatikImageToolkit() {
        XMLResourceDescriptor.setXMLParserClassName("com.jclark.xml.sax.SAX2Driver");
    }

    public String getName() {
        return "Batik";
    }

    public String getDescription() {
        return "Batik 1.5.1 is a toolkit for Java[tm] applications or applets that want to use images in the Scalable Vector Graphics (SVG) format for various purposes, such as viewing, generation or manipulation.\nSee http://xml.apache.org/batik/.\nCan read: SVG, SVGZ (SVG compressed using gzip).\nCan write: JPEG, PNG, TIFF.";
    }

    public double getDefaultResolution() {
        return 96.0;
    }

    public String getDefaultFontFamily() {
        return "SansSerif";
    }

    public int getDefaultFontSize() {
        return 12;
    }

    public int getDefaultImageWidth() {
        return 400;
    }

    public int getDefaultImageHeight() {
        return 400;
    }

    public ImageRenderer getImageRenderer(URL uRL) {
        boolean bl;
        String string = URLPathUtil.extension((String)uRL.toExternalForm());
        if (string.length() == 0) {
            return null;
        }
        if (string.equalsIgnoreCase("svg")) {
            bl = false;
        } else if (string.equalsIgnoreCase("svgz")) {
            bl = true;
        } else {
            return null;
        }
        final boolean bl2 = bl;
        return new ImageRendererAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Image createImage(URL uRL, double d, int n, double d2, int n2, boolean bl, boolean bl22, double d3) throws Exception {
                ImageScalingTranscoder imageScalingTranscoder = new ImageScalingTranscoder(d, n, d2, n2, bl, d3);
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setUseCaches(false);
                uRLConnection.setIfModifiedSince(0L);
                InputStream inputStream = uRLConnection.getInputStream();
                if (bl2) {
                    inputStream = new GZIPInputStream(inputStream);
                }
                try {
                    TranscoderInput transcoderInput = new TranscoderInput(inputStream);
                    transcoderInput.setURI(uRL.toExternalForm());
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    TranscoderOutput transcoderOutput = new TranscoderOutput(byteArrayOutputStream);
                    imageScalingTranscoder.transcode(transcoderInput, transcoderOutput);
                    Object var19_15 = null;
                }
                catch (Throwable throwable) {
                    Object var19_16 = null;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                return imageScalingTranscoder.getScaledImage();
            }
        };
    }

    public ImageRenderer getImageRenderer(byte[] byArray) {
        if (byArray.length < 6 || byArray[0] != 60 || byArray[1] != 63 || byArray[2] != 120 || byArray[3] != 109 || byArray[4] != 108 || byArray[5] != 32) {
            return null;
        }
        return new ImageRendererAdapter(){

            public Image createImage(byte[] byArray, URL uRL, double d, int n, double d2, int n2, boolean bl, boolean bl2, double d3) throws Exception {
                ImageScalingTranscoder imageScalingTranscoder = new ImageScalingTranscoder(d, n, d2, n2, bl, d3);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                TranscoderInput transcoderInput = new TranscoderInput(byteArrayInputStream);
                if (uRL != null) {
                    transcoderInput.setURI(uRL.toExternalForm());
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                TranscoderOutput transcoderOutput = new TranscoderOutput(byteArrayOutputStream);
                imageScalingTranscoder.transcode(transcoderInput, transcoderOutput);
                return imageScalingTranscoder.getScaledImage();
            }
        };
    }

    public ImageRenderer getImageRenderer(Element element) {
        if (!element.getLocalName().endsWith("svg")) {
            return null;
        }
        return new ImageRendererAdapter(){

            public Image createImage(Element element, double d, int n, double d2, int n2, boolean bl, boolean bl2, double d3) throws Exception {
                ImageScalingTranscoder imageScalingTranscoder = new ImageScalingTranscoder(d, n, d2, n2, bl, d3);
                Document document = BatikImageToolkit.toW3CDOMDocument(element);
                TranscoderInput transcoderInput = new TranscoderInput(document);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                TranscoderOutput transcoderOutput = new TranscoderOutput(byteArrayOutputStream);
                imageScalingTranscoder.transcode(transcoderInput, transcoderOutput);
                return imageScalingTranscoder.getScaledImage();
            }
        };
    }

    private static final Document toW3CDOMDocument(Element element) {
        boolean bl = element.getNamespace() == Namespace.SVG;
        DocumentType documentType = null;
        HashMap hashMap = null;
        if (!bl) {
            hashMap = new HashMap();
            documentType = DocumentTypeUtil.getDocumentType((Element)element);
            if (documentType == null) {
                documentType = UnconstrainedDocumentType.INSTANCE;
            }
        }
        DOMImplementation dOMImplementation = SVGDOMImplementation.getDOMImplementation();
        Document document = dOMImplementation.createDocument(BatikImageToolkit.nsURI(element, bl, hashMap, documentType), BatikImageToolkit.qName(element, bl, hashMap, documentType), null);
        URL uRL = element.getLocation();
        if (uRL != null) {
            ((SVGOMDocument)document).setURLObject(uRL);
        }
        org.w3c.dom.Element element2 = document.getDocumentElement();
        BatikImageToolkit.toW3CDOM(document, bl, hashMap, documentType, element, element2);
        return document;
    }

    private static final void toW3CDOM(Document document, boolean bl, HashMap hashMap, DocumentType documentType, Element element, org.w3c.dom.Element element2) {
        Node node;
        Enumeration enumeration = element.getAttributes();
        while (enumeration.hasMoreElements()) {
            node = (Attribute)enumeration.nextElement();
            if (!bl && node.name.getLocalPart().startsWith("xmlns")) continue;
            element2.setAttributeNS(BatikImageToolkit.nsURI(node.name, element, bl, hashMap, documentType), BatikImageToolkit.qName(node.name, element, bl, hashMap, documentType), node.value);
        }
        node = element.getFirstChild();
        while (node != null) {
            switch (node.getNodeType()) {
                case 0: {
                    Text text = (Text)node;
                    element2.appendChild(document.createTextNode(text.getText()));
                    break;
                }
                case 1: {
                    Text text = (Comment)node;
                    element2.appendChild(document.createComment(text.getText()));
                    break;
                }
                case 2: {
                    Text text = (ProcessingInstruction)node;
                    element2.appendChild(document.createProcessingInstruction(text.getTarget(), text.getText()));
                    break;
                }
                case 4: {
                    Text text = (Element)node;
                    org.w3c.dom.Element element3 = document.createElementNS(BatikImageToolkit.nsURI((Element)text, bl, hashMap, documentType), BatikImageToolkit.qName((Element)text, bl, hashMap, documentType));
                    element2.appendChild(element3);
                    BatikImageToolkit.toW3CDOM(document, bl, hashMap, documentType, (Element)text, element3);
                }
            }
            node = node.getNextSibling();
        }
    }

    private static final String nsURI(Element element, boolean bl, HashMap hashMap, DocumentType documentType) {
        if (bl) {
            Namespace namespace = element.getNamespace();
            return namespace == Namespace.NONE ? null : namespace.getURI();
        }
        String string = element.getLocalName();
        return BatikImageToolkit.nsURI(string, false, element, hashMap, documentType);
    }

    private static final String nsURI(String string, boolean bl, Element element, HashMap hashMap, DocumentType documentType) {
        String string2;
        boolean bl2;
        int n = string.indexOf(58);
        String string3 = n < 0 ? "" : string.substring(0, n);
        boolean bl3 = bl2 = string3.length() == 0;
        if (bl2) {
            if (bl) {
                return null;
            }
        } else if ("xml".equals(string3)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (hashMap == null) {
            Name name = Name.get((String)(bl2 ? "xmlns" : "xmlns:" + string3));
            string2 = documentType.lookupElementAttribute(element, name, null);
        } else {
            Name name;
            string2 = (String)hashMap.get(string3);
            if (string2 == null && (string2 = documentType.lookupElementAttribute(element, name = Name.get((String)(bl2 ? "xmlns" : "xmlns:" + string3)), null)) != null) {
                hashMap.put(string3, string2);
            }
        }
        if (string2 == null) {
            if (bl2) {
                return null;
            }
            throw new RuntimeException("don't find the namespace corresponding to prefix '" + string3 + "'");
        }
        return string2.length() == 0 ? null : string2;
    }

    private static final String qName(Element element, boolean bl, HashMap hashMap, DocumentType documentType) {
        if (bl) {
            return element.getName().format(false, (NamespaceToPrefixes)element);
        }
        return element.getLocalName();
    }

    private static final String nsURI(Name name, Element element, boolean bl, HashMap hashMap, DocumentType documentType) {
        if (bl) {
            Namespace namespace = name.getNamespace();
            return namespace == Namespace.NONE ? null : namespace.getURI();
        }
        String string = name.getLocalPart();
        return BatikImageToolkit.nsURI(string, true, element, hashMap, documentType);
    }

    private static final String qName(Name name, Element element, boolean bl, HashMap hashMap, DocumentType documentType) {
        if (bl) {
            return name.format(true, (NamespaceToPrefixes)element);
        }
        return name.getLocalPart();
    }

    public ImageConverter getImageConverter(File file, File file2) {
        ImageTranscoder imageTranscoder;
        boolean bl;
        String string = FileUtil.fileExtension((String)file.getPath());
        if (string.length() == 0) {
            return null;
        }
        if (string.equalsIgnoreCase("svg")) {
            bl = false;
        } else if (string.equalsIgnoreCase("svgz")) {
            bl = true;
        } else {
            return null;
        }
        final boolean bl2 = bl;
        String string2 = FileUtil.fileExtension((String)file2.getPath());
        if (string2.length() == 0) {
            return null;
        }
        if (string2.equalsIgnoreCase("png")) {
            imageTranscoder = new PNGTranscoder();
        } else if (string2.equalsIgnoreCase("jpg") || string2.equalsIgnoreCase("jpeg")) {
            imageTranscoder = new JPEGTranscoder();
        } else if (string2.equalsIgnoreCase("tiff") || string2.equalsIgnoreCase("tif")) {
            imageTranscoder = new TIFFTranscoder();
        } else {
            return null;
        }
        final PNGTranscoder pNGTranscoder = imageTranscoder;
        pNGTranscoder.setErrorHandler(this);
        pNGTranscoder.addTranscodingHint(XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME, "com.jclark.xml.sax.SAX2Driver");
        pNGTranscoder.addTranscodingHint(XMLAbstractTranscoder.KEY_XML_PARSER_VALIDATING, Boolean.FALSE);
        return new ImageConverter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void convertImage(File file, File file2, String[] stringArray, Console console) throws Exception {
                Object object;
                Object object2;
                if (pNGTranscoder instanceof JPEGTranscoder) {
                    pNGTranscoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, new Float(0.8));
                }
                if (stringArray != null && stringArray.length > 0) {
                    int n = 0;
                    while (n < stringArray.length) {
                        object2 = stringArray[n];
                        object = stringArray[n + 1];
                        if ("pxtomm".equals(object2) || "dpi".equals(object2)) {
                            float f;
                            try {
                                f = Float.parseFloat((String)object);
                            }
                            catch (NumberFormatException numberFormatException) {
                                f = -1.0f;
                            }
                            if (f <= 0.0f) {
                                throw new RuntimeException("'" + (String)object + "' invalid value for parameter '" + (String)object2 + "': should be a positive float.");
                            }
                            if ("dpi".equals(object2)) {
                                f = 25.4f / f;
                            }
                            pNGTranscoder.addTranscodingHint(ImageTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, new Float(f));
                        } else if ("background".equals(object2)) {
                            Color color = StyleValue.parseColor((String)object);
                            if (color == null) {
                                throw new RuntimeException("'" + (String)object + "' invalid value for parameter" + " 'background': should be a color" + " specified using CSS syntax");
                            }
                            pNGTranscoder.addTranscodingHint(ImageTranscoder.KEY_BACKGROUND_COLOR, color);
                        } else if ("quality".equals(object2) && pNGTranscoder instanceof JPEGTranscoder) {
                            float f;
                            try {
                                f = Float.parseFloat((String)object);
                            }
                            catch (NumberFormatException numberFormatException) {
                                f = -1.0f;
                            }
                            if (f < 0.0f || f > 1.0f) {
                                throw new RuntimeException("'" + (String)object + "' invalid value for parameter 'quality':" + " should be a float between 0 and 1");
                            }
                            pNGTranscoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, new Float(f));
                        } else if ("indexed".equals(object2) && pNGTranscoder instanceof PNGTranscoder) {
                            int n2;
                            try {
                                n2 = Integer.parseInt((String)object);
                            }
                            catch (NumberFormatException numberFormatException) {
                                n2 = -1;
                            }
                            if (n2 != 1 && n2 != 2 && n2 != 4 && n2 != 8) {
                                throw new RuntimeException("'" + (String)object + "' invalid value for parameter 'indexed':" + " should be 1, 2, 4, or 8");
                            }
                            pNGTranscoder.addTranscodingHint(PNGTranscoder.KEY_INDEXED, new Integer(n2));
                        } else {
                            throw new RuntimeException("unknown parameter '" + (String)object2 + "':" + " should be pxtomm, dpi, background, " + " quality (JPEG only) or indexed (PNG only)");
                        }
                        n += 2;
                    }
                }
                InputStream inputStream = new FileInputStream(file);
                if (bl2) {
                    inputStream = new GZIPInputStream(inputStream);
                }
                try {
                    object2 = new TranscoderInput(inputStream);
                    ((TranscoderInput)object2).setURI(FileUtil.fileToURL((File)file).toExternalForm());
                    object = new FileOutputStream(file2);
                    BatikImageToolkit.this.console = console;
                    try {
                        TranscoderOutput transcoderOutput = new TranscoderOutput((OutputStream)object);
                        pNGTranscoder.transcode((TranscoderInput)object2, transcoderOutput);
                        ((OutputStream)object).flush();
                        Object var11_18 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_19 = null;
                        ((OutputStream)object).close();
                        throw throwable;
                    }
                    ((OutputStream)object).close();
                    Object var13_21 = null;
                }
                catch (Throwable throwable) {
                    Object var13_22 = null;
                    inputStream.close();
                    BatikImageToolkit.this.console = null;
                    throw throwable;
                }
                inputStream.close();
                BatikImageToolkit.this.console = null;
            }
        };
    }

    public void warning(TranscoderException transcoderException) throws TranscoderException {
        String string = "SVG transcoder warning: " + MiscUtil.reason((Throwable)transcoderException);
        if (this.console == null) {
            System.err.println(string);
        } else {
            this.console.showMessage(string, 1);
        }
    }

    public void error(TranscoderException transcoderException) throws TranscoderException {
        String string = "SVG transcoder error: " + MiscUtil.reason((Throwable)transcoderException);
        if (this.console == null) {
            System.err.println(string);
        } else {
            this.console.showMessage(string, 2);
        }
    }

    public void fatalError(TranscoderException transcoderException) throws TranscoderException {
        throw transcoderException;
    }

    private static final class AnnotatedBufferedImage
    extends BufferedImage
    implements VectorImage {
        private Rectangle2D boundingBox;

        public AnnotatedBufferedImage(int n, int n2, Rectangle2D rectangle2D) {
            super(n, n2, 2);
            this.boundingBox = rectangle2D;
        }

        public Rectangle2D getBoundingBox() {
            return this.boundingBox;
        }
    }

    private final class ImageScalingTranscoder
    extends ImageTranscoder {
        private double specWidth;
        private double specHeight;
        private int specWidthType;
        private int specHeightType;
        private boolean specPreserveAspect;
        private Rectangle2D boundingBox;
        private BufferedImage scaledImage;

        public ImageScalingTranscoder(double d, int n, double d2, int n2, boolean bl, double d3) {
            this.specWidth = d;
            this.specHeight = d2;
            this.specWidthType = n;
            this.specHeightType = n2;
            this.specPreserveAspect = bl;
            this.setErrorHandler(BatikImageToolkit.this);
            this.addTranscodingHint(XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME, "com.jclark.xml.sax.SAX2Driver");
            this.addTranscodingHint(XMLAbstractTranscoder.KEY_XML_PARSER_VALIDATING, Boolean.FALSE);
            if (d3 > 0.0) {
                float f = (float)(25.4 / d3);
                this.addTranscodingHint(SVGAbstractTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, new Float(f));
            }
        }

        protected void setImageSize(float f, float f2) {
            double[] dArray = ImageToolkitUtil.computeScaledSize((double)f, (double)f2, (double)this.specWidth, (int)this.specWidthType, (double)this.specHeight, (int)this.specHeightType, (boolean)this.specPreserveAspect);
            if (dArray == null) {
                this.width = f;
                this.height = f2;
            } else {
                this.width = (float)dArray[0];
                this.height = (float)dArray[1];
            }
        }

        protected CanvasGraphicsNode getCanvasGraphicsNode(GraphicsNode graphicsNode) {
            CanvasGraphicsNode canvasGraphicsNode = super.getCanvasGraphicsNode(graphicsNode);
            if (canvasGraphicsNode != null) {
                this.boundingBox = canvasGraphicsNode.getPrimitiveBounds();
            }
            return canvasGraphicsNode;
        }

        public BufferedImage createImage(int n, int n2) {
            AnnotatedBufferedImage annotatedBufferedImage = new AnnotatedBufferedImage(n, n2, this.boundingBox);
            return annotatedBufferedImage;
        }

        public void writeImage(BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
            this.scaledImage = bufferedImage;
        }

        public BufferedImage getScaledImage() {
            return this.scaledImage;
        }
    }
}

