/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import org.apache.batik.util.CleanerThread;
import org.w3c.dom.Element;

public class DocumentDescriptor {
    protected static final int INITIAL_CAPACITY = 101;
    protected Entry[] table = new Entry[101];
    protected int count;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfElements() {
        DocumentDescriptor documentDescriptor = this;
        synchronized (documentDescriptor) {
            return this.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocationLine(Element element) {
        DocumentDescriptor documentDescriptor = this;
        synchronized (documentDescriptor) {
            int n = element.hashCode() & Integer.MAX_VALUE;
            int n2 = n % this.table.length;
            Entry entry = this.table[n2];
            while (entry != null) {
                Object t;
                if (entry.hash == n && (t = entry.get()) == element) {
                    return entry.locationLine;
                }
                entry = entry.next;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocationLine(Element element, int n) {
        DocumentDescriptor documentDescriptor = this;
        synchronized (documentDescriptor) {
            Entry entry;
            int n2 = element.hashCode() & Integer.MAX_VALUE;
            int n3 = n2 % this.table.length;
            Entry entry2 = this.table[n3];
            while (entry2 != null) {
                Object t;
                if (entry2.hash == n2 && (t = entry2.get()) == element) {
                    entry2.locationLine = n;
                }
                entry2 = entry2.next;
            }
            int n4 = this.table.length;
            if (this.count++ >= n4 * 3 >>> 2) {
                this.rehash();
                n3 = n2 % this.table.length;
            }
            this.table[n3] = entry = new Entry(n2, element, n, this.table[n3]);
        }
    }

    protected void rehash() {
        Entry[] entryArray = this.table;
        this.table = new Entry[entryArray.length * 2 + 1];
        int n = entryArray.length - 1;
        while (n >= 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n2 = entry2.hash % this.table.length;
                entry2.next = this.table[n2];
                this.table[n2] = entry2;
            }
            --n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeEntry(Entry entry) {
        DocumentDescriptor documentDescriptor = this;
        synchronized (documentDescriptor) {
            int n = entry.hash;
            int n2 = n % this.table.length;
            Entry entry2 = this.table[n2];
            Entry entry3 = null;
            while (entry2 != entry) {
                entry3 = entry2;
                entry2 = entry2.next;
            }
            if (entry2 == null) {
                return;
            }
            if (entry3 == null) {
                this.table[n2] = entry2.next;
            } else {
                entry3.next = entry2.next;
            }
            --this.count;
        }
    }

    protected class Entry
    extends CleanerThread.WeakReferenceCleared {
        public int hash;
        public int locationLine;
        public Entry next;

        public Entry(int n, Element element, int n2, Entry entry) {
            super(element);
            this.hash = n;
            this.locationLine = n2;
            this.next = entry;
        }

        public void cleared() {
            DocumentDescriptor.this.removeEntry(this);
        }
    }
}

