/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.tiff;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.batik.ext.awt.image.codec.SeekableStream;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFDecodeParam;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFDirectory;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFFaxDecoder;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFField;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFLZWDecoder;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class TIFFImage
extends AbstractRed {
    public static final int COMP_NONE = 1;
    public static final int COMP_FAX_G3_1D = 2;
    public static final int COMP_FAX_G3_2D = 3;
    public static final int COMP_FAX_G4_2D = 4;
    public static final int COMP_LZW = 5;
    public static final int COMP_JPEG_OLD = 6;
    public static final int COMP_JPEG_TTN2 = 7;
    public static final int COMP_PACKBITS = 32773;
    public static final int COMP_DEFLATE = 32946;
    private static final int TYPE_UNSUPPORTED = -1;
    private static final int TYPE_BILEVEL = 0;
    private static final int TYPE_GRAY_4BIT = 1;
    private static final int TYPE_GRAY = 2;
    private static final int TYPE_GRAY_ALPHA = 3;
    private static final int TYPE_PALETTE = 4;
    private static final int TYPE_RGB = 5;
    private static final int TYPE_RGB_ALPHA = 6;
    private static final int TYPE_YCBCR_SUB = 7;
    private static final int TYPE_GENERIC = 8;
    private static final int TIFF_JPEG_TABLES = 347;
    private static final int TIFF_YCBCR_SUBSAMPLING = 530;
    SeekableStream stream;
    int tileSize;
    int tilesX;
    int tilesY;
    long[] tileOffsets;
    long[] tileByteCounts;
    char[] colormap;
    int sampleSize;
    int compression;
    byte[] palette;
    int numBands;
    int chromaSubH;
    int chromaSubV;
    long tiffT4Options;
    long tiffT6Options;
    int fillOrder;
    int predictor;
    JPEGDecodeParam decodeParam = null;
    boolean colorConvertJPEG = false;
    Inflater inflater = null;
    boolean isBigEndian;
    int imageType;
    boolean isWhiteZero = false;
    int dataType;
    boolean decodePaletteAsShorts;
    boolean tiled;
    private TIFFFaxDecoder decoder = null;
    private TIFFLZWDecoder lzwDecoder = null;

    private static final Raster decodeJPEG(byte[] byArray, JPEGDecodeParam jPEGDecodeParam, boolean bl, int n, int n2) {
        Raster raster;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        JPEGImageDecoder jPEGImageDecoder = jPEGDecodeParam == null ? JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream) : JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream, (JPEGDecodeParam)jPEGDecodeParam);
        try {
            raster = bl ? jPEGImageDecoder.decodeAsBufferedImage().getWritableTile(0, 0) : jPEGImageDecoder.decodeAsRaster();
        }
        catch (IOException iOException) {
            throw new RuntimeException("TIFFImage13");
        }
        return raster.createTranslatedChild(n, n2);
    }

    private final void inflate(byte[] byArray, byte[] byArray2) {
        this.inflater.setInput(byArray);
        try {
            this.inflater.inflate(byArray2);
        }
        catch (DataFormatException dataFormatException) {
            throw new RuntimeException("TIFFImage17: " + dataFormatException.getMessage());
        }
        this.inflater.reset();
    }

    private static SampleModel createPixelInterleavedSampleModel(int n, int n2, int n3, int n4) {
        int[] nArray = new int[n4];
        int n5 = 0;
        while (n5 < n4) {
            nArray[n5] = n5;
            ++n5;
        }
        return new PixelInterleavedSampleModel(n, n2, n3, n4, n2 * n4, nArray);
    }

    private final long[] getFieldAsLongs(TIFFField tIFFField) {
        long[] lArray = null;
        if (tIFFField.getType() == 3) {
            char[] cArray = tIFFField.getAsChars();
            lArray = new long[cArray.length];
            int n = 0;
            while (n < cArray.length) {
                lArray[n] = cArray[n] & 0xFFFF;
                ++n;
            }
        } else if (tIFFField.getType() == 4) {
            lArray = tIFFField.getAsLongs();
        } else {
            throw new RuntimeException();
        }
        return lArray;
    }

    public TIFFImage(SeekableStream seekableStream, TIFFDecodeParam tIFFDecodeParam, int n) throws IOException {
        Object object;
        Object object2;
        TIFFField tIFFField;
        TIFFField tIFFField2;
        int n2;
        int n3;
        int n4;
        Serializable serializable;
        int n5;
        char[] cArray;
        char[] cArray2;
        this.stream = seekableStream;
        if (tIFFDecodeParam == null) {
            tIFFDecodeParam = new TIFFDecodeParam();
        }
        this.decodePaletteAsShorts = tIFFDecodeParam.getDecodePaletteAsShorts();
        TIFFDirectory tIFFDirectory = tIFFDecodeParam.getIFDOffset() == null ? new TIFFDirectory(seekableStream, n) : new TIFFDirectory(seekableStream, tIFFDecodeParam.getIFDOffset(), n);
        TIFFField tIFFField3 = tIFFDirectory.getField(277);
        int n6 = tIFFField3 == null ? 1 : (int)tIFFField3.getAsLong(0);
        TIFFField tIFFField4 = tIFFDirectory.getField(284);
        if (tIFFField4 == null) {
            char[] cArray3 = new char[1];
            cArray2 = cArray3;
            cArray3[0] = '\u0001';
        } else {
            cArray2 = cArray = tIFFField4.getAsChars();
        }
        if (cArray[0] != '\u0001' && n6 != 1) {
            throw new RuntimeException("TIFFImage0");
        }
        TIFFField tIFFField5 = tIFFDirectory.getField(258);
        char[] cArray4 = null;
        if (tIFFField5 != null) {
            cArray4 = tIFFField5.getAsChars();
        } else {
            cArray4 = new char[]{'\u0001'};
            int n7 = 1;
            while (n7 < cArray4.length) {
                if (cArray4[n7] != cArray4[0]) {
                    throw new RuntimeException("TIFFImage1");
                }
                ++n7;
            }
        }
        this.sampleSize = cArray4[0];
        TIFFField tIFFField6 = tIFFDirectory.getField(339);
        char[] cArray5 = null;
        if (tIFFField6 != null) {
            cArray5 = tIFFField6.getAsChars();
            n5 = 1;
            while (n5 < cArray5.length) {
                if (cArray5[n5] != cArray5[0]) {
                    throw new RuntimeException("TIFFImage2");
                }
                ++n5;
            }
        } else {
            cArray5 = new char[]{'\u0001'};
        }
        n5 = 0;
        switch (this.sampleSize) {
            case 1: 
            case 4: 
            case 8: {
                if (cArray5[0] == '\u0003') break;
                this.dataType = 0;
                n5 = 1;
                break;
            }
            case 16: {
                if (cArray5[0] == '\u0003') break;
                this.dataType = cArray5[0] == '\u0002' ? 2 : 1;
                n5 = 1;
                break;
            }
            case 32: {
                if (cArray5[0] == '\u0003') {
                    n5 = 0;
                    break;
                }
                this.dataType = 3;
                n5 = 1;
            }
        }
        if (n5 == 0) {
            throw new RuntimeException("TIFFImage3");
        }
        TIFFField tIFFField7 = tIFFDirectory.getField(259);
        this.compression = tIFFField7 == null ? 1 : tIFFField7.getAsInt(0);
        int n8 = (int)tIFFDirectory.getFieldAsLong(262);
        this.imageType = -1;
        switch (n8) {
            case 0: {
                this.isWhiteZero = true;
            }
            case 1: {
                if (this.sampleSize == 1 && n6 == 1) {
                    this.imageType = 0;
                    break;
                }
                if (this.sampleSize == 4 && n6 == 1) {
                    this.imageType = 1;
                    break;
                }
                if (this.sampleSize % 8 != 0) break;
                if (n6 == 1) {
                    this.imageType = 2;
                    break;
                }
                if (n6 == 2) {
                    this.imageType = 3;
                    break;
                }
                this.imageType = 8;
                break;
            }
            case 2: {
                if (this.sampleSize % 8 != 0) break;
                if (n6 == 3) {
                    this.imageType = 5;
                    break;
                }
                if (n6 == 4) {
                    this.imageType = 6;
                    break;
                }
                this.imageType = 8;
                break;
            }
            case 3: {
                if (n6 != true || this.sampleSize != 4 && this.sampleSize != 8 && this.sampleSize != 16) break;
                this.imageType = 4;
                break;
            }
            case 4: {
                if (this.sampleSize != 1 || n6 != true) break;
                this.imageType = 0;
                break;
            }
            case 6: {
                if (this.compression == 7 && this.sampleSize == 8 && n6 == 3) {
                    this.colorConvertJPEG = tIFFDecodeParam.getJPEGDecompressYCbCrToRGB();
                    this.imageType = this.colorConvertJPEG ? 5 : 8;
                    break;
                }
                serializable = tIFFDirectory.getField(530);
                if (serializable != null) {
                    this.chromaSubH = serializable.getAsInt(0);
                    this.chromaSubV = serializable.getAsInt(1);
                } else {
                    this.chromaSubV = 2;
                    this.chromaSubH = 2;
                }
                if (this.chromaSubH * this.chromaSubV == 1) {
                    this.imageType = 8;
                    break;
                }
                if (this.sampleSize != 8 || n6 != 3) break;
                this.imageType = 7;
                break;
            }
            default: {
                if (this.sampleSize % 8 != 0) break;
                this.imageType = 8;
            }
        }
        if (this.imageType == -1) {
            throw new RuntimeException("TIFFImage4");
        }
        serializable = new Rectangle(0, 0, (int)tIFFDirectory.getFieldAsLong(256), (int)tIFFDirectory.getFieldAsLong(257));
        this.numBands = n6;
        TIFFField tIFFField8 = tIFFDirectory.getField(338);
        int n9 = n4 = tIFFField8 == null ? 0 : (int)tIFFField8.getAsLong(0);
        if (tIFFDirectory.getField(324) != null) {
            this.tiled = true;
            n3 = (int)tIFFDirectory.getFieldAsLong(322);
            n2 = (int)tIFFDirectory.getFieldAsLong(323);
            this.tileOffsets = tIFFDirectory.getField(324).getAsLongs();
            this.tileByteCounts = this.getFieldAsLongs(tIFFDirectory.getField(325));
        } else {
            this.tiled = false;
            n3 = tIFFDirectory.getField(322) != null ? (int)tIFFDirectory.getFieldAsLong(322) : ((Rectangle)serializable).width;
            tIFFField2 = tIFFDirectory.getField(278);
            if (tIFFField2 == null) {
                n2 = tIFFDirectory.getField(323) != null ? (int)tIFFDirectory.getFieldAsLong(323) : ((Rectangle)serializable).height;
            } else {
                long l = tIFFField2.getAsLong(0);
                long l2 = 1L;
                n2 = l == (l2 = (l2 << 32) - 1L) ? ((Rectangle)serializable).height : (int)l;
            }
            tIFFField = tIFFDirectory.getField(273);
            if (tIFFField == null) {
                throw new RuntimeException("TIFFImage5");
            }
            this.tileOffsets = this.getFieldAsLongs(tIFFField);
            object2 = tIFFDirectory.getField(279);
            if (object2 == null) {
                throw new RuntimeException("TIFFImage6");
            }
            this.tileByteCounts = this.getFieldAsLongs((TIFFField)object2);
        }
        this.tilesX = (((Rectangle)serializable).width + n3 - 1) / n3;
        this.tilesY = (((Rectangle)serializable).height + n2 - 1) / n2;
        this.tileSize = n3 * n2 * this.numBands;
        this.isBigEndian = tIFFDirectory.isBigEndian();
        tIFFField2 = tIFFDirectory.getField(266);
        this.fillOrder = tIFFField2 != null ? tIFFField2.getAsInt(0) : 1;
        switch (this.compression) {
            case 1: 
            case 32773: {
                break;
            }
            case 32946: {
                this.inflater = new Inflater();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (this.sampleSize != 1) {
                    throw new RuntimeException("TIFFImage7");
                }
                if (this.compression == 3) {
                    tIFFField = tIFFDirectory.getField(292);
                    this.tiffT4Options = tIFFField != null ? tIFFField.getAsLong(0) : 0L;
                }
                if (this.compression == 4) {
                    tIFFField = tIFFDirectory.getField(293);
                    this.tiffT6Options = tIFFField != null ? tIFFField.getAsLong(0) : 0L;
                }
                this.decoder = new TIFFFaxDecoder(this.fillOrder, n3, n2);
                break;
            }
            case 5: {
                tIFFField = tIFFDirectory.getField(317);
                if (tIFFField == null) {
                    this.predictor = 1;
                } else {
                    this.predictor = tIFFField.getAsInt(0);
                    if (this.predictor != 1 && this.predictor != 2) {
                        throw new RuntimeException("TIFFImage8");
                    }
                    if (this.predictor == 2 && this.sampleSize != 8) {
                        throw new RuntimeException(this.sampleSize + "TIFFImage9");
                    }
                }
                this.lzwDecoder = new TIFFLZWDecoder(n3, this.predictor, n6);
                break;
            }
            case 6: {
                throw new RuntimeException("TIFFImage15");
            }
            case 7: {
                if (!(this.sampleSize == 8 && (this.imageType == 2 && n6 == 1 || this.imageType == 4 && n6 == 1 || this.imageType == 5 && n6 == 3))) {
                    throw new RuntimeException("TIFFImage16");
                }
                if (!tIFFDirectory.isTagPresent(347)) break;
                object2 = tIFFDirectory.getField(347);
                byte[] byArray = ((TIFFField)object2).getAsBytes();
                object = new ByteArrayInputStream(byArray);
                JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)object);
                jPEGImageDecoder.decodeAsRaster();
                this.decodeParam = jPEGImageDecoder.getJPEGDecodeParam();
                break;
            }
            default: {
                throw new RuntimeException("TIFFImage10");
            }
        }
        object2 = null;
        SampleModel sampleModel = null;
        switch (this.imageType) {
            case 0: 
            case 1: {
                sampleModel = new MultiPixelPackedSampleModel(this.dataType, n3, n2, this.sampleSize);
                if (this.imageType == 0) {
                    object = new byte[]{(byte)(this.isWhiteZero ? 255 : 0), (byte)(this.isWhiteZero ? 0 : 255)};
                    object2 = new IndexColorModel(1, 2, (byte[])object, (byte[])object, (byte[])object);
                    break;
                }
                object = new byte[16];
                if (this.isWhiteZero) {
                    int n10 = 0;
                    while (n10 < ((int[])object).length) {
                        object[n10] = (byte)(255 - 16 * n10);
                        ++n10;
                    }
                } else {
                    int n11 = 0;
                    while (n11 < ((int[])object).length) {
                        object[n11] = (byte)(16 * n11);
                        ++n11;
                    }
                }
                object2 = new IndexColorModel(4, 16, (byte[])object, (byte[])object, (byte[])object);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                object = new int[this.numBands];
                int n12 = 0;
                while (n12 < this.numBands) {
                    object[n12] = this.numBands - 1 - n12;
                    ++n12;
                }
                sampleModel = new PixelInterleavedSampleModel(this.dataType, n3, n2, this.numBands, this.numBands * n3, (int[])object);
                if (this.imageType == 2) {
                    object2 = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{this.sampleSize}, false, false, 1, this.dataType);
                    break;
                }
                if (this.imageType == 5) {
                    object2 = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{this.sampleSize, this.sampleSize, this.sampleSize}, false, false, 1, this.dataType);
                    break;
                }
                int n13 = 1;
                if (n4 == 1) {
                    n13 = 3;
                } else if (n4 == 2) {
                    n13 = 2;
                }
                object2 = this.createAlphaComponentColorModel(this.dataType, this.numBands, n4 == 1, n13);
                break;
            }
            case 7: 
            case 8: {
                int[] nArray = new int[this.numBands];
                int n14 = 0;
                while (n14 < this.numBands) {
                    nArray[n14] = n14;
                    ++n14;
                }
                sampleModel = new PixelInterleavedSampleModel(this.dataType, n3, n2, this.numBands, this.numBands * n3, nArray);
                object2 = null;
                break;
            }
            case 4: {
                TIFFField tIFFField9 = tIFFDirectory.getField(320);
                if (tIFFField9 == null) {
                    throw new RuntimeException("TIFFImage11");
                }
                this.colormap = tIFFField9.getAsChars();
                if (this.decodePaletteAsShorts) {
                    this.numBands = 3;
                    if (this.dataType == 0) {
                        this.dataType = 1;
                    }
                    sampleModel = TIFFImage.createPixelInterleavedSampleModel(this.dataType, n3, n2, this.numBands);
                    object2 = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{16, 16, 16}, false, false, 1, this.dataType);
                    break;
                }
                this.numBands = 1;
                if (this.sampleSize == 4) {
                    sampleModel = new MultiPixelPackedSampleModel(0, n3, n2, this.sampleSize);
                } else if (this.sampleSize == 8) {
                    sampleModel = TIFFImage.createPixelInterleavedSampleModel(0, n3, n2, this.numBands);
                } else if (this.sampleSize == 16) {
                    this.dataType = 1;
                    sampleModel = TIFFImage.createPixelInterleavedSampleModel(1, n3, n2, this.numBands);
                }
                int n15 = this.colormap.length / 3;
                byte[] byArray = new byte[n15];
                byte[] byArray2 = new byte[n15];
                byte[] byArray3 = new byte[n15];
                int n16 = n15;
                int n17 = n15 * 2;
                if (this.dataType == 2) {
                    int n18 = 0;
                    while (n18 < n15) {
                        byArray[n18] = tIFFDecodeParam.decodeSigned16BitsTo8Bits((short)this.colormap[n18]);
                        byArray2[n18] = tIFFDecodeParam.decodeSigned16BitsTo8Bits((short)this.colormap[n16 + n18]);
                        byArray3[n18] = tIFFDecodeParam.decodeSigned16BitsTo8Bits((short)this.colormap[n17 + n18]);
                        ++n18;
                    }
                } else {
                    int n19 = 0;
                    while (n19 < n15) {
                        byArray[n19] = tIFFDecodeParam.decode16BitsTo8Bits(this.colormap[n19] & 0xFFFF);
                        byArray2[n19] = tIFFDecodeParam.decode16BitsTo8Bits(this.colormap[n16 + n19] & 0xFFFF);
                        byArray3[n19] = tIFFDecodeParam.decode16BitsTo8Bits(this.colormap[n17 + n19] & 0xFFFF);
                        ++n19;
                    }
                }
                object2 = new IndexColorModel(this.sampleSize, n15, byArray, byArray2, byArray3);
                break;
            }
            default: {
                throw new RuntimeException("TIFFImage4");
            }
        }
        HashMap<String, TIFFDirectory> hashMap = new HashMap<String, TIFFDirectory>();
        hashMap.put("tiff_directory", tIFFDirectory);
        this.init((CachableRed)null, (Rectangle)serializable, (ColorModel)object2, sampleModel, 0, 0, hashMap);
    }

    public TIFFDirectory getPrivateIFD(long l) throws IOException {
        return new TIFFDirectory(this.stream, l, 0);
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        this.copyToRaster(writableRaster);
        return writableRaster;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Raster getTile(int n, int n2) {
        byte[] byArray;
        if (n < 0 || n >= this.tilesX || n2 < 0 || n2 >= this.tilesY) {
            throw new IllegalArgumentException("TIFFImage12");
        }
        byte[] byArray2 = null;
        short[] sArray = null;
        int[] nArray = null;
        SampleModel sampleModel = this.getSampleModel();
        WritableRaster writableRaster = this.makeTile(n, n2);
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n3 = sampleModel.getDataType();
        if (n3 == 0) {
            byArray2 = ((DataBufferByte)dataBuffer).getData();
        } else if (n3 == 1) {
            sArray = ((DataBufferUShort)dataBuffer).getData();
        } else if (n3 == 2) {
            sArray = ((DataBufferShort)dataBuffer).getData();
        } else if (n3 == 3) {
            nArray = ((DataBufferInt)dataBuffer).getData();
        }
        long l = 0L;
        try {
            l = this.stream.getFilePointer();
            this.stream.seek(this.tileOffsets[n2 * this.tilesX + n]);
        }
        catch (IOException iOException) {
            throw new RuntimeException("TIFFImage13");
        }
        int n4 = (int)this.tileByteCounts[n2 * this.tilesX + n];
        Rectangle rectangle = !this.tiled ? writableRaster.getBounds() : new Rectangle(writableRaster.getMinX(), writableRaster.getMinY(), this.tileWidth, this.tileHeight);
        int n5 = rectangle.width * rectangle.height * this.numBands;
        Object object = byArray = (Object)(this.compression != 1 || this.imageType == 4 ? new byte[n4] : null);
        if (this.imageType == 0) {
            try {
                if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n4);
                    int n6 = rectangle.width % 8 == 0 ? rectangle.width / 8 * rectangle.height : (rectangle.width / 8 + 1) * rectangle.height;
                    this.decodePackbits(byArray, n6, byArray2);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n4);
                    this.lzwDecoder.decode(byArray, byArray2, rectangle.height);
                } else if (this.compression == 2) {
                    this.stream.readFully(byArray, 0, n4);
                    this.decoder.decode1D(byArray2, byArray, 0, rectangle.height);
                } else if (this.compression == 3) {
                    this.stream.readFully(byArray, 0, n4);
                    this.decoder.decode2D(byArray2, byArray, 0, rectangle.height, this.tiffT4Options);
                } else if (this.compression == 4) {
                    this.stream.readFully(byArray, 0, n4);
                    this.decoder.decodeT6(byArray2, byArray, 0, rectangle.height, this.tiffT6Options);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n4);
                    this.inflate(byArray, byArray2);
                } else if (this.compression == 1) {
                    this.stream.readFully(byArray2, 0, n4);
                }
                this.stream.seek(l);
                return writableRaster;
            }
            catch (IOException iOException) {
                throw new RuntimeException("TIFFImage13");
            }
        }
        if (this.imageType == 4) {
            if (this.sampleSize == 16) {
                if (this.decodePaletteAsShorts) {
                    short[] sArray2 = null;
                    int n7 = n5 / 3;
                    int n8 = n7 * 2;
                    try {
                        byte[] byArray3;
                        if (this.compression == 32773) {
                            this.stream.readFully(byArray, 0, n4);
                            byArray3 = new byte[n8];
                            this.decodePackbits(byArray, n8, byArray3);
                            sArray2 = new short[n7];
                            this.interpretBytesAsShorts(byArray3, sArray2, n7);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray, 0, n4);
                            byArray3 = new byte[n8];
                            this.lzwDecoder.decode(byArray, byArray3, rectangle.height);
                            sArray2 = new short[n7];
                            this.interpretBytesAsShorts(byArray3, sArray2, n7);
                        } else if (this.compression == 32946) {
                            this.stream.readFully(byArray, 0, n4);
                            byArray3 = new byte[n8];
                            this.inflate(byArray, byArray3);
                            sArray2 = new short[n7];
                            this.interpretBytesAsShorts(byArray3, sArray2, n7);
                        } else if (this.compression == 1) {
                            sArray2 = new short[n4 / 2];
                            this.readShorts(n4 / 2, sArray2);
                        }
                        this.stream.seek(l);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException("TIFFImage13");
                    }
                    if (n3 == 1) {
                        int n9 = 0;
                        int n10 = this.colormap.length / 3;
                        int n11 = n10 * 2;
                        int n12 = 0;
                        while (n12 < n7) {
                            int n13 = sArray2[n12] & 0xFFFF;
                            char c = this.colormap[n13 + n11];
                            sArray[n9++] = (short)(c & 0xFFFF);
                            c = this.colormap[n13 + n10];
                            sArray[n9++] = (short)(c & 0xFFFF);
                            c = this.colormap[n13];
                            sArray[n9++] = (short)(c & 0xFFFF);
                            ++n12;
                        }
                        return writableRaster;
                    } else {
                        if (n3 != 2) return writableRaster;
                        int n14 = 0;
                        int n15 = this.colormap.length / 3;
                        int n16 = n15 * 2;
                        int n17 = 0;
                        while (n17 < n7) {
                            int n18 = sArray2[n17] & 0xFFFF;
                            char c = this.colormap[n18 + n16];
                            sArray[n14++] = (short)c;
                            c = this.colormap[n18 + n15];
                            sArray[n14++] = (short)c;
                            c = this.colormap[n18];
                            sArray[n14++] = (short)c;
                            ++n17;
                        }
                    }
                    return writableRaster;
                }
                try {
                    if (this.compression == 32773) {
                        this.stream.readFully(byArray, 0, n4);
                        int n19 = n5 * 2;
                        byte[] byArray4 = new byte[n19];
                        this.decodePackbits(byArray, n19, byArray4);
                        this.interpretBytesAsShorts(byArray4, sArray, n5);
                    } else if (this.compression == 5) {
                        this.stream.readFully(byArray, 0, n4);
                        byte[] byArray5 = new byte[n5 * 2];
                        this.lzwDecoder.decode(byArray, byArray5, rectangle.height);
                        this.interpretBytesAsShorts(byArray5, sArray, n5);
                    } else if (this.compression == 32946) {
                        this.stream.readFully(byArray, 0, n4);
                        byte[] byArray6 = new byte[n5 * 2];
                        this.inflate(byArray, byArray6);
                        this.interpretBytesAsShorts(byArray6, sArray, n5);
                    } else if (this.compression == 1) {
                        this.readShorts(n4 / 2, sArray);
                    }
                    this.stream.seek(l);
                    return writableRaster;
                }
                catch (IOException iOException) {
                    throw new RuntimeException("TIFFImage13");
                }
            }
            if (this.sampleSize == 8) {
                if (this.decodePaletteAsShorts) {
                    int n20;
                    byte[] byArray7 = null;
                    int n21 = n5 / 3;
                    try {
                        if (this.compression == 32773) {
                            this.stream.readFully(byArray, 0, n4);
                            byArray7 = new byte[n21];
                            this.decodePackbits(byArray, n21, byArray7);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray, 0, n4);
                            byArray7 = new byte[n21];
                            this.lzwDecoder.decode(byArray, byArray7, rectangle.height);
                        } else if (this.compression == 7) {
                            this.stream.readFully(byArray, 0, n4);
                            Raster raster = TIFFImage.decodeJPEG(byArray, this.decodeParam, this.colorConvertJPEG, writableRaster.getMinX(), writableRaster.getMinY());
                            int[] nArray2 = new int[n21];
                            raster.getPixels(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight(), nArray2);
                            byArray7 = new byte[n21];
                            n20 = 0;
                            while (n20 < n21) {
                                byArray7[n20] = (byte)nArray2[n20];
                                ++n20;
                            }
                        } else if (this.compression == 32946) {
                            this.stream.readFully(byArray, 0, n4);
                            byArray7 = new byte[n21];
                            this.inflate(byArray, byArray7);
                        } else if (this.compression == 1) {
                            byArray7 = new byte[n4];
                            this.stream.readFully(byArray7, 0, n4);
                        }
                        this.stream.seek(l);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException("TIFFImage13");
                    }
                    int n22 = 0;
                    int n23 = this.colormap.length / 3;
                    int n24 = n23 * 2;
                    int n25 = 0;
                    while (n25 < n21) {
                        n20 = byArray7[n25] & 0xFF;
                        char c = this.colormap[n20 + n24];
                        sArray[n22++] = (short)(c & 0xFFFF);
                        c = this.colormap[n20 + n23];
                        sArray[n22++] = (short)(c & 0xFFFF);
                        c = this.colormap[n20];
                        sArray[n22++] = (short)(c & 0xFFFF);
                        ++n25;
                    }
                    return writableRaster;
                }
                try {
                    if (this.compression == 32773) {
                        this.stream.readFully(byArray, 0, n4);
                        this.decodePackbits(byArray, n5, byArray2);
                    } else if (this.compression == 5) {
                        this.stream.readFully(byArray, 0, n4);
                        this.lzwDecoder.decode(byArray, byArray2, rectangle.height);
                    } else if (this.compression == 7) {
                        this.stream.readFully(byArray, 0, n4);
                        writableRaster.setRect(TIFFImage.decodeJPEG(byArray, this.decodeParam, this.colorConvertJPEG, writableRaster.getMinX(), writableRaster.getMinY()));
                    } else if (this.compression == 32946) {
                        this.stream.readFully(byArray, 0, n4);
                        this.inflate(byArray, byArray2);
                    } else if (this.compression == 1) {
                        this.stream.readFully(byArray2, 0, n4);
                    }
                    this.stream.seek(l);
                    return writableRaster;
                }
                catch (IOException iOException) {
                    throw new RuntimeException("TIFFImage13");
                }
            }
            if (this.sampleSize != 4) return writableRaster;
            int n26 = rectangle.width % 2 == 0 ? 0 : 1;
            int n27 = (rectangle.width / 2 + n26) * rectangle.height;
            if (this.decodePaletteAsShorts) {
                int n28;
                byte[] byArray8 = null;
                try {
                    this.stream.readFully(byArray, 0, n4);
                    this.stream.seek(l);
                }
                catch (IOException iOException) {
                    throw new RuntimeException("TIFFImage13");
                }
                if (this.compression == 32773) {
                    byArray8 = new byte[n27];
                    this.decodePackbits(byArray, n27, byArray8);
                } else if (this.compression == 5) {
                    byArray8 = new byte[n27];
                    this.lzwDecoder.decode(byArray, byArray8, rectangle.height);
                } else if (this.compression == 32946) {
                    byArray8 = new byte[n27];
                    this.inflate(byArray, byArray8);
                } else if (this.compression == 1) {
                    byArray8 = byArray;
                }
                int n29 = n5 / 3;
                byArray = new byte[n29];
                int n30 = 0;
                int n31 = 0;
                int n32 = 0;
                while (n32 < rectangle.height) {
                    n28 = 0;
                    while (n28 < rectangle.width / 2) {
                        byArray[n31++] = (byte)((byArray8[n30] & 0xF0) >> 4);
                        byArray[n31++] = (byte)(byArray8[n30++] & 0xF);
                        ++n28;
                    }
                    if (n26 == 1) {
                        byArray[n31++] = (byte)((byArray8[n30++] & 0xF0) >> 4);
                    }
                    ++n32;
                }
                n28 = this.colormap.length / 3;
                int n33 = n28 * 2;
                int n34 = 0;
                int n35 = 0;
                while (n35 < n29) {
                    int n36 = byArray[n35] & 0xFF;
                    char c = this.colormap[n36 + n33];
                    sArray[n34++] = (short)(c & 0xFFFF);
                    c = this.colormap[n36 + n28];
                    sArray[n34++] = (short)(c & 0xFFFF);
                    c = this.colormap[n36];
                    sArray[n34++] = (short)(c & 0xFFFF);
                    ++n35;
                }
                return writableRaster;
            }
            try {
                if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n4);
                    this.decodePackbits(byArray, n27, byArray2);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n4);
                    this.lzwDecoder.decode(byArray, byArray2, rectangle.height);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n4);
                    this.inflate(byArray, byArray2);
                } else if (this.compression == 1) {
                    this.stream.readFully(byArray2, 0, n4);
                }
                this.stream.seek(l);
                return writableRaster;
            }
            catch (IOException iOException) {
                throw new RuntimeException("TIFFImage13");
            }
        }
        if (this.imageType == 1) {
            try {
                if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n4);
                    int n37 = rectangle.width % 8 == 0 ? rectangle.width / 2 * rectangle.height : (rectangle.width / 2 + 1) * rectangle.height;
                    this.decodePackbits(byArray, n37, byArray2);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n4);
                    this.lzwDecoder.decode(byArray, byArray2, rectangle.height);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n4);
                    this.inflate(byArray, byArray2);
                } else {
                    this.stream.readFully(byArray2, 0, n4);
                }
                this.stream.seek(l);
                return writableRaster;
            }
            catch (IOException iOException) {
                throw new RuntimeException("TIFFImage13");
            }
        }
        try {
            byte[] byArray9;
            if (this.sampleSize == 8) {
                if (this.compression == 1) {
                    this.stream.readFully(byArray2, 0, n4);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n4);
                    this.lzwDecoder.decode(byArray, byArray2, rectangle.height);
                } else if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n4);
                    this.decodePackbits(byArray, n5, byArray2);
                } else if (this.compression == 7) {
                    this.stream.readFully(byArray, 0, n4);
                    writableRaster.setRect(TIFFImage.decodeJPEG(byArray, this.decodeParam, this.colorConvertJPEG, writableRaster.getMinX(), writableRaster.getMinY()));
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n4);
                    this.inflate(byArray, byArray2);
                }
            } else if (this.sampleSize == 16) {
                if (this.compression == 1) {
                    this.readShorts(n4 / 2, sArray);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n4);
                    byte[] byArray10 = new byte[n5 * 2];
                    this.lzwDecoder.decode(byArray, byArray10, rectangle.height);
                    this.interpretBytesAsShorts(byArray10, sArray, n5);
                } else if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n4);
                    int n38 = n5 * 2;
                    byArray9 = new byte[n38];
                    this.decodePackbits(byArray, n38, byArray9);
                    this.interpretBytesAsShorts(byArray9, sArray, n5);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n4);
                    byte[] byArray11 = new byte[n5 * 2];
                    this.inflate(byArray, byArray11);
                    this.interpretBytesAsShorts(byArray11, sArray, n5);
                }
            } else if (this.sampleSize == 32 && n3 == 3) {
                if (this.compression == 1) {
                    this.readInts(n4 / 4, nArray);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n4);
                    byte[] byArray12 = new byte[n5 * 4];
                    this.lzwDecoder.decode(byArray, byArray12, rectangle.height);
                    this.interpretBytesAsInts(byArray12, nArray, n5);
                } else if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n4);
                    int n39 = n5 * 4;
                    byArray9 = new byte[n39];
                    this.decodePackbits(byArray, n39, byArray9);
                    this.interpretBytesAsInts(byArray9, nArray, n5);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n4);
                    byte[] byArray13 = new byte[n5 * 4];
                    this.inflate(byArray, byArray13);
                    this.interpretBytesAsInts(byArray13, nArray, n5);
                }
            }
            this.stream.seek(l);
        }
        catch (IOException iOException) {
            throw new RuntimeException("TIFFImage13");
        }
        switch (this.imageType) {
            case 2: 
            case 3: {
                if (!this.isWhiteZero) return writableRaster;
                if (n3 == 0 && !(this.getColorModel() instanceof IndexColorModel)) {
                    int n40 = 0;
                    while (n40 < byArray2.length) {
                        byArray2[n40] = (byte)(255 - byArray2[n40]);
                        n40 += this.numBands;
                    }
                    return writableRaster;
                } else if (n3 == 1) {
                    int n41 = 65535;
                    int n42 = 0;
                    while (n42 < sArray.length) {
                        sArray[n42] = (short)(n41 - sArray[n42]);
                        n42 += this.numBands;
                    }
                    return writableRaster;
                } else if (n3 == 2) {
                    int n43 = 0;
                    while (n43 < sArray.length) {
                        sArray[n43] = ~sArray[n43];
                        n43 += this.numBands;
                    }
                    return writableRaster;
                } else {
                    if (n3 != 3) return writableRaster;
                    long l2 = 0xFFFFFFFFL;
                    int n44 = 0;
                    while (n44 < nArray.length) {
                        nArray[n44] = (int)(l2 - (long)nArray[n44]);
                        n44 += this.numBands;
                    }
                }
                return writableRaster;
            }
            case 5: {
                if (this.sampleSize == 8 && this.compression != 7) {
                    int n45 = 0;
                    while (n45 < n5) {
                        byte by = byArray2[n45];
                        byArray2[n45] = byArray2[n45 + 2];
                        byArray2[n45 + 2] = by;
                        n45 += 3;
                    }
                    return writableRaster;
                } else if (this.sampleSize == 16) {
                    int n46 = 0;
                    while (n46 < n5) {
                        short s = sArray[n46];
                        sArray[n46] = sArray[n46 + 2];
                        sArray[n46 + 2] = s;
                        n46 += 3;
                    }
                    return writableRaster;
                } else {
                    if (this.sampleSize != 32 || n3 != 3) return writableRaster;
                    int n47 = 0;
                    while (n47 < n5) {
                        int n48 = nArray[n47];
                        nArray[n47] = nArray[n47 + 2];
                        nArray[n47 + 2] = n48;
                        n47 += 3;
                    }
                }
                return writableRaster;
            }
            case 6: {
                if (this.sampleSize == 8) {
                    int n49 = 0;
                    while (n49 < n5) {
                        byte by = byArray2[n49];
                        byArray2[n49] = byArray2[n49 + 3];
                        byArray2[n49 + 3] = by;
                        by = byArray2[n49 + 1];
                        byArray2[n49 + 1] = byArray2[n49 + 2];
                        byArray2[n49 + 2] = by;
                        n49 += 4;
                    }
                    return writableRaster;
                } else if (this.sampleSize == 16) {
                    int n50 = 0;
                    while (n50 < n5) {
                        short s = sArray[n50];
                        sArray[n50] = sArray[n50 + 3];
                        sArray[n50 + 3] = s;
                        s = sArray[n50 + 1];
                        sArray[n50 + 1] = sArray[n50 + 2];
                        sArray[n50 + 2] = s;
                        n50 += 4;
                    }
                    return writableRaster;
                } else {
                    if (this.sampleSize != 32 || n3 != 3) return writableRaster;
                    int n51 = 0;
                    while (n51 < n5) {
                        int n52 = nArray[n51];
                        nArray[n51] = nArray[n51 + 3];
                        nArray[n51 + 3] = n52;
                        n52 = nArray[n51 + 1];
                        nArray[n51 + 1] = nArray[n51 + 2];
                        nArray[n51 + 2] = n52;
                        n51 += 4;
                    }
                }
                return writableRaster;
            }
            case 7: {
                int n53 = this.chromaSubH * this.chromaSubV;
                int n54 = rectangle.width / this.chromaSubH;
                int n55 = rectangle.height / this.chromaSubV;
                byte[] byArray14 = new byte[n54 * n55 * (n53 + 2)];
                System.arraycopy(byArray2, 0, byArray14, 0, byArray14.length);
                int n56 = n53 * 3;
                int[] nArray3 = new int[n56];
                int n57 = 0;
                int n58 = n53;
                int n59 = n58 + 1;
                int n60 = rectangle.y;
                int n61 = 0;
                while (n61 < n55) {
                    int n62 = rectangle.x;
                    int n63 = 0;
                    while (n63 < n54) {
                        int n64 = byArray14[n57 + n58];
                        int n65 = byArray14[n57 + n59];
                        int n66 = 0;
                        while (n66 < n56) {
                            nArray3[n66++] = byArray14[n57++];
                            nArray3[n66++] = n64;
                            nArray3[n66++] = n65;
                        }
                        n57 += 2;
                        writableRaster.setPixels(n62, n60, this.chromaSubH, this.chromaSubV, nArray3);
                        n62 += this.chromaSubH;
                        ++n63;
                    }
                    n60 += this.chromaSubV;
                    ++n61;
                }
                return writableRaster;
            }
        }
        return writableRaster;
    }

    private void readShorts(int n, short[] sArray) {
        int n2 = 2 * n;
        byte[] byArray = new byte[n2];
        try {
            this.stream.readFully(byArray, 0, n2);
        }
        catch (IOException iOException) {
            throw new RuntimeException("TIFFImage13");
        }
        this.interpretBytesAsShorts(byArray, sArray, n);
    }

    private void readInts(int n, int[] nArray) {
        int n2 = 4 * n;
        byte[] byArray = new byte[n2];
        try {
            this.stream.readFully(byArray, 0, n2);
        }
        catch (IOException iOException) {
            throw new RuntimeException("TIFFImage13");
        }
        this.interpretBytesAsInts(byArray, nArray, n);
    }

    private void interpretBytesAsShorts(byte[] byArray, short[] sArray, int n) {
        int n2 = 0;
        if (this.isBigEndian) {
            int n3 = 0;
            while (n3 < n) {
                int n4 = byArray[n2++] & 0xFF;
                int n5 = byArray[n2++] & 0xFF;
                sArray[n3] = (short)((n4 << 8) + n5);
                ++n3;
            }
        } else {
            int n6 = 0;
            while (n6 < n) {
                int n7 = byArray[n2++] & 0xFF;
                int n8 = byArray[n2++] & 0xFF;
                sArray[n6] = (short)((n8 << 8) + n7);
                ++n6;
            }
        }
    }

    private void interpretBytesAsInts(byte[] byArray, int[] nArray, int n) {
        int n2 = 0;
        if (this.isBigEndian) {
            int n3 = 0;
            while (n3 < n) {
                nArray[n3] = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n) {
                nArray[n4] = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
                ++n4;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private byte[] decodePackbits(byte[] var1_1, int var2_2, byte[] var3_3) {
        if (var3_3 == null) {
            var3_3 = new byte[var2_2];
        }
        var4_4 = 0;
        var5_5 = 0;
lbl5:
        // 3 sources

        try {
            while (var5_5 < var2_2) {
                block7: {
                    block6: {
                        if ((var7_7 = var1_1[var4_4++]) < 0 || var7_7 > 127) break block6;
                        var8_8 = 0;
                        while (var8_8 < var7_7 + 1) {
                            var3_3[var5_5++] = var1_1[var4_4++];
                            ++var8_8;
                        }
                        ** GOTO lbl5
                    }
                    if (var7_7 > -1 || var7_7 < -127) break block7;
                    var6_6 = var1_1[var4_4++];
                    var8_8 = 0;
                    while (var8_8 < -var7_7 + 1) {
                        var3_3[var5_5++] = var6_6;
                        ++var8_8;
                    }
                    ** GOTO lbl5
                }
                ++var4_4;
            }
        }
        catch (ArrayIndexOutOfBoundsException var8_9) {
            throw new RuntimeException("TIFFImage14");
        }
        return var3_3;
    }

    private ComponentColorModel createAlphaComponentColorModel(int n, int n2, boolean bl, int n3) {
        ComponentColorModel componentColorModel = null;
        int[] nArray = null;
        ColorSpace colorSpace = null;
        switch (n2) {
            case 2: {
                colorSpace = ColorSpace.getInstance(1003);
                break;
            }
            case 4: {
                colorSpace = ColorSpace.getInstance(1000);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int n4 = 0;
        switch (n) {
            case 0: {
                n4 = 8;
                break;
            }
            case 1: 
            case 2: {
                n4 = 16;
                break;
            }
            case 3: {
                n4 = 32;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        nArray = new int[n2];
        int n5 = 0;
        while (n5 < n2) {
            nArray[n5] = n4;
            ++n5;
        }
        componentColorModel = new ComponentColorModel(colorSpace, nArray, true, bl, n3, n);
        return componentColorModel;
    }
}

