/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.CompositeContext;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.batik.ext.awt.image.CompositeRule;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.SVGComposite;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.AbstractTiledRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.PadRed;

public class CompositeRed
extends AbstractRed {
    CompositeRule rule;
    CompositeContext[] contexts;

    public CompositeRed(List object, CompositeRule compositeRule) {
        Object object2;
        Object object3;
        CachableRed cachableRed = (CachableRed)object.get(0);
        ColorModel colorModel = CompositeRed.fixColorModel(cachableRed);
        this.rule = compositeRule;
        SVGComposite sVGComposite = new SVGComposite(compositeRule);
        this.contexts = new CompositeContext[object.size()];
        int n = 0;
        Iterator iterator = object.iterator();
        Object object4 = null;
        while (iterator.hasNext()) {
            object3 = (CachableRed)iterator.next();
            this.contexts[n++] = sVGComposite.createContext(object3.getColorModel(), colorModel, null);
            object2 = object3.getBounds();
            if (object4 == null) {
                object4 = object2;
                continue;
            }
            switch (compositeRule.getRule()) {
                case 2: {
                    if (((Rectangle)object4).intersects((Rectangle)object2)) {
                        object4 = ((Rectangle)object4).intersection((Rectangle)object2);
                        break;
                    }
                    ((Rectangle)object4).width = 0;
                    ((Rectangle)object4).height = 0;
                    break;
                }
                case 3: {
                    object4 = object2;
                    break;
                }
                default: {
                    object4 = ((Rectangle)object4).union((Rectangle)object2);
                }
            }
        }
        if (object4 == null) {
            throw new IllegalArgumentException("Composite Operation Must have some source!");
        }
        if (compositeRule.getRule() == 6) {
            object3 = new Vector();
            iterator = object.iterator();
            while (iterator.hasNext()) {
                object2 = (CachableRed)iterator.next();
                Rectangle rectangle = object2.getBounds();
                if (rectangle.x != ((Rectangle)object4).x || rectangle.y != ((Rectangle)object4).y || rectangle.width != ((Rectangle)object4).width || rectangle.height != ((Rectangle)object4).height) {
                    object2 = new PadRed((CachableRed)object2, (Rectangle)object4, PadMode.ZERO_PAD, null);
                }
                ((Vector)object3).add(object2);
            }
            object = object3;
        }
        object3 = CompositeRed.fixSampleModel(cachableRed, colorModel, object4);
        int n2 = AbstractTiledRed.getDefaultTileSize();
        int n3 = n2 * (int)Math.floor(((Rectangle)object4).x / n2);
        int n4 = n2 * (int)Math.floor(((Rectangle)object4).y / n2);
        this.init((List)object, (Rectangle)object4, colorModel, (SampleModel)object3, n3, n4, null);
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        this.genRect(writableRaster);
        return writableRaster;
    }

    public Raster getTile(int n, int n2) {
        int n3 = this.tileGridXOff + n * this.tileWidth;
        int n4 = this.tileGridYOff + n2 * this.tileHeight;
        Point point = new Point(n3, n4);
        WritableRaster writableRaster = Raster.createWritableRaster(this.sm, point);
        this.genRect(writableRaster);
        return writableRaster;
    }

    public void emptyRect(WritableRaster writableRaster) {
        PadRed.ZeroRecter zeroRecter = PadRed.ZeroRecter.getZeroRecter(writableRaster);
        zeroRecter.zeroRect(new Rectangle(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight()));
    }

    public void genRect(WritableRaster writableRaster) {
        Rectangle rectangle = writableRaster.getBounds();
        int n = 0;
        Iterator iterator = this.srcs.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Rectangle rectangle2;
            CachableRed cachableRed = (CachableRed)iterator.next();
            if (bl) {
                rectangle2 = cachableRed.getBounds();
                if (rectangle.x < rectangle2.x || rectangle.y < rectangle2.y || rectangle.x + rectangle.width > rectangle2.x + rectangle2.width || rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
                    this.emptyRect(writableRaster);
                }
                cachableRed.copyData(writableRaster);
                if (!cachableRed.getColorModel().isAlphaPremultiplied()) {
                    GraphicsUtil.coerceData(writableRaster, cachableRed.getColorModel(), true);
                }
                bl = false;
            } else {
                rectangle2 = cachableRed.getBounds();
                if (rectangle2.intersects(rectangle)) {
                    Rectangle rectangle3 = rectangle2.intersection(rectangle);
                    Raster raster = cachableRed.getData(rectangle3);
                    WritableRaster writableRaster2 = writableRaster.createWritableChild(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, rectangle3.x, rectangle3.y, null);
                    this.contexts[n].compose(raster, writableRaster2, writableRaster2);
                }
            }
            ++n;
        }
    }

    public void genRect_OVER(WritableRaster writableRaster) {
        Rectangle rectangle = writableRaster.getBounds();
        ColorModel colorModel = this.getColorModel();
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster.createWritableTranslatedChild(0, 0), colorModel.isAlphaPremultiplied(), null);
        Graphics2D graphics2D = GraphicsUtil.createGraphics(bufferedImage);
        graphics2D.translate(-rectangle.x, -rectangle.y);
        Iterator iterator = this.srcs.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            CachableRed cachableRed = (CachableRed)iterator.next();
            if (bl) {
                Rectangle rectangle2 = cachableRed.getBounds();
                if (rectangle.x < rectangle2.x || rectangle.y < rectangle2.y || rectangle.x + rectangle.width > rectangle2.x + rectangle2.width || rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
                    this.emptyRect(writableRaster);
                }
                cachableRed.copyData(writableRaster);
                GraphicsUtil.coerceData(writableRaster, cachableRed.getColorModel(), colorModel.isAlphaPremultiplied());
                bl = false;
                continue;
            }
            GraphicsUtil.drawImage(graphics2D, cachableRed);
        }
    }

    protected static SampleModel fixSampleModel(CachableRed cachableRed, ColorModel colorModel, Rectangle rectangle) {
        int n;
        int n2 = AbstractTiledRed.getDefaultTileSize();
        int n3 = n2 * (int)Math.floor(rectangle.x / n2);
        int n4 = n2 * (int)Math.floor(rectangle.y / n2);
        int n5 = rectangle.x + rectangle.width - n3;
        int n6 = rectangle.y + rectangle.height - n4;
        SampleModel sampleModel = cachableRed.getSampleModel();
        int n7 = sampleModel.getWidth();
        if (n7 < n2) {
            n7 = n2;
        }
        if (n7 > n5) {
            n7 = n5;
        }
        if ((n = sampleModel.getHeight()) < n2) {
            n = n2;
        }
        if (n > n6) {
            n = n6;
        }
        if (n7 <= 0 || n <= 0) {
            n7 = 1;
            n = 1;
        }
        return colorModel.createCompatibleSampleModel(n7, n);
    }

    protected static ColorModel fixColorModel(CachableRed cachableRed) {
        ColorModel colorModel = cachableRed.getColorModel();
        if (colorModel.hasAlpha()) {
            if (!colorModel.isAlphaPremultiplied()) {
                colorModel = GraphicsUtil.coerceColorModel(colorModel, true);
            }
            return colorModel;
        }
        int n = cachableRed.getSampleModel().getNumBands() + 1;
        if (n > 4) {
            throw new IllegalArgumentException("CompositeRed can only handle up to three band images");
        }
        int[] nArray = new int[4];
        int n2 = 0;
        while (n2 < n - 1) {
            nArray[n2] = 0xFF0000 >> 8 * n2;
            ++n2;
        }
        nArray[3] = 255 << 8 * (n - 1);
        ColorSpace colorSpace = colorModel.getColorSpace();
        return new DirectColorModel(colorSpace, 8 * n, nArray[0], nArray[1], nArray[2], nArray[3], true, 3);
    }
}

