/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font;

import java.io.FileOutputStream;
import java.io.PrintStream;
import org.apache.batik.svggen.font.Font;
import org.apache.batik.svggen.font.Glyph;
import org.apache.batik.svggen.font.Messages;
import org.apache.batik.svggen.font.Point;
import org.apache.batik.svggen.font.table.CmapFormat;
import org.apache.batik.svggen.font.table.Feature;
import org.apache.batik.svggen.font.table.FeatureTags;
import org.apache.batik.svggen.font.table.GsubTable;
import org.apache.batik.svggen.font.table.KernSubtable;
import org.apache.batik.svggen.font.table.KernTable;
import org.apache.batik.svggen.font.table.KerningPair;
import org.apache.batik.svggen.font.table.LangSys;
import org.apache.batik.svggen.font.table.PostTable;
import org.apache.batik.svggen.font.table.Script;
import org.apache.batik.svggen.font.table.ScriptTags;
import org.apache.batik.svggen.font.table.SingleSubst;
import org.apache.batik.util.SVGConstants;
import org.apache.batik.util.XMLConstants;

public class SVGFont
implements XMLConstants,
SVGConstants,
ScriptTags,
FeatureTags {
    static final String EOL;
    static final String PROPERTY_LINE_SEPARATOR = "line.separator";
    static final String PROPERTY_LINE_SEPARATOR_DEFAULT = "\n";
    private static String QUOT_EOL;
    private static String CONFIG_USAGE;
    private static String CONFIG_SVG_BEGIN;
    private static String CONFIG_SVG_TEST_CARD_START;
    private static String CONFIG_SVG_TEST_CARD_END;
    public static final char ARG_KEY_START_CHAR = '-';
    public static final String ARG_KEY_CHAR_RANGE_LOW = "-l";
    public static final String ARG_KEY_CHAR_RANGE_HIGH = "-h";
    public static final String ARG_KEY_ID = "-id";
    public static final String ARG_KEY_ASCII = "-ascii";
    public static final String ARG_KEY_TESTCARD = "-testcard";
    public static final String ARG_KEY_OUTPUT_PATH = "-o";

    protected static String encodeEntities(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '<') {
                stringBuffer.append("&lt;");
            } else if (string.charAt(n) == '>') {
                stringBuffer.append("&gt;");
            } else if (string.charAt(n) == '&') {
                stringBuffer.append("&amp;");
            } else if (string.charAt(n) == '\'') {
                stringBuffer.append("&apos;");
            } else if (string.charAt(n) == '\"') {
                stringBuffer.append("&quot;");
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected static String getContourAsSVGPathData(Glyph glyph, int n, int n2) {
        if (glyph.getPoint((int)n).endOfContour) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2) {
            Point point = glyph.getPoint(n + n3 % n2);
            Point point2 = glyph.getPoint(n + (n3 + 1) % n2);
            Point point3 = glyph.getPoint(n + (n3 + 2) % n2);
            if (n3 == 0) {
                stringBuffer.append("M").append(String.valueOf(point.x)).append(" ").append(String.valueOf(point.y));
            }
            if (point.onCurve && point2.onCurve) {
                if (point2.x == point.x) {
                    stringBuffer.append("V").append(String.valueOf(point2.y));
                } else if (point2.y == point.y) {
                    stringBuffer.append("H").append(String.valueOf(point2.x));
                } else {
                    stringBuffer.append("L").append(String.valueOf(point2.x)).append(" ").append(String.valueOf(point2.y));
                }
                ++n3;
                continue;
            }
            if (point.onCurve && !point2.onCurve && point3.onCurve) {
                stringBuffer.append("Q").append(String.valueOf(point2.x)).append(" ").append(String.valueOf(point2.y)).append(" ").append(String.valueOf(point3.x)).append(" ").append(String.valueOf(point3.y));
                n3 += 2;
                continue;
            }
            if (point.onCurve && !point2.onCurve && !point3.onCurve) {
                stringBuffer.append("Q").append(String.valueOf(point2.x)).append(" ").append(String.valueOf(point2.y)).append(" ").append(String.valueOf(SVGFont.midValue(point2.x, point3.x))).append(" ").append(String.valueOf(SVGFont.midValue(point2.y, point3.y)));
                n3 += 2;
                continue;
            }
            if (!point.onCurve && !point2.onCurve) {
                stringBuffer.append("T").append(String.valueOf(SVGFont.midValue(point.x, point2.x))).append(" ").append(String.valueOf(SVGFont.midValue(point.y, point2.y)));
                ++n3;
                continue;
            }
            if (!point.onCurve && point2.onCurve) {
                stringBuffer.append("T").append(String.valueOf(point2.x)).append(" ").append(String.valueOf(point2.y));
                ++n3;
                continue;
            }
            System.out.println("drawGlyph case not catered for!!");
            break;
        }
        stringBuffer.append("Z");
        return stringBuffer.toString();
    }

    protected static String getSVGFontFaceElement(Font font) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = font.getNameTable().getRecord((short)1);
        short s = font.getHeadTable().getUnitsPerEm();
        String string2 = font.getOS2Table().getPanose().toString();
        short s2 = font.getHheaTable().getAscender();
        short s3 = font.getHheaTable().getDescender();
        int n = 0;
        stringBuffer.append("<").append("font-face").append(EOL).append("    ").append("font-family").append("=\"").append(string).append(QUOT_EOL).append("    ").append("units-per-em").append("=\"").append(s).append(QUOT_EOL).append("    ").append("panose-1").append("=\"").append(string2).append(QUOT_EOL).append("    ").append("ascent").append("=\"").append(s2).append(QUOT_EOL).append("    ").append("descent").append("=\"").append(s3).append(QUOT_EOL).append("    ").append("alphabetic").append("=\"").append(n).append('\"').append(" />").append(EOL);
        return stringBuffer.toString();
    }

    protected static void writeFontAsSVGFragment(PrintStream printStream, Font font, String string, int n, int n2, boolean bl) throws Exception {
        Object object;
        Object object2;
        LangSys langSys;
        Script script;
        short s = font.getOS2Table().getAvgCharWidth();
        printStream.print("<");
        printStream.print("font");
        printStream.print(" ");
        if (string != null) {
            printStream.print("id");
            printStream.print("=\"");
            printStream.print(string);
            printStream.print('\"');
            printStream.print(" ");
        }
        printStream.print("horiz-adv-x");
        printStream.print("=\"");
        printStream.print(s);
        printStream.print('\"');
        printStream.print(" >");
        printStream.print(SVGFont.getSVGFontFaceElement(font));
        CmapFormat cmapFormat = null;
        if (bl) {
            cmapFormat = font.getCmapTable().getCmapFormat((short)1, (short)0);
        } else {
            cmapFormat = font.getCmapTable().getCmapFormat((short)3, (short)1);
            if (cmapFormat == null) {
                cmapFormat = font.getCmapTable().getCmapFormat((short)3, (short)0);
            }
        }
        if (cmapFormat == null) {
            throw new Exception("Cannot find a suitable cmap table");
        }
        GsubTable gsubTable = (GsubTable)font.getTable(1196643650);
        SingleSubst singleSubst = null;
        SingleSubst singleSubst2 = null;
        SingleSubst singleSubst3 = null;
        if (gsubTable != null && (script = gsubTable.getScriptList().findScript("arab")) != null && (langSys = script.getDefaultLangSys()) != null) {
            object2 = gsubTable.getFeatureList().findFeature(langSys, "init");
            object = gsubTable.getFeatureList().findFeature(langSys, "medi");
            Feature feature = gsubTable.getFeatureList().findFeature(langSys, "fina");
            singleSubst = (SingleSubst)gsubTable.getLookupList().getLookup((Feature)object2, 0).getSubtable(0);
            singleSubst2 = (SingleSubst)gsubTable.getLookupList().getLookup((Feature)object, 0).getSubtable(0);
            singleSubst3 = (SingleSubst)gsubTable.getLookupList().getLookup(feature, 0).getSubtable(0);
        }
        printStream.println(SVGFont.getGlyphAsSVG(font, font.getGlyph(0), 0, s, singleSubst, singleSubst2, singleSubst3, ""));
        try {
            int n3 = n;
            while (n3 <= n2) {
                int n4 = cmapFormat.mapCharCode(n3);
                if (n4 > 0) {
                    printStream.println(SVGFont.getGlyphAsSVG(font, font.getGlyph(n4), n4, s, singleSubst, singleSubst2, singleSubst3, 32 <= n3 && n3 <= 127 ? SVGFont.encodeEntities("" + (char)n3) : "&#x" + Integer.toHexString(n3) + ";"));
                }
                ++n3;
            }
            KernTable kernTable = (KernTable)font.getTable(1801810542);
            if (kernTable != null) {
                object2 = kernTable.getSubtable(0);
                object = (PostTable)font.getTable(1886352244);
                int n5 = 0;
                while (n5 < ((KernSubtable)object2).getKerningPairCount()) {
                    printStream.println(SVGFont.getKerningPairAsSVG(((KernSubtable)object2).getKerningPair(n5), (PostTable)object));
                    ++n5;
                }
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        printStream.print("</");
        printStream.print("font");
        printStream.println(">");
    }

    protected static String getGlyphAsSVG(Font font, Glyph glyph, int n, int n2, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = 0;
        int n5 = font.getHmtxTable().getAdvanceWidth(n);
        if (n == 0) {
            stringBuffer.append("<");
            stringBuffer.append("missing-glyph");
        } else {
            stringBuffer.append("<").append("glyph").append(" ").append("unicode").append("=\"").append(string2).append('\"');
            stringBuffer.append(" ").append("glyph-name").append("=\"").append(font.getPostTable().getGlyphName(n)).append('\"');
        }
        if (n5 != n2) {
            stringBuffer.append(" ").append("horiz-adv-x").append("=\"").append(n5).append('\"');
        }
        if (string != null) {
            stringBuffer.append(string);
        }
        if (glyph != null) {
            stringBuffer.append(" ").append("d").append("=\"");
            int n6 = 0;
            while (n6 < glyph.getPointCount()) {
                ++n4;
                if (glyph.getPoint((int)n6).endOfContour) {
                    stringBuffer.append(SVGFont.getContourAsSVGPathData(glyph, n3, n4));
                    n3 = n6 + 1;
                    n4 = 0;
                }
                ++n6;
            }
            stringBuffer.append('\"');
        }
        stringBuffer.append(" />");
        SVGFont.chopUpStringBuffer(stringBuffer);
        return stringBuffer.toString();
    }

    protected static String getGlyphAsSVG(Font font, Glyph glyph, int n, int n2, SingleSubst singleSubst, SingleSubst singleSubst2, SingleSubst singleSubst3, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n3 = n;
        int n4 = n;
        int n5 = n;
        if (singleSubst != null) {
            n3 = singleSubst.substitute(n);
        }
        if (singleSubst2 != null) {
            n4 = singleSubst2.substitute(n);
        }
        if (singleSubst3 != null) {
            n5 = singleSubst3.substitute(n);
        }
        if (n3 != n) {
            stringBuffer.append(SVGFont.getGlyphAsSVG(font, font.getGlyph(n3), n3, n2, "arabic-form=\"initial\"", string));
            stringBuffer.append(EOL);
            bl = true;
        }
        if (n4 != n) {
            stringBuffer.append(SVGFont.getGlyphAsSVG(font, font.getGlyph(n4), n4, n2, "arabic-form=\"medial\"", string));
            stringBuffer.append(EOL);
            bl = true;
        }
        if (n5 != n) {
            stringBuffer.append(SVGFont.getGlyphAsSVG(font, font.getGlyph(n5), n5, n2, "arabic-form=\"terminal\"", string));
            stringBuffer.append(EOL);
            bl = true;
        }
        if (bl) {
            stringBuffer.append(SVGFont.getGlyphAsSVG(font, glyph, n, n2, "arabic-form=\"isolated\"", string));
        } else {
            stringBuffer.append(SVGFont.getGlyphAsSVG(font, glyph, n, n2, null, string));
        }
        return stringBuffer.toString();
    }

    protected static String getKerningPairAsSVG(KerningPair kerningPair, PostTable postTable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<").append("hkern").append(" ");
        stringBuffer.append("g1").append("=\"");
        stringBuffer.append(postTable.getGlyphName(kerningPair.getLeft()));
        stringBuffer.append('\"').append(" ").append("g2").append("=\"");
        stringBuffer.append(postTable.getGlyphName(kerningPair.getRight()));
        stringBuffer.append('\"').append(" ").append("k").append("=\"");
        stringBuffer.append(-kerningPair.getValue());
        stringBuffer.append('\"').append(" />");
        return stringBuffer.toString();
    }

    protected static void writeSvgBegin(PrintStream printStream) {
        printStream.println(Messages.formatMessage(CONFIG_SVG_BEGIN, new Object[]{"-//W3C//DTD SVG 1.0//EN", "http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd"}));
    }

    protected static void writeSvgDefsBegin(PrintStream printStream) {
        printStream.println("<defs >");
    }

    protected static void writeSvgDefsEnd(PrintStream printStream) {
        printStream.println("</defs>");
    }

    protected static void writeSvgEnd(PrintStream printStream) {
        printStream.println("</svg>");
    }

    protected static void writeSvgTestCard(PrintStream printStream, String string) {
        printStream.println(Messages.formatMessage(CONFIG_SVG_TEST_CARD_START, null));
        printStream.println(string);
        printStream.println(Messages.formatMessage(CONFIG_SVG_TEST_CARD_END, null));
    }

    public static void main(String[] stringArray) {
        block6: {
            try {
                String string = SVGFont.parseArgs(stringArray, null);
                String string2 = SVGFont.parseArgs(stringArray, ARG_KEY_CHAR_RANGE_LOW);
                String string3 = SVGFont.parseArgs(stringArray, ARG_KEY_CHAR_RANGE_HIGH);
                String string4 = SVGFont.parseArgs(stringArray, ARG_KEY_ID);
                String string5 = SVGFont.parseArgs(stringArray, ARG_KEY_ASCII);
                String string6 = SVGFont.parseArgs(stringArray, ARG_KEY_TESTCARD);
                String string7 = SVGFont.parseArgs(stringArray, ARG_KEY_OUTPUT_PATH);
                PrintStream printStream = null;
                FileOutputStream fileOutputStream = null;
                if (string7 != null) {
                    fileOutputStream = new FileOutputStream(string7);
                    printStream = new PrintStream(fileOutputStream);
                } else {
                    printStream = System.out;
                }
                if (string != null) {
                    Font font = Font.create(string);
                    SVGFont.writeSvgBegin(printStream);
                    SVGFont.writeSvgDefsBegin(printStream);
                    SVGFont.writeFontAsSVGFragment(printStream, font, string4, string2 != null ? Integer.parseInt(string2) : 32, string3 != null ? Integer.parseInt(string3) : 127, string5 != null);
                    SVGFont.writeSvgDefsEnd(printStream);
                    if (string6 != null) {
                        String string8 = font.getNameTable().getRecord((short)1);
                        SVGFont.writeSvgTestCard(printStream, string8);
                    }
                    SVGFont.writeSvgEnd(printStream);
                    if (fileOutputStream == null) break block6;
                    fileOutputStream.close();
                    break block6;
                }
                SVGFont.usage();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println(exception.getMessage());
                SVGFont.usage();
            }
        }
    }

    private static void chopUpStringBuffer(StringBuffer stringBuffer) {
        if (stringBuffer.length() < 256) {
            return;
        }
        int n = 240;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == ' ') {
                stringBuffer.setCharAt(n, '\n');
                n += 240;
            }
            ++n;
        }
    }

    private static int midValue(int n, int n2) {
        return n + (n2 - n) / 2;
    }

    private static String parseArgs(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (string == null) {
                if (stringArray[n].charAt(0) != '-') {
                    return stringArray[n];
                }
            } else if (string.equalsIgnoreCase(stringArray[n])) {
                if (n < stringArray.length - 1 && stringArray[n + 1].charAt(0) != '-') {
                    return stringArray[n + 1];
                }
                return stringArray[n];
            }
            ++n;
        }
        return null;
    }

    private static void usage() {
        System.err.println(Messages.formatMessage(CONFIG_USAGE, null));
    }

    static {
        String string;
        try {
            string = System.getProperty(PROPERTY_LINE_SEPARATOR, PROPERTY_LINE_SEPARATOR_DEFAULT);
        }
        catch (SecurityException securityException) {
            string = PROPERTY_LINE_SEPARATOR_DEFAULT;
        }
        EOL = string;
        QUOT_EOL = '\"' + EOL;
        CONFIG_USAGE = "SVGFont.config.usage";
        CONFIG_SVG_BEGIN = "SVGFont.config.svg.begin";
        CONFIG_SVG_TEST_CARD_START = "SVGFont.config.svg.test.card.start";
        CONFIG_SVG_TEST_CARD_END = "SVGFont.config.svg.test.card.end";
    }
}

