/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.gui.resource;

import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.JComponentModifier;
import org.apache.batik.util.gui.resource.JToolbarButton;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.gui.resource.ResourceFormatException;
import org.apache.batik.util.gui.resource.ResourceManager;

public class ButtonFactory
extends ResourceManager {
    private static final String ICON_SUFFIX = ".icon";
    private static final String TEXT_SUFFIX = ".text";
    private static final String MNEMONIC_SUFFIX = ".mnemonic";
    private static final String ACTION_SUFFIX = ".action";
    private static final String SELECTED_SUFFIX = ".selected";
    private static final String TOOLTIP_SUFFIX = ".tooltip";
    private ActionMap actions;

    public ButtonFactory(ResourceBundle resourceBundle, ActionMap actionMap) {
        super(resourceBundle);
        this.actions = actionMap;
    }

    public JButton createJButton(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JButton jButton;
        try {
            jButton = new JButton(this.getString(string + TEXT_SUFFIX));
        }
        catch (MissingResourceException missingResourceException) {
            jButton = new JButton();
        }
        this.initializeButton(jButton, string);
        return jButton;
    }

    public JButton createJToolbarButton(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JToolbarButton jToolbarButton;
        try {
            jToolbarButton = new JToolbarButton(this.getString(string + TEXT_SUFFIX));
        }
        catch (MissingResourceException missingResourceException) {
            jToolbarButton = new JToolbarButton();
        }
        this.initializeButton(jToolbarButton, string);
        return jToolbarButton;
    }

    public JRadioButton createJRadioButton(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JRadioButton jRadioButton = new JRadioButton(this.getString(string + TEXT_SUFFIX));
        this.initializeButton(jRadioButton, string);
        try {
            jRadioButton.setSelected(this.getBoolean(string + SELECTED_SUFFIX));
        }
        catch (MissingResourceException missingResourceException) {}
        return jRadioButton;
    }

    public JCheckBox createJCheckBox(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JCheckBox jCheckBox = new JCheckBox(this.getString(string + TEXT_SUFFIX));
        this.initializeButton(jCheckBox, string);
        try {
            jCheckBox.setSelected(this.getBoolean(string + SELECTED_SUFFIX));
        }
        catch (MissingResourceException missingResourceException) {}
        return jCheckBox;
    }

    private void initializeButton(AbstractButton abstractButton, String string) throws ResourceFormatException, MissingListenerException {
        Object object;
        try {
            object = this.actions.getAction(this.getString(string + ACTION_SUFFIX));
            if (object == null) {
                throw new MissingListenerException("", "Action", string + ACTION_SUFFIX);
            }
            abstractButton.setAction((Action)object);
            abstractButton.setText(this.getString(string + TEXT_SUFFIX));
            if (object instanceof JComponentModifier) {
                ((JComponentModifier)object).addJComponent(abstractButton);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            object = this.getString(string + ICON_SUFFIX);
            URL uRL = this.actions.getClass().getResource((String)object);
            if (uRL != null) {
                abstractButton.setIcon(new ImageIcon(uRL));
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            object = this.getString(string + MNEMONIC_SUFFIX);
            if (((String)object).length() != 1) {
                throw new ResourceFormatException("Malformed mnemonic", this.bundle.getClass().getName(), string + MNEMONIC_SUFFIX);
            }
            abstractButton.setMnemonic(((String)object).charAt(0));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            object = this.getString(string + TOOLTIP_SUFFIX);
            if (object != null) {
                abstractButton.setToolTipText((String)object);
            }
        }
        catch (MissingResourceException missingResourceException) {}
    }
}

