/*
 * Decompiled with CFR 0.152.
 */
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmleditapp.dialog.PreferencesSheetPane;
import com.xmlmind.xmleditapp.kit.AppPart;
import com.xmlmind.xmleditapp.kit.AppPreferencesSheet;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class CountWordsOptions
extends AppPreferencesSheet {
    private SpinnerNumberModel countedWordMinCharsModel;
    private JSpinner countedWordMinChars;

    public CountWordsOptions() {
        super("countWords", "Count Words");
    }

    protected PreferencesSheetPane createPane() {
        PreferencesSheetPane preferencesSheetPane = new PreferencesSheetPane((LayoutManager)new FlowLayout(0, 5, 2));
        JLabel jLabel = new JLabel("Do not count words having less than");
        preferencesSheetPane.add((Component)jLabel);
        this.countedWordMinCharsModel = new SpinnerNumberModel(1, 1, 1000, 1);
        this.countedWordMinChars = new JSpinner(this.countedWordMinCharsModel);
        preferencesSheetPane.add((Component)this.countedWordMinChars);
        jLabel = new JLabel("characters");
        preferencesSheetPane.add((Component)jLabel);
        return preferencesSheetPane;
    }

    public void focusPane() {
        this.countedWordMinChars.requestFocus();
    }

    public void fillPane(Preferences preferences) {
        int n = preferences.getInt("countedWordMinChars", 1, 1000, 1);
        this.countedWordMinCharsModel.setValue(new Integer(n));
    }

    public boolean validatePane(Preferences preferences) {
        int n = this.countedWordMinCharsModel.getNumber().intValue();
        preferences.putInt("countedWordMinChars", n);
        return true;
    }

    public void applyPreferences(Preferences preferences) {
        AppPart appPart = this.app.getPart("countWordsTool");
        if (appPart != null) {
            appPart.applyPreferences();
        }
    }
}

