/*
 * Decompiled with CFR 0.152.
 */
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.guiutil.ThinBorder;
import com.xmlmind.xmledit.search.ElementCharSequence;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.AppTool;
import com.xmlmind.xmleditapp.kit.OpenedDocument;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;

public class CountWordsTool
extends JPanel
implements AppTool {
    private String helpId;
    private App app;
    private String id;
    private JToggleButton toggle;
    private JTextField field;
    private Color needUpdateColor;
    private Color upToDateColor;
    private boolean activated;
    private int minCharCount;
    private static final String WORD_COUNT_PROPERTY = "CountWordsTool.WordCount";
    static /* synthetic */ Class class$CountWordsTool;

    public CountWordsTool() {
        this.setLayout(new FlowLayout(0, 2, 0));
        this.toggle = new JToggleButton(new ImageIcon((class$CountWordsTool == null ? (class$CountWordsTool = CountWordsTool.class$("CountWordsTool")) : class$CountWordsTool).getResource("custom_parts_icons/wordCountTool.gif")));
        DialogUtil.setIconic((AbstractButton)this.toggle);
        this.toggle.setToolTipText("Turns word counting on and off");
        this.toggle.setFocusable(false);
        this.add(this.toggle);
        this.toggle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CountWordsTool.this.activated = CountWordsTool.this.toggle.isSelected();
                CountWordsTool.this.activationChanged();
            }
        });
        this.field = new JTextField(10);
        this.field.setEditable(false);
        this.field.setFont(new Font("SansSerif", 0, 10));
        Color color = this.field.getBackground();
        this.field.setBorder((Border)new ThinBorder(color, false));
        this.field.setToolTipText("Word count (click on it to update it)");
        this.field.setFocusable(false);
        this.add(this.field);
        this.needUpdateColor = color.darker();
        this.upToDateColor = this.field.getForeground();
        this.field.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (!CountWordsTool.this.activated) {
                    return;
                }
                OpenedDocument openedDocument = CountWordsTool.this.app.getActiveOpenedDocument();
                if (openedDocument != null) {
                    CountWordsTool.this.updateWordCount(openedDocument);
                }
            }
        });
    }

    private void activationChanged() {
        WordCount wordCount = null;
        OpenedDocument[] openedDocumentArray = this.app.getOpenedDocuments();
        int n = 0;
        while (n < openedDocumentArray.length) {
            if (!this.activated) {
                openedDocumentArray[n].removeProperty((Object)WORD_COUNT_PROPERTY);
            } else {
                wordCount = new WordCount();
                openedDocumentArray[n].putProperty((Object)WORD_COUNT_PROPERTY, (Object)wordCount);
            }
            ++n;
        }
        this.updateField(wordCount);
    }

    private void updateField(WordCount wordCount) {
        if (!this.activated || wordCount == null) {
            this.field.setText("");
        } else {
            this.field.setText(NumberFormat.getIntegerInstance().format(wordCount.wordCount));
            this.field.setForeground(wordCount.needUpdate ? this.needUpdateColor : this.upToDateColor);
        }
    }

    private void updateWordCount(OpenedDocument openedDocument) {
        WordCount wordCount = (WordCount)openedDocument.getProperty((Object)WORD_COUNT_PROPERTY);
        wordCount.wordCount = this.countWords(openedDocument.getDocument());
        wordCount.needUpdate = false;
        this.updateField(wordCount);
    }

    private int countWords(Document document) {
        ElementCharSequence elementCharSequence = new ElementCharSequence(document.getRootElement());
        int n = 0;
        int n2 = -1;
        int n3 = elementCharSequence.length();
        int n4 = 0;
        while (n4 < n3) {
            boolean bl;
            char c = elementCharSequence.charAt(n4);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case ' ': {
                    bl = true;
                    break;
                }
                default: {
                    bl = Character.isSpaceChar(c);
                }
            }
            if (bl) {
                if (n2 >= 0) {
                    if (n4 - n2 >= this.minCharCount) {
                        ++n;
                    }
                    n2 = -1;
                }
            } else if (n2 < 0) {
                n2 = n4;
            }
            ++n4;
        }
        if (n2 >= 0 && n3 - n2 >= this.minCharCount) {
            ++n;
        }
        return n;
    }

    public void setHelpId(String string) {
        this.helpId = string;
    }

    public String getHelpId() {
        return this.helpId;
    }

    public void initApp(App app, String string) {
        this.app = app;
        this.id = string;
    }

    public App getApp() {
        return this.app;
    }

    public String getId() {
        return this.id;
    }

    public void applyPreferences() {
        Preferences preferences = this.app.getPreferences();
        this.activated = preferences.getBoolean("countWords", false);
        this.minCharCount = preferences.getInt("countedWordMinChars", 1, 1000, 1);
        this.toggle.setSelected(this.activated);
        this.activationChanged();
    }

    public void flushPreferences() {
        Preferences preferences = this.app.getPreferences();
        preferences.putBoolean("countWords", this.toggle.isSelected());
        preferences.putInt("countedWordMinChars", this.minCharCount);
    }

    public void activeEditorChanged() {
        if (!this.activated) {
            return;
        }
        WordCount wordCount = null;
        OpenedDocument openedDocument = this.app.getActiveOpenedDocument();
        if (openedDocument != null && (wordCount = (WordCount)openedDocument.getProperty((Object)WORD_COUNT_PROPERTY)) == null) {
            wordCount = new WordCount();
            openedDocument.putProperty((Object)WORD_COUNT_PROPERTY, (Object)wordCount);
        }
        this.updateField(wordCount);
    }

    public void saveStateChanged() {
        if (!this.activated) {
            return;
        }
        OpenedDocument openedDocument = this.app.getActiveOpenedDocument();
        if (openedDocument.isSaveNeeded()) {
            WordCount wordCount = (WordCount)openedDocument.getProperty((Object)WORD_COUNT_PROPERTY);
            wordCount.needUpdate = true;
            this.updateField(wordCount);
        } else {
            this.updateWordCount(openedDocument);
        }
    }

    public void namespacePrefixesChanged() {
    }

    public void validityStateChanged() {
    }

    public void undoStateChanged() {
    }

    public void editingContextChanged() {
    }

    public boolean isEditingContextSensitive() {
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class WordCount {
        public int wordCount = 0;
        public boolean needUpdate = true;
    }
}

