/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.command;

import com.xmlmind.xmledit.command.CommandUtil;
import com.xmlmind.xmledit.command.Msg;
import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.ElementType;
import com.xmlmind.xmledit.doctype.Field;
import com.xmlmind.xmledit.edit.ElementEditor;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.Name;
import java.util.ArrayList;
import java.util.IdentityHashMap;

public class AddBlockInFlow
extends RecordableCommand {
    protected Name insertName;
    protected Node beforeNode;
    protected Field insertField;
    protected ArrayList list = new ArrayList();
    protected static final String INLINE_NAMES_PROPERTY = "com.xmlmind.xmledit.command.AddBlockInFlow.inlineNames";

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        Object object;
        this.insertName = null;
        this.beforeNode = null;
        this.insertField = null;
        this.list.clear();
        DocumentView documentView = (DocumentView)gadget;
        MarkManager markManager = documentView.getMarkManager();
        if (markManager == null || markManager.getMark() != null || markManager.getSelected2() != null) {
            return false;
        }
        Node node = null;
        NodeMark nodeMark = markManager.getSelected();
        if (nodeMark == null) {
            object = markManager.getDot();
            if (object != null) {
                node = ((TextLocation)object).getTextNode();
            }
        } else {
            node = nodeMark.getNode();
        }
        if (node == null) {
            return false;
        }
        this.insertName = this.parseInsertName(string);
        if (this.insertName == null) {
            return false;
        }
        object = documentView.getDocument();
        DocumentType documentType = (DocumentType)((Document)object).getProperty("DOCUMENT_TYPE");
        if (documentType == null) {
            return false;
        }
        Element element = node.getParentElement();
        while (element != null) {
            if (AddBlockInFlow.canContain(element, this.insertName, documentType)) break;
            node = element;
            element = node.getParentElement();
        }
        if (element == null) {
            return false;
        }
        Name[] nameArray = this.getInlineNames((Document)object, documentType, string);
        this.beforeNode = node.getNextSibling();
        while (this.beforeNode != null) {
            if (this.beforeNode instanceof Element) {
                boolean bl = false;
                Name name = ((Element)this.beforeNode).getName();
                int n3 = 0;
                while (n3 < nameArray.length) {
                    if (name == nameArray[n3]) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl) break;
            }
            node = this.beforeNode;
            this.beforeNode = node.getNextSibling();
        }
        ElementEditor elementEditor = documentView.getElementEditor();
        elementEditor.editElement(element);
        int n4 = elementEditor.canInsert(this.beforeNode, this.list);
        if (n4 == 0) {
            return false;
        }
        this.insertField = CommandUtil.findField(this.list, this.insertName);
        return this.insertField != null;
    }

    protected Name parseInsertName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(32);
        if (n < 0) {
            return null;
        }
        return Name.fromString(string.substring(n + 1));
    }

    protected static final boolean canContain(Element element, Name name, DocumentType documentType) {
        ElementType elementType = documentType.getElementType(element);
        if (elementType == null) {
            return true;
        }
        Field[] fieldArray = elementType.getChildElementFields();
        int n = 0;
        while (n < fieldArray.length) {
            if (name == fieldArray[n].getFieldName()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected Name[] getInlineNames(Document document, DocumentType documentType, String string) {
        Name[] nameArray = (Name[])document.getProperty(INLINE_NAMES_PROPERTY);
        if (nameArray == null) {
            nameArray = this.doGetInlineNames(document, documentType, string);
            if (nameArray == null) {
                nameArray = new Name[]{};
            }
            document.putProperty(INLINE_NAMES_PROPERTY, nameArray);
        }
        return nameArray;
    }

    protected Name[] doGetInlineNames(Document document, DocumentType documentType, String string) {
        int n;
        Name name = null;
        if (string != null && (n = string.indexOf(93)) > 0 && string.charAt(0) == '[') {
            name = Name.fromString(string.substring(1, n));
        }
        if (name == null) {
            return null;
        }
        return AddBlockInFlow.getChildElementNames(documentType, name);
    }

    protected static final Name[] getChildElementNames(DocumentType documentType, Name name) {
        Name[] nameArray = null;
        Document document = new Document();
        Element element = new Element(name);
        element.appendChild(new Text("#text"));
        document.appendChild(element);
        ElementType elementType = documentType.getElementType(element);
        if (elementType != null) {
            IdentityHashMap<Name, Name> identityHashMap = new IdentityHashMap<Name, Name>();
            Field[] fieldArray = elementType.getChildElementFields();
            int n = 0;
            while (n < fieldArray.length) {
                Name name2 = fieldArray[n].getFieldName();
                if (name2 != null) {
                    identityHashMap.put(name2, name2);
                }
                ++n;
            }
            nameArray = new Name[identityHashMap.size()];
            identityHashMap.values().toArray(nameArray);
        }
        return nameArray;
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        ElementEditor elementEditor = documentView.getElementEditor();
        MarkManager markManager = documentView.getMarkManager();
        markManager.beginBatchMarking();
        Element element = elementEditor.insert(this.beforeNode, this.insertField, this.insertName);
        documentView.describeUndo(Msg.msg("ABIF.add", this.insertName.getLocalPart()));
        markManager.remove("MARK");
        markManager.remove("SELECTED2");
        markManager.set("SELECTED", element);
        documentView.moveDotInto(element);
        markManager.endBatchMarking();
        this.insertName = null;
        this.beforeNode = null;
        this.insertField = null;
        this.list.clear();
        return null;
    }
}

