/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.command;

import com.xmlmind.xmledit.command.Msg;
import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.dialog.CheckValidityDialog;
import com.xmlmind.xmledit.dialog.DiagnosticsPane;
import com.xmlmind.xmledit.dialog.DiagnosticsUtil;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doctype.Diagnostic;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.guiutil.ShowStatus;
import com.xmlmind.xmledit.view.DocumentView;

public class CheckValidity
extends RecordableCommand {
    private static boolean dialogHasHelp;
    private DiagnosticsPane diagnosticsPane;

    public static void setDialogHasHelp(boolean bl) {
        dialogHasHelp = bl;
    }

    public static boolean getDialogHasHelp() {
        return dialogHasHelp;
    }

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        DocumentView documentView = (DocumentView)gadget;
        Document document = documentView.getDocument();
        if (document == null) {
            return false;
        }
        return DiagnosticsUtil.canCheckDocument(document);
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        Document document = documentView.getDocument();
        Diagnostic[] diagnosticArray = DiagnosticsUtil.checkDocument(document);
        if (diagnosticArray == null) {
            return null;
        }
        if (diagnosticArray.length == 0) {
            ShowStatus.showStatus(Msg.msg("CV.validDocument"));
            return diagnosticArray;
        }
        if (this.diagnosticsPane == null) {
            this.diagnosticsPane = new DiagnosticsPane();
        }
        CheckValidityDialog checkValidityDialog = new CheckValidityDialog(documentView.getPanel(), Msg.msg("CV.title"), 60, 15, dialogHasHelp, this.diagnosticsPane);
        checkValidityDialog.showDiagnostics(diagnosticArray, documentView, 9);
        return diagnosticArray;
    }
}

