/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.command;

import com.xmlmind.xmledit.dialog.FieldChoice;
import com.xmlmind.xmledit.dialog.FieldChooser;
import com.xmlmind.xmledit.dialog.FieldChooserDialog;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doctype.Field;
import com.xmlmind.xmledit.gadget.Bindings;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.view.DocumentView;
import java.util.ArrayList;

public abstract class ChooseFieldCommand
implements Command {
    private FieldChooser fieldChooser = null;
    protected static final Field[] NO_FIELDS = new Field[0];

    public Object executeCommand(Gadget gadget, String string, int n, int n2) {
        DocumentView documentView = (DocumentView)gadget;
        FieldChoice fieldChoice = this.getPreparedFieldChoice();
        if (fieldChoice == null) {
            FieldChoices fieldChoices = this.getFieldChoices(documentView, string, true, true);
            if (fieldChoices == null) {
                this.resetCommand();
                return Command.EXECUTION_FAILED;
            }
            fieldChoice = this.chooseField(documentView, fieldChoices);
            if (fieldChoice == null) {
                this.resetCommand();
                return Command.EXECUTION_FAILED;
            }
        }
        this.executeCommand(documentView, string, fieldChoice);
        this.resetCommand();
        return null;
    }

    public abstract FieldChoice getPreparedFieldChoice();

    public abstract FieldChoices getFieldChoices(DocumentView var1, String var2, boolean var3, boolean var4);

    public FieldChoice chooseField(DocumentView documentView, FieldChoices fieldChoices) {
        if (this.fieldChooser == null) {
            this.fieldChooser = new FieldChooser();
        }
        FieldChooserDialog fieldChooserDialog = new FieldChooserDialog(documentView.getPanel(), fieldChoices.dialogTitle, this.fieldChooser);
        FieldChoice fieldChoice = fieldChooserDialog.chooseField(fieldChoices.choices, fieldChoices.context);
        this.fieldChooser.removeFieldChooserListener(fieldChooserDialog);
        return fieldChoice;
    }

    public void executeCommand(DocumentView documentView, String string, FieldChoice fieldChoice) {
        int n;
        Object object;
        if (!documentView.hasCommandListeners()) {
            this.doExecuteCommand(documentView, string, fieldChoice);
            return;
        }
        if (!documentView.notifyCommandListeners(this, string, -1, -1, 0, null)) {
            return;
        }
        try {
            this.doExecuteCommand(documentView, string, fieldChoice);
            object = null;
            n = 3;
        }
        catch (Exception exception) {
            Bindings.reportCommandError(exception, this, string);
            object = Command.EXECUTION_FAILED;
            n = 2;
        }
        documentView.notifyCommandListeners(this, string, -1, -1, n, object);
    }

    protected abstract void doExecuteCommand(DocumentView var1, String var2, FieldChoice var3);

    public abstract void resetCommand();

    public String[] makeMenuItems(DocumentView documentView, String string) {
        String[] stringArray;
        FieldChoices fieldChoices = this.getFieldChoices(documentView, string, false, true);
        if (fieldChoices == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        FieldChoice[] fieldChoiceArray = fieldChoices.choices;
        int n = 0;
        if (fieldChoiceArray.length > 0 && fieldChoiceArray[n].text) {
            arrayList.add(fieldChoiceArray[n].label);
            arrayList.add(this.makeParameter(string, fieldChoiceArray[n]));
            ++n;
            if (fieldChoiceArray.length > 1) {
                arrayList.add("");
                arrayList.add("");
            }
        }
        while (n < fieldChoiceArray.length) {
            stringArray = fieldChoiceArray[n];
            arrayList.add(stringArray.label);
            arrayList.add(this.makeParameter(string, (FieldChoice)stringArray));
            ++n;
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    protected abstract String makeParameter(String var1, FieldChoice var2);

    public static final class FieldChoices {
        public String dialogTitle;
        public FieldChoice[] choices;
        public Element context;

        public FieldChoices(String string, FieldChoice[] fieldChoiceArray, Element element) {
            this.dialogTitle = string;
            this.choices = fieldChoiceArray;
            this.context = element;
        }
    }
}

