/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.command;

import com.xmlmind.xmledit.command.Msg;
import com.xmlmind.xmledit.command.RecordMacro;
import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.edit.CommandHistory;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.edit.UndoManager;
import com.xmlmind.xmledit.gadget.Binding;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.MenuItemSpec;
import com.xmlmind.xmledit.gadget.MenuSpec;
import com.xmlmind.xmledit.gadget.UserInput;
import com.xmlmind.xmledit.view.BindingSpec;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.view.NodeViewPart;
import java.awt.Point;
import java.awt.Rectangle;

public class CommandMenu
extends RecordableCommand
implements RecordMacro.Abort {
    public static final int NO_EDIT_MENU = 0;
    public static final int PREPEND_EDIT_MENU = 1;
    public static final int APPEND_EDIT_MENU = 2;
    private MenuSpec menuSpec;
    private int editMenuOffset;
    private Point point = new Point();
    private static final BindingSpec.Menu EDIT_MENU = new BindingSpec.Menu(null, new BindingSpec.MenuItem[]{new BindingSpec.MenuItem(Msg.msg("EM.undo"), "undo", null), new BindingSpec.MenuItem(Msg.msg("EM.redo"), "redo", null), new BindingSpec.MenuItem(Msg.msg("EM.repeat"), "repeat", null), new BindingSpec.MenuItem(), new BindingSpec.MenuItem(Msg.msg("EM.cut"), "cut", "[implicitElement]"), new BindingSpec.MenuItem(Msg.msg("EM.copy"), "copy", "[implicitElement]"), new BindingSpec.MenuItem(Msg.msg("EM.pasteBefore"), "paste", "before[implicitElement]"), new BindingSpec.MenuItem(Msg.msg("EM.paste"), "paste", "toOrInto"), new BindingSpec.MenuItem(Msg.msg("EM.pasteAfter"), "paste", "after[implicitElement]"), new BindingSpec.MenuItem(Msg.msg("EM.delete"), "delete", "[implicitElement]"), new BindingSpec.MenuItem(Msg.msg("EM.forceDeletion"), "delete", "force[implicitElement]"), new BindingSpec.MenuItem(), new BindingSpec.MenuItem(Msg.msg("EM.replace"), "replace", "[implicitElement]"), new BindingSpec.MenuItem(Msg.msg("EM.insertBefore"), "insert", "before[implicitElement]"), new BindingSpec.MenuItem(Msg.msg("EM.insert"), "insert", "into"), new BindingSpec.MenuItem(Msg.msg("EM.insertAfter"), "insert", "after[implicitElement]"), new BindingSpec.MenuItem(Msg.msg("EM.convert"), "convert", "[implicitElement]"), new BindingSpec.MenuItem(Msg.msg("EM.wrap"), "wrap", "[implicitElement]"), new BindingSpec.MenuItem(), new BindingSpec.MenuItem(Msg.msg("EM.split"), "split", null), new BindingSpec.MenuItem(Msg.msg("EM.join"), "join", null)});

    public CommandMenu(BindingSpec.Menu menu, int n) throws IllegalArgumentException {
        BindingSpec.MenuItem[] menuItemArray;
        Object object;
        if (menu == null) {
            this.editMenuOffset = 0;
            menu = EDIT_MENU.copy();
        } else {
            switch (n) {
                case 1: {
                    this.editMenuOffset = 0;
                    object = EDIT_MENU.copy();
                    menuItemArray = new BindingSpec.MenuItem[((BindingSpec.Menu)object).items.length + 1 + menu.items.length];
                    System.arraycopy(((BindingSpec.Menu)object).items, 0, menuItemArray, 0, ((BindingSpec.Menu)object).items.length);
                    menuItemArray[((BindingSpec.Menu)object).items.length] = new BindingSpec.MenuItem();
                    System.arraycopy(menu.items, 0, menuItemArray, ((BindingSpec.Menu)object).items.length + 1, menu.items.length);
                    menu = new BindingSpec.Menu(menu.label, menuItemArray);
                    break;
                }
                case 2: {
                    this.editMenuOffset = menu.items.length + 1;
                    object = EDIT_MENU.copy();
                    menuItemArray = new BindingSpec.MenuItem[menu.items.length + 1 + ((BindingSpec.Menu)object).items.length];
                    System.arraycopy(menu.items, 0, menuItemArray, 0, menu.items.length);
                    menuItemArray[menu.items.length] = new BindingSpec.MenuItem();
                    System.arraycopy(((BindingSpec.Menu)object).items, 0, menuItemArray, menu.items.length + 1, ((BindingSpec.Menu)object).items.length);
                    menu = new BindingSpec.Menu(menu.label, menuItemArray);
                    break;
                }
                default: {
                    this.editMenuOffset = -1;
                }
            }
        }
        object = UserInput.get(4, 0, 501);
        menuItemArray = new BindingSpec((UserInput)object, menu).toBinding();
        if (menuItemArray == null) {
            throw new IllegalArgumentException("some of the commands have not been registered");
        }
        this.menuSpec = menuItemArray.getMenuSpec();
    }

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        DocumentView documentView = (DocumentView)gadget;
        return documentView.getDocument() != null;
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        Object object;
        Object object2;
        MarkManager markManager = documentView.getMarkManager();
        boolean bl = false;
        boolean bl2 = false;
        if (string != null) {
            bl = string.indexOf("[showShortcuts]") >= 0;
            boolean bl3 = bl2 = string.indexOf("[selectElement]") >= 0;
        }
        if (bl2) {
            if (markManager.getSelected() != null) {
                bl2 = false;
            } else {
                object2 = markManager.getDot();
                object = markManager.getMark();
                if (object2 != null && object != null && (((TextLocation)object).getTextNode() != ((TextLocation)object2).getTextNode() || ((TextLocation)object).getOffset() != ((TextLocation)object2).getOffset())) {
                    bl2 = false;
                }
            }
            if (bl2) {
                this.point.x = n;
                this.point.y = n2;
                object2 = documentView.findGadgetAt(this.point);
                if (object2 == null || !(object2 instanceof NodeViewPart)) {
                    return null;
                }
                object = ((NodeViewPart)object2).getView().getModel();
                if (((Node)object).getNodeType() != 4) {
                    object = ((Node)object).getParentElement();
                }
                documentView.selectNode((Node)object);
            }
        }
        if (bl) {
            CommandMenu.updateShortcuts(documentView.getBindings(), this.menuSpec, true);
        }
        if (this.editMenuOffset >= 0) {
            Object object3;
            Object object4;
            object2 = documentView.getUndoManager();
            if (object2 != null) {
                object = this.menuSpec.items[this.editMenuOffset + 0];
                if (object != null) {
                    object4 = null;
                    object3 = ((UndoManager)object2).getTopUndoAction();
                    if (object3 != null && (object4 = ((UndoManager.Action)object3).getDescription()) == null) {
                        object4 = ((UndoManager.Action)object3).getDefaultDescription();
                    }
                    ((MenuItemSpec)object).label = object4 != null ? Msg.msg("EM.undoAction", object4) : Msg.msg("EM.undo");
                }
                if ((object = this.menuSpec.items[this.editMenuOffset + 1]) != null) {
                    object4 = null;
                    object3 = ((UndoManager)object2).getTopRedoAction();
                    if (object3 != null && (object4 = ((UndoManager.Action)object3).getDescription()) == null) {
                        object4 = ((UndoManager.Action)object3).getDefaultDescription();
                    }
                    ((MenuItemSpec)object).label = object4 != null ? Msg.msg("EM.redoAction", object4) : Msg.msg("EM.redo");
                }
            }
            if ((object = documentView.getCommandHistory()) != null && (object4 = this.menuSpec.items[this.editMenuOffset + 2]) != null) {
                object3 = null;
                int n3 = ((CommandHistory)object).getCommandCount() - 1;
                if (n3 >= 0) {
                    object3 = ((CommandHistory)object).getCommand(n3).getDescription();
                }
                ((MenuItemSpec)object4).label = object3 != null ? Msg.msg("EM.repeatAction", object3) : Msg.msg("EM.repeat");
            }
        }
        if ((n < 0 || n2 < 0) && (object2 = markManager.getDot()) != null && (object = documentView.modelToView(((TextLocation)object2).getTextNode(), ((TextLocation)object2).getOffset())) != null) {
            n = ((Rectangle)object).x + ((Rectangle)object).width / 2;
            n2 = ((Rectangle)object).y + ((Rectangle)object).height / 2;
        }
        if ((n < 0 || n2 < 0) && (object2 = markManager.getSelected()) != null && (object = documentView.modelToView(((NodeMark)object2).getNode())) != null) {
            n = ((Rectangle)object).x + ((Rectangle)object).width / 2;
            n2 = ((Rectangle)object).y + ((Rectangle)object).height / 2;
        }
        if (n < 0 || n2 < 0) {
            object2 = documentView.getVisibleRectangle();
            n = ((Rectangle)object2).x + ((Rectangle)object2).width / 2;
            n2 = ((Rectangle)object2).y + ((Rectangle)object2).height / 2;
        }
        documentView.showMenu(this.menuSpec, n, n2);
        return null;
    }

    private static final void updateShortcuts(Binding[] bindingArray, MenuSpec menuSpec, boolean bl) {
        MenuItemSpec[] menuItemSpecArray = menuSpec.items;
        int n = 0;
        while (n < menuItemSpecArray.length) {
            MenuItemSpec menuItemSpec = menuItemSpecArray[n];
            if (menuItemSpec instanceof MenuSpec) {
                CommandMenu.updateShortcuts(bindingArray, (MenuSpec)menuItemSpec, bl);
            } else if (menuItemSpec.command != null) {
                Binding binding;
                menuItemSpec.shortcut = !bl ? null : ((binding = DocumentView.findBinding(bindingArray, menuItemSpec.command, menuItemSpec.parameter)) == null || !binding.isKeyBinding() ? null : binding.triggerToString());
            }
            ++n;
        }
    }
}

