/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.command;

import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.edit.CommandEntry;
import com.xmlmind.xmledit.edit.CommandHistory;
import com.xmlmind.xmledit.edit.UndoManager;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.view.DocumentView;

public class CommandSequence
extends RecordableCommand {
    private CommandEntry[] sequence;
    private boolean undoable;
    private boolean repeatable;
    private String label;

    public CommandSequence(CommandEntry[] commandEntryArray) {
        this(commandEntryArray, false, false, null);
    }

    public CommandSequence(CommandEntry[] commandEntryArray, boolean bl, boolean bl2, String string) {
        this.sequence = commandEntryArray;
        this.undoable = bl;
        this.repeatable = bl2;
        this.label = string;
    }

    public CommandEntry[] getSequence() {
        return this.sequence;
    }

    public boolean isUndoable() {
        return this.undoable;
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        if (this.sequence == null || this.sequence.length == 0) {
            return false;
        }
        CommandEntry commandEntry = this.sequence[0];
        Command command = commandEntry.getCommand();
        String string2 = commandEntry.getParameter();
        return command.prepareCommand(gadget, string2, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        Object object;
        CommandHistory commandHistory = null;
        if (this.repeatable && (commandHistory = documentView.getCommandHistory()) != null) {
            if (commandHistory.isReadOnly()) {
                commandHistory = null;
            } else {
                commandHistory.setReadOnly(true);
            }
        }
        UndoManager undoManager = null;
        if (this.undoable && (undoManager = documentView.getUndoManager()) != null) {
            undoManager.beginMerge();
        }
        try {
            object = this.doExecute(documentView, string, n, n2);
        }
        finally {
            if (undoManager != null) {
                undoManager.endMerge(this.guiLabel());
            }
            if (commandHistory != null) {
                commandHistory.setReadOnly(false);
            }
        }
        if (commandHistory != null) {
            commandHistory.addCommand(this, string, this.guiLabel());
            documentView.notifyContextChangeListeners();
        }
        return object;
    }

    private String guiLabel() {
        return this.label != null ? this.label : "sequence";
    }

    private Object doExecute(Gadget gadget, String string, int n, int n2) {
        Object object = null;
        int n3 = 0;
        while (n3 < this.sequence.length) {
            String string2;
            CommandEntry commandEntry = this.sequence[n3];
            Command command = commandEntry.getCommand();
            if (!command.prepareCommand(gadget, string2 = commandEntry.getParameter(), n, n2)) {
                return Command.EXECUTION_FAILED;
            }
            object = command.executeCommand(gadget, string2, n, n2);
            if (object == Command.EXECUTION_FAILED) {
                return Command.EXECUTION_FAILED;
            }
            ++n3;
        }
        return object;
    }
}

