/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.command;

import com.xmlmind.xmledit.command.ChooseFieldCommand;
import com.xmlmind.xmledit.command.CommandUtil;
import com.xmlmind.xmledit.command.Msg;
import com.xmlmind.xmledit.dialog.FieldChoice;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doctype.Field;
import com.xmlmind.xmledit.edit.ElementEditor;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.edit.TextEditor;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.view.DocumentView;
import java.util.ArrayList;

public class Convert
extends ChooseFieldCommand {
    protected boolean wrap;
    private TextLocation beginLocation = null;
    private TextLocation endLocation = null;
    private Node child1 = null;
    private Node child2 = null;
    private FieldChoice choice = null;
    private ArrayList list = new ArrayList();
    private static final String convertLabel = Msg.msg("C.convert");
    private static final String wrapLabel = Msg.msg("C.wrap");

    public Convert() {
        this(false);
    }

    protected Convert(boolean bl) {
        this.wrap = bl;
    }

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        Object object;
        Object object2;
        this.beginLocation = null;
        this.endLocation = null;
        this.child1 = null;
        this.child2 = null;
        this.choice = null;
        this.list.clear();
        DocumentView documentView = (DocumentView)gadget;
        MarkManager markManager = documentView.getMarkManager();
        if (markManager == null) {
            return false;
        }
        NodeMark nodeMark = markManager.getSelected();
        if (nodeMark != null) {
            object2 = markManager.getSelected2();
            if (object2 == null) {
                object2 = nodeMark;
            }
            this.child1 = nodeMark.getNode();
            this.child2 = ((NodeMark)object2).getNode();
        } else {
            object2 = markManager.getDot();
            if (object2 == null) {
                return false;
            }
            object = markManager.getMark();
            if (object != null && (((TextLocation)object).getTextNode() != ((TextLocation)object2).getTextNode() || ((TextLocation)object).getOffset() != ((TextLocation)object2).getOffset())) {
                this.beginLocation = object;
                this.endLocation = object2;
            } else if (Convert.isImplicitNode(string)) {
                this.child1 = this.child2 = ((TextLocation)object2).getTextNode();
            } else if (Convert.isImplicitElement(string)) {
                this.child1 = this.child2 = ((TextLocation)object2).getTextNode().getParentElement();
            } else {
                return false;
            }
        }
        Object object3 = object2 = this.beginLocation != null ? this.beginLocation.getTextNode().getParentElement() : this.child1.getParentElement();
        if (object2 == null) {
            return false;
        }
        object = null;
        if (string != null && (object = Convert.getOperand(string)) != null && !CommandUtil.specifiesFieldChoice((String)object)) {
            object = null;
        }
        if (object == null) {
            return this.canConvert(documentView, null) != 0;
        }
        int n3 = this.canConvert(documentView, this.list);
        if (n3 == 0) {
            return false;
        }
        this.choice = CommandUtil.parseFieldChoice((String)object, this.list, n3 == 2, false, (Element)object2);
        return this.choice != null;
    }

    private static final boolean isImplicitNode(String string) {
        return string != null && string.indexOf("[implicitNode]") >= 0;
    }

    private static final boolean isImplicitElement(String string) {
        return string != null && string.indexOf("[implicitElement]") >= 0;
    }

    private static final String getOperand(String string) {
        int n = string.lastIndexOf(93);
        String string2 = n < 0 ? string : string.substring(n + 1);
        if ((string2 = string2.trim()).length() == 0) {
            string2 = null;
        }
        return string2;
    }

    private int canConvert(DocumentView documentView, ArrayList arrayList) {
        int n;
        if (this.beginLocation != null) {
            TextEditor textEditor = documentView.getTextEditor();
            n = textEditor.canConvert(this.beginLocation.getTextNode(), this.beginLocation.getOffset(), this.endLocation.getTextNode(), this.endLocation.getOffset(), arrayList);
        } else {
            Element element = this.child1.getParentElement();
            ElementEditor elementEditor = documentView.getElementEditor();
            elementEditor.editElement(element);
            boolean bl = this.child1 == this.child2 && this.child1 instanceof Element && !this.wrap ? elementEditor.canConvert((Element)this.child1, arrayList) : elementEditor.canWrap(this.child1, this.child2, arrayList);
            n = elementEditor.canConvertToText(this.child1, this.child2) ? 2 : (bl ? 1 : 0);
        }
        return n;
    }

    public FieldChoice getPreparedFieldChoice() {
        return this.choice;
    }

    public ChooseFieldCommand.FieldChoices getFieldChoices(DocumentView documentView, String string, boolean bl, boolean bl2) {
        int n = this.canConvert(documentView, this.list);
        Field[] fieldArray = this.list.toArray(ChooseFieldCommand.NO_FIELDS);
        Element element = this.beginLocation != null ? this.beginLocation.getTextNode().getParentElement() : this.child1.getParentElement();
        FieldChoice[] fieldChoiceArray = FieldChoice.list(fieldArray, n == 2, bl, false, element);
        return new ChooseFieldCommand.FieldChoices(this.wrap ? wrapLabel : convertLabel, fieldChoiceArray, element);
    }

    protected void doExecuteCommand(DocumentView documentView, String string, FieldChoice fieldChoice) {
        Object object;
        MarkManager markManager = documentView.getMarkManager();
        markManager.beginBatchMarking();
        Node node = null;
        if (this.beginLocation != null) {
            object = documentView.getTextEditor();
            node = fieldChoice.text ? ((TextEditor)object).convertToText(this.beginLocation, this.endLocation) : ((TextEditor)object).convert(this.beginLocation, this.endLocation, fieldChoice.field, fieldChoice.name);
        } else {
            object = documentView.getElementEditor();
            node = fieldChoice.text ? ((ElementEditor)object).convertToText(this.child1, this.child2) : (this.child1 == this.child2 && this.child1 instanceof Element && !this.wrap ? ((ElementEditor)object).convert((Element)this.child1, fieldChoice.field, fieldChoice.name) : ((ElementEditor)object).wrap(this.child1, this.child2, fieldChoice.field, fieldChoice.name));
        }
        object = this.wrap ? wrapLabel : convertLabel;
        documentView.describeUndo((String)object);
        documentView.addToCommandHistory(this, this.makeParameter(string, fieldChoice), (String)object);
        markManager.remove("MARK");
        markManager.remove("SELECTED2");
        if (node != null && node.getDocument() == null) {
            node = null;
        }
        if (node == null) {
            markManager.remove("SELECTED");
        } else {
            markManager.set("SELECTED", node);
            documentView.moveDotInto(node);
        }
        markManager.endBatchMarking();
    }

    protected String makeParameter(String string, FieldChoice fieldChoice) {
        StringBuffer stringBuffer = new StringBuffer();
        if (Convert.isImplicitElement(string)) {
            stringBuffer.append("[implicitElement] ");
        } else if (Convert.isImplicitNode(string)) {
            stringBuffer.append("[implicitNode] ");
        }
        stringBuffer.append(CommandUtil.formatFieldChoice(fieldChoice));
        return stringBuffer.toString();
    }

    public void resetCommand() {
        this.beginLocation = null;
        this.endLocation = null;
        this.child1 = null;
        this.child2 = null;
        this.choice = null;
        this.list.clear();
    }
}

