/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.command;

import com.xmlmind.xmledit.command.Msg;
import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.edit.TextCollector;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.edit.TextRange;
import com.xmlmind.xmledit.edit.TextRangeList;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.XMLUtil;

public class ConvertCase
extends RecordableCommand {
    public static final int LOWER = 0;
    public static final int UPPER = 1;
    public static final int CAPITAL = 2;
    private int conversion = -1;
    private TextNode beginText = null;
    private int beginOffset = -1;
    private TextNode endText = null;
    private int endOffset = -1;

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        this.beginText = null;
        this.beginOffset = -1;
        this.endText = null;
        this.endOffset = -1;
        DocumentView documentView = (DocumentView)gadget;
        MarkManager markManager = documentView.getMarkManager();
        if (markManager == null) {
            return false;
        }
        if ("lower".equals(string)) {
            this.conversion = 0;
        } else if ("upper".equals(string)) {
            this.conversion = 1;
        } else if ("capital".equals(string)) {
            this.conversion = 2;
        } else {
            return false;
        }
        NodeMark nodeMark = markManager.getSelected();
        if (nodeMark != null) {
            Node node = nodeMark.getNode();
            NodeMark nodeMark2 = markManager.getSelected2();
            if (nodeMark2 != null && nodeMark2.getNode() != node) {
                return false;
            }
            this.beginText = (TextNode)Traversal.traverse(node, Traversal.textNodeFinder);
            if (this.beginText == null) {
                return false;
            }
            this.beginOffset = 0;
            this.endText = (TextNode)Traversal.traverseBackwards(node, Traversal.textNodeFinder);
            this.endOffset = this.endText.getTextLength();
            if (this.beginText == this.endText && this.beginOffset == this.endOffset) {
                return false;
            }
        } else {
            TextLocation textLocation = markManager.getDot();
            if (textLocation == null) {
                return false;
            }
            this.beginText = textLocation.getTextNode();
            this.beginOffset = textLocation.getOffset();
            TextLocation textLocation2 = markManager.getMark();
            if (textLocation2 != null) {
                this.endText = textLocation2.getTextNode();
                this.endOffset = textLocation2.getOffset();
            } else {
                this.endText = this.beginText;
                this.endOffset = this.beginOffset;
            }
            if (this.beginText == this.endText) {
                if (this.beginOffset == this.endOffset) {
                    int n3 = this.beginText.getTextLength();
                    while (this.endOffset < n3) {
                        if (XMLUtil.isXMLSpace(this.beginText.getTextChar(this.endOffset))) break;
                        ++this.endOffset;
                    }
                    if (this.endOffset == this.beginOffset) {
                        return false;
                    }
                } else if (this.beginOffset > this.endOffset) {
                    int n4 = this.beginOffset;
                    this.beginOffset = this.endOffset;
                    this.endOffset = n4;
                }
            }
        }
        return documentView.getTextEditor().canEdit(this.beginText, this.beginOffset, this.endText, this.endOffset);
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        Object object;
        MarkManager markManager = documentView.getMarkManager();
        markManager.beginBatchMarking();
        boolean bl = false;
        if (this.beginText == this.endText) {
            this.convertCase(this.beginText, this.beginOffset, this.endOffset - this.beginOffset);
        } else {
            object = documentView.getDocument();
            ((Document)object).beginBatchEditing();
            TextRangeList textRangeList = new TextRangeList();
            int n3 = new TextCollector().collect(this.beginText, this.beginOffset, this.endText, this.endOffset, textRangeList);
            bl = n3 == 2;
            TextRange[] textRangeArray = textRangeList.list;
            int n4 = textRangeList.size;
            int n5 = 0;
            while (n5 < n4) {
                TextRange textRange = textRangeArray[n5];
                this.convertCase(textRange.text, textRange.offset, textRange.count);
                ++n5;
            }
            ((Document)object).endBatchEditing();
        }
        object = Msg.msg("CC.convertCase");
        documentView.describeUndo((String)object);
        markManager.remove("SELECTED");
        markManager.remove("SELECTED2");
        markManager.remove("MARK");
        if (bl) {
            markManager.getDot().moveTo(this.beginText, this.beginOffset);
        } else {
            markManager.getDot().moveTo(this.endText, this.endOffset);
        }
        markManager.endBatchMarking();
        this.beginText = null;
        this.beginOffset = -1;
        this.endText = null;
        this.endOffset = -1;
        return null;
    }

    private void convertCase(TextNode textNode, int n, int n2) {
        char[] cArray = textNode.getTextChars();
        switch (this.conversion) {
            case 0: {
                textNode.replaceText(n, n2, new String(cArray, n, n2).toLowerCase());
                break;
            }
            case 1: {
                textNode.replaceText(n, n2, new String(cArray, n, n2).toUpperCase());
                break;
            }
            default: {
                char[] cArray2 = new char[n2];
                System.arraycopy(cArray, n, cArray2, 0, n2);
                boolean bl = true;
                int n3 = 0;
                while (n3 < n2) {
                    char c = cArray2[n3];
                    if (XMLUtil.isXMLSpace(c)) {
                        bl = true;
                    } else if (bl) {
                        bl = false;
                        cArray2[n3] = Character.toUpperCase(c);
                    }
                    ++n3;
                }
                textNode.replaceText(n, n2, new String(cArray2));
            }
        }
    }
}

