/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.command;

import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.edit.ElementEditor;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.guiutil.Clipboard;
import com.xmlmind.xmledit.view.DocumentView;

public class Copy
extends RecordableCommand {
    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        DocumentView documentView = (DocumentView)gadget;
        MarkManager markManager = documentView.getMarkManager();
        if (markManager == null) {
            return false;
        }
        NodeMark nodeMark = markManager.getSelected();
        if (nodeMark != null) {
            return true;
        }
        TextLocation textLocation = markManager.getDot();
        if (textLocation == null) {
            return false;
        }
        TextLocation textLocation2 = markManager.getMark();
        if (textLocation2 != null && (textLocation2.getTextNode() != textLocation.getTextNode() || textLocation2.getOffset() != textLocation.getOffset())) {
            return true;
        }
        return Copy.isImplicitElement(string) || Copy.isImplicitNode(string);
    }

    protected static final boolean isImplicitNode(String string) {
        return string != null && string.startsWith("[implicitNode]");
    }

    protected static final boolean isImplicitElement(String string) {
        return string != null && string.startsWith("[implicitElement]");
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        String string2 = null;
        MarkManager markManager = documentView.getMarkManager();
        NodeMark nodeMark = markManager.getSelected();
        if (nodeMark != null) {
            Element element = nodeMark.getNode().getParentElement();
            if (element == null) {
                string2 = this.copyElement((Element)nodeMark.getNode(), documentView, string);
            } else {
                NodeMark nodeMark2 = markManager.getSelected2();
                if (nodeMark2 == null) {
                    nodeMark2 = nodeMark;
                }
                string2 = this.copyNodeRange(element, nodeMark.getNode(), nodeMark2.getNode(), documentView, string);
            }
        } else {
            TextLocation textLocation = markManager.getDot();
            TextLocation textLocation2 = markManager.getMark();
            if (textLocation2 != null && (textLocation2.getTextNode() != textLocation.getTextNode() || textLocation2.getOffset() != textLocation.getOffset())) {
                string2 = this.copyTextRange(textLocation2.getTextNode(), textLocation2.getOffset(), textLocation.getTextNode(), textLocation.getOffset(), documentView, string);
            } else if (Copy.isImplicitElement(string)) {
                Element element = textLocation.getTextNode().getParentElement();
                string2 = this.copyElement(element, documentView, string);
            } else if (Copy.isImplicitNode(string)) {
                TextNode textNode = textLocation.getTextNode();
                Element element = textNode.getParentElement();
                string2 = this.copyNodeRange(element, textNode, textNode, documentView, string);
            }
        }
        Clipboard.put(documentView.getPanel(), string2);
        markManager.notifyContextChangeListeners();
        return null;
    }

    protected String copyElement(Element element, DocumentView documentView, String string) {
        ElementEditor elementEditor = documentView.getElementEditor();
        elementEditor.editElement(element);
        return elementEditor.copy();
    }

    protected String copyNodeRange(Element element, Node node, Node node2, DocumentView documentView, String string) {
        ElementEditor elementEditor = documentView.getElementEditor();
        elementEditor.editElement(element);
        return elementEditor.copy(node, node2);
    }

    protected String copyTextRange(TextNode textNode, int n, TextNode textNode2, int n2, DocumentView documentView, String string) {
        return documentView.getTextEditor().copy(textNode, n, textNode2, n2);
    }
}

