/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.command;

import com.xmlmind.xmledit.command.Msg;
import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.edit.ElementEditor;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.guiutil.Clipboard;
import com.xmlmind.xmledit.view.DocumentView;

public class Delete
extends RecordableCommand {
    private boolean cut;
    private static final String deleteLabel = Msg.msg("D.delete");
    private static final String cutLabel = Msg.msg("D.cut");

    public Delete() {
        this(false);
    }

    protected Delete(boolean bl) {
        this.cut = bl;
    }

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        DocumentView documentView = (DocumentView)gadget;
        MarkManager markManager = documentView.getMarkManager();
        if (markManager == null) {
            return false;
        }
        ElementEditor elementEditor = documentView.getElementEditor();
        NodeMark nodeMark = markManager.getSelected();
        if (nodeMark != null) {
            Element element = nodeMark.getNode().getParentElement();
            if (element != null) {
                NodeMark nodeMark2 = markManager.getSelected2();
                if (nodeMark2 == null) {
                    nodeMark2 = nodeMark;
                }
                elementEditor.editElement(element);
                if (Delete.isForce(string) && elementEditor.canEditElement() || elementEditor.canDelete(nodeMark.getNode(), nodeMark2.getNode())) {
                    return true;
                }
            }
        } else {
            TextLocation textLocation = markManager.getDot();
            TextLocation textLocation2 = markManager.getMark();
            if (textLocation != null) {
                Element element;
                Element element2;
                if (textLocation2 != null && (textLocation2.getTextNode() != textLocation.getTextNode() || textLocation2.getOffset() != textLocation.getOffset())) {
                    return documentView.getTextEditor().canEdit(textLocation2, textLocation);
                }
                if (Delete.isImplicitNode(string)) {
                    Element element3 = textLocation.getTextNode().getParentElement();
                    elementEditor.editElement(element3);
                    return elementEditor.canEditElement();
                }
                if (Delete.isImplicitElement(string) && (element2 = (element = textLocation.getTextNode().getParentElement()).getParentElement()) != null) {
                    elementEditor.editElement(element2);
                    if (Delete.isForce(string) && elementEditor.canEditElement() || elementEditor.canDelete(element, element)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static final boolean isForce(String string) {
        return string != null && string.startsWith("force");
    }

    private static final boolean isImplicitNode(String string) {
        return string != null && string.endsWith("[implicitNode]");
    }

    private static final boolean isImplicitElement(String string) {
        return string != null && string.endsWith("[implicitElement]");
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        ElementEditor elementEditor = documentView.getElementEditor();
        String string2 = null;
        MarkManager markManager = documentView.getMarkManager();
        markManager.beginBatchMarking();
        NodeMark nodeMark = markManager.getSelected();
        if (nodeMark != null) {
            NodeMark nodeMark2 = markManager.getSelected2();
            if (nodeMark2 == null) {
                nodeMark2 = nodeMark;
            }
            if (this.cut) {
                string2 = elementEditor.cut(nodeMark.getNode(), nodeMark2.getNode());
            } else {
                elementEditor.delete(nodeMark.getNode(), nodeMark2.getNode());
            }
            markManager.remove("SELECTED");
            markManager.remove("SELECTED2");
        } else {
            TextLocation textLocation = markManager.getDot();
            TextLocation textLocation2 = markManager.getMark();
            if (textLocation2 != null && (textLocation2.getTextNode() != textLocation.getTextNode() || textLocation2.getOffset() != textLocation.getOffset())) {
                if (this.cut) {
                    string2 = documentView.getTextEditor().cut(textLocation2, textLocation);
                } else {
                    documentView.getTextEditor().delete(textLocation2, textLocation);
                }
            } else if (Delete.isImplicitNode(string)) {
                TextNode textNode = textLocation.getTextNode();
                string2 = elementEditor.cut(textNode, textNode);
            } else if (Delete.isImplicitElement(string)) {
                Element element = textLocation.getTextNode().getParentElement();
                string2 = elementEditor.cut(element, element);
            }
            markManager.remove("MARK");
        }
        documentView.describeUndo(this.cut ? cutLabel : deleteLabel);
        if (this.cut) {
            Clipboard.put(documentView.getPanel(), string2);
        }
        markManager.endBatchMarking();
        return null;
    }
}

