/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.command;

import com.xmlmind.xmledit.command.Msg;
import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.dialog.SetAttributeValue;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doctype.DataType;
import com.xmlmind.xmledit.doctype.DocumentTypeUtil;
import com.xmlmind.xmledit.edit.ElementEditor;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.guiutil.PromptDialog;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.Name;
import java.awt.Container;

public abstract class EditAttribute
extends RecordableCommand {
    protected static final int NONE = 0;
    protected static final int EMPTY = 1;
    protected static final int DUMMY = 2;
    protected static final int ID = 3;
    protected Name attributeName;
    protected String attributeValue;
    protected int otherValue;

    protected ElementEditor doPrepareCommand(DocumentView documentView, String string) {
        Object object;
        this.attributeName = null;
        this.attributeValue = null;
        this.otherValue = 0;
        MarkManager markManager = documentView.getMarkManager();
        if (markManager == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        String[] stringArray = StringUtil.splitArguments(string);
        if (stringArray.length < 1 || stringArray.length > 4) {
            return null;
        }
        int n = 0;
        boolean bl = false;
        if ("[implicitElement]".equals(stringArray[n])) {
            bl = true;
            ++n;
        }
        if (n == stringArray.length) {
            return null;
        }
        if ("[empty]".equals(stringArray[n])) {
            this.otherValue = 1;
            ++n;
        } else if ("[dummy]".equals(stringArray[n])) {
            this.otherValue = 2;
            ++n;
        } else if ("[id]".equals(stringArray[n])) {
            this.otherValue = 3;
            ++n;
        }
        if (n == stringArray.length) {
            return null;
        }
        this.attributeName = Name.fromString(stringArray[n++]);
        if (this.attributeName == null) {
            return null;
        }
        if (n == stringArray.length - 1) {
            this.attributeValue = stringArray[n];
        } else if (n != stringArray.length) {
            return null;
        }
        if (this.attributeValue != null && this.otherValue != 0) {
            return null;
        }
        Node node = null;
        NodeMark nodeMark = markManager.getSelected();
        if (nodeMark != null) {
            if (markManager.getSelected2() != null) {
                return null;
            }
            node = nodeMark.getNode();
        } else {
            object = markManager.getDot();
            if (object == null) {
                return null;
            }
            TextLocation textLocation = markManager.getMark();
            if (textLocation != null && (textLocation.getTextNode() != ((TextLocation)object).getTextNode() || textLocation.getOffset() != ((TextLocation)object).getOffset())) {
                return null;
            }
            if (bl) {
                node = ((TextLocation)object).getTextNode().getParentElement();
            } else {
                return null;
            }
        }
        if (node.getNodeType() != 4) {
            return null;
        }
        object = documentView.getElementEditor();
        ((ElementEditor)object).editElement((Element)node);
        return object;
    }

    protected String selectAttributeValue(DocumentView documentView, boolean bl) {
        ElementEditor elementEditor = documentView.getElementEditor();
        Element element = elementEditor.getEditedElement();
        DataType dataType = DocumentTypeUtil.getAttributeDataType(element, this.attributeName);
        String string = DocumentTypeUtil.getElementAttribute(element, this.attributeName, null);
        Container container = documentView.getPanel();
        if (dataType != null && SetAttributeValue.canSetValue(element, dataType)) {
            return SetAttributeValue.setValue(container, element, this.attributeName, string, dataType);
        }
        String string2 = this.attributeName.format(true, element);
        String string3 = bl ? Msg.msg("AA.title", string2) : Msg.msg("PA.title", string2);
        String string4 = Msg.msg("PA.message", string2);
        PromptDialog promptDialog = new PromptDialog(container);
        return promptDialog.getValue(string3, string4, string, element.getLocation(), true);
    }
}

