/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.command;

import com.xmlmind.xmledit.command.Msg;
import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.guiutil.AWTUtil;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import javax.swing.JOptionPane;

public class EditPITarget
extends RecordableCommand {
    private ProcessingInstruction pi = null;
    private String newTarget = null;
    private static final String title = Msg.msg("EPT.title");
    private static final String message = Msg.msg("EPT.message");

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        Node node;
        this.pi = null;
        this.newTarget = null;
        DocumentView documentView = (DocumentView)gadget;
        MarkManager markManager = documentView.getMarkManager();
        if (markManager == null) {
            return false;
        }
        NodeMark nodeMark = markManager.getSelected();
        if (nodeMark != null) {
            if (markManager.getSelected2() != null) {
                return false;
            }
            node = nodeMark.getNode();
        } else {
            TextLocation textLocation = markManager.getDot();
            if (textLocation == null) {
                return false;
            }
            TextLocation textLocation2 = markManager.getMark();
            if (textLocation2 != null && (textLocation2.getTextNode() != textLocation.getTextNode() || textLocation2.getOffset() != textLocation.getOffset())) {
                return false;
            }
            if (EditPITarget.isImplicitNode(string)) {
                node = textLocation.getTextNode();
            } else {
                return false;
            }
        }
        if (node.getNodeType() != 2) {
            return false;
        }
        this.pi = (ProcessingInstruction)node;
        if (string != null) {
            this.newTarget = EditPITarget.getTarget(string);
        }
        return this.pi.isEditable();
    }

    private static final boolean isImplicitNode(String string) {
        return string != null && string.startsWith("[implicitNode]");
    }

    private static final String getTarget(String string) {
        int n = string.lastIndexOf(93);
        if (n == string.length() - 1) {
            return null;
        }
        String string2 = string.substring(n + 1).trim();
        return string2.length() > 0 && XMLUtil.isPITarget(string2) ? string2 : null;
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        MarkManager markManager = documentView.getMarkManager();
        if (this.newTarget == null) {
            this.newTarget = (String)JOptionPane.showInputDialog(AWTUtil.getDialogAnchor(documentView.getPanel()), message, title, 3, null, null, this.pi.getTarget());
        }
        if (this.newTarget == null) {
            return Command.EXECUTION_FAILED;
        }
        if (!XMLUtil.isPITarget(this.newTarget)) {
            documentView.getToolkit().beep();
            Alert.showError(documentView.getPanel(), Msg.msg("EPT.badTarget", this.newTarget));
            return Command.EXECUTION_FAILED;
        }
        markManager.beginBatchMarking();
        ProcessingInstruction processingInstruction = new ProcessingInstruction(this.newTarget, this.pi.getText());
        this.pi.getParent().replaceChild(this.pi, processingInstruction);
        documentView.describeUndo(title);
        documentView.addToCommandHistory(this, EditPITarget.makeParameter(string, this.newTarget), title);
        markManager.remove("SELECTED2");
        markManager.remove("MARK");
        markManager.set("SELECTED", processingInstruction);
        documentView.moveDotInto(processingInstruction);
        markManager.endBatchMarking();
        this.pi = null;
        this.newTarget = null;
        return null;
    }

    private static final String makeParameter(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (EditPITarget.isImplicitNode(string)) {
            stringBuffer.append("[implicitNode] ");
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }
}

