/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.command;

import com.xmlmind.xmledit.command.Msg;
import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.edit.CommandEntry;
import com.xmlmind.xmledit.edit.CommandHistory;
import com.xmlmind.xmledit.edit.CommandHistoryEvent;
import com.xmlmind.xmledit.edit.CommandHistoryListener;
import com.xmlmind.xmledit.edit.Commands;
import com.xmlmind.xmledit.gadget.Binding;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.guiutil.AutoCompletion;
import com.xmlmind.xmledit.guiutil.DialogBase;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.guiutil.ShowStatus;
import com.xmlmind.xmledit.view.DocumentView;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Execute
extends RecordableCommand
implements CommandHistoryListener {
    private long expectedSerialNumber = -1L;
    private CommandEntry addedCommandEntry = null;
    private String[] split = new String[2];

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        DocumentView documentView = (DocumentView)gadget;
        return documentView.getDocument() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        Object object;
        Command command;
        Dialog dialog = new Dialog(documentView.getPanel());
        String string2 = dialog.getCommandLine(documentView);
        if (string2 == null) {
            return Command.EXECUTION_FAILED;
        }
        Execute.splitCommandLine(string2, this.split);
        String string3 = this.split[0];
        String string4 = this.split[1];
        string2 = string3;
        if (string4 != null) {
            string2 = string2 + " " + string4;
        }
        if ((command = Commands.getCommand(string3)) == null) {
            ShowStatus.showStatus(Msg.msg("E.commandNotFound", string3));
            return Command.EXECUTION_FAILED;
        }
        if (command.prepareCommand(documentView, string4, -1, -1)) {
            CommandHistory commandHistory = documentView.getCommandHistory();
            if (commandHistory != null) {
                this.expectedSerialNumber = commandHistory.getNextSerialNumber();
                this.addedCommandEntry = null;
                commandHistory.addCommandHistoryListener(this);
            }
            try {
                object = command.executeCommand(documentView, string4, -1, -1);
                Object var13_12 = null;
                if (commandHistory != null) {
                    commandHistory.removeCommandHistoryListener(this);
                }
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                if (commandHistory != null) {
                    commandHistory.removeCommandHistoryListener(this);
                }
                throw throwable;
            }
            boolean bl = true;
            if (commandHistory != null) {
                bl = this.addedCommandEntry == null || this.addedCommandEntry.getSerialNumber() != this.expectedSerialNumber;
                this.addedCommandEntry = null;
                this.expectedSerialNumber = -1L;
            }
            if (bl && object != Command.EXECUTION_FAILED) {
                commandHistory.addCommand(command, string4, null);
                documentView.notifyContextChangeListeners();
            }
        } else {
            ShowStatus.showStatus(Msg.msg("E.cannotExecute", string2));
            object = Command.EXECUTION_FAILED;
        }
        return object;
    }

    public void commandAdded(CommandHistoryEvent commandHistoryEvent) {
        this.addedCommandEntry = commandHistoryEvent.getEntry();
    }

    private static final void splitCommandLine(String string, String[] stringArray) {
        int n = string.indexOf(32);
        if (n < 0) {
            stringArray[0] = string;
            stringArray[1] = null;
        } else {
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n + 1).trim();
        }
    }

    public static final class ParameterChoices
    implements AutoCompletion.Choices {
        private JTextField commandField;
        private boolean dependsOnPrefix;
        private HashMap commandToParameters;
        private static final String[] NO_PARAMETERS = new String[0];

        public ParameterChoices(JTextField jTextField, DocumentView documentView, boolean bl) {
            Object[] objectArray;
            Object object;
            this.commandField = jTextField;
            this.dependsOnPrefix = bl;
            this.commandToParameters = new HashMap();
            Binding[] bindingArray = documentView.getBindings();
            int n = 0;
            while (n < bindingArray.length) {
                String string;
                String string2;
                object = bindingArray[n];
                objectArray = ((Binding)object).getCommand();
                if (objectArray != null && (string2 = Commands.getName((Command)objectArray)) != null && (string = ((Binding)object).getParameter()) != null && (string = string.trim()).length() != 0) {
                    this.addToMap(string2, string);
                }
                ++n;
            }
            object = this.commandToParameters.values().iterator();
            while (object.hasNext()) {
                objectArray = (String[])object.next();
                if (objectArray.length <= 1) continue;
                Arrays.sort(objectArray);
            }
        }

        private void addToMap(String string, String string2) {
            String[] stringArray = (String[])this.commandToParameters.get(string);
            if (stringArray == null) {
                stringArray = new String[]{string2};
            } else {
                String[] stringArray2 = new String[stringArray.length + 1];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                stringArray2[stringArray.length] = string2;
                stringArray = stringArray2;
            }
            this.commandToParameters.put(string, stringArray);
        }

        public void getChoices(String string, AutoCompletion.ChoiceList choiceList) {
            String string2 = this.commandField.getText().trim();
            String[] stringArray = (String[])this.commandToParameters.get(string2);
            if (stringArray == null) {
                choiceList.list = NO_PARAMETERS;
                choiceList.first = -1;
                return;
            }
            if (this.dependsOnPrefix) {
                String[] stringArray2;
                if (string.length() == 0) {
                    choiceList.list = stringArray;
                    choiceList.first = -1;
                    return;
                }
                String[] stringArray3 = new String[stringArray.length];
                int n = 0;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    stringArray2 = stringArray[n2];
                    if (stringArray2.startsWith(string)) {
                        stringArray3[n++] = stringArray[n2];
                    }
                    ++n2;
                }
                if (n != stringArray3.length) {
                    stringArray2 = new String[n];
                    System.arraycopy(stringArray3, 0, stringArray2, 0, n);
                    stringArray3 = stringArray2;
                }
                choiceList.list = stringArray3;
                choiceList.first = n > 0 ? 0 : -1;
            } else {
                choiceList.list = stringArray;
                choiceList.first = -1;
                if (string.length() == 0) {
                    return;
                }
                int n = 0;
                while (n < stringArray.length) {
                    String string3 = stringArray[n];
                    if (string3.startsWith(string)) {
                        choiceList.first = n;
                        return;
                    }
                    ++n;
                }
            }
        }

        public boolean choiceListDependsOnPrefix() {
            return this.dependsOnPrefix;
        }
    }

    public static final class Dialog
    extends DialogBase
    implements ListSelectionListener,
    MouseListener {
        private JTextField commandField;
        private AutoCompletion commandAutoCompletion;
        private JTextField parameterField;
        private AutoCompletion parameterAutoCompletion;
        private JList historyList;
        private String result = null;
        private String[] split = new String[2];

        public Dialog(Component component) {
            super(component, Msg.msg("E.executeCommand"), 27);
        }

        protected Component createForm() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets.left = 5;
            String string = Msg.msg("E.command");
            JLabel jLabel = new JLabel(DialogUtil.buttonLabel(string));
            DialogUtil.setDisplayedMnemonic(jLabel, string);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets.top = 5;
            jPanel.add((Component)jLabel, gridBagConstraints);
            this.commandField = new JTextField(20);
            this.commandField.addActionListener(this);
            this.commandField.setActionCommand("ok");
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 2.0;
            gridBagConstraints.insets.top = 2;
            jPanel.add((Component)this.commandField, gridBagConstraints);
            jLabel.setLabelFor(this.commandField);
            this.commandAutoCompletion = new AutoCompletion(this.commandField);
            AWTKeyStroke[] aWTKeyStrokeArray = new AWTKeyStroke[]{AWTKeyStroke.getAWTKeyStroke(32, 2), AWTKeyStroke.getAWTKeyStroke(' ')};
            this.commandAutoCompletion.setAppendKeyStrokes(aWTKeyStrokeArray);
            string = Msg.msg("E.parameter");
            jLabel = new JLabel(DialogUtil.buttonLabel(string));
            DialogUtil.setDisplayedMnemonic(jLabel, string);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets.top = 5;
            gridBagConstraints.insets.right = 5;
            jPanel.add((Component)jLabel, gridBagConstraints);
            this.parameterField = new JTextField(30);
            this.parameterField.addActionListener(this);
            this.parameterField.setActionCommand("ok");
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 3.0;
            gridBagConstraints.insets.top = 2;
            jPanel.add((Component)this.parameterField, gridBagConstraints);
            jLabel.setLabelFor(this.parameterField);
            this.parameterAutoCompletion = new AutoCompletion(this.parameterField);
            aWTKeyStrokeArray = new AWTKeyStroke[]{AWTKeyStroke.getAWTKeyStroke(32, 2)};
            this.parameterAutoCompletion.setAppendKeyStrokes(aWTKeyStrokeArray);
            string = Msg.msg("E.commandHistory");
            jLabel = new JLabel(DialogUtil.buttonLabel(string));
            DialogUtil.setDisplayedMnemonic(jLabel, string);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets.top = 5;
            jPanel.add((Component)jLabel, gridBagConstraints);
            this.historyList = new JList();
            this.historyList.setSelectionMode(0);
            this.historyList.setVisibleRowCount(15);
            this.historyList.addListSelectionListener(this);
            this.historyList.addMouseListener(this);
            jLabel.setLabelFor(this.historyList);
            JScrollPane jScrollPane = new JScrollPane(this.historyList);
            ++gridBagConstraints.gridy;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 5.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets.top = 2;
            gridBagConstraints.insets.bottom = 5;
            jPanel.add((Component)jScrollPane, gridBagConstraints);
            return jPanel;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            String string = (String)this.historyList.getSelectedValue();
            if (string != null) {
                Execute.splitCommandLine(string, this.split);
                this.commandAutoCompletion.setEntry(this.split[0]);
                this.parameterAutoCompletion.setEntry(this.split[1] == null ? "" : this.split[1]);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (mouseEvent.getClickCount() == 2 && (n = this.historyList.locationToIndex(mouseEvent.getPoint())) >= 0) {
                this.ok();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public String getCommandLine(DocumentView documentView) {
            this.commandAutoCompletion.setEntry("");
            Object[] objectArray = Commands.getAllNames();
            AutoCompletion.ChoicesBase choicesBase = AutoCompletion.getPreferMinimalChoices() ? new AutoCompletion.MinimalChoices(objectArray) : new AutoCompletion.SimpleChoices(objectArray);
            this.commandAutoCompletion.setChoices(choicesBase);
            this.parameterAutoCompletion.setEntry("");
            ParameterChoices parameterChoices = new ParameterChoices(this.commandField, documentView, AutoCompletion.getPreferMinimalChoices());
            this.parameterAutoCompletion.setChoices(parameterChoices);
            this.historyList.setListData(this.getHistory(documentView));
            this.historyList.ensureIndexIsVisible(0);
            this.getRootPane().setDefaultButton(this.dialogButtons[0]);
            this.setLocationRelativeTo(this.dialogAnchor);
            this.pack();
            this.commandField.requestFocus();
            this.setVisible(true);
            this.commandAutoCompletion.setChoices(null);
            this.parameterAutoCompletion.setChoices(null);
            return this.result;
        }

        private String[] getHistory(DocumentView documentView) {
            String[] stringArray = null;
            CommandHistory commandHistory = documentView.getCommandHistory();
            if (commandHistory != null) {
                stringArray = new String[commandHistory.getCommandCount()];
                int n = 0;
                int n2 = stringArray.length - 1;
                while (n2 >= 0) {
                    CommandEntry commandEntry = commandHistory.getCommand(n2);
                    stringArray[n++] = commandEntry.toString();
                    --n2;
                }
            }
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            return stringArray;
        }

        public void ok() {
            String string = this.commandField.getText().trim();
            if (string.length() == 0) {
                DialogUtil.badField(this.commandField);
                return;
            }
            String string2 = this.parameterField.getText().trim();
            this.result = string2.length() == 0 ? string : string + ' ' + string2;
            this.setVisible(false);
            this.dispose();
        }

        public void cancel() {
            this.result = null;
            this.setVisible(false);
            this.dispose();
        }
    }
}

