/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.command;

import com.xmlmind.xmledit.command.InsertControlChar;
import com.xmlmind.xmledit.command.Split;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.edit.Commands;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.TextEditor;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.view.DocumentView;

public class InsertControlCharOrSplit
extends InsertControlChar {
    private Split splitCommand = null;
    private Element splitElement = null;
    private TextNode splitText = null;
    private int splitOffset = 0;

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        this.splitElement = null;
        this.splitText = null;
        this.splitOffset = -1;
        if (super.prepareCommand(gadget, string, -1, -1)) {
            return true;
        }
        if (string == null || string.length() != 1 || string.charAt(0) != '\n') {
            return false;
        }
        return this.prepareSplit((DocumentView)gadget);
    }

    private boolean prepareSplit(DocumentView documentView) {
        MarkManager markManager = documentView.getMarkManager();
        if (markManager == null || markManager.getMark() != null || markManager.getSelected() != null || markManager.getSelected2() != null) {
            return false;
        }
        TextLocation textLocation = markManager.getDot();
        if (textLocation == null) {
            return false;
        }
        this.splitText = textLocation.getTextNode();
        this.splitOffset = textLocation.getOffset();
        TextEditor textEditor = documentView.getTextEditor();
        this.splitElement = textEditor.findSplit(this.splitText);
        return this.splitElement != null;
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        if (this.splitElement == null) {
            super.doExecuteCommand(documentView, string, -1, -1);
        } else {
            if (this.splitCommand == null) {
                this.splitCommand = (Split)Commands.getCommand("split");
            }
            Split.executeSplit(documentView, this.splitElement, this.splitText, this.splitOffset);
            this.splitElement = null;
            this.splitText = null;
            this.splitOffset = -1;
        }
        return null;
    }
}

