/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.command;

import com.xmlmind.xmledit.command.Msg;
import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.edit.TextEditor;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.view.DocumentView;

public class Join
extends RecordableCommand {
    private Element joinElement;
    private static final String joinLabel = Msg.msg("J.join");

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        Object object;
        this.joinElement = null;
        DocumentView documentView = (DocumentView)gadget;
        MarkManager markManager = documentView.getMarkManager();
        if (markManager == null || markManager.getMark() != null || markManager.getSelected2() != null) {
            return false;
        }
        NodeMark nodeMark = markManager.getSelected();
        if (nodeMark == null) {
            if (!Join.isImplicitElement(string)) {
                return false;
            }
            object = markManager.getDot();
            if (object == null) {
                return false;
            }
            this.joinElement = ((TextLocation)object).getTextNode().getParentElement();
        } else {
            object = nodeMark.getNode();
            if (!(object instanceof Element)) {
                return false;
            }
            this.joinElement = (Element)object;
        }
        if (Join.isAfter(string)) {
            object = this.joinElement.getNextSibling();
            if (object == null || !(object instanceof Element)) {
                return false;
            }
            this.joinElement = (Element)object;
        }
        object = documentView.getTextEditor();
        return ((TextEditor)object).canJoin(this.joinElement);
    }

    private static final boolean isImplicitElement(String string) {
        return string != null && string.endsWith("[implicitElement]");
    }

    private static final boolean isAfter(String string) {
        return string != null && string.startsWith("after");
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        MarkManager markManager = documentView.getMarkManager();
        markManager.beginBatchMarking();
        TextEditor textEditor = documentView.getTextEditor();
        Node node = textEditor.join(this.joinElement);
        documentView.describeUndo(joinLabel);
        markManager.set("SELECTED", node);
        documentView.moveDotInto(node);
        markManager.endBatchMarking();
        this.joinElement = null;
        return null;
    }
}

