/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.command;

import com.xmlmind.xmledit.command.DeleteChar;
import com.xmlmind.xmledit.command.Msg;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.TextEditor;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.view.DocumentView;

public class JoinOrDeleteChar
extends DeleteChar {
    private Element joinElement = null;
    private int dotPosition = -1;
    private static final String joinLabel = Msg.msg("J.join");

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        if (this.prepareJoin((DocumentView)gadget, "backwards".equals(string))) {
            return true;
        }
        return super.prepareCommand(gadget, string, -1, -1);
    }

    private boolean prepareJoin(DocumentView documentView, boolean bl) {
        this.joinElement = null;
        this.dotPosition = -1;
        MarkManager markManager = documentView.getMarkManager();
        if (markManager == null) {
            return false;
        }
        TextLocation textLocation = markManager.getDot();
        if (textLocation == null) {
            return false;
        }
        TextNode textNode = textLocation.getTextNode();
        if (!(textNode instanceof Text)) {
            return false;
        }
        int n = textLocation.getOffset();
        if (bl && n != 0 || !bl && n != textNode.getTextLength()) {
            return false;
        }
        if (markManager.getMark() != null || markManager.getSelected() != null || markManager.getSelected2() != null) {
            return false;
        }
        TextEditor textEditor = documentView.getTextEditor();
        this.joinElement = bl ? textEditor.findJoinBefore((Text)textNode, n) : textEditor.findJoinAfter((Text)textNode, n);
        if (this.joinElement != null) {
            this.dotPosition = bl ? textLocation.getPositionFromEnd() : textLocation.getPositionFromBegin();
            return true;
        }
        return false;
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        if (this.joinElement == null) {
            super.doExecuteCommand(documentView, string, -1, -1);
        } else {
            MarkManager markManager = documentView.getMarkManager();
            markManager.beginBatchMarking();
            TextEditor textEditor = documentView.getTextEditor();
            Node node = textEditor.join(this.joinElement);
            documentView.describeUndo(joinLabel);
            markManager.remove("SELECTED");
            TextLocation textLocation = markManager.getDot();
            if (textLocation != null) {
                if ("backwards".equals(string)) {
                    textLocation.setPositionFromEnd(this.dotPosition);
                } else {
                    textLocation.setPositionFromBegin(this.dotPosition);
                }
            }
            markManager.endBatchMarking();
            this.joinElement = null;
            this.dotPosition = -1;
        }
        return null;
    }
}

