/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.command;

import com.xmlmind.xmledit.command.Operation;
import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.command.TextLineParts;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.view.TextNodeViewText;
import java.awt.Rectangle;
import java.util.HashMap;

public class MoveDotTo
extends RecordableCommand {
    public static final int PREVIOUS_CHAR = 0;
    public static final int NEXT_CHAR = 1;
    public static final int PREVIOUS_WORD = 2;
    public static final int NEXT_WORD = 3;
    public static final int PREVIOUS_TEXT_NODE = 4;
    public static final int NEXT_TEXT_NODE = 5;
    public static final int PREVIOUS_ELEMENT = 6;
    public static final int NEXT_ELEMENT = 7;
    public static final int TEXT_NODE_BEGIN = 8;
    public static final int TEXT_NODE_END = 9;
    public static final int ELEMENT_BEGIN = 10;
    public static final int ELEMENT_END = 11;
    public static final int DOCUMENT_BEGIN = 12;
    public static final int DOCUMENT_END = 13;
    public static final int LINE_BEGIN = 14;
    public static final int LINE_END = 15;
    public static final int PREVIOUS_LINE = 16;
    public static final int NEXT_LINE = 17;
    public static final int WORD_BEGIN = 18;
    public static final int WORD_END = 19;
    protected static final String[] opNames = new String[]{"previousChar", "nextChar", "previousWord", "nextWord", "previousTextNode", "nextTextNode", "previousElement", "nextElement", "textNodeBegin", "textNodeEnd", "elementBegin", "elementEnd", "documentBegin", "documentEnd", "lineBegin", "lineEnd", "previousLine", "nextLine", "wordBegin", "wordEnd"};
    protected static HashMap ops = new HashMap();
    protected static final int PREVIOUS = 0;
    protected static final int NEXT = 1;
    protected static final int BEGIN = 2;
    protected static final int END = 3;

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        DocumentView documentView = (DocumentView)gadget;
        Operation operation = null;
        if (string != null) {
            operation = (Operation)ops.get(string);
        }
        if (operation == null) {
            return false;
        }
        MarkManager markManager = documentView.getMarkManager();
        if (markManager == null) {
            return false;
        }
        TextLocation textLocation = markManager.getDot();
        return textLocation != null;
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        MarkManager markManager = documentView.getMarkManager();
        TextLocation textLocation = markManager.getDot();
        markManager.beginBatchMarking();
        markManager.remove("MARK");
        markManager.remove("SELECTED");
        markManager.remove("SELECTED2");
        int n3 = -1;
        int n4 = -1;
        Operation operation = (Operation)ops.get(string);
        switch (operation.code) {
            case 0: {
                textLocation.moveToPreviousChar();
                break;
            }
            case 1: {
                textLocation.moveToNextChar();
                break;
            }
            case 2: {
                textLocation.moveToPreviousWord();
                break;
            }
            case 3: {
                textLocation.moveToNextWord();
                break;
            }
            case 4: {
                textLocation.moveToPreviousTextNode();
                break;
            }
            case 5: {
                textLocation.moveToNextTextNode();
                break;
            }
            case 6: {
                textLocation.moveToPreviousElement();
                break;
            }
            case 7: {
                textLocation.moveToNextElement();
                break;
            }
            case 8: {
                textLocation.moveToTextNodeBegin();
                break;
            }
            case 9: {
                textLocation.moveToTextNodeEnd();
                break;
            }
            case 10: {
                textLocation.moveToElementBegin();
                break;
            }
            case 11: {
                textLocation.moveToElementEnd();
                break;
            }
            case 12: {
                textLocation.moveToDocumentBegin();
                break;
            }
            case 13: {
                textLocation.moveToDocumentEnd();
                break;
            }
            case 14: {
                this.moveDotToLine(textLocation, 2, -1, documentView);
                break;
            }
            case 15: {
                this.moveDotToLine(textLocation, 3, -1, documentView);
                break;
            }
            case 16: 
            case 17: {
                n3 = documentView.getMagicX();
                if (n3 < 0) {
                    Rectangle rectangle = documentView.modelToView(textLocation);
                    n3 = rectangle == null ? 0 : rectangle.x;
                }
                n4 = n3;
                this.moveDotToLine(textLocation, operation.code == 16 ? 0 : 1, n3, documentView);
                break;
            }
            case 18: {
                textLocation.moveToWordBegin();
                break;
            }
            case 19: {
                textLocation.moveToWordEnd();
            }
        }
        markManager.endBatchMarking();
        switch (operation.code) {
            case 16: 
            case 17: {
                documentView.setMagicX(n4);
            }
        }
        return null;
    }

    protected boolean moveDotToLine(TextLocation textLocation, int n, int n2, DocumentView documentView) {
        int n3;
        switch (n) {
            case 0: {
                n3 = 1;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
            default: {
                n3 = 0;
            }
        }
        TextLineParts textLineParts = new TextLineParts();
        int n4 = textLineParts.get(n3, textLocation.getTextNode(), textLocation.getOffset(), documentView.getDocument().documentListenerIndex(documentView));
        switch (n4) {
            case -2: 
            case -1: {
                switch (n) {
                    case 0: 
                    case 2: {
                        return textLocation.moveToPreviousTextNode();
                    }
                    case 1: 
                    case 3: {
                        return textLocation.moveToNextTextNode();
                    }
                }
                throw new RuntimeException("internal error");
            }
            case 0: {
                return false;
            }
        }
        TextLineParts.Part[] partArray = textLineParts.getParts();
        Object object = null;
        switch (n) {
            case 0: 
            case 1: {
                int n5 = Integer.MAX_VALUE;
                int n6 = 0;
                while (n6 < n4) {
                    TextLineParts.Part part = partArray[n6];
                    int n7 = 0;
                    if (n2 < part.x) {
                        n7 = part.x - n2;
                    } else if (n2 >= part.x + part.gadget.width) {
                        n7 = n2 - (part.x + part.gadget.width);
                    }
                    if (n7 == 0) {
                        object = part;
                        break;
                    }
                    if (object == null || n7 < n5) {
                        object = part;
                        n5 = n7;
                    }
                    ++n6;
                }
                int n8 = n2 - ((TextLineParts.Part)object).x;
                if (n8 < 0) {
                    n8 = 0;
                } else if (n8 >= ((TextLineParts.Part)object).gadget.width) {
                    n8 = ((TextLineParts.Part)object).gadget.width - 1;
                }
                TextNodeViewText textNodeViewText = (TextNodeViewText)((Object)((TextLineParts.Part)object).gadget);
                TextNode textNode = textNodeViewText.getTextNodeView().getTextNode();
                int n9 = textNodeViewText.gadgetToModel(n8, 0);
                return textLocation.moveTo(textNode, n9);
            }
            case 2: {
                Object object2;
                int n10 = Integer.MAX_VALUE;
                int n11 = 0;
                while (n11 < n4) {
                    object2 = partArray[n11];
                    if (((TextLineParts.Part)object2).x < n10) {
                        object = object2;
                        n10 = ((TextLineParts.Part)object2).x;
                    }
                    ++n11;
                }
                object2 = (TextNodeViewText)((Object)((TextLineParts.Part)object).gadget);
                TextNode textNode = object2.getTextNodeView().getTextNode();
                int n12 = object2.gadgetToModel(0, 0);
                return textLocation.moveTo(textNode, n12);
            }
            case 3: {
                Object object3;
                int n13 = Integer.MIN_VALUE;
                int n14 = 0;
                while (n14 < n4) {
                    object3 = partArray[n14];
                    if (((TextLineParts.Part)object3).x > n13) {
                        object = object3;
                        n13 = ((TextLineParts.Part)object3).x;
                    }
                    ++n14;
                }
                object3 = (TextNodeViewText)((Object)((TextLineParts.Part)object).gadget);
                TextNode textNode = object3.getTextNodeView().getTextNode();
                int n15 = object3.gadgetToModel(((TextLineParts.Part)object).gadget.width - 1, 0);
                return textLocation.moveTo(textNode, n15);
            }
        }
        throw new RuntimeException("internal error");
    }

    static {
        int n = 0;
        while (n < opNames.length) {
            String string = opNames[n];
            ops.put(string, new Operation(string, n));
            ++n;
        }
    }
}

