/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.command;

import com.xmlmind.xmledit.command.CommandSequence;
import com.xmlmind.xmledit.command.InsertString;
import com.xmlmind.xmledit.command.Msg;
import com.xmlmind.xmledit.command.RecordMacroEvent;
import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.edit.CommandEntry;
import com.xmlmind.xmledit.edit.CommandHistory;
import com.xmlmind.xmledit.edit.CommandHistoryEvent;
import com.xmlmind.xmledit.edit.CommandHistoryListener;
import com.xmlmind.xmledit.edit.Commands;
import com.xmlmind.xmledit.edit.UndoManager;
import com.xmlmind.xmledit.edit.UndoManagerEvent;
import com.xmlmind.xmledit.edit.UndoManagerListener;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.ShowStatus;
import com.xmlmind.xmledit.view.CommandEvent;
import com.xmlmind.xmledit.view.CommandListener;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import java.util.ArrayList;
import javax.swing.JComponent;

public class RecordMacro
extends RecordableCommand
implements CommandListener,
CommandHistoryListener,
UndoManagerListener {
    public static final int SEQUENCE_MAX_LENGTH = 20;
    private static final String STATE_PROPERTY = "com.xmlmind.xmledit.command.RecordMacro.state";
    private long expectedSerialNumber = -1L;
    private CommandEntry addedCommandEntry = null;
    private boolean markAsUndoable = false;

    private static final State getState(Gadget gadget) {
        return (State)((JComponent)gadget.getPanel()).getClientProperty(STATE_PROPERTY);
    }

    private static final void setState(Gadget gadget, State state) {
        ((JComponent)gadget.getPanel()).putClientProperty(STATE_PROPERTY, state);
    }

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        DocumentView documentView = (DocumentView)gadget;
        if (documentView.getDocument() == null) {
            return false;
        }
        State state = RecordMacro.getState(documentView);
        if ("replay".equals(string) || "view".equals(string)) {
            return state != null && state.command != null;
        }
        if ("start".equals(string)) {
            return state == null || state.command != null;
        }
        if ("stop".equals(string) || "cancel".equals(string)) {
            return state != null && state.command == null;
        }
        return "toggle".equals(string);
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        Object object;
        boolean bl = false;
        if ("replay".equals(string)) {
            object = this.replay(documentView);
        } else if ("toggle".equals(string)) {
            bl = true;
            object = this.toggle(documentView);
        } else if ("start".equals(string)) {
            bl = true;
            object = this.start(documentView);
        } else if ("stop".equals(string)) {
            bl = true;
            object = this.stop(documentView);
        } else if ("cancel".equals(string)) {
            bl = true;
            object = this.cancel(documentView, Msg.msg("RM.canceled"));
        } else {
            object = "view".equals(string) ? this.view(documentView) : Command.EXECUTION_FAILED;
        }
        if (object != Command.EXECUTION_FAILED && bl) {
            this.notifyListeners(documentView);
        }
        return object;
    }

    private void notifyListeners(DocumentView documentView) {
        RecordMacroEvent recordMacroEvent = new RecordMacroEvent(this, documentView);
        documentView.getDocument().notifyDocumentListeners(recordMacroEvent);
    }

    private Object replay(DocumentView documentView) {
        State state = RecordMacro.getState(documentView);
        if (state == null || state.command == null) {
            return Command.EXECUTION_FAILED;
        }
        if (!state.command.prepareCommand(documentView, null, -1, -1)) {
            return Command.EXECUTION_FAILED;
        }
        return state.command.executeCommand(documentView, null, -1, -1);
    }

    private Object view(DocumentView documentView) {
        State state = RecordMacro.getState(documentView);
        if (state == null || state.command == null) {
            return Command.EXECUTION_FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<command name=\"COMMAND_NAME_HERE\"\n");
        stringBuffer.append("         xmlns=\"");
        stringBuffer.append(Namespace.CONFIGURATION.getURI());
        stringBuffer.append("\">\n");
        stringBuffer.append("  <macro undoable=\"");
        stringBuffer.append(state.command.isUndoable() ? "true" : "false");
        stringBuffer.append("\"\n");
        stringBuffer.append("         repeatable=\"false\"\n");
        stringBuffer.append("         trace=\"false\">\n");
        stringBuffer.append("    <sequence>\n");
        CommandEntry[] commandEntryArray = state.command.getSequence();
        int n = 0;
        while (n < commandEntryArray.length) {
            CommandEntry commandEntry = commandEntryArray[n];
            stringBuffer.append("      <command name=\"");
            XMLUtil.escapeXML(Commands.getLabel(commandEntry.getCommand()), stringBuffer);
            stringBuffer.append('\"');
            String string = commandEntry.getParameter();
            if (string != null) {
                stringBuffer.append('\n');
                stringBuffer.append("               parameter=\"");
                XMLUtil.escapeXML(string, stringBuffer);
                stringBuffer.append('\"');
            }
            stringBuffer.append("/>\n");
            ++n;
        }
        stringBuffer.append("    </sequence>\n");
        stringBuffer.append("  </macro>\n");
        stringBuffer.append("</command>\n");
        Alert.showInfo(documentView.getPanel(), Msg.msg("RM.viewTitle"), stringBuffer.toString(), false, 25, 80);
        return null;
    }

    private Object toggle(DocumentView documentView) {
        State state = RecordMacro.getState(documentView);
        if (state == null || state.command != null) {
            return this.start(documentView);
        }
        return this.stop(documentView);
    }

    private Object start(DocumentView documentView) {
        State state = RecordMacro.getState(documentView);
        if (state != null && state.command == null) {
            return Command.EXECUTION_FAILED;
        }
        RecordMacro.setState(documentView, new State());
        documentView.addCommandListener(this);
        ShowStatus.showStatus(Msg.msg("RM.recording"));
        return null;
    }

    private Object stop(DocumentView documentView) {
        State state = RecordMacro.getState(documentView);
        if (state == null || state.command != null) {
            return Command.EXECUTION_FAILED;
        }
        this.doStop(documentView);
        int n = state.entries.size();
        if (n == 0) {
            RecordMacro.setState(documentView, null);
            ShowStatus.showStatus(Msg.msg("RM.emptyMacro"));
        } else {
            CommandEntry[] commandEntryArray = new CommandEntry[n];
            state.entries.toArray(commandEntryArray);
            state.entries = null;
            state.command = new CommandSequence(commandEntryArray, state.undoable, false, Msg.msg("RM.recordedMacro"));
            ShowStatus.showStatus(Msg.msg("RM.recorded"));
        }
        return null;
    }

    private void doStop(DocumentView documentView) {
        CommandHistory commandHistory;
        UndoManager undoManager = documentView.getUndoManager();
        if (undoManager != null) {
            undoManager.removeUndoManagerListener(this);
        }
        if ((commandHistory = documentView.getCommandHistory()) != null) {
            commandHistory.removeCommandHistoryListener(this);
        }
        documentView.removeCommandListener(this);
    }

    public static boolean isRecording(DocumentView documentView) {
        CommandListener[] commandListenerArray = documentView.getCommandListeners();
        int n = 0;
        while (n < commandListenerArray.length) {
            if (commandListenerArray[n] instanceof RecordMacro) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private Object cancel(DocumentView documentView, String string) {
        this.doStop(documentView);
        RecordMacro.setState(documentView, null);
        ShowStatus.showStatus(string);
        return null;
    }

    public boolean executingCommand(CommandEvent commandEvent) {
        DocumentView documentView = commandEvent.getSource();
        State state = RecordMacro.getState(documentView);
        if (state == null) {
            this.cancel(documentView, Msg.msg("RM.internalError"));
            this.notifyListeners(documentView);
            return true;
        }
        if (state.nesting == 0) {
            UndoManager undoManager;
            CommandHistory commandHistory = documentView.getCommandHistory();
            if (commandHistory != null) {
                this.expectedSerialNumber = commandHistory.getNextSerialNumber();
                this.addedCommandEntry = null;
                commandHistory.addCommandHistoryListener(this);
            }
            if (!state.undoable && (undoManager = documentView.getUndoManager()) != null) {
                this.markAsUndoable = false;
                undoManager.addUndoManagerListener(this);
            }
        }
        ++state.nesting;
        return true;
    }

    public void commandAdded(CommandHistoryEvent commandHistoryEvent) {
        this.addedCommandEntry = commandHistoryEvent.getEntry();
    }

    public void undoManagerChange(UndoManagerEvent undoManagerEvent) {
        this.markAsUndoable = true;
    }

    public void commandExecuted(CommandEvent commandEvent) {
        UndoManager undoManager;
        Object object;
        DocumentView documentView = commandEvent.getSource();
        State state = RecordMacro.getState(documentView);
        if (state == null) {
            return;
        }
        --state.nesting;
        if (state.nesting > 0) {
            return;
        }
        String string = null;
        if (state.entries != null && state.entries.size() >= 20) {
            string = Msg.msg("RM.tooManyRecordedCommands", Integer.toString(20));
        } else if (commandEvent.getStatus() != 3 || commandEvent.getResult() == Command.EXECUTION_FAILED) {
            string = Msg.msg("RM.commandExecutionHasFailed", RecordMacro.commandLine(commandEvent));
        } else {
            Command command = commandEvent.getCommand();
            if (command instanceof RecordMacro) {
                object = commandEvent.getParameter();
                if ("stop".equals(object) || "cancel".equals(object) || "toggle".equals(object)) {
                    return;
                }
                string = Msg.msg("RM.forbiddenCommand", RecordMacro.commandLine(commandEvent));
            } else if (command instanceof Abort) {
                string = Msg.msg("RM.forbiddenCommand", RecordMacro.commandLine(commandEvent));
            }
        }
        if (string != null) {
            this.cancel(documentView, string);
            this.notifyListeners(documentView);
            return;
        }
        boolean bl = true;
        object = documentView.getCommandHistory();
        if (object != null) {
            ((CommandHistory)object).removeCommandHistoryListener(this);
            if (this.addedCommandEntry != null && this.addedCommandEntry.getSerialNumber() == this.expectedSerialNumber) {
                state.add(this.addedCommandEntry.getCommand(), this.addedCommandEntry.getParameter());
                bl = false;
            }
            this.addedCommandEntry = null;
            this.expectedSerialNumber = -1L;
        }
        if (bl) {
            state.add(commandEvent.getCommand(), commandEvent.getParameter());
        }
        if (!state.undoable && (undoManager = documentView.getUndoManager()) != null) {
            undoManager.removeUndoManagerListener(this);
            if (this.markAsUndoable) {
                state.undoable = true;
            }
            this.markAsUndoable = false;
        }
    }

    private static String commandLine(CommandEvent commandEvent) {
        Command command = commandEvent.getCommand();
        String string = commandEvent.getParameter();
        String string2 = Commands.getLabel(command);
        if (string != null) {
            string2 = string2 + ' ' + string;
        }
        return string2;
    }

    private static final class State {
        public int nesting = 0;
        public ArrayList entries = new ArrayList();
        public boolean undoable = false;
        public CommandSequence command = null;

        private State() {
        }

        public void add(Command command, String string) {
            CommandEntry commandEntry;
            int n;
            if (command instanceof InsertString && (n = this.entries.size() - 1) >= 0 && (commandEntry = (CommandEntry)this.entries.get(n)).getCommand() instanceof InsertString) {
                commandEntry.setParameter(commandEntry.getParameter() + string);
                return;
            }
            this.entries.add(new CommandEntry(command, string));
        }
    }

    public static interface Abort {
    }
}

