/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.command;

import com.xmlmind.xmledit.command.ChooseFieldCommand;
import com.xmlmind.xmledit.command.CommandUtil;
import com.xmlmind.xmledit.command.Msg;
import com.xmlmind.xmledit.dialog.FieldChoice;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doctype.Field;
import com.xmlmind.xmledit.edit.ElementEditor;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.view.DocumentView;
import java.util.ArrayList;

public class Replace
extends ChooseFieldCommand {
    private Node child1;
    private Node child2;
    private FieldChoice choice;
    private ArrayList list = new ArrayList();
    private static final String replaceLabel = Msg.msg("R.replace");

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        Object object;
        Object object2;
        this.child1 = null;
        this.child2 = null;
        this.choice = null;
        DocumentView documentView = (DocumentView)gadget;
        MarkManager markManager = documentView.getMarkManager();
        if (markManager == null) {
            return false;
        }
        NodeMark nodeMark = markManager.getSelected();
        if (nodeMark != null) {
            object2 = markManager.getSelected2();
            if (object2 == null) {
                object2 = nodeMark;
            }
            this.child1 = nodeMark.getNode();
            this.child2 = ((NodeMark)object2).getNode();
        } else {
            object2 = markManager.getDot();
            if (object2 == null) {
                return false;
            }
            object = markManager.getMark();
            if (object != null && (((TextLocation)object).getTextNode() != ((TextLocation)object2).getTextNode() || ((TextLocation)object).getOffset() != ((TextLocation)object2).getOffset())) {
                return false;
            }
            if (Replace.isImplicitNode(string)) {
                this.child1 = this.child2 = ((TextLocation)object2).getTextNode();
            } else if (Replace.isImplicitElement(string)) {
                this.child1 = this.child2 = ((TextLocation)object2).getTextNode().getParentElement();
            } else {
                return false;
            }
        }
        object2 = this.child1.getParentElement();
        if (object2 == null) {
            return false;
        }
        object = documentView.getElementEditor();
        ((ElementEditor)object).editElement((Element)object2);
        String string2 = null;
        if (string != null && (string2 = Replace.getOperand(string)) != null && !CommandUtil.specifiesFieldChoice(string2)) {
            string2 = null;
        }
        if (string2 == null) {
            return ((ElementEditor)object).canReplace(this.child1, this.child2);
        }
        int n3 = ((ElementEditor)object).canReplace(this.child1, this.child2, this.list);
        if (n3 == 0) {
            return false;
        }
        this.choice = CommandUtil.parseFieldChoice(string2, this.list, n3 == 2, true, (Element)object2);
        return this.choice != null;
    }

    private static final boolean isImplicitNode(String string) {
        return string != null && string.startsWith("[implicitNode]");
    }

    private static final boolean isImplicitElement(String string) {
        return string != null && string.startsWith("[implicitElement]");
    }

    private static final String getOperand(String string) {
        int n = string.lastIndexOf(93);
        String string2 = n < 0 ? string : string.substring(n + 1);
        if ((string2 = string2.trim()).length() == 0) {
            string2 = null;
        }
        return string2;
    }

    public FieldChoice getPreparedFieldChoice() {
        return this.choice;
    }

    public ChooseFieldCommand.FieldChoices getFieldChoices(DocumentView documentView, String string, boolean bl, boolean bl2) {
        ElementEditor elementEditor = documentView.getElementEditor();
        int n = elementEditor.canReplace(this.child1, this.child2, this.list);
        if (n == 0) {
            return null;
        }
        Field[] fieldArray = this.list.toArray(ChooseFieldCommand.NO_FIELDS);
        Element element = elementEditor.getEditedElement();
        FieldChoice[] fieldChoiceArray = FieldChoice.list(fieldArray, n == 2, bl, bl2, element);
        return new ChooseFieldCommand.FieldChoices(replaceLabel, fieldChoiceArray, element);
    }

    protected void doExecuteCommand(DocumentView documentView, String string, FieldChoice fieldChoice) {
        Node node;
        ElementEditor elementEditor = documentView.getElementEditor();
        MarkManager markManager = documentView.getMarkManager();
        markManager.beginBatchMarking();
        if (fieldChoice.name != null) {
            node = elementEditor.replace(this.child1, this.child2, fieldChoice.field, fieldChoice.name);
        } else if (fieldChoice.text) {
            node = new Text();
            elementEditor.replace(this.child1, this.child2, node);
        } else {
            node = elementEditor.replace(this.child1, this.child2, fieldChoice.field, fieldChoice.template);
        }
        documentView.describeUndo(replaceLabel);
        documentView.addToCommandHistory(this, this.makeParameter(string, fieldChoice), replaceLabel);
        markManager.remove("SELECTED2");
        markManager.remove("MARK");
        markManager.set("SELECTED", node);
        documentView.moveDotInto(node);
        markManager.endBatchMarking();
    }

    protected String makeParameter(String string, FieldChoice fieldChoice) {
        StringBuffer stringBuffer = new StringBuffer();
        if (Replace.isImplicitElement(string)) {
            stringBuffer.append("[implicitElement] ");
        } else if (Replace.isImplicitNode(string)) {
            stringBuffer.append("[implicitNode] ");
        }
        stringBuffer.append(CommandUtil.formatFieldChoice(fieldChoice));
        return stringBuffer.toString();
    }

    public void resetCommand() {
        this.child1 = null;
        this.child2 = null;
        this.choice = null;
        this.list.clear();
    }
}

