/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.command;

import com.xmlmind.xmledit.command.CommandUtil;
import com.xmlmind.xmledit.command.RecordMacro;
import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.edit.TextOffset;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.view.DocumentView;

public class SelectAt
extends RecordableCommand
implements RecordMacro.Abort {
    private boolean extendingSelection;
    private boolean updateSystemSelection;
    private TextOffset textOffset = new TextOffset();

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        this.textOffset.text = null;
        DocumentView documentView = (DocumentView)gadget;
        return documentView.getDocument() != null;
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        MarkManager markManager = documentView.getMarkManager();
        TextLocation textLocation = markManager.getDot();
        if (textLocation == null) {
            if ("begin".equals(string)) {
                documentView.executeCommand("selectNodeAt", null, n, n2);
            }
            return null;
        }
        if ("begin".equals(string)) {
            this.extendingSelection = false;
            this.updateSystemSelection = false;
            if (!documentView.pickText(n, n2, this.textOffset)) {
                return null;
            }
            markManager.beginBatchMarking();
            markManager.remove("MARK");
            markManager.remove("SELECTED");
            markManager.remove("SELECTED2");
            textLocation.moveTo(this.textOffset.text, this.textOffset.offset);
            markManager.endBatchMarking();
            this.extendingSelection = true;
        } else if ("extend".equals(string)) {
            if (this.extendingSelection) {
                this.selectTo(documentView, markManager, textLocation, n, n2);
            }
        } else if ("end".equals(string)) {
            if (this.extendingSelection) {
                this.extendingSelection = false;
                if (this.updateSystemSelection) {
                    this.updateSystemSelection = false;
                    CommandUtil.updateSystemSelection(documentView, markManager.getMark(), textLocation);
                    markManager.notifyContextChangeListeners();
                }
            } else {
                documentView.executeCommand("selectNodeAt", null, n, n2);
            }
        } else {
            this.extendingSelection = false;
            this.updateSystemSelection = false;
            this.selectTo(documentView, markManager, textLocation, n, n2);
            if (this.updateSystemSelection) {
                this.updateSystemSelection = false;
                CommandUtil.updateSystemSelection(documentView, markManager.getMark(), textLocation);
                markManager.notifyContextChangeListeners();
            }
        }
        return null;
    }

    private void selectTo(DocumentView documentView, MarkManager markManager, TextLocation textLocation, int n, int n2) {
        if (!documentView.pickText(n, n2, this.textOffset)) {
            return;
        }
        markManager.beginBatchMarking();
        TextLocation textLocation2 = markManager.getMark();
        if (textLocation2 == null) {
            markManager.remove("SELECTED");
            markManager.remove("SELECTED2");
            textLocation2 = markManager.add("MARK", textLocation.getTextNode(), textLocation.getOffset());
        }
        textLocation.moveTo(this.textOffset.text, this.textOffset.offset);
        if (textLocation2.getTextNode() == textLocation.getTextNode() && textLocation2.getOffset() == textLocation.getOffset()) {
            textLocation2.remove();
        }
        markManager.endBatchMarking();
        this.updateSystemSelection = true;
    }
}

