/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.command;

import com.xmlmind.xmledit.command.Msg;
import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doctype.AttributeType;
import com.xmlmind.xmledit.doctype.DataType;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.DocumentTypeUtil;
import com.xmlmind.xmledit.doctype.Field;
import com.xmlmind.xmledit.edit.ElementEditor;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.edit.StructureInfo;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.guiutil.ItemChooserDialog;
import com.xmlmind.xmledit.guiutil.ShowStatus;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xsd.datatype.IDREFSType;
import com.xmlmind.xmledit.xsd.datatype.IDREFType;
import com.xmlmind.xmledit.xsd.datatype.IDType;
import java.awt.Rectangle;

public class SelectById
extends RecordableCommand {
    private static final int ID = 0;
    private static final int REFERENCE = 1;
    private static final int NEXT_REFERENCE = 2;
    private static final int PREVIOUS_REFERENCE = 3;
    private static final int SWAP_ID_AND_REFERENCE = 4;
    private int op;
    private String searched;
    private Element startElement;
    private String id;
    private String[] idRefs;

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        this.searched = null;
        this.startElement = null;
        this.id = null;
        this.idRefs = null;
        DocumentView documentView = (DocumentView)gadget;
        MarkManager markManager = documentView.getMarkManager();
        if (markManager == null) {
            return false;
        }
        if (string == null) {
            return false;
        }
        if (string.startsWith("id")) {
            this.op = 0;
        } else if (string.startsWith("reference")) {
            this.op = 1;
        } else if (string.startsWith("nextReference")) {
            this.op = 2;
        } else if (string.startsWith("previousReference")) {
            this.op = 3;
        } else if (string.startsWith("swapIdAndReference")) {
            this.op = 4;
        } else {
            return false;
        }
        ElementEditor elementEditor = documentView.getElementEditor();
        DocumentType documentType = elementEditor.getDocumentType();
        if (!DocumentTypeUtil.isConstrainedDocumentType(documentType)) {
            return false;
        }
        int n3 = string.indexOf(32);
        if (n3 >= 0 && n3 + 1 < string.length()) {
            this.searched = string.substring(n3 + 1).trim();
            if (this.searched.length() == 0) {
                this.searched = null;
            }
        }
        if (this.searched == null) {
            Object object;
            NodeMark nodeMark = markManager.getSelected();
            if (nodeMark != null) {
                object = markManager.getSelected2();
                if (object != null) {
                    return false;
                }
                this.startElement = nodeMark.getNode() instanceof Element ? (Element)nodeMark.getNode() : nodeMark.getNode().getParentElement();
            } else {
                object = markManager.getDot();
                TextLocation textLocation = markManager.getMark();
                if (object != null) {
                    if (textLocation != null && (textLocation.getTextNode() != ((TextLocation)object).getTextNode() || textLocation.getOffset() != ((TextLocation)object).getOffset())) {
                        return false;
                    }
                    this.startElement = ((TextLocation)object).getTextNode().getParentElement();
                } else {
                    return false;
                }
            }
            elementEditor.editElement(this.startElement);
            object = elementEditor.getEditedElementStructureInfo();
            int n4 = ((StructureInfo)object).structure.attributeFieldCount;
            int n5 = 0;
            while (n5 < n4) {
                Field field = ((StructureInfo)object).structure.attributeFields[n5];
                Name name = ((StructureInfo)object).structure.attributeNames[n5];
                AttributeType attributeType = ((StructureInfo)object).elementType.getAttributeType(field, name);
                if (attributeType != null) {
                    String[] stringArray;
                    DataType dataType = attributeType.getAttributeDataType();
                    if (dataType instanceof IDType) {
                        this.id = dataType.normalizeWhiteSpace(this.startElement.getAttribute(name));
                        if (this.id.length() == 0) {
                            this.id = null;
                        }
                    } else if ((dataType instanceof IDREFType || dataType instanceof IDREFSType) && (stringArray = XMLUtil.splitList(this.startElement.getAttribute(name))).length > 0) {
                        if (this.idRefs == null) {
                            this.idRefs = stringArray;
                        } else {
                            String[] stringArray2 = new String[this.idRefs.length + stringArray.length];
                            System.arraycopy(this.idRefs, 0, stringArray2, 0, this.idRefs.length);
                            System.arraycopy(stringArray, 0, stringArray2, this.idRefs.length, stringArray.length);
                            this.idRefs = stringArray2;
                        }
                    }
                }
                ++n5;
            }
        }
        switch (this.op) {
            case 0: {
                if (this.searched != null || this.idRefs != null) break;
                return false;
            }
            case 1: {
                if (this.searched != null || this.id != null) break;
                return false;
            }
            case 2: 
            case 3: {
                if (this.searched == null && this.idRefs != null) break;
                return false;
            }
            case 4: {
                if (this.searched == null && (this.id != null || this.idRefs != null)) break;
                return false;
            }
        }
        return true;
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        if (this.searched == null) {
            switch (this.op) {
                case 1: {
                    this.searched = this.id;
                    break;
                }
                case 0: 
                case 2: 
                case 3: {
                    this.searched = SelectById.selectIdRef(documentView, this.idRefs);
                    break;
                }
                case 4: {
                    if (this.id != null) {
                        this.op = 1;
                        this.searched = this.id;
                        break;
                    }
                    this.op = 0;
                    this.searched = SelectById.selectIdRef(documentView, this.idRefs);
                }
            }
        }
        if (this.searched != null) {
            Object object;
            Document document = documentView.getDocument();
            DocumentType documentType = documentView.getElementEditor().getDocumentType();
            Element element = null;
            if (this.op == 0) {
                element = documentType.findElementById(document.getRootElement(), this.searched, false);
            } else {
                object = DocumentTypeUtil.getIdRefs(document, this.searched, documentType);
                switch (this.op) {
                    case 1: {
                        if (((Element[])object).length <= 0) break;
                        element = object[0];
                        break;
                    }
                    case 2: 
                    case 3: {
                        int n3 = -1;
                        int n4 = 0;
                        while (n4 < ((Element[])object).length) {
                            if (object[n4] == this.startElement) {
                                n3 = n4;
                                break;
                            }
                            ++n4;
                        }
                        if (n3 < 0) break;
                        if (this.op == 2 && n3 + 1 < ((Element[])object).length) {
                            element = object[n3 + 1];
                            break;
                        }
                        if (this.op != 3 || n3 - 1 < 0) break;
                        element = object[n3 - 1];
                    }
                }
            }
            if (element != null) {
                documentView.selectNode(element);
                documentView.ensureViewIsExpanded(element);
                object = documentView.modelToView(element);
                if (object != null) {
                    documentView.makeRectangleVisible((Rectangle)object);
                }
            } else {
                switch (this.op) {
                    case 0: {
                        ShowStatus.showStatus(Msg.msg("SBI.referenceToUndefinedId", this.searched));
                        break;
                    }
                    case 1: {
                        ShowStatus.showStatus(Msg.msg("SBI.idNotReferenced", this.searched));
                        break;
                    }
                    case 2: {
                        ShowStatus.showStatus(Msg.msg("SBI.noNextIdReference", this.searched));
                        break;
                    }
                    case 3: {
                        ShowStatus.showStatus(Msg.msg("SBI.noPreviousIdReference", this.searched));
                    }
                }
            }
        }
        this.searched = null;
        this.startElement = null;
        this.id = null;
        this.idRefs = null;
        return null;
    }

    private static final String selectIdRef(DocumentView documentView, String[] stringArray) {
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        ItemChooserDialog itemChooserDialog = new ItemChooserDialog(documentView.getPanel(), Msg.msg("SBI.selectId"), 10, 40);
        itemChooserDialog.setSingleClick(true);
        return (String)itemChooserDialog.chooseItem(stringArray);
    }
}

