/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.command;

import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.Name;
import java.util.StringTokenizer;

public class SelectNode
extends RecordableCommand {
    private static final int PARENT = 0;
    private static final int CHILD = 1;
    private static final int CHILDREN = 2;
    private static final int PREVIOUS_SIBLING = 3;
    private static final int NEXT_SIBLING = 4;
    private static final int FIRST_SIBLING = 5;
    private static final int LAST_SIBLING = 6;
    private static final int ANCESTOR = 7;
    private static final int ANCESTOR_OR_SELF = 8;
    private static final int SELF = 9;
    private static final int DESCENDANT = 10;
    private static final int DESCENDANT_OR_SELF = 11;
    private static final int PRECEDING = 12;
    private static final int PRECEDING_OR_SELF = 13;
    private static final int FOLLOWING = 14;
    private static final int FOLLOWING_OR_SELF = 15;
    private static final int EXTEND_TO_PREVIOUS_SIBLING = 16;
    private static final int EXTEND_TO_NEXT_SIBLING = 17;
    private static final int FIRST_CHILD = 18;
    private static final int LAST_CHILD = 19;
    private static final int EXPLICIT = 0;
    private static final int IMPLICIT_NODE = 1;
    private static final int IMPLICIT_ELEMENT = 2;
    private static final int NO_ALTERNATIVE = 0;
    private static final int OR_NODE = 1;
    private static final int OR_ELEMENT = 2;
    private static final int OR_NONE = 3;
    private Node fromSelectedNode;
    private Node selectedNode;
    private Node selected2Node;
    private ParsedParameter parsedParam = new ParsedParameter();

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        this.fromSelectedNode = null;
        this.selectedNode = null;
        this.selected2Node = null;
        DocumentView documentView = (DocumentView)gadget;
        MarkManager markManager = documentView.getMarkManager();
        if (markManager == null) {
            return false;
        }
        if (!SelectNode.parseParameter(string, this.parsedParam)) {
            return false;
        }
        NodeMark nodeMark = markManager.getSelected();
        TextLocation textLocation = markManager.getDot();
        Node node = null;
        if (nodeMark != null) {
            node = nodeMark.getNode();
        } else {
            if (textLocation == null) {
                return false;
            }
            switch (this.parsedParam.implicit) {
                case 2: {
                    node = textLocation.getTextNode().getParentElement();
                    break;
                }
                case 1: {
                    node = textLocation.getTextNode();
                }
            }
        }
        if (node == null) {
            switch (this.parsedParam.alternative) {
                case 2: {
                    if (textLocation == null) break;
                    this.selectedNode = textLocation.getTextNode().getParentElement();
                    return true;
                }
                case 1: {
                    if (textLocation == null) break;
                    this.selectedNode = textLocation.getTextNode();
                    return true;
                }
            }
            return false;
        }
        if (this.doPrepareCommand(markManager, nodeMark, textLocation, node)) {
            return true;
        }
        return this.parsedParam.alternative == 3 && nodeMark != null;
    }

    private boolean doPrepareCommand(MarkManager markManager, NodeMark nodeMark, TextLocation textLocation, Node node) {
        switch (this.parsedParam.command) {
            case 0: {
                Element element = node.getParentElement();
                if (element == null || !SelectNode.accept(element, this.parsedParam)) {
                    return false;
                }
                this.selectedNode = element;
                this.fromSelectedNode = node;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                Element element = !(node instanceof Element) ? node.getParentElement() : (Element)node;
                if (this.parsedParam.command == 7 && element != null) {
                    element = element.getParentElement();
                }
                while (element != null) {
                    if (SelectNode.accept(element, this.parsedParam)) {
                        this.selectedNode = element;
                        break;
                    }
                    if (this.parsedParam.command == 9) break;
                    element = element.getParentElement();
                }
                if (this.selectedNode == null) {
                    return false;
                }
                this.fromSelectedNode = node;
                break;
            }
            case 3: 
            case 4: {
                Node node2 = node.getParentElement() != null ? (this.parsedParam.command == 3 ? node.getPreviousSibling() : node.getNextSibling()) : null;
                if (node2 == null || !SelectNode.accept(node2, this.parsedParam)) {
                    return false;
                }
                this.selectedNode = node2;
                break;
            }
            case 16: 
            case 17: {
                Node node3;
                NodeMark nodeMark2 = markManager.getSelected2();
                Node node4 = node3 = nodeMark2 == null ? node : nodeMark2.getNode();
                Node node5 = node3.getParentElement() != null ? (this.parsedParam.command == 16 ? node3.getPreviousSibling() : node3.getNextSibling()) : null;
                if (node5 == null || !SelectNode.accept(node5, this.parsedParam)) {
                    return false;
                }
                this.selectedNode = node;
                this.selected2Node = node5;
                if (this.selected2Node != this.selectedNode) break;
                this.selected2Node = null;
                break;
            }
            case 5: 
            case 6: {
                Node node6;
                if (node.getParentElement() != null) {
                    node6 = this.parsedParam.command == 5 ? node.getFirstSibling() : node.getLastSibling();
                    if (node6 == null) {
                        node6 = node;
                    }
                } else {
                    node6 = node;
                }
                if (!SelectNode.accept(node6, this.parsedParam)) {
                    return false;
                }
                this.selectedNode = node6;
                break;
            }
            case 12: 
            case 13: {
                Node node7 = node;
                if (this.parsedParam.command == 12) {
                    node7 = node.getParentElement() != null ? node7.getPreviousSibling() : null;
                }
                while (node7 != null) {
                    if (SelectNode.accept(node7, this.parsedParam)) break;
                    node7 = node7.getPreviousSibling();
                }
                if (node7 == null) {
                    return false;
                }
                this.selectedNode = node7;
                break;
            }
            case 14: 
            case 15: {
                Node node8 = node;
                if (this.parsedParam.command == 14) {
                    node8 = node.getParentElement() != null ? node8.getNextSibling() : null;
                }
                while (node8 != null) {
                    if (SelectNode.accept(node8, this.parsedParam)) break;
                    node8 = node8.getNextSibling();
                }
                if (node8 == null) {
                    return false;
                }
                this.selectedNode = node8;
                break;
            }
            case 2: {
                if (!(node instanceof Element)) {
                    return false;
                }
                Element element = (Element)node;
                if (element.hasNoChildren()) {
                    return false;
                }
                Node node9 = element.getFirstChild();
                while (node9 != null) {
                    if (!SelectNode.accept(node9, this.parsedParam)) {
                        return false;
                    }
                    node9 = node9.getNextSibling();
                }
                this.selectedNode = element.getFirstChild();
                this.selected2Node = element.getLastChild();
                if (this.selected2Node != this.selectedNode) break;
                this.selected2Node = null;
                break;
            }
            case 18: 
            case 19: {
                Node node10;
                if (!(node instanceof Element)) {
                    return false;
                }
                Element element = (Element)node;
                Node node11 = node10 = this.parsedParam.command == 18 ? element.getFirstChild() : element.getLastChild();
                if (node10 == null || !SelectNode.accept(node10, this.parsedParam)) {
                    return false;
                }
                this.selectedNode = node10;
                break;
            }
            case 1: {
                Node node12 = nodeMark != null && node == nodeMark.getNode() ? nodeMark.getPreviouslyMarkedChild(0) : null;
                if (node12 == null && node instanceof Element) {
                    node12 = ((Element)node).getFirstChild();
                }
                if (node12 == null || !SelectNode.accept(node12, this.parsedParam)) {
                    return false;
                }
                this.selectedNode = node12;
                this.fromSelectedNode = node;
                break;
            }
            case 11: {
                if (SelectNode.accept(node, this.parsedParam)) {
                    this.selectedNode = this.fromSelectedNode = node;
                    break;
                }
            }
            case 10: {
                Node node13 = node;
                if (nodeMark != null && node == nodeMark.getNode()) {
                    int n = nodeMark.getPreviouslyMarkedChildCount();
                    int n2 = 0;
                    while (n2 < n) {
                        node13 = nodeMark.getPreviouslyMarkedChild(n2);
                        if (SelectNode.accept(node13, this.parsedParam)) {
                            this.selectedNode = node13;
                            break;
                        }
                        ++n2;
                    }
                }
                if (this.selectedNode == null) {
                    while (node13 instanceof Element) {
                        if ((node13 = ((Element)node13).getFirstChild()) == null) break;
                        if (!SelectNode.accept(node13, this.parsedParam)) continue;
                        this.selectedNode = node13;
                        break;
                    }
                }
                if (this.selectedNode == null) {
                    return false;
                }
                this.fromSelectedNode = node;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static final boolean parseParameter(String string, ParsedParameter parsedParameter) {
        int n;
        if (string == null) {
            return false;
        }
        if (string.startsWith("parent")) {
            parsedParameter.command = 0;
            n = 6;
        } else if (string.startsWith("children")) {
            parsedParameter.command = 2;
            n = 8;
        } else if (string.startsWith("child")) {
            parsedParameter.command = 1;
            n = 5;
        } else if (string.startsWith("previousSibling")) {
            parsedParameter.command = 3;
            n = 15;
        } else if (string.startsWith("nextSibling")) {
            parsedParameter.command = 4;
            n = 11;
        } else if (string.startsWith("firstSibling")) {
            parsedParameter.command = 5;
            n = 12;
        } else if (string.startsWith("lastSibling")) {
            parsedParameter.command = 6;
            n = 11;
        } else if (string.startsWith("ancestorOrSelf")) {
            parsedParameter.command = 8;
            n = 14;
        } else if (string.startsWith("ancestor")) {
            parsedParameter.command = 7;
            n = 8;
        } else if (string.startsWith("self")) {
            parsedParameter.command = 9;
            n = 4;
        } else if (string.startsWith("descendantOrSelf")) {
            parsedParameter.command = 11;
            n = 16;
        } else if (string.startsWith("descendant")) {
            parsedParameter.command = 10;
            n = 10;
        } else if (string.startsWith("precedingOrSelf")) {
            parsedParameter.command = 13;
            n = 15;
        } else if (string.startsWith("preceding")) {
            parsedParameter.command = 12;
            n = 9;
        } else if (string.startsWith("followingOrSelf")) {
            parsedParameter.command = 15;
            n = 15;
        } else if (string.startsWith("following")) {
            parsedParameter.command = 14;
            n = 9;
        } else if (string.startsWith("extendToPreviousSibling")) {
            parsedParameter.command = 16;
            n = 23;
        } else if (string.startsWith("extendToNextSibling")) {
            parsedParameter.command = 17;
            n = 19;
        } else if (string.startsWith("firstChild")) {
            parsedParameter.command = 18;
            n = 10;
        } else if (string.startsWith("lastChild")) {
            parsedParameter.command = 19;
            n = 9;
        } else {
            return false;
        }
        if (string.indexOf("OrNode", n) == n) {
            parsedParameter.alternative = 1;
            n += 6;
        } else if (string.indexOf("OrElement", n) == n) {
            parsedParameter.alternative = 2;
            n += 9;
        } else if (string.indexOf("OrNone", n) == n) {
            parsedParameter.alternative = 3;
            n += 6;
        } else {
            parsedParameter.alternative = 0;
        }
        if (string.indexOf("[implicitElement]", n) == n) {
            parsedParameter.implicit = 2;
            n += 17;
        } else if (string.indexOf("[implicitNode]", n) == n) {
            parsedParameter.implicit = 1;
            n += 14;
        } else {
            parsedParameter.implicit = 0;
        }
        if (n < string.length()) {
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n));
            int n2 = stringTokenizer.countTokens();
            if (n2 == 0) {
                parsedParameter.acceptAll = true;
            } else {
                parsedParameter.acceptAll = false;
                parsedParameter.acceptText = false;
                parsedParameter.acceptComment = false;
                parsedParameter.acceptPI = false;
                parsedParameter.acceptedNames = new Name[n2];
                parsedParameter.acceptedNameCount = 0;
                int n3 = 0;
                while (n3 < n2) {
                    String string2 = stringTokenizer.nextToken();
                    Name name = Name.fromString(string2);
                    if (name != null) {
                        parsedParameter.acceptedNames[parsedParameter.acceptedNameCount++] = name;
                    } else if ("#text".equals(string2)) {
                        parsedParameter.acceptText = true;
                    } else if ("#comment".equals(string2)) {
                        parsedParameter.acceptComment = true;
                    } else if ("#processing-instruction".equals(string2)) {
                        parsedParameter.acceptPI = true;
                    } else {
                        return false;
                    }
                    ++n3;
                }
            }
        } else {
            parsedParameter.acceptAll = true;
        }
        return true;
    }

    private static final boolean accept(Node node, ParsedParameter parsedParameter) {
        if (parsedParameter.acceptAll) {
            return true;
        }
        switch (node.getNodeType()) {
            case 0: {
                if (!parsedParameter.acceptText) break;
                return true;
            }
            case 1: {
                if (!parsedParameter.acceptComment) break;
                return true;
            }
            case 2: {
                if (!parsedParameter.acceptPI) break;
                return true;
            }
            case 4: {
                Name name = ((Element)node).getName();
                Name[] nameArray = parsedParameter.acceptedNames;
                int n = parsedParameter.acceptedNameCount;
                int n2 = 0;
                while (n2 < n) {
                    Name name2 = nameArray[n2];
                    if (name == name2) {
                        return true;
                    }
                    ++n2;
                }
                break;
            }
        }
        return false;
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        MarkManager markManager = documentView.getMarkManager();
        markManager.beginBatchMarking();
        markManager.remove("MARK");
        if (this.fromSelectedNode != null) {
            markManager.remove("SELECTED2");
            block0 : switch (this.parsedParam.command) {
                case 1: 
                case 10: 
                case 11: {
                    NodeMark nodeMark = markManager.set("SELECTED", this.fromSelectedNode);
                    while (this.fromSelectedNode != this.selectedNode) {
                        if (!nodeMark.moveToChild()) break block0;
                        this.fromSelectedNode = nodeMark.getNode();
                    }
                    break;
                }
                default: {
                    NodeMark nodeMark = markManager.set("SELECTED", this.fromSelectedNode);
                    while (this.fromSelectedNode != this.selectedNode) {
                        if (!nodeMark.moveToParent()) break block0;
                        this.fromSelectedNode = nodeMark.getNode();
                    }
                    break block0;
                }
            }
            documentView.ensureDotIsInside(this.selectedNode);
        } else if (this.selected2Node != null) {
            markManager.set("SELECTED", this.selectedNode);
            markManager.set("SELECTED2", this.selected2Node);
            documentView.ensureDotIsInside(this.selected2Node);
        } else {
            markManager.remove("SELECTED2");
            if (this.selectedNode != null) {
                markManager.set("SELECTED", this.selectedNode);
                documentView.ensureDotIsInside(this.selectedNode);
            } else {
                markManager.remove("SELECTED");
            }
        }
        markManager.endBatchMarking();
        this.fromSelectedNode = null;
        this.selectedNode = null;
        this.selected2Node = null;
        return null;
    }

    private static final class ParsedParameter {
        public int command;
        public int implicit;
        public int alternative;
        public boolean acceptAll;
        public boolean acceptText;
        public boolean acceptComment;
        public boolean acceptPI;
        public Name[] acceptedNames;
        public int acceptedNameCount;

        private ParsedParameter() {
        }
    }
}

