/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.command;

import com.xmlmind.xmledit.command.Msg;
import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.edit.TextEditor;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.view.DocumentView;

public class Split
extends RecordableCommand {
    private Element splitElement = null;
    private TextNode splitText = null;
    private int splitOffset = -1;
    private static final String splitLabel = Msg.msg("S.split");

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        Object object;
        this.splitElement = null;
        this.splitText = null;
        this.splitOffset = -1;
        DocumentView documentView = (DocumentView)gadget;
        MarkManager markManager = documentView.getMarkManager();
        if (markManager == null || markManager.getMark() != null || markManager.getSelected2() != null) {
            return false;
        }
        TextLocation textLocation = markManager.getDot();
        if (textLocation == null) {
            return false;
        }
        this.splitText = textLocation.getTextNode();
        this.splitOffset = textLocation.getOffset();
        NodeMark nodeMark = markManager.getSelected();
        if (nodeMark == null) {
            if (!"[implicitElement]".equals(string)) {
                return false;
            }
            this.splitElement = this.splitText.getParentElement();
        } else {
            object = nodeMark.getNode();
            if (!(object instanceof Element)) {
                return false;
            }
            this.splitElement = (Element)object;
        }
        object = documentView.getTextEditor();
        return ((TextEditor)object).canSplit(this.splitElement, this.splitText);
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        Split.executeSplit(documentView, this.splitElement, this.splitText, this.splitOffset);
        this.splitElement = null;
        this.splitText = null;
        this.splitOffset = -1;
        return null;
    }

    public static final void executeSplit(DocumentView documentView, Element element, TextNode textNode, int n) {
        MarkManager markManager = documentView.getMarkManager();
        markManager.beginBatchMarking();
        TextEditor textEditor = documentView.getTextEditor();
        Element element2 = textEditor.split(element, textNode, n);
        documentView.describeUndo(splitLabel);
        markManager.remove("SELECTED");
        documentView.moveDotInto(element2);
        markManager.endBatchMarking();
    }
}

