/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.command;

import com.xmlmind.xmledit.doc.Comment;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.RootGadget;
import com.xmlmind.xmledit.view.GadgetListImpl;
import com.xmlmind.xmledit.view.RectangleList;
import com.xmlmind.xmledit.view.TextNodeView;
import com.xmlmind.xmledit.view.TextNodeViewText;
import java.awt.Point;
import java.awt.Rectangle;

public class TextLineParts
implements Traversal.Handler,
RectangleList {
    public static final int CURRENT = 0;
    public static final int PREVIOUS = 1;
    public static final int NEXT = 2;
    public static final int NO_TEXT_NODE_VIEW = -2;
    public static final int NO_TEXT_NODE_VIEW_TEXT = -1;
    private Part[] parts = new Part[0];
    private int partCount = 0;
    private Rectangle bounds = new Rectangle();
    private int rootWidth;
    private int rootHeight;
    private int viewIndex;
    private GadgetListImpl gadgetList = new GadgetListImpl();
    private GadgetListImpl gadgetList2 = new GadgetListImpl();
    private Point point = new Point();
    private boolean crossLine;
    private boolean backwards;

    public int get(int n, TextNode textNode, int n2, int n3) {
        Gadget gadget;
        this.bounds.height = 0;
        this.bounds.width = 0;
        this.bounds.y = 0;
        this.bounds.x = 0;
        this.partCount = 0;
        TextNodeView textNodeView = (TextNodeView)textNode.getDocumentListenerData(n3);
        if (textNodeView == null) {
            return -2;
        }
        this.gadgetList.removeAll();
        textNodeView.getTextGadgets(this.gadgetList, n3);
        int n4 = -1;
        int n5 = 0;
        while (n5 < this.gadgetList.size) {
            gadget = this.gadgetList.list[n5];
            if (gadget instanceof TextNodeViewText && ((TextNodeViewText)((Object)gadget)).modelToGadget(n2, 0, this) > 0) {
                n4 = n5;
                break;
            }
            ++n5;
        }
        if (n4 < 0) {
            return -1;
        }
        gadget = this.gadgetList.list[0].getRoot();
        this.rootWidth = ((RootGadget)gadget).width;
        this.rootHeight = ((RootGadget)gadget).height;
        this.viewIndex = n3;
        switch (n) {
            case 1: {
                this.crossLine = false;
                n5 = n4;
                while (n5 < this.gadgetList.size) {
                    if (!this.processGadget(this.gadgetList.list[n5])) break;
                    ++n5;
                }
                if (n5 >= this.gadgetList.size) {
                    this.backwards = false;
                    Traversal.traverseAfter(textNode, this);
                }
                this.crossLine = true;
                n5 = n4 - 1;
                while (n5 >= 0) {
                    if (!this.processGadget(this.gadgetList.list[n5])) break;
                    --n5;
                }
                if (n5 < 0) {
                    this.backwards = true;
                    Traversal.traverseBefore(textNode, this);
                }
                if (!this.crossLine) break;
                this.bounds.height = 0;
                this.bounds.width = 0;
                this.bounds.y = 0;
                this.bounds.x = 0;
                this.partCount = 0;
                break;
            }
            case 2: {
                this.crossLine = false;
                n5 = n4;
                while (n5 >= 0) {
                    if (!this.processGadget(this.gadgetList.list[n5])) break;
                    --n5;
                }
                if (n5 < 0) {
                    this.backwards = true;
                    Traversal.traverseBefore(textNode, this);
                }
                this.crossLine = true;
                n5 = n4 + 1;
                while (n5 < this.gadgetList.size) {
                    if (!this.processGadget(this.gadgetList.list[n5])) break;
                    ++n5;
                }
                if (n5 >= this.gadgetList.size) {
                    this.backwards = false;
                    Traversal.traverseAfter(textNode, this);
                }
                if (!this.crossLine) break;
                this.bounds.height = 0;
                this.bounds.width = 0;
                this.bounds.y = 0;
                this.bounds.x = 0;
                this.partCount = 0;
                break;
            }
            default: {
                this.crossLine = false;
                n5 = n4;
                while (n5 < this.gadgetList.size) {
                    if (!this.processGadget(this.gadgetList.list[n5])) break;
                    ++n5;
                }
                if (n5 >= this.gadgetList.size) {
                    this.backwards = false;
                    Traversal.traverseAfter(textNode, this);
                }
                n5 = n4 - 1;
                while (n5 >= 0) {
                    if (!this.processGadget(this.gadgetList.list[n5])) break;
                    --n5;
                }
                if (n5 >= 0) break;
                this.backwards = true;
                Traversal.traverseBefore(textNode, this);
            }
        }
        return this.partCount;
    }

    private boolean processGadget(Gadget gadget) {
        if (!(gadget instanceof TextNodeViewText)) {
            return true;
        }
        this.point.y = 0;
        this.point.x = 0;
        gadget.gadgetToRoot(this.point);
        if (this.point.x >= this.rootWidth || this.point.y >= this.rootHeight || this.point.x + gadget.width <= 0 || this.point.y + gadget.height <= 0) {
            return true;
        }
        if (this.bounds.height <= 0) {
            this.bounds.x = this.point.x;
            this.bounds.y = this.point.y;
            this.bounds.width = gadget.width;
            this.bounds.height = gadget.height;
            this.addPart(this.point, gadget);
            return true;
        }
        if (this.point.y >= this.bounds.y && this.point.y < this.bounds.y + this.bounds.height || this.point.y + gadget.height > this.bounds.y && this.point.y + gadget.height <= this.bounds.y + this.bounds.height || this.bounds.y >= this.point.y && this.bounds.y < this.point.y + gadget.height || this.bounds.y + this.bounds.height > this.point.y && this.bounds.y + this.bounds.height <= this.point.y + gadget.height) {
            TextLineParts.union(this.bounds, this.point.x, this.point.y, gadget.width, gadget.height);
            this.addPart(this.point, gadget);
            return true;
        }
        if (!this.crossLine) {
            return false;
        }
        this.bounds.x = this.point.x;
        this.bounds.y = this.point.y;
        this.bounds.width = gadget.width;
        this.bounds.height = gadget.height;
        this.partCount = 0;
        this.addPart(this.point, gadget);
        this.crossLine = false;
        return true;
    }

    private void addPart(Point point, Gadget gadget) {
        Object object;
        if (this.partCount == this.parts.length) {
            object = new Part[Math.max(10, 2 * this.parts.length)];
            System.arraycopy(this.parts, 0, object, 0, this.parts.length);
            int n = this.parts.length;
            while (n < ((Part[])object).length) {
                object[n] = new Part();
                ++n;
            }
            this.parts = object;
        }
        object = this.parts[this.partCount++];
        object.x = point.x;
        object.y = point.y;
        object.gadget = gadget;
    }

    private static final void union(Rectangle rectangle, int n, int n2, int n3, int n4) {
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            rectangle.x = n;
            rectangle.y = n2;
            rectangle.width = n3;
            rectangle.height = n4;
            return;
        }
        int n5 = Math.min(rectangle.x, n);
        int n6 = Math.max(rectangle.x + rectangle.width, n + n3);
        int n7 = Math.min(rectangle.y, n2);
        int n8 = Math.max(rectangle.y + rectangle.height, n2 + n4);
        rectangle.x = n5;
        rectangle.y = n7;
        rectangle.width = n6 - n5;
        rectangle.height = n8 - n7;
    }

    public Part[] getParts() {
        return this.parts;
    }

    public int getPartCount() {
        return this.partCount;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public Object enterElement(Element element) {
        return null;
    }

    public Object leaveElement(Element element) {
        return null;
    }

    public Object processText(Text text) {
        return this.processTextNode(text);
    }

    public Object processPI(ProcessingInstruction processingInstruction) {
        return this.processTextNode(processingInstruction);
    }

    public Object processComment(Comment comment) {
        return this.processTextNode(comment);
    }

    private Object processTextNode(TextNode textNode) {
        TextNodeView textNodeView = (TextNodeView)textNode.getDocumentListenerData(this.viewIndex);
        if (textNodeView == null) {
            return null;
        }
        this.gadgetList2.removeAll();
        textNodeView.getTextGadgets(this.gadgetList2, this.viewIndex);
        if (this.backwards) {
            int n = this.gadgetList2.size - 1;
            while (n >= 0) {
                if (!this.processGadget(this.gadgetList2.list[n])) {
                    return textNode;
                }
                --n;
            }
        } else {
            int n = 0;
            while (n < this.gadgetList2.size) {
                if (!this.processGadget(this.gadgetList2.list[n])) {
                    return textNode;
                }
                ++n;
            }
        }
        return null;
    }

    public void appendRectangle(int n, int n2, int n3, int n4) {
    }

    public static class Part {
        public int x;
        public int y;
        public Gadget gadget;
    }
}

