/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.command;

import com.xmlmind.xmledit.command.Msg;
import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.ShowStatus;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.PlatformUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.view.DocumentView;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

public class ViewHTML
extends RecordableCommand {
    private URL url;

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        this.url = null;
        DocumentView documentView = (DocumentView)gadget;
        Document document = documentView.getDocument();
        if (document == null) {
            return false;
        }
        if (string != null && (string = string.trim()).length() > 0) {
            Serializable serializable;
            try {
                this.url = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (this.url == null && (serializable = document.getLocation()) != null) {
                try {
                    this.url = new URL((URL)serializable, string);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (this.url == null) {
                serializable = new File(string);
                if (!((File)serializable).isAbsolute()) {
                    File file;
                    serializable = null;
                    URL uRL = document.getLocation();
                    if (uRL != null && (file = FileUtil.urlToFile(uRL)) != null && (file = file.getParentFile()) != null) {
                        serializable = new File(file, string);
                    }
                }
                if (serializable != null && ((File)serializable).isFile()) {
                    this.url = FileUtil.fileToURL((File)serializable);
                }
            }
        }
        return this.url != null;
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        if (!ViewHTML.viewHTML(this.url, null, documentView.getPanel())) {
            return Command.EXECUTION_FAILED;
        }
        return null;
    }

    public static boolean viewHTML(URL uRL, String string, Component component) {
        boolean bl;
        String string2 = ViewHTML.getViewCommand(uRL, string);
        ShowStatus.showStatus(Msg.msg("VH.executingCommand", string2));
        try {
            PlatformUtil.shellStart(string2);
            bl = true;
        }
        catch (IOException iOException) {
            Alert.showError(component, Msg.msg("VH.cannotView", uRL, MiscUtil.reason(iOException)));
            bl = false;
        }
        return bl;
    }

    public static String getViewCommand(URL uRL, String string) {
        if (string == null || (string = string.trim()).length() == 0) {
            string = System.getProperty("XXE_HTML_PREVIEW_COMMAND");
        }
        if (string == null || (string = string.trim()).length() == 0) {
            switch (PlatformUtil.PLATFORM) {
                case 2: {
                    string = "start \"\" \"%U\"";
                    break;
                }
                case 3: {
                    string = "open \"%U\"";
                    break;
                }
                default: {
                    string = "(mozilla -remote \"openURL(%U)\" 1> /dev/null 2>&1) || (mozilla \"%U\" &)";
                }
            }
        }
        if (PlatformUtil.PLATFORM != 2 && string.endsWith("&")) {
            string = string.substring(0, string.length() - 1);
        }
        return StringUtil.replaceAll(string, "%U", uRL.toExternalForm());
    }
}

