/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.cssparser;

import com.xmlmind.xmledit.cssparser.ValueComponent;
import com.xmlmind.xmledit.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;

public class ParseUtil {
    public static final int UCS4_BE_BOM = 0;
    public static final int UCS4_LE_BOM = 1;
    public static final int UCS4_2143_BOM = 2;
    public static final int UCS4_3412_BOM = 3;
    public static final int UTF16_BE_BOM = 4;
    public static final int UTF16_LE_BOM = 5;
    public static final int UTF8_BOM = 6;
    public static final int UCS4_BE = 7;
    public static final int UCS4_LE = 8;
    public static final int UCS4_2143 = 9;
    public static final int UCS4_3412 = 10;
    public static final int UTF16_BE = 11;
    public static final int UTF16_LE = 12;
    public static final int ASCII_COMPATIBLE = 13;
    public static final int EBCDIC = 14;
    private static final NamedColor black = new NamedColor("black", 0, 0, 0);
    private static final NamedColor silver = new NamedColor("silver", 192, 192, 192);
    private static final NamedColor gray = new NamedColor("gray", 128, 128, 128);
    private static final NamedColor white = new NamedColor("white", 255, 255, 255);
    private static final NamedColor maroon = new NamedColor("maroon", 128, 0, 0);
    private static final NamedColor red = new NamedColor("red", 255, 0, 0);
    private static final NamedColor purple = new NamedColor("purple", 128, 0, 128);
    private static final NamedColor fuchsia = new NamedColor("fuchsia", 255, 0, 255);
    private static final NamedColor green = new NamedColor("green", 0, 128, 0);
    private static final NamedColor lime = new NamedColor("lime", 0, 255, 0);
    private static final NamedColor olive = new NamedColor("olive", 128, 128, 0);
    private static final NamedColor yellow = new NamedColor("yellow", 255, 255, 0);
    private static final NamedColor navy = new NamedColor("navy", 0, 0, 128);
    private static final NamedColor blue = new NamedColor("blue", 0, 0, 255);
    private static final NamedColor teal = new NamedColor("teal", 0, 128, 128);
    private static final NamedColor aqua = new NamedColor("aqua", 0, 255, 255);
    private static final NamedColor[] namedColors = new NamedColor[]{black, silver, gray, white, maroon, red, purple, fuchsia, green, lime, olive, yellow, navy, blue, teal, aqua};
    private static HashMap namedColorMap = new HashMap();

    public static String loadSource(URL uRL) throws IOException {
        return ParseUtil.loadSource(uRL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadSource(URL uRL, String string) throws IOException {
        InputStream inputStream = uRL.openStream();
        String string2 = null;
        try {
            string2 = ParseUtil.loadSource(inputStream, string);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return string2;
    }

    public static String loadSource(InputStream inputStream, String string) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[8192];
        while ((n = bufferedInputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byArray = byteArrayOutputStream.toByteArray();
        return ParseUtil.loadSource(byArray, 0, byArray.length, string);
    }

    public static String loadSource(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        if (string == null) {
            int n3 = ParseUtil.guessEncoding(byArray, n, n2);
            switch (n3) {
                case 4: {
                    n += 2;
                    n2 -= 2;
                }
                case 11: {
                    string = "UnicodeBigUnmarked";
                    break;
                }
                case 5: {
                    n += 2;
                    n2 -= 2;
                }
                case 12: {
                    string = "UnicodeLittleUnmarked";
                    break;
                }
                case 6: {
                    n += 3;
                    n2 -= 3;
                    string = "UTF8";
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 14: {
                    throw new UnsupportedEncodingException();
                }
            }
            if (!(string != null || n2 <= 8 || byArray[n] != 64 || byArray[n + 1] != 99 && byArray[n + 1] != 67 || byArray[n + 2] != 104 && byArray[n + 2] != 72 || byArray[n + 3] != 97 && byArray[n + 3] != 65 || byArray[n + 4] != 114 && byArray[n + 4] != 82 || byArray[n + 5] != 115 && byArray[n + 5] != 83 || byArray[n + 6] != 101 && byArray[n + 6] != 69 || byArray[n + 7] != 116 && byArray[n + 7] != 84)) {
                byte by = 0;
                int n4 = 8;
                block11: while (n4 < n2) {
                    switch (byArray[n + n4]) {
                        case 34: 
                        case 39: {
                            by = byArray[n + n4];
                            ++n4;
                            break block11;
                        }
                        default: {
                            ++n4;
                        }
                    }
                }
                int n5 = n4;
                while (n5 < n2) {
                    if (byArray[n + n5] == by) break;
                    ++n5;
                }
                if (n5 > n4 && n5 < n2) {
                    string = new String(byArray, n + n4, n5 - n4, "ASCII");
                }
            }
        }
        if (string == null) {
            string = FileUtil.defaultEncoding();
        }
        return new String(byArray, n, n2, string);
    }

    public static int guessEncoding(byte[] byArray, int n, int n2) {
        if (n2 < 4) {
            return -1;
        }
        int n3 = byArray[n] & 0xFF;
        int n4 = byArray[n + 1] & 0xFF;
        int n5 = byArray[n + 2] & 0xFF;
        int n6 = byArray[n + 3] & 0xFF;
        if (n3 == 0 && n4 == 0 && n5 == 254 && n6 == 255) {
            return 0;
        }
        if (n3 == 255 && n4 == 254 && n5 == 0 && n6 == 0) {
            return 1;
        }
        if (n3 == 0 && n4 == 0 && n5 == 255 && n6 == 254) {
            return 2;
        }
        if (n3 == 254 && n4 == 255 && n5 == 0 && n6 == 0) {
            return 3;
        }
        if (n3 == 254 && n4 == 255 && n5 != 0 && n6 != 0) {
            return 4;
        }
        if (n3 == 255 && n4 == 254 && n5 != 0 && n6 != 0) {
            return 5;
        }
        if (n3 == 239 && n4 == 187 && n5 == 191) {
            return 6;
        }
        if (n3 == 0 && n4 == 0 && n5 == 0 && n6 == 64) {
            return 7;
        }
        if (n3 == 64 && n4 == 0 && n5 == 0 && n6 == 0) {
            return 8;
        }
        if (n3 == 0 && n4 == 0 && n5 == 64 && n6 == 0) {
            return 9;
        }
        if (n3 == 0 && n4 == 64 && n5 == 0 && n6 == 0) {
            return 10;
        }
        if (n3 == 0 && n4 == 64 && n5 == 0 && (n6 == 99 || n6 == 67)) {
            return 11;
        }
        if (n3 == 64 && n4 == 0 && (n5 == 99 || n5 == 67) && n6 == 0) {
            return 12;
        }
        if (!(n3 != 64 || n4 != 99 && n4 != 67 || n5 != 104 && n5 != 72 || n6 != 97 && n6 != 65)) {
            return 13;
        }
        return -1;
    }

    public static String[] lexemeToCaseSensitiveQName(String string) {
        String[] stringArray = new String[2];
        ParseUtil.lexemeToCaseSensitiveQName(string, stringArray);
        return stringArray;
    }

    public static void lexemeToCaseSensitiveQName(String string, String[] stringArray) {
        int n = string.indexOf(124);
        if (n < 0) {
            stringArray[0] = null;
            stringArray[1] = ParseUtil.unescape(string);
        } else {
            stringArray[0] = n == 0 ? "" : ParseUtil.unescape(string.substring(0, n));
            stringArray[1] = n + 1 == string.length() ? "" : ParseUtil.unescape(string.substring(n + 1));
        }
    }

    public static String[] lexemeToQName(String string) {
        String[] stringArray = new String[2];
        ParseUtil.lexemeToQName(string, stringArray);
        return stringArray;
    }

    public static void lexemeToQName(String string, String[] stringArray) {
        ParseUtil.lexemeToCaseSensitiveQName(string, stringArray);
        if (stringArray[0] != null) {
            stringArray[0] = stringArray[0].toLowerCase();
        }
        stringArray[1] = stringArray[1].toLowerCase();
    }

    public static String lexemeToCaseSensitiveIdent(String string) {
        return ParseUtil.unescape(string);
    }

    public static String lexemeToIdent(String string) {
        return ParseUtil.unescape(string).toLowerCase();
    }

    public static String lexemeToString(String string) {
        String string2 = ParseUtil.unescape(string.substring(1, string.length() - 1));
        if (string2.indexOf(92) < 0) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (c == '\\' && n2 + 1 < n) {
                switch (string2.charAt(n2 + 1)) {
                    case '\r': {
                        if (n2 + 2 < n && string2.charAt(n2 + 2) == '\n') {
                            n2 += 2;
                            break;
                        }
                        ++n2;
                        break;
                    }
                    case '\n': 
                    case '\f': {
                        ++n2;
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                        break;
                    }
                }
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String lexemeToURI(String string) {
        String string2 = ParseUtil.trim(string.substring(4, string.length() - 1));
        if (string2.length() > 0) {
            switch (string2.charAt(0)) {
                case '\"': 
                case '\'': {
                    string2 = string2.substring(1, string2.length() - 1);
                }
            }
        }
        return ParseUtil.unescape(string2);
    }

    public static String lexemeToUnit(String string) {
        int n = string.length();
        int n2 = 0;
        block3: while (n2 < n) {
            switch (string.charAt(n2)) {
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                default: {
                    break block3;
                }
            }
            ++n2;
        }
        if (n2 >= n) {
            return null;
        }
        return string.substring(n2).toLowerCase();
    }

    public static double lexemeToNumber(String string) {
        double d;
        String string2 = ParseUtil.lexemeToUnit(string);
        if (string2 != null) {
            string = string.substring(0, string.length() - string2.length());
        }
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = Double.NaN;
        }
        return d;
    }

    public static int[] lexemeToUnicodeRange(String string) {
        String string2;
        String string3;
        int n = (string = string.substring(2)).indexOf(45);
        if (n < 0) {
            string3 = string.replace('?', '0');
            string2 = string.replace('?', 'F');
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        int[] nArray = new int[2];
        try {
            nArray[0] = Integer.parseInt(string3, 16);
            nArray[1] = Integer.parseInt(string2, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (nArray[0] > nArray[1]) {
            return null;
        }
        return nArray;
    }

    public static int[] lexemeToHexColor(String string) {
        String string2 = ParseUtil.unescape(string.substring(1));
        int[] nArray = new int[3];
        switch (string2.length()) {
            case 3: {
                try {
                    String string3 = string2.substring(0, 1);
                    nArray[0] = Integer.parseInt(string3 + string3, 16);
                    string3 = string2.substring(1, 2);
                    nArray[1] = Integer.parseInt(string3 + string3, 16);
                    string3 = string2.substring(2, 3);
                    nArray[2] = Integer.parseInt(string3 + string3, 16);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            case 6: {
                try {
                    nArray[0] = Integer.parseInt(string2.substring(0, 2), 16);
                    nArray[1] = Integer.parseInt(string2.substring(2, 4), 16);
                    nArray[2] = Integer.parseInt(string2.substring(4, 6), 16);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            default: {
                return null;
            }
        }
        return nArray;
    }

    public static String lexemeToFunction(String string) {
        String string2 = ParseUtil.unescape(string.substring(0, string.length() - 1));
        return string2.toLowerCase();
    }

    public static final int[] nameToRGB(String string) {
        NamedColor namedColor = (NamedColor)namedColorMap.get(string.toLowerCase());
        if (namedColor == null) {
            return null;
        }
        return namedColor.rgb;
    }

    public static final int[] functionArgumentsToRGB(ValueComponent[] valueComponentArray) {
        if (valueComponentArray.length != 3) {
            return null;
        }
        int[] nArray = new int[3];
        int n = 0;
        while (n < 3) {
            int n2;
            ValueComponent valueComponent = valueComponentArray[n];
            if (n == 0 && valueComponent.operator != '\u0000' || n > 0 && valueComponent.operator != ',') {
                return null;
            }
            switch (valueComponent.type) {
                case -25: {
                    n2 = (int)valueComponent.numericValue;
                    break;
                }
                case -24: {
                    n2 = (int)(valueComponent.numericValue * 255.0 / 100.0);
                    break;
                }
                default: {
                    return null;
                }
            }
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > 255) {
                n2 = 255;
            }
            nArray[n] = n2;
            ++n;
        }
        return nArray;
    }

    public static String trim(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!ParseUtil.isSpace(string.charAt(n2))) break;
            ++n2;
        }
        int n3 = n - 1;
        while (n3 >= 0) {
            if (!ParseUtil.isSpace(string.charAt(n3))) break;
            --n3;
        }
        return n3 >= n2 ? string.substring(n2, n3 + 1) : "";
    }

    public static String unescape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = string.charAt(n2);
            if (n3 == 92 && n2 + 1 < n) {
                int n4 = string.charAt(n2 + 1);
                if (ParseUtil.isHexDigit((char)n4)) {
                    int n5 = ++n2;
                    while (n2 < n && ParseUtil.isHexDigit(string.charAt(n2))) {
                        if (++n2 - n5 == 6) break;
                    }
                    try {
                        int n6 = Integer.parseInt(string.substring(n5, n2), 16);
                        n3 = n6 > 65535 ? 63 : (int)((char)n6);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n3 = 63;
                    }
                    if (n2 < n && ParseUtil.isSpace(string.charAt(n2))) {
                        ++n2;
                    }
                    --n2;
                } else if (n4 >= 32 && n4 <= 126 || n4 >= 128) {
                    ++n2;
                    n3 = n4;
                }
            }
            stringBuffer.append((char)n3);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static boolean isHexDigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return true;
            }
        }
        return false;
    }

    public static boolean isSpace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    static {
        int n = 0;
        while (n < namedColors.length) {
            namedColorMap.put(ParseUtil.namedColors[n].name, namedColors[n]);
            ++n;
        }
    }

    private static class NamedColor {
        public String name;
        public int[] rgb = new int[3];

        public NamedColor(String string, int n, int n2, int n3) {
            this.name = string;
            this.rgb[0] = n;
            this.rgb[1] = n2;
            this.rgb[2] = n3;
        }
    }
}

