/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.cssparser;

import com.xmlmind.xmledit.cssparser.AttributeSelector;
import com.xmlmind.xmledit.cssparser.Handler;
import com.xmlmind.xmledit.cssparser.ParseUtil;
import com.xmlmind.xmledit.cssparser.Scanner;
import com.xmlmind.xmledit.cssparser.SelectorComponent;
import com.xmlmind.xmledit.cssparser.ValueComponent;
import com.xmlmind.xmledit.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Stack;

public class Parser {
    protected Handler handler;
    protected Stack sources = new Stack();
    protected Scanner scanner;
    protected URL url;
    protected String[] media;
    protected int token;

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void parse(File file) throws MalformedURLException, IOException {
        this.parse(file, null);
    }

    public void parse(File file, String[] stringArray) throws MalformedURLException, IOException {
        this.parse(FileUtil.fileToURL(file), stringArray);
    }

    public void parse(URL uRL) throws IOException {
        this.parse(uRL, null);
    }

    public void parse(URL uRL, String[] stringArray) throws IOException {
        this.parse(ParseUtil.loadSource(uRL), uRL, stringArray);
    }

    public void parse(InputStream inputStream, String string, URL uRL, String[] stringArray) throws IOException {
        this.parse(ParseUtil.loadSource(inputStream, string), uRL, stringArray);
    }

    public void parse(String string) {
        this.parse(string, null, null);
    }

    public void parse(String string, URL uRL, String[] stringArray) {
        this.parse(string.toCharArray(), 0, string.length(), uRL, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void parse(char[] var1_1, int var2_2, int var3_3, URL var4_4, String[] var5_5) {
        block6: {
            if (var5_5 == null) {
                var5_5 = new String[]{};
            }
            try {
                if (this.handleBeginStyleSheet(var4_4, null, var5_5)) {
                    this.pushSource(var1_1, var2_2, var3_3, var4_4, var5_5);
                    this.nextToken();
                    this.stylesheet();
                    this.handleEndStyleSheet(var4_4, null, var5_5);
                }
                var7_6 = null;
                ** while (this.scanner != null)
            }
            catch (Throwable var6_8) {
                var7_7 = null;
                ** while (this.scanner != null)
            }
lbl-1000:
            // 1 sources

            {
                this.popSource();
                continue;
lbl14:
                // 1 sources

                break block6;
            }
lbl-1000:
            // 1 sources

            {
                this.popSource();
                continue;
            }
lbl21:
            // 1 sources

            throw var6_8;
        }
    }

    protected void nextToken() {
        this.token = this.scanner.getNextToken();
    }

    protected void pushSource(String string, URL uRL, String[] stringArray) {
        this.pushSource(string.toCharArray(), 0, string.length(), uRL, stringArray);
    }

    protected void pushSource(char[] cArray, int n, int n2, URL uRL, String[] stringArray) {
        Source source;
        if (!this.sources.empty()) {
            source = (Source)this.sources.peek();
            source.token = this.token;
        }
        source = new Source(new Scanner(cArray, n, n2), uRL, stringArray);
        this.sources.push(source);
        this.scanner = source.scanner;
        this.url = source.url;
        this.media = source.media;
        this.token = 0;
    }

    protected void popSource() {
        if (!this.sources.empty()) {
            this.sources.pop();
            if (this.sources.empty()) {
                this.scanner = null;
                this.url = null;
                this.media = null;
                this.token = 0;
            } else {
                Source source = (Source)this.sources.peek();
                this.scanner = source.scanner;
                this.url = source.url;
                this.media = source.media;
                this.token = source.token;
            }
        }
    }

    public URL getURL() {
        return this.url;
    }

    public String[] getMedia() {
        return this.media;
    }

    public int getLineNumber() {
        return this.scanner.getLineNumber();
    }

    public int getColumnNumber() {
        return this.scanner.getColumnNumber();
    }

    protected void stylesheet() {
        if (this.token == -14) {
            this.skipStatement();
        }
        this.skipSpaceBetweenBlocks();
        block13: while (true) {
            switch (this.token) {
                case -10: {
                    this.import_();
                    break;
                }
                case -29: {
                    this.namespace();
                    break;
                }
                default: {
                    break block13;
                }
            }
            this.skipSpaceBetweenBlocks();
        }
        while (true) {
            switch (this.token) {
                case -1: {
                    return;
                }
                case -12: {
                    this.media();
                    break;
                }
                case -11: {
                    this.page();
                    break;
                }
                case -13: {
                    this.font_face();
                    break;
                }
                case -29: {
                    this.namespace();
                    break;
                }
                case -30: {
                    this.script();
                    break;
                }
                case -15: {
                    this.atRule();
                    break;
                }
                default: {
                    this.ruleset();
                }
            }
            this.skipSpaceBetweenBlocks();
        }
    }

    protected void import_() {
        String string;
        this.nextToken();
        this.skipSpace();
        switch (this.token) {
            case -7: {
                string = ParseUtil.lexemeToString(this.scanner.getLexeme());
                break;
            }
            case -26: {
                string = ParseUtil.lexemeToURI(this.scanner.getLexeme());
                break;
            }
            default: {
                this.reportError("expected " + Scanner.tokenName(-7) + " or " + Scanner.tokenName(-26) + ", found " + Scanner.tokenName(this.token));
                this.skipStatement();
                return;
            }
        }
        if (string.trim().length() == 0) {
            this.reportError("empty import specification");
            this.skipStatement();
            return;
        }
        this.nextToken();
        this.skipSpace();
        String[] stringArray = this.mediaList();
        if (!this.matchToken(59)) {
            this.skipStatement();
            return;
        }
        this.nextToken();
        this.skipSpace();
        URL uRL = this.handleResolveURI(string, this.url);
        if (uRL == null) {
            try {
                uRL = new URL(this.url, string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (uRL == null) {
            this.reportError("cannot convert \"" + string + "\" to an URL");
            return;
        }
        if (this.handleBeginStyleSheet(this.url, string, stringArray)) {
            String string2;
            try {
                string2 = ParseUtil.loadSource(uRL);
            }
            catch (IOException iOException) {
                this.reportError("cannot load " + uRL.toExternalForm(), iOException);
                this.handleEndStyleSheet(this.url, string, stringArray);
                return;
            }
            this.pushSource(string2, uRL, stringArray);
            this.nextToken();
            this.stylesheet();
            this.popSource();
            this.handleEndStyleSheet(this.url, string, stringArray);
        }
    }

    protected String[] mediaList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (this.token == -8) {
            arrayList.add(ParseUtil.lexemeToIdent(this.scanner.getLexeme()));
            this.nextToken();
            this.skipSpace();
            if (this.token != 44) break;
            this.nextToken();
            this.skipSpace();
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    protected void media() {
        this.nextToken();
        this.skipSpace();
        String[] stringArray = this.mediaList();
        if (!this.matchToken(123)) {
            this.skipBlock();
            return;
        }
        if (stringArray.length == 0) {
            this.reportError("no media specified");
            this.skipBlock();
            return;
        }
        if (!this.handleBeginMedia(stringArray)) {
            this.skipBlock();
            return;
        }
        this.nextToken();
        this.skipSpace();
        block8: while (true) {
            switch (this.token) {
                case -1: 
                case 125: {
                    break block8;
                }
                case -11: {
                    this.page();
                    continue block8;
                }
                case -13: {
                    this.font_face();
                    continue block8;
                }
                case -29: {
                    this.namespace();
                    continue block8;
                }
                case -30: {
                    this.script();
                    continue block8;
                }
                case -15: {
                    this.atRule();
                    continue block8;
                }
                default: {
                    this.ruleset();
                    continue block8;
                }
            }
            break;
        }
        this.handleEndMedia();
        if (!this.matchToken(125)) {
            this.skipBlock();
            return;
        }
        this.nextToken();
        this.skipSpace();
    }

    protected void page() {
        this.nextToken();
        this.skipSpace();
        String string = null;
        String string2 = null;
        if (this.token == -8) {
            string = ParseUtil.lexemeToIdent(this.scanner.getLexeme());
            this.nextToken();
        }
        if (this.token == 58) {
            this.nextToken();
            if (!this.matchToken(-8)) {
                this.skipBlock();
                return;
            }
            string2 = ParseUtil.lexemeToIdent(this.scanner.getLexeme());
            this.nextToken();
        }
        this.skipSpace();
        if (!this.matchToken(123)) {
            this.skipBlock();
            return;
        }
        if (!this.handleBeginPage(string, string2)) {
            this.skipBlock();
            return;
        }
        this.nextToken();
        this.skipSpace();
        this.declarations();
        this.handleEndPage();
        if (!this.matchToken(125)) {
            this.skipBlock();
            return;
        }
        this.nextToken();
        this.skipSpace();
    }

    protected void declarations() {
        while (true) {
            if (this.token == 59) {
                this.nextToken();
                this.skipSpace();
                continue;
            }
            switch (this.token) {
                case -1: 
                case 125: {
                    return;
                }
            }
            this.declaration();
        }
    }

    protected void font_face() {
        this.nextToken();
        this.skipSpace();
        if (!this.matchToken(123)) {
            this.skipBlock();
            return;
        }
        if (!this.handleBeginFontFace()) {
            this.skipBlock();
            return;
        }
        this.nextToken();
        this.skipSpace();
        this.declarations();
        this.handleEndFontFace();
        if (!this.matchToken(125)) {
            this.skipBlock();
            return;
        }
        this.nextToken();
        this.skipSpace();
    }

    protected void namespace() {
        this.nextToken();
        this.skipSpace();
        String string = null;
        if (this.token == -8) {
            string = ParseUtil.lexemeToCaseSensitiveIdent(this.scanner.getLexeme());
            this.nextToken();
            this.skipSpace();
        }
        String string2 = null;
        switch (this.token) {
            case -7: {
                string2 = ParseUtil.lexemeToString(this.scanner.getLexeme());
                break;
            }
            case -26: {
                string2 = ParseUtil.lexemeToURI(this.scanner.getLexeme());
                break;
            }
            default: {
                this.reportError("expected " + Scanner.tokenName(-7) + " or " + Scanner.tokenName(-26) + ", found " + Scanner.tokenName(this.token));
                this.skipStatement();
                return;
            }
        }
        this.nextToken();
        this.skipSpace();
        if (!this.matchToken(59)) {
            this.skipStatement();
            return;
        }
        this.nextToken();
        this.skipSpace();
        this.handleNamespace(string, string2);
    }

    protected void script() {
        this.nextToken();
        this.skipSpace();
        String string = null;
        if (this.token == -7) {
            string = ParseUtil.lexemeToString(this.scanner.getLexeme());
            this.nextToken();
            this.skipSpace();
        }
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        URL uRL = null;
        int n = -1;
        int n2 = -1;
        switch (this.token) {
            case 59: {
                break;
            }
            case 123: {
                uRL = this.getURL();
                n = this.getLineNumber();
                n2 = this.getColumnNumber();
                if (this.scanner.skipBlock()) {
                    string3 = this.scanner.getLexeme();
                    break;
                }
                bl = true;
                break;
            }
            case -7: {
                string2 = ParseUtil.lexemeToString(this.scanner.getLexeme());
                this.nextToken();
                this.skipSpace();
                break;
            }
            case -26: {
                string2 = ParseUtil.lexemeToURI(this.scanner.getLexeme());
                this.nextToken();
                this.skipSpace();
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            this.reportError("expected " + Scanner.tokenName(59) + ", " + Scanner.tokenName(123) + ", " + Scanner.tokenName(-7) + " or " + Scanner.tokenName(-26) + ", found " + Scanner.tokenName(this.token));
            this.skipStatement();
            return;
        }
        if (string3 == null) {
            if (!this.matchToken(59)) {
                this.skipStatement();
                return;
            }
            if (string == null && string2 == null) {
                this.reportError("useless " + Scanner.tokenName(-30));
                this.nextToken();
                this.skipSpace();
                return;
            }
        } else {
            this.nextToken();
            this.skipSpace();
        }
        this.nextToken();
        this.skipSpace();
        this.handleScript(string, string2, string3, uRL, n, n2);
    }

    protected void atRule() {
        String string = ParseUtil.lexemeToIdent(this.scanner.getLexeme().substring(1));
        this.nextToken();
        this.skipSpace();
        String string2 = null;
        if (this.token == -7) {
            string2 = ParseUtil.lexemeToString(this.scanner.getLexeme());
            this.nextToken();
            this.skipSpace();
        }
        String string3 = null;
        boolean bl = false;
        switch (this.token) {
            case 59: {
                break;
            }
            case 123: {
                if (this.scanner.skipBlock()) {
                    string3 = this.scanner.getLexeme();
                    this.nextToken();
                    this.skipSpace();
                    break;
                }
                bl = true;
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            this.reportError("expected " + Scanner.tokenName(59) + " or " + Scanner.tokenName(123) + ", found " + Scanner.tokenName(this.token));
            this.skipStatement();
            return;
        }
        this.nextToken();
        this.skipSpace();
        this.handleAtRule(string, string2, string3);
    }

    protected void ruleset() {
        this.handleBeginRule();
        this.handleBeginSelectors();
        block4: while (true) {
            if (!this.selector()) {
                this.skipBlock();
                this.handleEndSelectors();
                this.handleEndRule();
                return;
            }
            switch (this.token) {
                case -1: 
                case 123: {
                    break block4;
                }
                case 44: {
                    this.nextToken();
                    this.skipSpace();
                }
                default: {
                    continue block4;
                }
            }
            break;
        }
        this.handleEndSelectors();
        if (!this.matchToken(123)) {
            this.skipBlock();
            this.handleEndRule();
            return;
        }
        this.handleBeginProperties();
        this.nextToken();
        this.skipSpace();
        this.declarations();
        this.handleEndProperties();
        this.handleEndRule();
        if (!this.matchToken(125)) {
            this.skipBlock();
            return;
        }
        this.nextToken();
        this.skipSpace();
    }

    protected boolean selector() {
        ArrayList<SelectorComponent> arrayList = new ArrayList<SelectorComponent>();
        SelectorComponent selectorComponent = new SelectorComponent();
        selectorComponent.combinator = '\u0000';
        switch (this.simple_selector(selectorComponent)) {
            case -1: {
                return false;
            }
            case 0: {
                this.reportError("expected simple selector, found " + Scanner.tokenName(this.token));
                return false;
            }
        }
        arrayList.add(selectorComponent);
        block11: while (true) {
            selectorComponent = new SelectorComponent();
            switch (this.token) {
                case 43: 
                case 62: {
                    selectorComponent.combinator = (char)this.token;
                    this.nextToken();
                    this.skipSpace();
                    break;
                }
                default: {
                    selectorComponent.combinator = '\u0000';
                }
            }
            switch (this.simple_selector(selectorComponent)) {
                case -1: {
                    return false;
                }
                case 0: {
                    if (selectorComponent.combinator == '\u0000') break block11;
                    this.reportError("expected simple selector after " + Scanner.tokenName(selectorComponent.combinator) + ", found " + Scanner.tokenName(this.token));
                    return false;
                }
                default: {
                    arrayList.add(selectorComponent);
                    continue block11;
                }
            }
            break;
        }
        if (!this.matchToken(44, 123)) {
            return false;
        }
        SelectorComponent[] selectorComponentArray = new SelectorComponent[arrayList.size()];
        arrayList.toArray(selectorComponentArray);
        this.handleSelector(selectorComponentArray);
        return true;
    }

    protected int simple_selector(SelectorComponent selectorComponent) {
        String[] stringArray;
        selectorComponent.elementPrefix = null;
        switch (this.token) {
            case -31: {
                stringArray = ParseUtil.lexemeToCaseSensitiveQName(this.scanner.getLexeme());
                selectorComponent.elementPrefix = stringArray[0];
                selectorComponent.elementName = stringArray[1];
                this.nextToken();
                break;
            }
            case -8: {
                selectorComponent.elementName = ParseUtil.lexemeToCaseSensitiveIdent(this.scanner.getLexeme());
                this.nextToken();
                break;
            }
            case 42: {
                selectorComponent.elementName = "*";
                this.nextToken();
            }
        }
        stringArray = new ArrayList();
        ArrayList<ValueComponent> arrayList = new ArrayList<ValueComponent>();
        block11: while (true) {
            switch (this.token) {
                case -9: {
                    AttributeSelector attributeSelector = this.idAttrib();
                    if (attributeSelector == null) {
                        return -1;
                    }
                    stringArray.add(attributeSelector);
                    continue block11;
                }
                case 46: {
                    AttributeSelector attributeSelector = this.classAttrib();
                    if (attributeSelector == null) {
                        return -1;
                    }
                    stringArray.add(attributeSelector);
                    continue block11;
                }
                case 91: {
                    AttributeSelector attributeSelector = this.namedAttrib();
                    if (attributeSelector == null) {
                        return -1;
                    }
                    stringArray.add(attributeSelector);
                    continue block11;
                }
                case 58: {
                    ValueComponent valueComponent = this.pseudo();
                    if (valueComponent == null) {
                        return -1;
                    }
                    arrayList.add(valueComponent);
                    continue block11;
                }
            }
            break;
        }
        this.skipSpace();
        if (selectorComponent.elementName == null && stringArray.size() == 0 && arrayList.size() == 0) {
            return 0;
        }
        if (selectorComponent.elementName == null) {
            selectorComponent.elementName = "*";
        }
        selectorComponent.attributeSelectors = new AttributeSelector[stringArray.size()];
        stringArray.toArray(selectorComponent.attributeSelectors);
        selectorComponent.pseudos = new ValueComponent[arrayList.size()];
        arrayList.toArray(selectorComponent.pseudos);
        return 1;
    }

    protected AttributeSelector idAttrib() {
        AttributeSelector attributeSelector = new AttributeSelector();
        attributeSelector.matcher = "#";
        attributeSelector.value = ParseUtil.lexemeToCaseSensitiveIdent(this.scanner.getLexeme().substring(1));
        this.nextToken();
        return attributeSelector;
    }

    protected AttributeSelector classAttrib() {
        this.nextToken();
        if (!this.matchToken(-8)) {
            return null;
        }
        AttributeSelector attributeSelector = new AttributeSelector();
        attributeSelector.matcher = ".";
        attributeSelector.value = ParseUtil.lexemeToCaseSensitiveIdent(this.scanner.getLexeme());
        this.nextToken();
        return attributeSelector;
    }

    protected AttributeSelector namedAttrib() {
        this.nextToken();
        this.skipSpace();
        AttributeSelector attributeSelector = new AttributeSelector();
        switch (this.token) {
            case -31: {
                String string = this.scanner.getLexeme();
                String[] stringArray = ParseUtil.lexemeToCaseSensitiveQName(string);
                attributeSelector.prefix = stringArray[0];
                attributeSelector.name = stringArray[1];
                if (!"*".equals(attributeSelector.name)) break;
                this.reportError("\"" + string + "\" not allowed here");
                return null;
            }
            case -8: {
                attributeSelector.prefix = null;
                attributeSelector.name = ParseUtil.lexemeToCaseSensitiveIdent(this.scanner.getLexeme());
                break;
            }
            default: {
                this.reportError("expected " + Scanner.tokenName(-31) + " or " + Scanner.tokenName(-8) + ", found " + Scanner.tokenName(this.token));
                return null;
            }
        }
        this.nextToken();
        this.skipSpace();
        boolean bl = true;
        switch (this.token) {
            case 61: {
                attributeSelector.matcher = "=";
                break;
            }
            case -5: {
                attributeSelector.matcher = "~=";
                break;
            }
            case -6: {
                attributeSelector.matcher = "|=";
                break;
            }
            case -32: {
                attributeSelector.matcher = "^=";
                break;
            }
            case -33: {
                attributeSelector.matcher = "$=";
                break;
            }
            case -34: {
                attributeSelector.matcher = "*=";
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) {
            this.nextToken();
            this.skipSpace();
            if (!this.matchToken(-8, -7)) {
                return null;
            }
            attributeSelector.value = this.token == -8 ? ParseUtil.lexemeToCaseSensitiveIdent(this.scanner.getLexeme()) : ParseUtil.lexemeToString(this.scanner.getLexeme());
            this.nextToken();
            this.skipSpace();
        }
        if (!this.matchToken(93)) {
            return null;
        }
        this.nextToken();
        return attributeSelector;
    }

    protected ValueComponent pseudo() {
        this.nextToken();
        if (this.token == 58) {
            this.nextToken();
        }
        if (!this.matchToken(-8, -27)) {
            return null;
        }
        ValueComponent valueComponent = new ValueComponent();
        valueComponent.type = this.token;
        String string = this.scanner.getLexeme();
        if (this.token == -8) {
            valueComponent.stringValue = ParseUtil.lexemeToIdent(string);
            this.nextToken();
        } else {
            this.nextToken();
            this.skipSpace();
            if (this.token != 41) {
                valueComponent.functionArguments = this.expr();
                if (valueComponent.functionArguments == null) {
                    return null;
                }
                if (this.token != 41) {
                    this.reportError("expected " + Scanner.tokenName(41) + ", found " + Scanner.tokenName(this.token));
                    return null;
                }
            } else {
                valueComponent.functionArguments = new ValueComponent[0];
            }
            valueComponent.functionName = ParseUtil.lexemeToFunction(string);
            this.nextToken();
        }
        return valueComponent;
    }

    protected void declaration() {
        if (!this.matchToken(-8)) {
            this.skipToEndOfDecl();
            return;
        }
        String string = ParseUtil.lexemeToIdent(this.scanner.getLexeme());
        this.nextToken();
        this.skipSpace();
        if (!this.matchToken(58)) {
            this.skipToEndOfDecl();
            return;
        }
        this.nextToken();
        this.skipSpace();
        ValueComponent[] valueComponentArray = this.expr();
        if (valueComponentArray == null) {
            this.skipToEndOfDecl();
            return;
        }
        boolean bl = false;
        if (this.token == -16) {
            bl = true;
            this.nextToken();
            this.skipSpace();
        }
        if (!this.matchToken(59, 125)) {
            this.skipToEndOfDecl();
            return;
        }
        this.handleProperty(string, valueComponentArray, bl);
    }

    protected ValueComponent[] expr() {
        ArrayList<ValueComponent> arrayList = new ArrayList<ValueComponent>();
        ValueComponent valueComponent = new ValueComponent();
        valueComponent.operator = '\u0000';
        switch (this.term(valueComponent)) {
            case -1: {
                return null;
            }
            case 0: {
                this.reportError("expected expression term, found " + Scanner.tokenName(this.token));
                return null;
            }
        }
        arrayList.add(valueComponent);
        block11: while (true) {
            valueComponent = new ValueComponent();
            switch (this.token) {
                case 44: 
                case 47: {
                    valueComponent.operator = (char)this.token;
                    this.nextToken();
                    this.skipSpace();
                    break;
                }
                default: {
                    valueComponent.operator = '\u0000';
                }
            }
            switch (this.term(valueComponent)) {
                case -1: {
                    return null;
                }
                case 0: {
                    if (valueComponent.operator == '\u0000') break block11;
                    this.reportError("expected expression term after " + Scanner.tokenName(valueComponent.operator) + ", found " + Scanner.tokenName(this.token));
                    return null;
                }
                default: {
                    arrayList.add(valueComponent);
                    continue block11;
                }
            }
            break;
        }
        ValueComponent[] valueComponentArray = new ValueComponent[arrayList.size()];
        arrayList.toArray(valueComponentArray);
        return valueComponentArray;
    }

    protected int term(ValueComponent valueComponent) {
        int n = -1;
        switch (this.token) {
            case 43: 
            case 45: {
                n = this.token;
                this.nextToken();
            }
        }
        valueComponent.type = this.token;
        String string = this.scanner.getLexeme();
        switch (this.token) {
            case -18: 
            case -17: {
                valueComponent.type = -19;
            }
            case -24: 
            case -23: 
            case -22: 
            case -21: 
            case -20: 
            case -19: {
                valueComponent.unit = ParseUtil.lexemeToUnit(string);
            }
            case -25: {
                valueComponent.numericValue = ParseUtil.lexemeToNumber(string);
                if (Double.isNaN(valueComponent.numericValue)) {
                    this.reportError("invalid " + Scanner.tokenName(this.token));
                    return -1;
                }
                if (n != 45) break;
                if (this.token == -21 || this.token == -22) {
                    this.reportError("negative " + Scanner.tokenName(this.token));
                    return -1;
                }
                valueComponent.numericValue = -valueComponent.numericValue;
                break;
            }
            case -31: {
                String[] stringArray = ParseUtil.lexemeToCaseSensitiveQName(string);
                valueComponent.prefix = stringArray[0];
                valueComponent.stringValue = stringArray[1];
                if (!"*".equals(valueComponent.stringValue)) break;
                this.reportError("\"" + string + "\" not allowed here");
                return -1;
            }
            case -8: {
                valueComponent.stringValue = ParseUtil.lexemeToIdent(string);
                break;
            }
            case -7: {
                valueComponent.stringValue = ParseUtil.lexemeToString(string);
                break;
            }
            case -26: {
                valueComponent.stringValue = ParseUtil.lexemeToURI(string);
                break;
            }
            case -28: {
                valueComponent.unicodeRange = ParseUtil.lexemeToUnicodeRange(string);
                if (valueComponent.unicodeRange != null) break;
                this.reportError("invalid " + Scanner.tokenName(this.token));
                return -1;
            }
            case -9: {
                valueComponent.hexColor = ParseUtil.lexemeToHexColor(string);
                if (valueComponent.hexColor != null) break;
                this.reportError(Scanner.tokenName(this.token) + " is not a color");
                return -1;
            }
            case -27: {
                this.nextToken();
                this.skipSpace();
                valueComponent.functionName = ParseUtil.lexemeToFunction(string);
                if (this.token != 41) {
                    if (valueComponent.functionName.equals("attr") && this.token == -8) {
                        ValueComponent valueComponent2 = new ValueComponent();
                        valueComponent2.type = -8;
                        valueComponent2.stringValue = ParseUtil.lexemeToCaseSensitiveIdent(this.scanner.getLexeme());
                        valueComponent.functionArguments = new ValueComponent[]{valueComponent2};
                        this.nextToken();
                        this.skipSpace();
                    } else {
                        valueComponent.functionArguments = this.expr();
                        if (valueComponent.functionArguments == null) {
                            return -1;
                        }
                    }
                    if (this.token == 41) break;
                    this.reportError("expected " + Scanner.tokenName(41) + ", found " + Scanner.tokenName(this.token));
                    return -1;
                }
                valueComponent.functionArguments = new ValueComponent[0];
                break;
            }
            default: {
                if (n != -1) {
                    this.reportError("expected term after " + Scanner.tokenName(n) + ", found " + Scanner.tokenName(this.token));
                    return -1;
                }
                return 0;
            }
        }
        this.nextToken();
        this.skipSpace();
        return 1;
    }

    protected boolean matchToken(int n) {
        if (this.token != n) {
            this.reportError("expected " + Scanner.tokenName(n) + ", found " + Scanner.tokenName(this.token));
            return false;
        }
        return true;
    }

    protected boolean matchToken(int n, int n2) {
        if (this.token != n && this.token != n2) {
            this.reportError("expected " + Scanner.tokenName(n) + " or " + Scanner.tokenName(n2) + ", found " + Scanner.tokenName(this.token));
            return false;
        }
        return true;
    }

    protected void reportError(String string) {
        this.reportError(string, null);
    }

    protected void reportError(String string, Exception exception) {
        if (exception != null) {
            String string2 = exception.getMessage();
            if (string2 == null) {
                string2 = exception.getClass().getName();
            }
            string = string + ": " + string2;
        }
        this.handleError(this.getURL(), this.getLineNumber(), this.getColumnNumber(), string);
    }

    protected void skipSpaceBetweenBlocks() {
        block3: while (true) {
            switch (this.token) {
                case -4: 
                case -3: 
                case -2: {
                    this.nextToken();
                    continue block3;
                }
            }
            break;
        }
    }

    protected void skipSpace() {
        while (this.token == -2) {
            this.nextToken();
        }
    }

    protected void skipStatement() {
        int n = 0;
        block6: while (true) {
            switch (this.token) {
                case -1: {
                    return;
                }
                case 59: {
                    this.nextToken();
                    if (n > 0) continue block6;
                    this.skipSpace();
                    return;
                }
                case 123: {
                    ++n;
                    this.nextToken();
                    continue block6;
                }
                case 125: {
                    --n;
                    this.nextToken();
                    continue block6;
                }
            }
            this.nextToken();
        }
    }

    protected void skipBlock() {
        int n = 0;
        block5: while (true) {
            switch (this.token) {
                case -1: {
                    return;
                }
                case 123: {
                    ++n;
                    this.nextToken();
                    continue block5;
                }
                case 125: {
                    this.nextToken();
                    if (--n > 0) continue block5;
                    this.skipSpace();
                    return;
                }
            }
            this.nextToken();
        }
    }

    protected void skipToEndOfDecl() {
        int n = 0;
        block6: while (true) {
            switch (this.token) {
                case -1: {
                    return;
                }
                case 59: {
                    if (n <= 0) {
                        return;
                    }
                    this.nextToken();
                    continue block6;
                }
                case 123: {
                    ++n;
                    this.nextToken();
                    continue block6;
                }
                case 125: {
                    if (--n <= 0) {
                        return;
                    }
                    this.nextToken();
                    continue block6;
                }
            }
            this.nextToken();
        }
    }

    protected URL handleResolveURI(String string, URL uRL) {
        return this.handler.resolveURI(string, uRL);
    }

    protected boolean handleBeginStyleSheet(URL uRL, String string, String[] stringArray) {
        return this.handler.beginStyleSheet(uRL, string, stringArray);
    }

    protected void handleEndStyleSheet(URL uRL, String string, String[] stringArray) {
        this.handler.endStyleSheet(uRL, string, stringArray);
    }

    protected boolean handleBeginMedia(String[] stringArray) {
        return this.handler.beginMedia(stringArray);
    }

    protected void handleEndMedia() {
        this.handler.endMedia();
    }

    protected boolean handleBeginPage(String string, String string2) {
        return this.handler.beginPage(string, string2);
    }

    protected void handleEndPage() {
        this.handler.endPage();
    }

    protected boolean handleBeginFontFace() {
        return this.handler.beginFontFace();
    }

    protected void handleEndFontFace() {
        this.handler.endFontFace();
    }

    protected void handleNamespace(String string, String string2) {
        this.handler.namespace(string, string2);
    }

    protected void handleScript(String string, String string2, String string3, URL uRL, int n, int n2) {
        this.handler.script(string, string2, string3, uRL, n, n2);
    }

    protected void handleAtRule(String string, String string2, String string3) {
        this.handler.atRule(string, string2, string3);
    }

    protected void handleBeginRule() {
        this.handler.beginRule();
    }

    protected void handleEndRule() {
        this.handler.endRule();
    }

    protected void handleBeginSelectors() {
        this.handler.beginSelectors();
    }

    protected void handleSelector(SelectorComponent[] selectorComponentArray) {
        this.handler.selector(selectorComponentArray);
    }

    protected void handleEndSelectors() {
        this.handler.endSelectors();
    }

    protected void handleBeginProperties() {
        this.handler.beginProperties();
    }

    protected void handleProperty(String string, ValueComponent[] valueComponentArray, boolean bl) {
        this.handler.property(string, valueComponentArray, bl);
    }

    protected void handleEndProperties() {
        this.handler.endProperties();
    }

    protected void handleError(URL uRL, int n, int n2, String string) {
        this.handler.error(uRL, n, n2, string);
    }

    protected static class Source {
        public Scanner scanner;
        public URL url;
        public String[] media;
        public int token;

        public Source(Scanner scanner, URL uRL, String[] stringArray) {
            this.scanner = scanner;
            this.url = uRL;
            this.media = stringArray;
            this.token = 0;
        }
    }
}

