/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.cssparser;

import com.xmlmind.xmledit.cssparser.ParseUtil;
import com.xmlmind.xmledit.cssparser.Parser;
import com.xmlmind.xmledit.cssparser.ValueComponent;
import com.xmlmind.xmledit.util.LinearHashtable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;

public final class ParserEx
extends Parser {
    private HashMap propertyGroups = new HashMap();
    private HashMap propertyValues = new HashMap();
    private static final int PROPERTY_GROUP_MASK = 1;
    private static final int PROPERTY_VALUE_MASK = 2;
    private int macroMask = 0;
    private Stack checkRecurse = new Stack();

    protected void atRule() {
        String string = ParseUtil.lexemeToIdent(this.scanner.getLexeme().substring(1));
        if ("property-group".equals(string)) {
            this.propertyGroup();
        } else if ("property-value".equals(string)) {
            this.propertyValue();
        } else {
            super.atRule();
        }
    }

    private void propertyGroup() {
        Object[] objectArray = this.macro();
        if (objectArray == null) {
            return;
        }
        String string = (String)objectArray[0];
        String[] stringArray = (String[])objectArray[1];
        if (!this.matchToken(123)) {
            this.skipBlock();
            return;
        }
        this.nextToken();
        this.skipSpace();
        Property[] propertyArray = this.properties();
        if (propertyArray == null) {
            this.skipBlock();
            return;
        }
        if (!this.matchToken(125)) {
            this.skipBlock();
            return;
        }
        this.nextToken();
        this.skipSpace();
        this.addPropertyGroup(string, stringArray, propertyArray);
    }

    private Object[] macro() {
        this.nextToken();
        this.skipSpace();
        if (!this.matchToken(-27)) {
            this.skipToEndOfDecl();
            return null;
        }
        String string = ParseUtil.lexemeToFunction(this.scanner.getLexeme());
        this.nextToken();
        this.skipSpace();
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = true;
        while (this.token != 41) {
            if (bl) {
                bl = false;
            } else {
                if (!this.matchToken(44)) {
                    this.skipToEndOfDecl();
                    return null;
                }
                this.nextToken();
                this.skipSpace();
            }
            if (this.token != -8) break;
            arrayList.add(ParseUtil.lexemeToIdent(this.scanner.getLexeme()));
            this.nextToken();
            this.skipSpace();
        }
        if (!this.matchToken(41)) {
            this.skipToEndOfDecl();
            return null;
        }
        this.nextToken();
        this.skipSpace();
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return new Object[]{string, stringArray};
    }

    private Property[] properties() {
        Property[] propertyArray;
        ArrayList<Property[]> arrayList = new ArrayList<Property[]>();
        block4: while (true) {
            if (this.token == 59) {
                this.nextToken();
                this.skipSpace();
                continue;
            }
            switch (this.token) {
                case -1: {
                    this.reportError("unexpected end of @property-group");
                    return null;
                }
                case 125: {
                    break block4;
                }
                default: {
                    propertyArray = this.property();
                    if (propertyArray == null) {
                        return null;
                    }
                    arrayList.add(propertyArray);
                    continue block4;
                }
            }
            break;
        }
        propertyArray = new Property[arrayList.size()];
        arrayList.toArray(propertyArray);
        return propertyArray;
    }

    private Property property() {
        if (!this.matchToken(-8)) {
            this.skipToEndOfDecl();
            return null;
        }
        String string = ParseUtil.lexemeToIdent(this.scanner.getLexeme());
        this.nextToken();
        this.skipSpace();
        if (!this.matchToken(58)) {
            this.skipToEndOfDecl();
            return null;
        }
        this.nextToken();
        this.skipSpace();
        ValueComponent[] valueComponentArray = this.expr();
        if (valueComponentArray == null) {
            this.skipToEndOfDecl();
            return null;
        }
        boolean bl = false;
        if (this.token == -16) {
            bl = true;
            this.nextToken();
            this.skipSpace();
        }
        if (!this.matchToken(59, 125)) {
            this.skipToEndOfDecl();
            return null;
        }
        return new Property(string, valueComponentArray, bl);
    }

    private void addPropertyGroup(String string, String[] stringArray, Property[] propertyArray) {
        int n = 0;
        PropertyGroup propertyGroup = (PropertyGroup)this.propertyGroups.remove(string);
        if (propertyGroup != null) {
            n = propertyGroup.version + 1;
            propertyGroup.name = propertyGroup.name + '#' + Integer.toString(propertyGroup.version);
            this.propertyGroups.put(propertyGroup.name, propertyGroup);
            ParserEx.substituteGroup(string, propertyGroup.name, propertyArray);
        }
        this.propertyGroups.put(string, new PropertyGroup(string, stringArray, propertyArray, n));
        this.macroMask |= 1;
    }

    private static final void substituteGroup(String string, String string2, Property[] propertyArray) {
        int n = 0;
        while (n < propertyArray.length) {
            ValueComponent[] valueComponentArray;
            Property property = propertyArray[n];
            if ("property-group".equals(property.name) && (valueComponentArray = property.components).length == 1 && valueComponentArray[0].type == -27 && string.equals(valueComponentArray[0].functionName)) {
                valueComponentArray[0].functionName = string2;
            }
            ++n;
        }
    }

    private void propertyValue() {
        Object[] objectArray = this.macro();
        if (objectArray == null) {
            return;
        }
        String string = (String)objectArray[0];
        String[] stringArray = (String[])objectArray[1];
        ValueComponent[] valueComponentArray = this.expr();
        if (valueComponentArray == null) {
            this.skipToEndOfDecl();
            return;
        }
        if (!this.matchToken(59)) {
            this.skipToEndOfDecl();
            return;
        }
        this.nextToken();
        this.skipSpace();
        this.addPropertyValue(string, stringArray, valueComponentArray);
    }

    private void addPropertyValue(String string, String[] stringArray, ValueComponent[] valueComponentArray) {
        int n = 0;
        PropertyValue propertyValue = (PropertyValue)this.propertyValues.remove(string);
        if (propertyValue != null) {
            n = propertyValue.version + 1;
            propertyValue.name = propertyValue.name + '#' + Integer.toString(propertyValue.version);
            this.propertyValues.put(propertyValue.name, propertyValue);
            ParserEx.substituteFunction(string, propertyValue.name, valueComponentArray);
        }
        this.propertyValues.put(string, new PropertyValue(string, stringArray, valueComponentArray, n));
        this.macroMask |= 2;
    }

    private static final void substituteFunction(String string, String string2, ValueComponent[] valueComponentArray) {
        int n = 0;
        while (n < valueComponentArray.length) {
            ValueComponent valueComponent = valueComponentArray[n];
            if (valueComponent.type == -27) {
                if (string.equals(valueComponent.functionName)) {
                    valueComponent.functionName = string2;
                } else {
                    ParserEx.substituteFunction(string, string2, valueComponent.functionArguments);
                }
            }
            ++n;
        }
    }

    protected void handleProperty(String string, ValueComponent[] valueComponentArray, boolean bl) {
        if (this.macroMask == 0) {
            this.handler.property(string, valueComponentArray, bl);
            return;
        }
        if ("property-group".equals(string) && (this.macroMask & 1) != 0) {
            ParserEx.popAll(this.checkRecurse);
            ArrayList arrayList = new ArrayList();
            try {
                this.expandGroup(new Property(string, valueComponentArray, bl), arrayList, this.checkRecurse);
            }
            catch (ExpandException expandException) {
                this.reportError(expandException.getMessage());
                return;
            }
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                Property property = (Property)arrayList.get(n2);
                ValueComponent[] valueComponentArray2 = property.components;
                if ((this.macroMask & 2) != 0) {
                    ParserEx.popAll(this.checkRecurse);
                    try {
                        valueComponentArray2 = this.expandValues(valueComponentArray2, this.checkRecurse);
                    }
                    catch (ExpandException expandException) {
                        this.reportError(expandException.getMessage());
                        return;
                    }
                }
                this.handler.property(property.name, valueComponentArray2, property.important);
                ++n2;
            }
        } else {
            if ((this.macroMask & 2) != 0) {
                ParserEx.popAll(this.checkRecurse);
                try {
                    valueComponentArray = this.expandValues(valueComponentArray, this.checkRecurse);
                }
                catch (ExpandException expandException) {
                    this.reportError(expandException.getMessage());
                    return;
                }
            }
            this.handler.property(string, valueComponentArray, bl);
        }
    }

    private static final void popAll(Stack stack) {
        while (!stack.empty()) {
            stack.pop();
        }
    }

    private void expandGroup(Property property, ArrayList arrayList, Stack stack) throws ExpandException {
        if (property.components.length != 1 || property.components[0].type != -27) {
            throw new ExpandException("syntax error in reference to property-group");
        }
        PropertyGroup propertyGroup = (PropertyGroup)this.propertyGroups.get(property.components[0].functionName);
        if (propertyGroup == null) {
            throw new ExpandException("'" + property.components[0].functionName + "' unknown property-group");
        }
        if (stack.contains(propertyGroup.name)) {
            throw new ExpandException("'" + propertyGroup.name + "' recursive property-group");
        }
        Property[] propertyArray = propertyGroup.properties;
        ValueComponent[] valueComponentArray = property.components[0].functionArguments;
        if (valueComponentArray.length > 0 || propertyGroup.parameters.length > 0) {
            LinearHashtable linearHashtable = ParserEx.substitutionMap(propertyGroup, valueComponentArray);
            propertyArray = (Property[])propertyArray.clone();
            int n = 0;
            while (n < propertyArray.length) {
                Property property2 = propertyArray[n];
                propertyArray[n] = new Property(property2.name, this.substituteParameters(property2.components, linearHashtable), property2.important);
                ++n;
            }
        }
        stack.push(propertyGroup.name);
        int n = 0;
        while (n < propertyArray.length) {
            Property property3 = propertyArray[n];
            if ("property-group".equals(property3.name)) {
                this.expandGroup(property3, arrayList, stack);
            } else {
                arrayList.add(property3);
            }
            ++n;
        }
        stack.pop();
    }

    private static final LinearHashtable substitutionMap(Macro macro, ValueComponent[] valueComponentArray) throws ExpandException {
        if (macro.parameters.length != valueComponentArray.length) {
            String string = macro instanceof PropertyGroup ? "property-group" : "property-value";
            throw new ExpandException("expected " + macro.parameters.length + " arguments for " + string + " " + macro.name + ", got " + valueComponentArray.length);
        }
        LinearHashtable linearHashtable = new LinearHashtable();
        int n = 0;
        while (n < valueComponentArray.length) {
            linearHashtable.put(macro.parameters[n], valueComponentArray[n]);
            ++n;
        }
        return linearHashtable;
    }

    private ValueComponent[] substituteParameters(ValueComponent[] valueComponentArray, LinearHashtable linearHashtable) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < valueComponentArray.length) {
            object = valueComponentArray[n];
            switch (((ValueComponent)object).type) {
                case -8: {
                    ValueComponent valueComponent = (ValueComponent)linearHashtable.get(((ValueComponent)object).stringValue);
                    if (valueComponent == null) {
                        arrayList.add(object);
                        break;
                    }
                    if (valueComponent.type == -27 && "argument-list".equals(valueComponent.functionName)) {
                        ValueComponent[] valueComponentArray2 = valueComponent.functionArguments;
                        int n2 = 0;
                        while (n2 < valueComponentArray2.length) {
                            ValueComponent valueComponent2 = valueComponentArray2[n2];
                            if (n2 == 0 && valueComponent2.operator != ((ValueComponent)object).operator) {
                                valueComponent2 = valueComponent2.copy();
                                valueComponent2.operator = ((ValueComponent)object).operator;
                            }
                            arrayList.add(valueComponent2);
                            ++n2;
                        }
                        break;
                    }
                    if (valueComponent.operator != ((ValueComponent)object).operator) {
                        valueComponent = valueComponent.copy();
                        valueComponent.operator = ((ValueComponent)object).operator;
                    }
                    arrayList.add(valueComponent);
                    break;
                }
                case -27: {
                    ValueComponent valueComponent = ((ValueComponent)object).copy();
                    valueComponent.functionArguments = this.substituteParameters(((ValueComponent)object).functionArguments, linearHashtable);
                    arrayList.add(valueComponent);
                    break;
                }
                default: {
                    arrayList.add(object);
                }
            }
            ++n;
        }
        object = new ValueComponent[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    private ValueComponent[] expandValues(ValueComponent[] valueComponentArray, Stack stack) throws ExpandException {
        ValueComponent[] valueComponentArray2;
        boolean bl = false;
        int n = 0;
        while (n < valueComponentArray.length) {
            if (valueComponentArray[n].type == -27) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            return valueComponentArray;
        }
        ArrayList<ValueComponent[]> arrayList = new ArrayList<ValueComponent[]>();
        int n2 = 0;
        while (n2 < valueComponentArray.length) {
            valueComponentArray2 = valueComponentArray[n2];
            if (valueComponentArray2.type == -27) {
                this.expandValue((ValueComponent)valueComponentArray2, arrayList, stack);
            } else {
                arrayList.add(valueComponentArray2);
            }
            ++n2;
        }
        valueComponentArray2 = new ValueComponent[arrayList.size()];
        arrayList.toArray(valueComponentArray2);
        return valueComponentArray2;
    }

    private void expandValue(ValueComponent valueComponent, ArrayList arrayList, Stack stack) throws ExpandException {
        ValueComponent valueComponent2;
        PropertyValue propertyValue = (PropertyValue)this.propertyValues.get(valueComponent.functionName);
        if (propertyValue == null) {
            ValueComponent valueComponent3 = valueComponent.copy();
            valueComponent3.functionArguments = this.expandValues(valueComponent.functionArguments, stack);
            arrayList.add(valueComponent3);
            return;
        }
        if (stack.contains(propertyValue.name)) {
            throw new ExpandException("'" + propertyValue.name + "' recursive property-value");
        }
        ValueComponent[] valueComponentArray = propertyValue.value;
        ValueComponent[] valueComponentArray2 = valueComponent.functionArguments;
        if (valueComponentArray2.length > 0 || propertyValue.parameters.length > 0) {
            LinearHashtable linearHashtable = ParserEx.substitutionMap(propertyValue, valueComponentArray2);
            valueComponentArray = this.substituteParameters(valueComponentArray, linearHashtable);
        }
        stack.push(propertyValue.name);
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < valueComponentArray.length) {
            valueComponent2 = valueComponentArray[n2];
            if (valueComponent2.type == -27) {
                this.expandValue(valueComponent2, arrayList, stack);
            } else {
                arrayList.add(valueComponent2);
            }
            ++n2;
        }
        if (arrayList.size() > n) {
            valueComponent2 = (ValueComponent)arrayList.get(n);
            if (valueComponent2.operator != valueComponent.operator) {
                valueComponent2 = valueComponent2.copy();
                valueComponent2.operator = valueComponent.operator;
                arrayList.set(n, valueComponent2);
            }
        }
        stack.pop();
    }

    private static final class PropertyValue
    extends Macro {
        public ValueComponent[] value;

        public PropertyValue(String string, String[] stringArray, ValueComponent[] valueComponentArray, int n) {
            super(string, stringArray, n);
            this.value = valueComponentArray;
        }
    }

    private static final class PropertyGroup
    extends Macro {
        public Property[] properties;

        public PropertyGroup(String string, String[] stringArray, Property[] propertyArray, int n) {
            super(string, stringArray, n);
            this.properties = propertyArray;
        }
    }

    private static class Macro {
        public String name;
        public String[] parameters;
        public int version;

        protected Macro(String string, String[] stringArray, int n) {
            this.name = string;
            this.parameters = stringArray;
            this.version = n;
        }
    }

    private static final class Property {
        public String name;
        public ValueComponent[] components;
        public boolean important;

        public Property(String string, ValueComponent[] valueComponentArray, boolean bl) {
            this.name = string;
            this.components = valueComponentArray;
            this.important = bl;
        }
    }

    private static final class ExpandException
    extends Exception {
        public ExpandException(String string) {
            super(string);
        }
    }
}

