/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.cssparser;

import com.xmlmind.xmledit.cssparser.ParseUtil;
import com.xmlmind.xmledit.util.FileUtil;
import java.io.FileWriter;
import java.io.PrintWriter;

public class Scanner {
    public static final int EOF = -1;
    public static final int S = -2;
    public static final int CDO = -3;
    public static final int CDC = -4;
    public static final int INCLUDES = -5;
    public static final int DASHMATCH = -6;
    public static final int STRING = -7;
    public static final int IDENT = -8;
    public static final int HASH = -9;
    public static final int IMPORT_SYM = -10;
    public static final int PAGE_SYM = -11;
    public static final int MEDIA_SYM = -12;
    public static final int FONT_FACE_SYM = -13;
    public static final int CHARSET_SYM = -14;
    public static final int ATKEYWORD = -15;
    public static final int IMPORTANT_SYM = -16;
    public static final int EMS = -17;
    public static final int EXS = -18;
    public static final int LENGTH = -19;
    public static final int ANGLE = -20;
    public static final int TIME = -21;
    public static final int FREQ = -22;
    public static final int DIMEN = -23;
    public static final int PERCENTAGE = -24;
    public static final int NUMBER = -25;
    public static final int URI = -26;
    public static final int FUNCTION = -27;
    public static final int UNICODERANGE = -28;
    public static final int NAMESPACE_SYM = -29;
    public static final int SCRIPT_SYM = -30;
    public static final int QNAME = -31;
    public static final int STARTS_WITH = -32;
    public static final int ENDS_WITH = -33;
    public static final int CONTAINS = -34;
    private static final String[] tokenNames = new String[]{null, "end of data", "space", "'<!--'", "'-->'", "'~='", "'|='", "string", "identifier", "'#'identifier", "'@import'", "'@page'", "'@media'", "'@font-face'", "'@charset'", "'@'identifier", "'!important'", "em", "ex", "length", "angle", "time", "frequency", "dimension", "percentage", "number", "URL", "function", "Unicode range", "'@namespace'", "'@script'", "qualified name", "^=", "$=", "*="};
    private char[] source = null;
    private int firstPos = -1;
    private int endPos = -1;
    private int pos = -1;
    private int lexemePos = -1;
    private int cachedPos = -1;
    private int lineNum = -1;
    private int charNum = -1;

    public Scanner(String string) {
        this();
        this.setSourceChars(string.toCharArray(), 0, string.length());
    }

    public Scanner(char[] cArray, int n, int n2) {
        this();
        this.setSourceChars(cArray, n, n2);
    }

    public Scanner() {
    }

    public void setSourceChars(char[] cArray, int n, int n2) {
        this.source = cArray;
        this.firstPos = n;
        this.endPos = n + n2;
        this.lexemePos = this.pos = this.firstPos;
        this.charNum = -1;
        this.lineNum = -1;
        this.cachedPos = -1;
    }

    public char[] getSourceChars() {
        return this.source;
    }

    public int getSourceCharOffset() {
        return this.firstPos;
    }

    public int getSourceCharCount() {
        return this.endPos - this.firstPos;
    }

    public int getNextToken() {
        if (this.pos >= this.endPos) {
            return -1;
        }
        char c = this.source[this.pos];
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                this.lexemePos = this.pos;
                this.skipSpace();
                return -2;
            }
            case '/': {
                if (this.match("/*") && this.skipComment()) {
                    return this.getNextToken();
                }
                this.lexemePos = this.pos++;
                return c;
            }
            case '<': {
                this.lexemePos = this.pos++;
                if (this.match("<!--")) {
                    this.pos += 4;
                    return -3;
                }
                return c;
            }
            case '-': {
                this.lexemePos = this.pos++;
                if (this.match("-->")) {
                    this.pos += 3;
                    return -4;
                }
                return c;
            }
            case '~': {
                this.lexemePos = this.pos++;
                if (this.match("~=")) {
                    this.pos += 2;
                    return -5;
                }
                return c;
            }
            case '|': {
                this.lexemePos = this.pos++;
                if (this.pos < this.endPos) {
                    if (this.source[this.pos] == '=') {
                        ++this.pos;
                        return -6;
                    }
                    if (this.source[this.pos] == '*') {
                        ++this.pos;
                        return -31;
                    }
                    if (this.matchIdentStart()) {
                        this.skipName();
                        return -31;
                    }
                    return c;
                }
                return c;
            }
            case '^': {
                this.lexemePos = this.pos++;
                if (this.match("^=")) {
                    this.pos += 2;
                    return -32;
                }
                return c;
            }
            case '$': {
                this.lexemePos = this.pos++;
                if (this.match("$=")) {
                    this.pos += 2;
                    return -33;
                }
                return c;
            }
            case '*': {
                this.lexemePos = this.pos++;
                if (this.match("*=")) {
                    this.pos += 2;
                    return -34;
                }
                if (this.pos < this.endPos && this.source[this.pos] == '|') {
                    ++this.pos;
                    if (this.pos < this.endPos && this.source[this.pos] == '*') {
                        ++this.pos;
                        return -31;
                    }
                    if (this.matchIdentStart()) {
                        this.skipName();
                        return -31;
                    }
                    --this.pos;
                    return c;
                }
                return c;
            }
            case '\"': 
            case '\'': {
                this.lexemePos = this.pos++;
                if (this.skipString(c)) {
                    return -7;
                }
                return c;
            }
            case '#': {
                this.lexemePos = this.pos++;
                if (this.matchNameStart()) {
                    this.skipName();
                    return -9;
                }
                return c;
            }
            case '@': {
                if (this.match("@import")) {
                    this.lexemePos = this.pos;
                    this.pos += 7;
                    return -10;
                }
                if (this.match("@page")) {
                    this.lexemePos = this.pos;
                    this.pos += 5;
                    return -11;
                }
                if (this.match("@media")) {
                    this.lexemePos = this.pos;
                    this.pos += 6;
                    return -12;
                }
                if (this.match("@font-face")) {
                    this.lexemePos = this.pos;
                    this.pos += 10;
                    return -13;
                }
                if (this.match("@charset")) {
                    this.lexemePos = this.pos;
                    this.pos += 8;
                    return -14;
                }
                if (this.match("@namespace")) {
                    this.lexemePos = this.pos;
                    this.pos += 10;
                    return -29;
                }
                if (this.match("@script")) {
                    this.lexemePos = this.pos;
                    this.pos += 7;
                    return -30;
                }
                this.lexemePos = this.pos++;
                if (this.matchIdentStart()) {
                    this.skipName();
                    return -15;
                }
                return c;
            }
            case '!': {
                this.lexemePos = this.pos++;
                if (this.skipImportant()) {
                    return -16;
                }
                return c;
            }
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.lexemePos = this.pos;
                if (!(c != '.' || this.pos + 1 < this.endPos && Character.isDigit(this.source[this.pos + 1]))) {
                    ++this.pos;
                    return c;
                }
                this.skipNumber();
                if (this.match("em")) {
                    this.pos += 2;
                    return -17;
                }
                if (this.match("ex")) {
                    this.pos += 2;
                    return -18;
                }
                if (this.match("cm") || this.match("mm") || this.match("in") || this.match("pt") || this.match("pc") || this.match("px")) {
                    this.pos += 2;
                    return -19;
                }
                if (this.match("deg") || this.match("rad")) {
                    this.pos += 3;
                    return -20;
                }
                if (this.match("grad")) {
                    this.pos += 4;
                    return -20;
                }
                if (this.match("ms")) {
                    this.pos += 2;
                    return -21;
                }
                if (this.match("s")) {
                    ++this.pos;
                    return -21;
                }
                if (this.match("hz")) {
                    this.pos += 2;
                    return -22;
                }
                if (this.match("khz")) {
                    this.pos += 3;
                    return -22;
                }
                if (this.match("%")) {
                    ++this.pos;
                    return -24;
                }
                if (this.matchIdentStart()) {
                    this.skipName();
                    return -23;
                }
                return -25;
            }
            case 'U': 
            case 'u': {
                this.lexemePos = this.pos;
                if (this.match("url(")) {
                    if (!this.skipURI()) break;
                    return -26;
                }
                if (!this.match("u+") || !this.skipUnicodeRange()) break;
                return -28;
            }
        }
        this.lexemePos = this.pos++;
        if (this.matchIdentStart()) {
            this.skipName();
            if (this.pos < this.endPos) {
                if (this.source[this.pos] == '(') {
                    ++this.pos;
                    return -27;
                }
                if (this.source[this.pos] == '|') {
                    ++this.pos;
                    if (this.pos < this.endPos && this.source[this.pos] == '*') {
                        ++this.pos;
                        return -31;
                    }
                    if (this.matchIdentStart()) {
                        this.skipName();
                        return -31;
                    }
                    --this.pos;
                    return -8;
                }
                return -8;
            }
            return -8;
        }
        return c;
    }

    private boolean match(String string) {
        int n = string.length();
        int n2 = this.pos;
        int n3 = 0;
        while (n3 < n) {
            if (n2 >= this.endPos || Character.toLowerCase(this.source[n2++]) != string.charAt(n3)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private boolean matchNameStart() {
        char c = this.source[this.pos];
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c >= '\u0080') {
            return true;
        }
        if (c == '\\' && this.pos + 1 < this.endPos) {
            char c2 = this.source[this.pos + 1];
            return ParseUtil.isHexDigit(c2) || c2 >= ' ' && c2 <= '~' || c2 >= '\u0080';
        }
        return false;
    }

    private boolean matchIdentStart() {
        char c = this.source[this.pos];
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '\u0080') {
            return true;
        }
        if (c == '\\' && this.pos + 1 < this.endPos) {
            char c2 = this.source[this.pos + 1];
            return ParseUtil.isHexDigit(c2) || c2 >= ' ' && c2 <= '~' || c2 >= '\u0080';
        }
        return false;
    }

    private void skipSpace() {
        while (this.pos < this.endPos) {
            switch (this.source[this.pos]) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    ++this.pos;
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    private boolean skipComment() {
        int n = this.pos;
        this.pos += 2;
        while (this.pos < this.endPos) {
            switch (this.source[this.pos]) {
                case '*': {
                    if (this.pos + 1 >= this.endPos || this.source[this.pos + 1] != '/') break;
                    this.pos += 2;
                    return true;
                }
            }
            ++this.pos;
        }
        this.pos = n;
        return false;
    }

    private boolean skipString(char c) {
        int n = this.pos++;
        char c2 = c == '\"' ? (char)'\'' : '\"';
        while (this.pos < this.endPos) {
            char c3 = this.source[this.pos];
            if (c3 == c) {
                ++this.pos;
                return true;
            }
            if (c3 == '\\') {
                ++this.pos;
                if (this.pos >= this.endPos || (c3 = this.source[this.pos]) != c && c3 != c2 && c3 != '\n' && c3 != '\r' && c3 != '\f') continue;
                ++this.pos;
                if (c3 != '\r' || this.pos >= this.endPos || this.source[this.pos] != '\n') continue;
                ++this.pos;
                continue;
            }
            if (c3 != c2 && (c3 < '(' || c3 > '~') && c3 != ' ' && c3 != '\t' && c3 != '!' && c3 != '#' && c3 != '$' && c3 != '%' && c3 != '&' && c3 < '\u0080') break;
            ++this.pos;
        }
        this.pos = n;
        return false;
    }

    private void skipName() {
        while (this.pos < this.endPos) {
            char c = this.source[this.pos];
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c >= '\u0080') {
                ++this.pos;
                continue;
            }
            if (c == '\\') {
                if (this.skipEscape()) continue;
                return;
            }
            return;
        }
    }

    private boolean skipEscape() {
        if (this.pos + 1 < this.endPos) {
            char c = this.source[this.pos + 1];
            if (ParseUtil.isHexDigit(c)) {
                ++this.pos;
                int n = this.pos;
                while (this.pos < this.endPos && ParseUtil.isHexDigit(this.source[this.pos])) {
                    ++this.pos;
                    if (this.pos - n == 6) break;
                }
                if (this.pos < this.endPos && ParseUtil.isSpace(this.source[this.pos])) {
                    ++this.pos;
                }
                return true;
            }
            if (c >= ' ' && c <= '~' || c >= '\u0080') {
                this.pos += 2;
                return true;
            }
        }
        return false;
    }

    private void skipNumber() {
        boolean bl = false;
        while (this.pos < this.endPos) {
            char c = this.source[this.pos];
            if (c >= '0' && c <= '9') {
                ++this.pos;
                continue;
            }
            if (c == '.') {
                if (bl) {
                    return;
                }
                bl = true;
                ++this.pos;
                continue;
            }
            return;
        }
    }

    private boolean skipURI() {
        int n = this.pos;
        this.pos += 4;
        this.skipSpace();
        if (this.pos < this.endPos) {
            char c = this.source[this.pos];
            if (c == '\"' || c == '\'') {
                this.skipString(c);
            } else {
                boolean bl = false;
                while (this.pos < this.endPos) {
                    c = this.source[this.pos];
                    if (c == ')' || ParseUtil.isSpace(c)) break;
                    if (c == '\\') {
                        if (this.skipEscape()) continue;
                        bl = true;
                        break;
                    }
                    if (c >= '*' && c <= '~' || c == '!' || c == '#' || c == '$' || c == '%' || c == '&' || c >= '\u0080') {
                        ++this.pos;
                        continue;
                    }
                    bl = true;
                    break;
                }
                if (bl) {
                    this.pos = n;
                    return false;
                }
            }
        }
        this.skipSpace();
        if (this.pos < this.endPos && this.source[this.pos] == ')') {
            ++this.pos;
            return true;
        }
        this.pos = n;
        return false;
    }

    private boolean skipUnicodeRange() {
        int n = this.pos;
        this.pos += 2;
        int n2 = this.skipHexDigits(true);
        if (n2 < 0) {
            return true;
        }
        if (n2 > 0) {
            if (this.pos < this.endPos && this.source[this.pos] == '-') {
                ++this.pos;
                n2 = this.skipHexDigits(false);
                if (n2 > 0) {
                    return true;
                }
            } else {
                return true;
            }
        }
        this.pos = n;
        return false;
    }

    private int skipHexDigits(boolean bl) {
        boolean bl2 = false;
        int n = 0;
        while (this.pos < this.endPos) {
            char c = this.source[this.pos];
            if (!ParseUtil.isHexDigit(c) && (!bl || c != '?')) break;
            if (c == '?') {
                bl2 = true;
            }
            ++this.pos;
            if (++n == 6) break;
        }
        return bl2 ? -n : n;
    }

    private boolean skipImportant() {
        int n = this.pos;
        if (this.source[this.pos] != '!') {
            return false;
        }
        ++this.pos;
        while (this.pos < this.endPos && ParseUtil.isSpace(this.source[this.pos])) {
            ++this.pos;
        }
        if (!this.match("important")) {
            this.pos = n;
            return false;
        }
        this.pos += 9;
        return true;
    }

    public boolean skipBlock() {
        if (this.pos <= 0 || this.source[this.pos - 1] != '{') {
            return false;
        }
        int n = 1;
        int n2 = this.pos;
        while (n2 < this.endPos) {
            switch (this.source[n2]) {
                case '{': {
                    ++n;
                    break;
                }
                case '}': {
                    if (--n != 0) break;
                    this.lexemePos = this.pos;
                    this.pos = n2;
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public String getLexeme() {
        return new String(this.source, this.lexemePos, this.pos - this.lexemePos);
    }

    public int getLineNumber() {
        if (this.cachedPos != this.pos) {
            this.locate(this.pos);
        }
        return 1 + this.lineNum;
    }

    public int getColumnNumber() {
        if (this.cachedPos != this.pos) {
            this.locate(this.pos);
        }
        return 1 + this.charNum;
    }

    private void locate(int n) {
        if (n > this.endPos) {
            n = this.endPos;
        }
        this.charNum = 0;
        this.lineNum = 0;
        int n2 = this.firstPos;
        while (n2 < n) {
            char c = this.source[n2];
            switch (c) {
                case '\r': {
                    if (n2 + 1 < this.endPos && this.source[n2 + 1] == '\n') {
                        ++n2;
                    }
                }
                case '\n': 
                case '\f': {
                    ++this.lineNum;
                    this.charNum = 0;
                    ++n2;
                    break;
                }
                default: {
                    ++this.charNum;
                    ++n2;
                }
            }
        }
        this.cachedPos = n;
    }

    public static String tokenName(int n) {
        if (n >= 0 && n < 65535) {
            return "'" + (char)n + "'";
        }
        if ((n = -n) >= 1 && n < tokenNames.length) {
            return tokenNames[n];
        }
        return "(unknown " + -n + ")";
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        if (stringArray.length != 2) {
            System.err.println("usage: java com.xmlmind.xmledit.cssparser.Scanner in_file out_file");
            System.exit(1);
        }
        Scanner scanner = new Scanner(FileUtil.loadString(stringArray[0]));
        PrintWriter printWriter = new PrintWriter(new FileWriter(stringArray[1]));
        boolean bl = true;
        while ((n = scanner.getNextToken()) != -1) {
            printWriter.print(Scanner.tokenName(n));
            if (bl) {
                printWriter.print("\t\t" + scanner.getLineNumber() + ":" + scanner.getColumnNumber() + "\t'" + scanner.getLexeme() + "'");
            }
            printWriter.println();
        }
        printWriter.flush();
        printWriter.close();
    }
}

